--[[
Author: Starinnia
CPR is a combo points display addon based on Funkydude's BasicComboPoints
$Date: 2009-10-12 00:06:34 +0000 (Mon, 12 Oct 2009) $
$Revision: 82 $
Project Version: 1.0.13
contact: codemaster2010 AT gmail DOT com

Copyright (c) 2007-2009 Michael J. Murray aka Starinnia of Lothar
All rights reserved unless otherwise explicitly stated.
]]

local basepath = "Interface\\Addons\\ComboPointsRedux\\Icons\\"
local GetComboPoints = _G.GetComboPoints
local UnitDebuff = _G.UnitDebuff
local str_find = string.find

local graphics = nil
local text = nil
local poisons = nil

local defaults = {
	profile = {
		locked = false,
		
		--cp text options
		font = "Friz Quadrata TT",
		fontsize = 12,
		textColorr = 1,
		textColorg = 1,
		textColorb = 1,
		alpha = 1,
		disableText = false,
		textpos = {},
		
		--cp graphics options
		disableGraphics = false,
		orientation = "h",
		icon = "square",
		normColorr = 1,
		normColorg = 0.9,
		normColorb = 0,
		fullColorr = 1,
		fullColorg = 0,
		fullColorb = 0,
		spacing = 5,
		graphicscale = 1,
		graphicpos = {},
		
		--deadly poison tracker options
		disablePoison = false,
		poisonOrientation = "h",
		poisonIcon = "square",
		poisonColor = {0, 1, 0},
		poisonFullColor = {0, .5, 0},
		poisonSpacing = 5,
		poisonScale = 1,
		poisonpos = {},
	},
}
	
local ComboPointsRedux = LibStub("AceAddon-3.0"):NewAddon("ComboPointsRedux", "AceConsole-3.0", "AceEvent-3.0")
local LSM = LibStub("LibSharedMedia-3.0")
local L = LibStub("AceLocale-3.0"):GetLocale("ComboPointsRedux")

local cprOps
local function getCPROps()
	if not cprOps then
		cprOps = {
			type = 'group',
			childGroups = 'tab',
			name = "ComboPointsRedux",
			args = {
				main = {
					type = 'group',
					name = L["Options"],
					args = {
						lock = {
							type = "toggle",
							name = L["Lock"],
							get = function() return ComboPointsRedux.db.profile.locked end,
							set = function()
								if not ComboPointsRedux.db.profile.locked then
									graphics:SetBackdropColor(1,1,1,0)
									graphics:EnableMouse(false)
									graphics:SetMovable(false)
									graphics.points[1]:Hide()
									graphics.points[2]:Hide()
									text:SetBackdropColor(1,1,1,0)
									text:EnableMouse(false)
									text:SetMovable(false)
									text.t:SetText("")
									if poisons then
										poisons:SetBackdropColor(1,1,1,0)
										poisons:EnableMouse(false)
										poisons:SetMovable(false)
										poisons.points[1]:Hide()
										poisons.points[2]:Hide()
									end
									ComboPointsRedux.db.profile.locked = true
								else
									if not ComboPointsRedux.db.profile.disableGraphics then
										graphics:SetBackdropColor(1,1,1,1)
										graphics:EnableMouse(true)
										graphics:SetMovable(true)
										graphics.points[1]:Show()
										graphics.points[2]:Show()
									end
									if not ComboPointsRedux.db.profile.disableText then
										text:SetBackdropColor(1,1,1,1)
										text:EnableMouse(true)
										text:SetMovable(true)
										text.t:SetText("2")
									end
									if poisons and (not ComboPointsRedux.db.profile.disablePoisons) then
										poisons:SetBackdropColor(1,1,1,1)
										poisons:EnableMouse(true)
										poisons:SetMovable(true)
										poisons.points[1]:Show()
										poisons.points[2]:Show()
									end
									ComboPointsRedux.db.profile.locked = false
								end
							end,
							order = 1,
						},
						disableText = {
							type = 'toggle',
							name = L["Disable Text Display"],
							get = function() return ComboPointsRedux.db.profile.disableText end,
							set = function(_, v)
								ComboPointsRedux.db.profile.disableText = v
								if v then
									text:Hide()
								else
									text:Show()
								end
							end,
							order = 2,
						},
						disableGraphics = {
							type = 'toggle',
							name = L["Disable Graphics Display"],
							get = function() return ComboPointsRedux.db.profile.disableGraphics end,
							set = function(_, v)
								ComboPointsRedux.db.profile.disableGraphics = v
								if v then
									graphics:Hide()
								else
									graphics:Show()
								end
							end,
							order = 3,
						},
						alpha = {
							type = 'range',
							name = L["Alpha"],
							get = function() return ComboPointsRedux.db.profile.alpha end,
							set = function(_, v)
								ComboPointsRedux.db.profile.alpha = v
								text.t:SetAlpha(v)
								text.t:SetShadowColor(0, 0, 0, ComboPointsRedux.db.profile.alpha)
								for i = 1, 5 do
									graphics.points[i]:SetAlpha(v)
								end
							end,
							min = 0,
							max = 1,
							step = .01,
							width = 'full',
							hidden = function()
								if ComboPointsRedux.db.profile.disableGraphics and ComboPointsRedux.db.profile.disableText then
									return true
								end
								return false
							end,
							order = 5,
						},
						spacer1 = {
							type = 'description',
							name = "   ",
							hidden = function()
								if ComboPointsRedux.db.profile.disableGraphics then
									return true
								end
								return false
							end,
							order = 6,
						},
						header1 = {
							type = 'header',
							name = L["Combo Point Icon Options"],
							hidden = function()
								if ComboPointsRedux.db.profile.disableGraphics then
									return true
								end
								return false
							end,
							order = 7,
						},
						orientation = {
							type = 'select',
							name = L["Orientation"],
							get = function() return ComboPointsRedux.db.profile.orientation end,
							set = function(_, value)
								ComboPointsRedux.db.profile.orientation = value
								local offset = ComboPointsRedux.db.profile.spacing*ComboPointsRedux.db.profile.graphicscale
								for i = 1, 5 do
									graphics.points[i]:ClearAllPoints()
								end
								if value == "v" then
									graphics.points[1]:SetPoint("BOTTOM", graphics, "BOTTOM", 0, 0)
									graphics.points[2]:SetPoint("BOTTOM", graphics.points[1], "TOP", 0, offset)
									graphics.points[3]:SetPoint("BOTTOM", graphics.points[2], "TOP", 0, offset)
									graphics.points[4]:SetPoint("BOTTOM", graphics.points[3], "TOP", 0, offset)
									graphics.points[5]:SetPoint("BOTTOM", graphics.points[4], "TOP", 0, offset)
									graphics:SetHeight(145*ComboPointsRedux.db.profile.graphicscale)
									graphics:SetWidth(25*ComboPointsRedux.db.profile.graphicscale)
								else
									graphics.points[1]:SetPoint("LEFT", graphics, "LEFT", 0, 0)
									graphics.points[2]:SetPoint("LEFT", graphics.points[1], "RIGHT", offset, 0)
									graphics.points[3]:SetPoint("LEFT", graphics.points[2], "RIGHT", offset, 0)
									graphics.points[4]:SetPoint("LEFT", graphics.points[3], "RIGHT", offset, 0)
									graphics.points[5]:SetPoint("LEFT", graphics.points[4], "RIGHT", offset, 0)
									graphics:SetWidth(145*ComboPointsRedux.db.profile.graphicscale)
									graphics:SetHeight(25*ComboPointsRedux.db.profile.graphicscale)
								end
							end,
							values = { h = L["Horizontal"], v = L["Vertical"], },
							hidden = function()
								if ComboPointsRedux.db.profile.disableGraphics then
									return true
								end
								return false
							end,
							order = 8,
						},
						icon = {
							type = 'select',
							name = L["Combo Point Icon"],
							get = function() return ComboPointsRedux.db.profile.icon end,
							set = function(_, v)
								ComboPointsRedux.db.profile.icon = v
								for i = 1, 5 do
									graphics.points[i].icon:SetTexture(basepath..ComboPointsRedux.db.profile.icon)
								end
							end,
							values = { square = L["Square"], circle = L["Circle"], triangle = L["Triangle"], diamond = L["Diamond"], },
							hidden = function()
								if ComboPointsRedux.db.profile.disableGraphics then
									return true
								end
								return false
							end,
							order = 9,
						},
						graphicscale = {
							type = "range",
							name = L["Graphics Scale"],
							get = function() return ComboPointsRedux.db.profile.graphicscale end,
							set = function(_, scale)
								ComboPointsRedux.db.profile.graphicscale = scale
								local offset = ComboPointsRedux.db.profile.spacing*scale
								for i = 1, 5 do
									graphics.points[i]:SetHeight(25*scale)
									graphics.points[i]:SetWidth(25*scale)
								end
								if ComboPointsRedux.db.profile.orientation == "v" then
									graphics.points[2]:SetPoint("BOTTOM", graphics.points[1], "TOP", 0, offset)
									graphics.points[3]:SetPoint("BOTTOM", graphics.points[2], "TOP", 0, offset)
									graphics.points[4]:SetPoint("BOTTOM", graphics.points[3], "TOP", 0, offset)
									graphics.points[5]:SetPoint("BOTTOM", graphics.points[4], "TOP", 0, offset)
									graphics:SetHeight(145*scale)
									graphics:SetWidth(25*scale)
								else
									graphics.points[2]:SetPoint("LEFT", graphics.points[1], "RIGHT", offset, 0)
									graphics.points[3]:SetPoint("LEFT", graphics.points[2], "RIGHT", offset, 0)
									graphics.points[4]:SetPoint("LEFT", graphics.points[3], "RIGHT", offset, 0)
									graphics.points[5]:SetPoint("LEFT", graphics.points[4], "RIGHT", offset, 0)
									graphics:SetHeight(25*scale)
									graphics:SetWidth(145*scale)
								end
							end,
							min = .1,
							max = 1.5,
							step = .01,
							width = 'full',
							hidden = function()
								if ComboPointsRedux.db.profile.disableGraphics then
									return true
								end
								return false
							end,
							order = 10,
						},
						spacing = {
							type = 'range',
							name = L["Spacing"],
							get = function() return ComboPointsRedux.db.profile.spacing end,
							set = function(_, v)
								ComboPointsRedux.db.profile.spacing = v
								local offset = v*ComboPointsRedux.db.profile.graphicscale
								if ComboPointsRedux.db.profile.orientation == "v" then
									graphics.points[2]:SetPoint("BOTTOM", graphics.points[1], "TOP", 0, offset)
									graphics.points[3]:SetPoint("BOTTOM", graphics.points[2], "TOP", 0, offset)
									graphics.points[4]:SetPoint("BOTTOM", graphics.points[3], "TOP", 0, offset)
									graphics.points[5]:SetPoint("BOTTOM", graphics.points[4], "TOP", 0, offset)
								else
									graphics.points[2]:SetPoint("LEFT", graphics.points[1], "RIGHT", offset, 0)
									graphics.points[3]:SetPoint("LEFT", graphics.points[2], "RIGHT", offset, 0)
									graphics.points[4]:SetPoint("LEFT", graphics.points[3], "RIGHT", offset, 0)
									graphics.points[5]:SetPoint("LEFT", graphics.points[4], "RIGHT", offset, 0)
								end
							end,
							min = -2,
							max = 10,
							step = 1,
							width = 'full',
							hidden = function()
								if ComboPointsRedux.db.profile.disableGraphics then
									return true
								end
								return false
							end,
							order = 11,
						},
						normalcolor = {
							type = 'color',
							name = L["Normal Color"],
							get = function() return ComboPointsRedux.db.profile.normColorr, ComboPointsRedux.db.profile.normColorg, ComboPointsRedux.db.profile.normColorb end,
							set = function(_, r, g, b)
								ComboPointsRedux.db.profile.normColorr = r
								ComboPointsRedux.db.profile.normColorg = g
								ComboPointsRedux.db.profile.normColorb = b
								for i = 1, 5 do
									graphics.points[i].icon:SetVertexColor(r, g, b)
								end
							end,
							hidden = function()
								if ComboPointsRedux.db.profile.disableGraphics then
									return true
								end
								return false
							end,
							order = 12,
						},
						fullcolor = {
							type = 'color',
							name = L["Five Point Color"],
							get = function() return ComboPointsRedux.db.profile.fullColorr, ComboPointsRedux.db.profile.fullColorg, ComboPointsRedux.db.profile.fullColorb end,
							set = function(_, r, g, b)
								ComboPointsRedux.db.profile.fullColorr = r
								ComboPointsRedux.db.profile.fullColorg = g
								ComboPointsRedux.db.profile.fullColorb = b
							end,
							hidden = function()
								if ComboPointsRedux.db.profile.disableGraphics then
									return true
								end
								return false
							end,
							order = 13,
						},
						spacer2 = {
							type = 'description',
							name = "   ",
							hidden = function()
								if ComboPointsRedux.db.profile.disableText then
									return true
								end
								return false
							end,
							order = 14,
						},

						header2 = {
							type = 'header',
							name = L["Combo Point Text Options"],
							hidden = function()
								if ComboPointsRedux.db.profile.disableText then
									return true
								end
								return false
							end,
							order = 15,
						},
						font = {
							type = "select",
							name = L["Font"],
							get = function() return ComboPointsRedux.db.profile.font end,
							set = function(_, v)
								ComboPointsRedux.db.profile.font = v
								text.t:SetFont(LSM:Fetch('font', v), ComboPointsRedux.db.profile.fontsize)
							end,
							dialogControl = "LSM30_Font",
							values = AceGUIWidgetLSMlists.font,
							hidden = function()
								if ComboPointsRedux.db.profile.disableText then
									return true
								end
								return false
							end,
							order = 16,
						},
						fontsize = {
							type = "range",
							name = L["Font Size"],
							get = function() return ComboPointsRedux.db.profile.fontsize end,
							set = function(_, v)
								ComboPointsRedux.db.profile.fontsize = v
								text.t:SetFont(LSM:Fetch('font', ComboPointsRedux.db.profile.font), v)
							end,
							min = 1,
							max = 36,
							step = 1,
							width = 'full',
							hidden = function()
								if ComboPointsRedux.db.profile.disableText then
									return true
								end
								return false
							end,
							order = 17,
						},
						textcolor = {
							type = 'color',
							name = L["Text Color"],
							get = function() return ComboPointsRedux.db.profile.textColorr, ComboPointsRedux.db.profile.textColorg, ComboPointsRedux.db.profile.textColorb end,
							set = function(_, r, g, b)
								ComboPointsRedux.db.profile.textColorr = r
								ComboPointsRedux.db.profile.textColorg = g
								ComboPointsRedux.db.profile.textColorb = b
								text.t:SetTextColor(r, g, b)
							end,
							hidden = function()
								if ComboPointsRedux.db.profile.disableText then
									return true
								end
								return false
							end,
							order = 18,
						},
					},
				},
				profiles = LibStub("AceDBOptions-3.0"):GetOptionsTable(ComboPointsRedux.db)
			},
		}
		
		if select(2, UnitClass("player")) == "ROGUE" then
		local opts = cprOps.args.main.args
			opts.disablePoison = {
				type = 'toggle',
				name = L["Disable Poison Graphics"],
				get = function() return ComboPointsRedux.db.profile.disablePoison end,
				set = function(_, v)
					ComboPointsRedux.db.profile.disablePoison = v
					if v then
						poisons:Hide()
					else
						poisons:Show()
					end
				end,
				order = 4,
			}
			spacer3 = {
				type = 'description',
				name = "   ",
				hidden = function()
					if ComboPointsRedux.db.profile.disablePoison then
						return true
					end
					return false
				end,
				order = 19,
			}
			opts.header3 = {
				type = 'header',
				name = L["Poison Icon Options"],
				hidden = function()
					if ComboPointsRedux.db.profile.disablePoison then
						return true
					end
					return false
				end,
				order = 20,
			}
			opts.poisonOrientation = {
				type = 'select',
				name = L["Poison Icon Orientation"],
				get = function() return ComboPointsRedux.db.profile.poisonOrientation end,
				set = function(_, value)
					ComboPointsRedux.db.profile.poisonOrientation = value
					local offset = ComboPointsRedux.db.profile.poisonSpacing*ComboPointsRedux.db.profile.poisonScale
					for i = 1, 5 do
						poisons.points[i]:ClearAllPoints()
					end
					if value == "v" then
						poisons.points[1]:SetPoint("BOTTOM", poisons, "BOTTOM", 0, 0)
						poisons.points[2]:SetPoint("BOTTOM", poisons.points[1], "TOP", 0, offset)
						poisons.points[3]:SetPoint("BOTTOM", poisons.points[2], "TOP", 0, offset)
						poisons.points[4]:SetPoint("BOTTOM", poisons.points[3], "TOP", 0, offset)
						poisons.points[5]:SetPoint("BOTTOM", poisons.points[4], "TOP", 0, offset)
						poisons:SetHeight(145*ComboPointsRedux.db.profile.poisonScale)
						poisons:SetWidth(25*ComboPointsRedux.db.profile.poisonScale)
					else
						poisons.points[1]:SetPoint("LEFT", poisons, "LEFT", 0, 0)
						poisons.points[2]:SetPoint("LEFT", poisons.points[1], "RIGHT", offset, 0)
						poisons.points[3]:SetPoint("LEFT", poisons.points[2], "RIGHT", offset, 0)
						poisons.points[4]:SetPoint("LEFT", poisons.points[3], "RIGHT", offset, 0)
						poisons.points[5]:SetPoint("LEFT", poisons.points[4], "RIGHT", offset, 0)
						poisons:SetWidth(145*ComboPointsRedux.db.profile.poisonScale)
						poisons:SetHeight(25*ComboPointsRedux.db.profile.poisonScale)
					end
				end,
				values = { h = L["Horizontal"], v = L["Vertical"], },
				hidden = function()
					if ComboPointsRedux.db.profile.disablePoison then
						return true
					end
					return false
				end,
				order = 21,
			}
			opts.poisonicon = {
				type = 'select',
				name = L["Poison Icon"],
				get = function() return ComboPointsRedux.db.profile.poisonIcon end,
				set = function(_, v)
					ComboPointsRedux.db.profile.poisonIcon = v
					for i = 1, 5 do
						poisons.points[i].icon:SetTexture(basepath..ComboPointsRedux.db.profile.poisonIcon)
					end
				end,
				values = { square = L["Square"], circle = L["Circle"], triangle = L["Triangle"], diamond = L["Diamond"], },
				hidden = function()
					if ComboPointsRedux.db.profile.disablePoison then
						return true
					end
					return false
				end,
				order = 22,
			}
			opts.poisonscale = {
				type = "range",
				name = L["Poison Scale"],
				get = function() return ComboPointsRedux.db.profile.poisonScale end,
				set = function(_, scale)
					ComboPointsRedux.db.profile.poisonScale = scale
					local offset = ComboPointsRedux.db.profile.poisonSpacing*scale
					for i = 1, 5 do
						poisons.points[i]:SetHeight(25*scale)
						poisons.points[i]:SetWidth(25*scale)
					end
					
					if ComboPointsRedux.db.profile.poisonOrientation == "v" then
						poisons.points[2]:SetPoint("BOTTOM", poisons.points[1], "TOP", 0, offset)
						poisons.points[3]:SetPoint("BOTTOM", poisons.points[2], "TOP", 0, offset)
						poisons.points[4]:SetPoint("BOTTOM", poisons.points[3], "TOP", 0, offset)
						poisons.points[5]:SetPoint("BOTTOM", poisons.points[4], "TOP", 0, offset)
						poisons:SetHeight(145*scale)
						poisons:SetWidth(25*scale)
					else
						poisons.points[2]:SetPoint("LEFT", poisons.points[1], "RIGHT", offset, 0)
						poisons.points[3]:SetPoint("LEFT", poisons.points[2], "RIGHT", offset, 0)
						poisons.points[4]:SetPoint("LEFT", poisons.points[3], "RIGHT", offset, 0)
						poisons.points[5]:SetPoint("LEFT", poisons.points[4], "RIGHT", offset, 0)
						poisons:SetHeight(25*scale)
						poisons:SetWidth(145*scale)
					end
				end,
				min = .1,
				max = 1.5,
				step = .01,
				width = 'full',
				hidden = function()
					if ComboPointsRedux.db.profile.disablePoison then
						return true
					end
					return false
				end,
				order = 23,
			}
			opts.poisonspacing = {
				type = 'range',
				name = L["Poison Icon Spacing"],
				get = function() return ComboPointsRedux.db.profile.poisonSpacing end,
				set = function(_, v)
					ComboPointsRedux.db.profile.poisonSpacing = v
					local offset = v*ComboPointsRedux.db.profile.poisonScale
					if ComboPointsRedux.db.profile.poisonOrientation == "v" then
						poisons.points[2]:SetPoint("BOTTOM", poisons.points[1], "TOP", 0, offset)
						poisons.points[3]:SetPoint("BOTTOM", poisons.points[2], "TOP", 0, offset)
						poisons.points[4]:SetPoint("BOTTOM", poisons.points[3], "TOP", 0, offset)
						poisons.points[5]:SetPoint("BOTTOM", poisons.points[4], "TOP", 0, offset)
					else
						poisons.points[2]:SetPoint("LEFT", poisons.points[1], "RIGHT", offset, 0)
						poisons.points[3]:SetPoint("LEFT", poisons.points[2], "RIGHT", offset, 0)
						poisons.points[4]:SetPoint("LEFT", poisons.points[3], "RIGHT", offset, 0)
						poisons.points[5]:SetPoint("LEFT", poisons.points[4], "RIGHT", offset, 0)
					end
				end,
				min = -2,
				max = 10,
				step = 1,
				width = 'full',
				hidden = function()
					if ComboPointsRedux.db.profile.disablePoison then
						return true
					end
					return false
				end,
				order = 24,
			}
			opts.poisoncolor = {
				type = 'color',
				name = L["Poison Normal Color"],
				get = function() return unpack(ComboPointsRedux.db.profile.poisonColor) end,
				set = function(_, r, g, b)
					ComboPointsRedux.db.profile.poisonColor[1] = r
					ComboPointsRedux.db.profile.poisonColor[2] = g
					ComboPointsRedux.db.profile.poisonColor[3] = b
					for i = 1, 5 do
						poisons.points[i].icon:SetVertexColor(r, g, b)
					end
				end,
				hidden = function()
					if ComboPointsRedux.db.profile.disablePoison then
						return true
					end
					return false
				end,
				order = 25,
			}
			opts.poisonfullcolor = {
				type = 'color',
				name = L["Poison Full Color"],
				get = function() return unpack(ComboPointsRedux.db.profile.poisonFullColor) end,
				set = function(_, r, g, b)
					ComboPointsRedux.db.profile.poisonFullColor[1] = r
					ComboPointsRedux.db.profile.poisonFullColor[2] = g
					ComboPointsRedux.db.profile.poisonFullColor[3] = b
				end,
				hidden = function()
					if ComboPointsRedux.db.profile.disablePoison then
						return true
					end
					return false
				end,
				order = 26,
			}
		end
	end
	return cprOps
end

function ComboPointsRedux:OnInitialize()
	self.db = LibStub("AceDB-3.0"):New("CPRDB", defaults, "Default")
	defaults = nil
	
	self.db.RegisterCallback(self, "OnProfileReset", "Reset")
	self.db.RegisterCallback(self, "OnProfileCopied", "Refresh")
	self.db.RegisterCallback(self, "OnProfileChanged", "Refresh")
	
	LibStub("AceConfig-3.0"):RegisterOptionsTable("ComboPointsRedux", getCPROps)
	LibStub("AceConfigDialog-3.0"):AddToBlizOptions("ComboPointsRedux", "ComboPointsRedux")
	self:RegisterChatCommand("cpr", "OpenConfig", true, true)
	self:RegisterChatCommand("cpredux", "OpenConfig", true, true)
end

function ComboPointsRedux:OnEnable()
	self:MakeComboTextFrame()
	self:MakeComboGraphicsFrame()
	
	self:RegisterEvent("UNIT_COMBO_POINTS", "ReDraw")
	
	--only deal with the deadly poison functions/events if the player is a rogue
	--nil the functions and register the PTC event like before
	--otherwise register the new func for the PTC event and register the Aura event
	if select(2, UnitClass("player")) ~= "ROGUE" then
		self.AuraUpdate = nil
		self.UpdateDeadlyPoison = nil
		self.NewTarget = nil
		self.MakePoisonGraphicsFrame = nil
		self:RegisterEvent("PLAYER_TARGET_CHANGED", "ReDraw")
	else
		self:RegisterEvent("PLAYER_TARGET_CHANGED", "NewTarget")
		self:RegisterEvent("UNIT_AURA", "AuraUpdate")
		self:MakePoisonGraphicsFrame()
	end
end

function ComboPointsRedux:Reset()
	text:ClearAllPoints()
	graphics:ClearAllPoints()
	
	text:SetPoint("CENTER", UIParent, "CENTER")
	graphics:SetPoint("CENTER", UIParent, "CENTER")
	
	for i = 1, 5 do
		graphics.points[i].icon:SetTexture(basepath.."square")
	end
	
	graphics:SetWidth(145)
	graphics:SetHeight(25)
	
	if poisons then
		for i = 1, 5 do
			poisons.points[i].icon:SetTexture(basepath.."square")
		end
		poisons:ClearAllPoints()
		poisons:SetPoint("CENTER", UIParent, "CENTER", 0, -25)
		poisons:SetWidth(145)
		poisons:SetHeight(25)
	end
end

function ComboPointsRedux:Refresh()
	text:ClearAllPoints()
	graphics:ClearAllPoints()
	
	if self.db.profile.textpos.x then
		text:SetPoint(self.db.profile.textpos.point, UIParent, self.db.profile.textpos.anchor, self.db.profile.textpos.x, self.db.profile.textpos.y)
		graphics:SetPoint(self.db.profile.graphicpos.point, UIParent, self.db.profile.graphicpos.anchor, self.db.profile.graphicpos.x, self.db.profile.graphicpos.y)
	else
		text:SetPoint("CENTER", UIParent, "CENTER")
		graphics:SetPoint("CENTER", UIParent, "CENTER")
	end
	
	for i = 1, 5 do
		graphics.points[i].icon:SetTexture(basepath..self.db.profile.icon)
	end
	
	local offset1 = self.db.profile.spacing*self.db.profile.graphicscale
	if self.db.profile.orientation == "v" then
		graphics.points[1]:SetPoint("BOTTOM", graphics, "BOTTOM", 0, 0)
		graphics.points[2]:SetPoint("BOTTOM", graphics.points[1], "TOP", 0, offset1)
		graphics.points[3]:SetPoint("BOTTOM", graphics.points[2], "TOP", 0, offset1)
		graphics.points[4]:SetPoint("BOTTOM", graphics.points[3], "TOP", 0, offset1)
		graphics.points[5]:SetPoint("BOTTOM", graphics.points[4], "TOP", 0, offset1)
		graphics:SetHeight(145*self.db.profile.graphicscale)
		graphics:SetWidth(25*self.db.profile.graphicscale)
	else
		graphics.points[1]:SetPoint("LEFT", graphics, "LEFT", 0, 0)
		graphics.points[2]:SetPoint("LEFT", graphics.points[1], "RIGHT", offset1, 0)
		graphics.points[3]:SetPoint("LEFT", graphics.points[2], "RIGHT", offset1, 0)
		graphics.points[4]:SetPoint("LEFT", graphics.points[3], "RIGHT", offset1, 0)
		graphics.points[5]:SetPoint("LEFT", graphics.points[4], "RIGHT", offset1, 0)
		graphics:SetWidth(145*self.db.profile.graphicscale)
		graphics:SetHeight(25*self.db.profile.graphicscale)
	end
	
	if poisons then
		poisons:ClearAllPoints()
		if self.db.profile.poisonpos.x then
			poisons:SetPoint(self.db.profile.poisonpos.point, UIParent, self.db.profile.poisonpos.anchor, self.db.profile.poisonpos.x, self.db.profile.poisonpos.y)
		else
			poisons:SetPoint("CENTER", UIParent, "CENTER")
		end
		
		local offset2 = self.db.profile.poisonSpacing*self.db.profile.poisonScale
		if self.db.profile.poisonOrientation == "v" then
			graphics.points[1]:SetPoint("BOTTOM", graphics, "BOTTOM", 0, 0)
			graphics.points[2]:SetPoint("BOTTOM", graphics.points[1], "TOP", 0, offset2)
			graphics.points[3]:SetPoint("BOTTOM", graphics.points[2], "TOP", 0, offset2)
			graphics.points[4]:SetPoint("BOTTOM", graphics.points[3], "TOP", 0, offset2)
			graphics.points[5]:SetPoint("BOTTOM", graphics.points[4], "TOP", 0, offset2)
			graphics:SetHeight(145*self.db.profile.poisonScale)
			graphics:SetWidth(25*self.db.profile.poisonScale)
		else
			graphics.points[1]:SetPoint("LEFT", graphics, "LEFT", 0, 0)
			graphics.points[2]:SetPoint("LEFT", graphics.points[1], "RIGHT", offset2, 0)
			graphics.points[3]:SetPoint("LEFT", graphics.points[2], "RIGHT", offset2, 0)
			graphics.points[4]:SetPoint("LEFT", graphics.points[3], "RIGHT", offset2, 0)
			graphics.points[5]:SetPoint("LEFT", graphics.points[4], "RIGHT", offset2, 0)
			graphics:SetWidth(145*self.db.profile.poisonScale)
			graphics:SetHeight(25*self.db.profile.poisonScale)
		end
		
		for i = 1, 5 do
			poisons.points[i].icon:SetTexture(basepath..self.db.profile.poisonIcon)
		end
	end
	
	if not self.db.profile.locked then
		text:SetBackdropColor(1,1,1,0)
		text:EnableMouse(false)
		text:SetMovable(false)
		graphics:SetBackdropColor(1,1,1,0)
		graphics:EnableMouse(false)
		graphics:SetMovable(false)
		if poisons then
			poisons:SetBackdropColor(1,1,1,0)
			poisons:EnableMouse(false)
			poisons:SetMovable(false)
		end
	end
end

function ComboPointsRedux:OpenConfig()
	LibStub("AceConfigDialog-3.0"):SetDefaultSize("ComboPointsRedux", 500, 550)
	LibStub("AceConfigDialog-3.0"):Open("ComboPointsRedux")
end

function ComboPointsRedux:AuraUpdate(event, unit)
	if self.db.profile.disablePoison then return end
	if unit ~= "target" then return end
	if UnitIsDead("target") then
		self:UpdateDeadlyPoison(0)
		return
	end
	
	local stacks, i = 0, 1
	local icon, count, owner
	
	if UnitExists("target") then
		while UnitDebuff("target", i) ~= nil do
			_, _, texture, count, _, _, _, owner = UnitDebuff("target", i)
			if owner == "player" and str_find(texture, "Ability_Rogue_DualWeild") then
				stacks = count
				break
			end
			i = i + 1
		end
	end
	self:UpdateDeadlyPoison(stacks)
end

function ComboPointsRedux:UpdateDeadlyPoison(count)
	if count == 0 then
		for i = 1, 5 do
			poisons.points[i]:Hide()
			poisons.points[i].icon:SetVertexColor(unpack(self.db.profile.poisonColor))
		end
	elseif count == 5 then
		for i = count, 1, -1 do
			poisons.points[i].icon:SetVertexColor(unpack(self.db.profile.poisonFullColor))
			poisons.points[i]:Show()
		end
	else
		for i = count, 1, -1 do
			poisons.points[i].icon:SetVertexColor(unpack(self.db.profile.poisonColor))
			poisons.points[i]:Show()
		end
		for j = 5, count+1, -1 do
			poisons.points[j]:Hide()
			poisons.points[j].icon:SetVertexColor(unpack(self.db.profile.poisonColor))
		end
	end
end

function ComboPointsRedux:ReDraw()
	--see if the player has a vehicle, if they do get the vehicle's CPs
	local points = GetComboPoints(UnitHasVehicleUI("player") and "vehicle" or "player", "target")
	if UnitIsDead("target") then points = 0 end
	
	if points == 0 then
		for i = 1, 5 do
			graphics.points[i]:Hide()
			graphics.points[i].icon:SetVertexColor(self.db.profile.normColorr, self.db.profile.normColorg, self.db.profile.normColorb)
		end
		points = ""
	elseif points == 5 then
		for i = points, 1, -1 do
			graphics.points[i].icon:SetVertexColor(self.db.profile.fullColorr, self.db.profile.fullColorg, self.db.profile.fullColorb)
			graphics.points[i]:Show()
		end
	else
		for i = points, 1, -1 do
			graphics.points[i]:Show()
		end
	end
	text.t:SetText(points)
end

function ComboPointsRedux:NewTarget()
	self:ReDraw()
	self:AuraUpdate(nil, "target")
end

local bg = {bgFile = "Interface\\Tooltips\\UI-Tooltip-Background",}
function ComboPointsRedux:MakeComboTextFrame()
	text = CreateFrame("FRAME", "CPRTEXTFRAME", UIParent)
	text:SetBackdrop(bg)
	text:SetFrameStrata("BACKGROUND")
	text:SetClampedToScreen(true)
	if self.db.profile.textpos.x then
		text:SetPoint(self.db.profile.textpos.point, UIParent, self.db.profile.textpos.anchor, self.db.profile.textpos.x, self.db.profile.textpos.y)
	else
		text:SetPoint("CENTER", UIParent, "CENTER", 0, 0)
	end
	text:SetBackdropColor(1,1,1,0)
	text:SetWidth(50)
	text:SetHeight(50)
	
	text.t = text:CreateFontString(nil,"OVERLAY")
	text.t:SetAllPoints(text)
	text.t:SetShadowColor(0, 0, 0, self.db.profile.alpha)
	text.t:SetShadowOffset(1, -1)
	text.t:SetFont(LSM:Fetch("font", self.db.profile.font), self.db.profile.fontsize)
	text.t:SetTextColor(self.db.profile.textColorr, self.db.profile.textColorg, self.db.profile.textColorb)
	text.t:SetAlpha(self.db.profile.alpha)
	
	text:RegisterForDrag("LeftButton")
	text:SetScript("OnDragStart", function(frame) frame:StartMoving() end)
	text:SetScript("OnDragStop", function(frame)
		frame:StopMovingOrSizing()
		local point, _, anchor, x, y = frame:GetPoint()
		ComboPointsRedux.db.profile.textpos.x = math.floor(x)
		ComboPointsRedux.db.profile.textpos.y = math.floor(y)
		ComboPointsRedux.db.profile.textpos.anchor = anchor
		ComboPointsRedux.db.profile.textpos.point = point
	end)
	
	if not self.db.profile.locked then
		text:SetBackdropColor(1,1,1,1)
		text:EnableMouse(true)
		text:SetMovable(true)
		text.t:SetText("2")
	end
	
	if not self.db.profile.disableText then
		text:Show()
	else
		text:Hide()
	end
end

function ComboPointsRedux:MakeComboGraphicsFrame()
	graphics = CreateFrame("FRAME", "CPRGRAPHICSFRAME", UIParent)
	graphics:SetBackdrop(bg)
	graphics:SetFrameStrata("BACKGROUND")
	graphics:SetClampedToScreen(true)
	if self.db.profile.graphicpos.x then
		graphics:SetPoint(self.db.profile.graphicpos.point, UIParent, self.db.profile.graphicpos.anchor, self.db.profile.graphicpos.x, self.db.profile.graphicpos.y)
	else
		graphics:SetPoint("CENTER", UIParent, "CENTER", 0, 0)
	end
	graphics:SetBackdropColor(1,1,1,0)
	if self.db.profile.orientation == "v" then
		graphics:SetHeight(145*self.db.profile.graphicscale)
		graphics:SetWidth(25*self.db.profile.graphicscale)
	else
		graphics:SetWidth(145*self.db.profile.graphicscale)
		graphics:SetHeight(25*self.db.profile.graphicscale)
	end
	
	graphics:RegisterForDrag("LeftButton")
	graphics:SetScript("OnDragStart", function(frame) frame:StartMoving() end)
	graphics:SetScript("OnDragStop", function(frame)
		frame:StopMovingOrSizing()
		local point, _, anchor, x, y = frame:GetPoint()
		ComboPointsRedux.db.profile.graphicpos.x = math.floor(x)
		ComboPointsRedux.db.profile.graphicpos.y = math.floor(y)
		ComboPointsRedux.db.profile.graphicpos.anchor = anchor
		ComboPointsRedux.db.profile.graphicpos.point = point
	end)
	
	graphics.points = {}
	for i = 1, 5 do
		graphics.points[i] = CreateFrame("FRAME", nil, graphics)
		graphics.points[i].icon = graphics.points[i]:CreateTexture(nil, "OVERLAY")
		graphics.points[i].icon:SetAllPoints(graphics.points[i])
		graphics.points[i].icon:SetTexture(basepath..self.db.profile.icon)
		graphics.points[i].icon:SetVertexColor(self.db.profile.normColorr, self.db.profile.normColorg, self.db.profile.normColorb)
		graphics.points[i]:SetAlpha(self.db.profile.alpha)
		graphics.points[i]:SetHeight(25*self.db.profile.graphicscale)
		graphics.points[i]:SetWidth(25*self.db.profile.graphicscale)
		graphics.points[i]:Hide()
	end
	
	if not self.db.profile.locked then
		graphics:SetBackdropColor(1,1,1,1)
		graphics:EnableMouse(true)
		graphics:SetMovable(true)
		graphics.points[1]:Show()
		graphics.points[2]:Show()
	end
	
	local offset = self.db.profile.spacing*self.db.profile.graphicscale
	if self.db.profile.orientation == "v" then
		graphics.points[1]:SetPoint("BOTTOM", graphics, "BOTTOM", 0, 0)
		graphics.points[2]:SetPoint("BOTTOM", graphics.points[1], "TOP", 0, offset)
		graphics.points[3]:SetPoint("BOTTOM", graphics.points[2], "TOP", 0, offset)
		graphics.points[4]:SetPoint("BOTTOM", graphics.points[3], "TOP", 0, offset)
		graphics.points[5]:SetPoint("BOTTOM", graphics.points[4], "TOP", 0, offset)
	else
		graphics.points[1]:SetPoint("LEFT", graphics, "LEFT", 0, 0)
		graphics.points[2]:SetPoint("LEFT", graphics.points[1], "RIGHT", offset, 0)
		graphics.points[3]:SetPoint("LEFT", graphics.points[2], "RIGHT", offset, 0)
		graphics.points[4]:SetPoint("LEFT", graphics.points[3], "RIGHT", offset, 0)
		graphics.points[5]:SetPoint("LEFT", graphics.points[4], "RIGHT", offset, 0)
	end
	
	if not self.db.profile.disableGraphics then
		graphics:Show()
	else
		graphics:Hide()
	end
end

function ComboPointsRedux:MakePoisonGraphicsFrame()
	poisons = CreateFrame("FRAME", "CPRPOISONSFRAME", UIParent)
	poisons:SetBackdrop(bg)
	poisons:SetFrameStrata("BACKGROUND")
	poisons:SetClampedToScreen(true)
	if self.db.profile.poisonpos.x then
		poisons:SetPoint(self.db.profile.poisonpos.point, UIParent, self.db.profile.poisonpos.anchor, self.db.profile.poisonpos.x, self.db.profile.poisonpos.y)
	else
		poisons:SetPoint("CENTER", UIParent, "CENTER", 0, -25) --offset the poisons frame for easier setup
	end
	poisons:SetBackdropColor(1,1,1,0)
	if self.db.profile.poisonOrientation == "v" then
		poisons:SetHeight(145*self.db.profile.poisonScale)
		poisons:SetWidth(25*self.db.profile.poisonScale)
	else
		poisons:SetWidth(145*self.db.profile.poisonScale)
		poisons:SetHeight(25*self.db.profile.poisonScale)
	end
	
	poisons:RegisterForDrag("LeftButton")
	poisons:SetScript("OnDragStart", function(frame) frame:StartMoving() end)
	poisons:SetScript("OnDragStop", function(frame)
		frame:StopMovingOrSizing()
		local point, _, anchor, x, y = frame:GetPoint()
		ComboPointsRedux.db.profile.poisonpos.x = math.floor(x)
		ComboPointsRedux.db.profile.poisonpos.y = math.floor(y)
		ComboPointsRedux.db.profile.poisonpos.anchor = anchor
		ComboPointsRedux.db.profile.poisonpos.point = point
	end)
	
	poisons.points = {}
	for i = 1, 5 do
		poisons.points[i] = CreateFrame("FRAME", nil, poisons)
		poisons.points[i].icon = poisons.points[i]:CreateTexture(nil, "OVERLAY")
		poisons.points[i].icon:SetAllPoints(poisons.points[i])
		poisons.points[i].icon:SetTexture(basepath..self.db.profile.poisonIcon)
		poisons.points[i].icon:SetVertexColor(unpack(self.db.profile.poisonColor))
		poisons.points[i]:SetAlpha(self.db.profile.alpha)
		poisons.points[i]:SetHeight(25*self.db.profile.poisonScale)
		poisons.points[i]:SetWidth(25*self.db.profile.poisonScale)
		poisons.points[i]:Hide()
	end
	
	if not self.db.profile.locked then
		poisons:SetBackdropColor(1,1,1,1)
		poisons:EnableMouse(true)
		poisons:SetMovable(true)
		poisons.points[1]:Show()
		poisons.points[2]:Show()
	end
	
	local offset = self.db.profile.poisonSpacing*self.db.profile.poisonScale
	if self.db.profile.poisonOrientation == "v" then
		poisons.points[1]:SetPoint("BOTTOM", poisons, "BOTTOM", 0, 0)
		poisons.points[2]:SetPoint("BOTTOM", poisons.points[1], "TOP", 0, offset)
		poisons.points[3]:SetPoint("BOTTOM", poisons.points[2], "TOP", 0, offset)
		poisons.points[4]:SetPoint("BOTTOM", poisons.points[3], "TOP", 0, offset)
		poisons.points[5]:SetPoint("BOTTOM", poisons.points[4], "TOP", 0, offset)
	else
		poisons.points[1]:SetPoint("LEFT", poisons, "LEFT", 0, 0)
		poisons.points[2]:SetPoint("LEFT", poisons.points[1], "RIGHT", offset, 0)
		poisons.points[3]:SetPoint("LEFT", poisons.points[2], "RIGHT", offset, 0)
		poisons.points[4]:SetPoint("LEFT", poisons.points[3], "RIGHT", offset, 0)
		poisons.points[5]:SetPoint("LEFT", poisons.points[4], "RIGHT", offset, 0)
	end
	
	if not self.db.profile.disablePoison then
		poisons:Show()
	else
		poisons:Hide()
	end
end
