assert(FatCooldowns, "FatCooldowns not found!")

local MINOR_VERSION = tonumber(("$Revision: 49 $"):match("%d+"))
if MINOR_VERSION > FatCooldowns.MINOR_VERSION then FatCooldowns.MINOR_VERSION = MINOR_VERSION end

local Media = LibStub("LibSharedMedia-3.0")
local textures = Media:List("statusbar")
local fonts = Media:List("font")

local pairs, ipairs = _G.pairs, _G.ipairs
local tonumber, tostring = _G.tonumber, _G.tostring

local Display = FatCooldowns:GetModule("Display")

Media.RegisterCallback(Display, "LibSharedMedia_Registered", "UpdateDisplay")
Media.RegisterCallback(Display, "LibSharedMedia_SetGlobal", "UpdateDisplay")

local folder, core = ...
core.tooltip = core.tooltip or CreateFrame("GameTooltip", folder.."Tooltip", UIParent, "GameTooltipTemplate")
local tooltip = core.tooltip
tooltip:Show()
tooltip:SetOwner(UIParent, "ANCHOR_NONE")
 
local TempFrameXNames = nil
local TempFrameZNames = nil
local TempFrameNamesSpells = false
local LootBlackList = nil
local TempSellList = nil
local TempMBlackList = nil

local function GetLSMIndex(t, value)
	for k, v in pairs(Media:List(t)) do
		if v == value then
			return k
		end
	end
	return nil
end

local function set(t, value)
	Display.db.profile[t[#t]] = value
	Display:UpdateDisplay()
end
local function get(t)
	return Display.db.profile[t[#t]]
end

local options = {}

local function RefreshFrameListOptionsAndVariables()
	local optArgs = options.args.frames.args
	local classes = {"DEATHKNIGHT", "DRUID", "HUNTER", "MAGE", "PALADIN", "PRIEST", "ROGUE", "SHAMAN", "WARLOCK", "WARRIOR", "ITEMS", "RACIALS", "CONSUMABLES", "Tank Only Cooldowns", "OTHER BARS", "ITEM PROC"}
	local reporters = {"OTHER", "ITEMS", "MULTIPLE BOSSES","BPC AND BQL", "THE LICH KING", "OTHER BOSSES", "PARRY REPORTER", "SOUND AND SAY"}
	local ChatFilters = {"CHAT FILTER - Deaths", "CHAT FILTER - Other", "CHAT FILTER - Bubbles", "CHAT FILTER - Raid","CHAT FILTER - RaidLoot", "CHAT FILTER - Global", "CHAT FILTER - Spells", "CHAT FILTER - FCD"}
	local Display = Display
	
	for i = 1, 10, 1 do
		if i <= Display.db.profile.frameCount then
			if not Display.db.profile.frames[i] then
				local newFrame = {};
				newFrame.name = "Frame"..i;
				newFrame.growUp = Display.db.profile.frames[i-1].growUp;
				newFrame.hideSelf = Display.db.profile.frames[i-1].hideSelf;
				newFrame.readyMsg = Display.db.profile.frames[i-1].readyMsg;
				newFrame.scale = Display.db.profile.frames[i-1].scale;
				newFrame.alpha = Display.db.profile.frames[i-1].alpha;
				newFrame.width = Display.db.profile.frames[i-1].width;
				newFrame.fontsize = Display.db.profile.frames[i-1].fontsize;
				newFrame.height = Display.db.profile.frames[i-1].height;
				newFrame.maxTextLength = Display.db.profile.frames[i-1].maxTextLength;
				newFrame.permanent = Display.db.profile.frames[i-1].permanent;
				newFrame.anchor = Display.db.profile.frames[i-1].anchor;
				newFrame.hideFrame = Display.db.profile.frames[i-1].hideFrame;
				newFrame.hidetarget = Display.db.profile.frames[i-1].hidetarget;
				newFrame.RaidMsg = Display.db.profile.frames[i-1].RaidMsg;
				newFrame.UsedMsg = Display.db.profile.frames[i-1].UsedMsg;
				newFrame.HideLabel = Display.db.profile.frames[i-1].HideLabel;
				newFrame.onlySelf = Display.db.profile.frames[i-1].onlySelf;
				newFrame.SpellNameLabel = Display.db.profile.frames[i-1].SpellNameLabel;
				newFrame.EnemyFCDCaster = Display.db.profile.frames[i-1].EnemyFCDCaster;
				newFrame.FriendlyCaster = Display.db.profile.frames[i-1].FriendlyCaster;
				newFrame.spells = {}

				Display.db.profile.frames[i] = newFrame;
			end
			
			if not optArgs["frame"..i] then
				optArgs["frame"..i] = {
					type = "group",
					name = Display.db.profile.frames[i].name .. " Options",
					desc = "Configure frame options and spells displayed",
					cmdHidden = true,
					order = i,
					args = {
						name = {
							type = "input",
							name = "Frame Name",
							desc = "Choose name of this frame",
							get = function(v) return Display.db.profile.frames[i].name end,
							set = function(info, v) 
								--print(info[#info])
								Display.db.profile.frames[i].name = v; optArgs["frame"..i].name = v .. " Options";
								Display:UpdateDisplay();
							end,
							width = "double",
							order = 1
						},
						maxTextLength = {
							type = "range",
							name = "Max Characters",
							desc = "This will limit the amount of letters used in peoples.",
							min = 3, max = 12, step = 1, bigStep = 1,
							get = function(v) if Display.db.profile.frames[i].maxTextLength >= 12 then return 12 else
								return Display.db.profile.frames[i].maxTextLength end end,
							set = function(info, v) if v < 12 then Display.db.profile.frames[i].maxTextLength = v else Display.db.profile.frames[i].maxTextLength = 99 end Display:UpdateDisplay() end,
							order = 2,
							--width = "double",
						},
						anchor = {
							type = "toggle",
							name = "Show Anchor",
							desc = "Shows Anchor with frame name.",
							order = 2.2,
							get = function(v) return Display.db.profile.frames[i].anchor end,
							set = function(info, v) Display.db.profile.frames[i].anchor = v; Display:UpdateDisplay() end,
						},
						hidetarget = {
							type = "toggle",
							name = "Hide Target",
							desc = "Hides the Target.",
							order = 2.5,
							get = function(v) return Display.db.profile.frames[i].hidetarget end,
							set = function(info, v) Display.db.profile.frames[i].hidetarget = v; Display:UpdateDisplay(); end,
						},
						hide = {
							type = "toggle",
							name = "Hide Frame",							
							desc = "Hides this frame.",
							order = 3,
							get = function(v) return Display.db.profile.frames[i].hideFrame end,
							set = function(info, v) Display.db.profile.frames[i].hideFrame = v; Display:UpdateDisplay(); end,
						},
						hideSelf = {
							type = "toggle",
							name =  "Dont Show Self",
							desc =  "Hide your own cooldowns.",
							--width = "half",
							order = 5,
							get = function(v) return Display.db.profile.frames[i].hideSelf end,
							set = function(info, v) Display.db.profile.frames[i].hideSelf = v; Display:UpdateDisplay() end,
						},
						onlySelf = {
							type = "toggle",
							name =  "Only Self",
							--width = "half",
							desc =  "Only show your own cooldowns.",
							order = 5.5,
							get = function(v) return Display.db.profile.frames[i].onlySelf end,
							set = function(info, v) Display.db.profile.frames[i].onlySelf = v; Display:UpdateDisplay() end,
						},
						EnemyFCDCaster = {
							type = "toggle",
							name =  "Only Enemy",
							--width = "half",
							desc =  "Only show Enemy cooldowns.",
							order = 5.6,		
							disabled = function() if Display.db.profile.frames[i].FriendlyCaster then Display.db.profile.frames[i].EnemyFCDCaster = false return true else return false end end,
							get = function(v) return Display.db.profile.frames[i].EnemyFCDCaster end,
							set = function(info, v) Display.db.profile.frames[i].EnemyFCDCaster = v; Display:UpdateDisplay() end,
						},
						FriendlyCaster = {
							type = "toggle",
							name =  "Only Friendly",
							--width = "half",
							desc =  "Only show Friendly cooldowns.",
							order = 5.7,
							disabled = function() if Display.db.profile.frames[i].EnemyFCDCaster then Display.db.profile.frames[i].FriendlyCaster = false return true else return false end end,
							get = function(v) return Display.db.profile.frames[i].FriendlyCaster end,
							set = function(info, v) Display.db.profile.frames[i].FriendlyCaster = v; Display:UpdateDisplay() end,
						},
						message = {
							type = "toggle",
							name =  "Ready Messag (Self)",
							desc =  "Print a chat message when a cooldown becomes ready to self chat.",
							order = 6,
							get = function(v) return Display.db.profile.frames[i].readyMsg end,
							set = function(info, v) Display.db.profile.frames[i].readyMsg = v; Display:UpdateDisplay() end,
						},
						messageraid = {
							type = "toggle",
							name =  "Ready Message (Raid)",
							desc =  "Print a chat message when a cooldown becomes ready to raid chat.",
							order = 7,
							get = function(v) return Display.db.profile.frames[i].RaidMsg end,
							set = function(info, v) Display.db.profile.frames[i].RaidMsg = v; Display:UpdateDisplay() end,
						},
						UsedMsg = {
							type = "toggle",
							name =  "Used Message (Self)",
							desc =  "Print a chat message when a cooldown is used to self.",
							order = 8,
							get = function(v) return Display.db.profile.frames[i].UsedMsg end,
							set = function(info, v) Display.db.profile.frames[i].UsedMsg = v; Display:UpdateDisplay() end,
						},
						permanent = {
							type = "toggle",
							name = "Permanent Bars (Show when ready)",
							desc = "Displays the spells even when ready.",
							--width = "double",
							get = function(v) return Display.db.profile.frames[i].permanent end,
							set = function(info, v) 
								if v then
									Display.db.profile.frames[i].permanent = v;  
									if FatCooldowns.raidRoster then Display:RaidUpdate(FatCooldowns.raidRoster,{},i) end
								else
									if FatCooldowns.raidRoster then Display:RaidUpdate({},FatCooldowns.raidRoster,i) end
									Display.db.profile.frames[i].permanent = v;  
								end
								
								Display:UpdateDisplay()
							end,
							order = 9,
						},
						growUp = {
							type = "toggle",
							name =  "Grow Up",
							desc =  "Grow bars upwards",
							get = function(v) return Display.db.profile.frames[i].growUp end,
							set = function(info, v) Display.db.profile.frames[i].growUp = v; Display:UpdateDisplay() end,
							order = 10,
						},
						HideLabel = {
							type = "toggle",
							name =  "Hide Label",
							desc =  "Hides Labels from bars",
							disabled = function() if Display.db.profile.frames[i].SpellNameLabel then Display.db.profile.frames[i].HideLabel = false return true else return false end end,
							get = function(v) return Display.db.profile.frames[i].HideLabel end,
							set = function(info, v) Display.db.profile.frames[i].HideLabel = v; Display:UpdateDisplay() end,
							order = 10.5,
						},
						SpellNameLabel = {
							type = "toggle",
							name =  "Spell Name Label",
							desc =  "Gives the bars the label of the spells",
							disabled = function() if Display.db.profile.frames[i].HideLabel then Display.db.profile.frames[i].SpellNameLabel = false return true else return false end end,
							get = function(v) return Display.db.profile.frames[i].SpellNameLabel end,
							set = function(info, v) Display.db.profile.frames[i].SpellNameLabel = v; Display:UpdateDisplay() end,
							order = 10.9,
						},
						scale = {
							type = "range",
							name =  "Scale",
							desc =  "Control the scale of the entire FatCooldowns GUI",
							min = 1, max = 250, step = 1, bigStep = 1,
							get = function(v) return Display.db.profile.frames[i].scale end,
							set = function(info, v) Display.db.profile.frames[i].scale = v; Display:UpdateDisplay() end,
							order = 11,
						},
						alpha = {
							type = "range",
							name =  "Alpha",
							desc =  "Control the transparency of the entire FatCooldowns GUI",
							min = 0, max = 100, step = 5, bigStep = 10,
							get = function(v) return Display.db.profile.frames[i].alpha end,
							set = function(info, v) Display.db.profile.frames[i].alpha = v; Display:UpdateDisplay() end,
							order = 12,
						},
						fontsize = {
							type = "range",
							name =  "Font Size",
							desc =  "The size of the font the bar will use",
							min = 5, max = 30, step = 1, bigStep = 1,
							get = function(v) return Display.db.profile.frames[i].fontsize end,
							set = function(info, v) Display.db.profile.frames[i].fontsize = v; Display:UpdateDisplay() end,
							order = 12.2,
						},
						height = {
							type = "range",
							name =  "Height",
							min = 1, max = 25, step = 1, bigStep = 1,
							get = function(v) return Display.db.profile.frames[i].height end,
							set = function(info, v) Display.db.profile.frames[i].height = v; Display:UpdateDisplay() end,
							order = 13,
							width = "double",
						},
						width = {
							type = "range",
							name =  "Width",
							min = 50, max = 500, step = 5, bigStep = 10,
							get = function(v) return Display.db.profile.frames[i].width end,
							set = function(info, v) Display.db.profile.frames[i].width = v; Display:UpdateDisplay() end,
							order = 14,
							width = "double",
						},
						posX = {
							type = 'range',
							name =  "X Position",
							desc =  "Allows you to move the frame. if this is disabled your bars are locked, you can unlock them in the General options tab",
							disabled = function() if not Display.db.profile.locked then return false elseif Display.db.profile.locked then return true end end,
						    softMin = 0,
            				softMax = math.ceil(GetScreenWidth()),
           					step = 1,
            				bigStep = 5,
							get = function(info) return tonumber(Display.db.profile.frames[i].posX) end,
							set = function(info, v)
								Display.db.profile.frames[i].posX = tonumber(v)
								Display:SetAnchors(true)
							end,
							order = 15,
							width = "double",
						},
						posY = {
							type = 'range',
							name =  "Y Position",
							desc =  "Allows you to move the frame. if this is disabled your bars are locked, you can unlock them in the General options tab",
							disabled = function() if not Display.db.profile.locked then return false elseif Display.db.profile.locked then return true end end,
						    softMin = 0,
            				softMax = math.ceil(GetScreenHeight()),
           					step = 1,
            				bigStep = 5,
							get = function(info) return tonumber(Display.db.profile.frames[i].posY) end,
							set = function(info, v)
								Display.db.profile.frames[i].posY = tonumber(v)
								Display:SetAnchors(true)
							end,
							order = 16,
							width = "double",
						},
						descr3 = {
							type = "description",
							name =  "\nNote: When a spell does not have a real cooldown e.g. Piercing Howl a 5 sec cooldown is used, Spells with * at the start of the name will have extra info in the tooltip\n",
							width = "full",
							fontSize  = "medium",
							order = 16.8,
						},
					},
				};

				
				local tab = optArgs["frame"..i].args
				local orderIndex = 17 -- Sorting
				local tempsortingcount = 0
				local bubbleorder = nil
				local bubbleorder2 = nil
				local bubbleorder3 = nil
			-- class bars
				for _, class in ipairs(classes) do
					if class == "DEATHKNIGHT" or class == "DRUID" or class == "MAGE" or class == "PALADIN" or class == "PRIEST" or class == "ROGUE" or class == "SHAMAN" or class == "WARLOCK" or class == "HUNTER" or class == "WARRIOR" then
						tab[class] = {
							type = "header",
							name =  class,
							cmdHidden = true,
							order = orderIndex,
						}
						orderIndex = orderIndex + 1
						for spellInfo, spellTable in pairs(FatCooldowns.cooldowns[class]) do
							local name, rank, icon, castTime, minRange, maxRange, spellID = GetSpellInfo(spellTable.id)

							local item = spellTable.itemid
							local id = spellTable.descid or spellTable.realid or spellTable.id
							local spellDesc = "??"
							if id then
								if item == nil then
									tooltip:SetHyperlink("spell:"..id)
								else
									tooltip:SetHyperlink("item:"..item)
								end
								local lines = tooltip:NumLines()
								if lines > 0 then
									spellDesc = _G[folder.."TooltipTextLeft"..lines] and _G[folder.."TooltipTextLeft"..lines]:GetText() or "??"
									if spellTable.desc ~= nil then 
										spellDesc = spellDesc.."\n\n"..spellTable.desc
									end
								end
							end


							if spellTable.icon ~= nil then icon = spellTable.icon end
							tab[tostring(spellTable.id)] = {
								type = "toggle",
								name = (spellTable.sortname ~= nil and "|T"..icon..":24:24:0:0:64:64:6:58:6:58|t "..spellTable.sortname) or (type(spellInfo) == "number" and (GetSpellInfo(spellInfo) .. " [#" .. spellInfo .. "]") or "|T"..icon..":24:24:0:0:64:64:6:58:6:58|t "..spellInfo),
								desc = spellDesc,
								order = orderIndex + spellTable.sort,
								get = function(info) return Display.db.profile.frames[i].spells[spellTable.id] end,
								set = function(info, val)
									Display.db.profile.frames[i].spells[spellTable.id] = val
									Display:SpellToggle(i,spellTable.id, val)
								end,
								cmdHidden = true,
							}
							tempsortingcount = tempsortingcount + 1
						end 
						orderIndex = orderIndex + tempsortingcount + 1 tempsortingcount = 0
					end
				end
			-- extra bars not class
				for _, class in ipairs(classes) do
					if class == "ITEMS" or class == "RACIALS" or class == "CONSUMABLES" or class == "Tank Only Cooldowns" or class == "OTHER BARS" or class == "ITEM PROC" then
						tab[class] = {
							type = "header",
							name =  class,
							cmdHidden = true,
							order = orderIndex,
						}
						orderIndex = orderIndex + 1
						for spellInfo, spellTable in pairs(FatCooldowns.cooldowns[class]) do
							local name, rank, icon, castTime, minRange, maxRange, spellID = GetSpellInfo(spellTable.id)

							local proc = spellTable.proc
							local item = spellTable.itemid
							local id = spellTable.realid or spellTable.id
							local spellDesc = "??"
							if id and proc == nil then
								if item == nil then
									tooltip:SetHyperlink("spell:"..id)
								else
									tooltip:SetHyperlink("item:"..item)
								end
								local lines = tooltip:NumLines()
								if lines > 0 then
									spellDesc = _G[folder.."TooltipTextLeft"..lines] and _G[folder.."TooltipTextLeft"..lines]:GetText() or "??"
									if spellTable.desc ~= nil then 
										spellDesc = spellDesc.."\n\n"..spellTable.desc
									end
								end
							elseif spellTable.desc ~= nil then spellDesc = spellTable.desc
							end

							if spellTable.icon ~= nil then icon = spellTable.icon end
							tab[tostring(spellTable.id)] = {
								type = "toggle",
								name = (spellTable.sortname ~= nil and "|T"..icon..":24:24:0:0:64:64:6:58:6:58|t "..spellTable.sortname) or (type(spellInfo) == "number" and (GetSpellInfo(spellInfo) .. " [#" .. spellInfo .. "]") or "|T"..icon..":24:24:0:0:64:64:6:58:6:58|t "..spellInfo),
								desc =  spellDesc,
								order = orderIndex,
								get = function(info) return Display.db.profile.frames[i].spells[spellTable.id] end,
								set = function(info, val)
									Display.db.profile.frames[i].spells[spellTable.id] = val
									Display:SpellToggle(i,spellTable.id, val)
								end,
								cmdHidden = true,
							}
							orderIndex = orderIndex + 1
						end
					end
				end

				local otherorderIndex = 17
			--reporter - other
				for _, class in ipairs(reporters) do
					if class == "OTHER" then
						options.args.other.args[class] = {
							name = "REPORTER",
							type = "header",
							cmdHidden = true,
							order = 17,
						}
						for spellInfo, spellTable in pairs(FatCooldowns.reporter["OTHER"]) do
							if spellInfo:find("^Header[%d]+$") then
								options.args.other.args[tostring(spellTable.id)] = {
									name = spellTable.desc,
									type = "header",
									cmdHidden = true,
									order = otherorderIndex + spellTable.sort,
								}
							end
							if spellTable.id ~= 99803 and spellTable.id ~= 99804 and not spellInfo:find("^Header[%d]+$") then
								options.args.other.args[tostring(spellTable.id)] = {
									type = "toggle",
									name = spellInfo,
									desc =  spellTable.desc,
									order = otherorderIndex + spellTable.sort,
									width = "double",
									get = function(info) return Display.db.profile.reporter[spellTable.id] end,
									set = function(info, val)
										Display.db.profile.reporter[spellTable.id] = val
									end,
									cmdHidden = true,
								}
							elseif spellTable.id == 99804 and not spellInfo:find("^Header[%d]+$") then
								options.args.other.args[tostring(spellTable.id)] = {
									type = "range",
									name = spellInfo,
									desc = spellTable.desc,
									min = 0, max = spellTable.max, step = 1, bigStep = 1,
									get = function(v) return Display.db.profile.SoulStoneCount end,
									set = function(info, v) Display.db.profile.SoulStoneCount = v end,
									order = otherorderIndex + 999,
									width = "double",
								} 
							end
						end 
					end 
				end

			--reporter
				for _, class in ipairs(reporters) do
					if class ~= "OTHER" then
						options.args.ChatReporter.args[class] = {
							type = "header",
							name =  class,
							cmdHidden = true,
							order = orderIndex,
						}
						orderIndex = orderIndex + 1
						for spellInfo, spellTable in pairs(FatCooldowns.reporter[class]) do
							options.args.ChatReporter.args[tostring(spellTable.id)] = {
								type = "toggle",
								name = spellInfo,
								desc =  spellTable.desc,
								order = orderIndex,
								get = function(info) return Display.db.profile.reporter[spellTable.id] end,
								set = function(info, val)
									Display.db.profile.reporter[spellTable.id] = val
								end,
								cmdHidden = true,
							}
							orderIndex = orderIndex + 1
						end 
					end 
				end

			--chat filter
				for _, class in ipairs(ChatFilters) do
					options.args.ChatFilter.args[class] = {
						type = "header",
						name =  class,
						cmdHidden = true,
						order = orderIndex,
					}
					if class == "CHAT FILTER - Bubbles" then bubbleorder = orderIndex end
					orderIndex = orderIndex + 1
					for spellInfo, spellTable in pairs(FatCooldowns.chatfilter[class]) do
						if spellTable.id == 99917 then bubbleorder2 = orderIndex orderIndex = bubbleorder + 0.01 end
						if spellTable.id == 99897 then bubbleorder3 = orderIndex orderIndex = bubbleorder + 0.02 end
						if spellTable.id == 99917 or spellTable.id == 99897 then
							options.args.ChatFilter.args[tostring(spellTable.id)] = {
								type = "toggle",
								name = spellInfo,
								desc =  spellTable.desc,
								order = orderIndex,
								width = "full",
								disabled = function()
									if spellInfo == "Bubbles Only" and Display.db.profile.chatfilter[99917] then return false
									elseif spellInfo == "Bubbles Only" and not Display.db.profile.chatfilter[99917] then Display.db.profile.chatfilter[99897] = false return true end
								end,
								get = function(info) return Display.db.profile.chatfilter[spellTable.id] end,
								set = function(info, val)
									Display.db.profile.chatfilter[spellTable.id] = val
									Display:Chatfiltercheck()
								end,
								cmdHidden = true,
							}
						else
							options.args.ChatFilter.args[tostring(spellTable.id)] = {
								type = "toggle",
								name = type(spellInfo) == "number" and (GetSpellInfo(spellInfo) .. " [#" .. spellInfo .. "]") or spellInfo,
								disabled = function()
									if spellInfo == "Monster/NPC Bubbles" and Display.db.profile.chatfilter[99917] then return false
									elseif spellInfo == "Monster/NPC Bubbles" and not Display.db.profile.chatfilter[99917] then Display.db.profile.chatfilter[99916] = false return true end
													
									if spellInfo == "Japanese, Chinese and Korean Bubbles" and Display.db.profile.chatfilter[99917] then return false
									elseif spellInfo == "Japanese, Chinese and Korean Bubbles" and not Display.db.profile.chatfilter[99917] then Display.db.profile.chatfilter[99915] = false return true end

									if spellInfo == "Russian Bubbles" and Display.db.profile.chatfilter[99917] then return false
									elseif spellInfo == "Russian Bubbles" and not Display.db.profile.chatfilter[99917] then Display.db.profile.chatfilter[99913] = false return true end

									if spellInfo == "Bubbles Shekles Spam List" and Display.db.profile.chatfilter[99917] then return false
									elseif spellInfo == "Bubbles Shekles Spam List" and not Display.db.profile.chatfilter[99917] then Display.db.profile.chatfilter[99934] = false return true end

									if spellInfo == "Innervate Bubbles" and Display.db.profile.chatfilter[99917] then return false
									elseif spellInfo == "Innervate Bubbles" and not Display.db.profile.chatfilter[99917] then Display.db.profile.chatfilter[99933] = false return true end

									if spellInfo == "Spanish Bubbles" and Display.db.profile.chatfilter[99917] then return false
									elseif spellInfo == "Spanish Bubbles" and not Display.db.profile.chatfilter[99917] then Display.db.profile.chatfilter[99937] = false return true end

									if spellInfo == "Unbound Plague" and Display.db.profile.chatfilter[99917] then return false
									elseif spellInfo == "Unbound Plague" and not Display.db.profile.chatfilter[99917] then Display.db.profile.chatfilter[99938] = false return true end

								end,
								desc =  spellTable.desc,
								order = orderIndex,
								get = function(info) return Display.db.profile.chatfilter[spellTable.id] end,
								set = function(info, val)
									Display.db.profile.chatfilter[spellTable.id] = val
									Display:Chatfiltercheck()
								end,
								cmdHidden = true,
							}
						end
						if spellTable.id == 99917 then orderIndex = bubbleorder2 end
						if spellTable.id == 99897 then orderIndex = bubbleorder3 end
						orderIndex = orderIndex + 1
					end 
				end 
			end -- end of not optArgs["frame"..i]

		local orderIndexCR = 17 -- Sorting
		for _, class in ipairs(ChatFilters) do
			options.args.ChatFilter.args.ChatFilterReporter2.args[class] = {
				type = "header",
				name =  class,
				cmdHidden = true,
				order = orderIndexCR,
				}
				orderIndexCR = orderIndexCR + 1
			for spellInfo, spellTable in pairs(FatCooldowns.chatfilter[class]) do
				if spellTable.id ~= 99917 and spellTable.id ~= 99897 then
					if Display.db.profile.ChatFilterReporter2[spellTable.id] == nil then Display.db.profile.ChatFilterReporter2[spellTable.id] = 0 end 
					options.args.ChatFilter.args.ChatFilterReporter2.args[tostring(spellTable.id)] = {
					type = "range",
					name = spellInfo,
					desc = spellTable.desc,
					min = 0, max = 10, step = 1, bigStep = 1,
					get = function(v) return Display.db.profile.ChatFilterReporter2[spellTable.id] end,
					set = function(info, v) Display.db.profile.ChatFilterReporter2[spellTable.id] = v end,
					hidden = function() if Display.db.profile.chatfilter[spellTable.id] then return false elseif not Display.db.profile.chatfilter[spellTable.id] then Display.db.profile.ChatFilterReporter2[spellTable.id] = 0 return true end end,
					order = orderIndexCR,
					width = "normal",
					cmdHidden = true,
					}
					
				end
				orderIndexCR = orderIndexCR + 1
			end 
		end
	

	--soundspells
		local orderIndex2 = 17 -- Sorting
		local tempsortingcount2 = 0
				
		for _, class in ipairs(classes) do
			if class == "DEATHKNIGHT" or class == "DRUID" or class == "MAGE" or class == "PALADIN" or class == "PRIEST" or class == "ROGUE" or class == "SHAMAN" or class == "WARLOCK" or class == "HUNTER" or class == "WARRIOR" or class == "OTHER BARS" then
				options.args.soundspells.args[class] = {
					type = "header",
					name =  class,
					cmdHidden = true,
					order = orderIndex2,
				}
				orderIndex2 = orderIndex2 + 1
				for spellInfo, spellTable in pairs(FatCooldowns.cooldowns[class]) do
					local name, rank, icon, castTime, minRange, maxRange, spellID = GetSpellInfo(spellTable.id)
					if spellTable.icon ~= nil then icon = spellTable.icon end
					if spellTable.id ~= 69766 then
						options.args.soundspells.args[tostring(spellTable.id)] = {
							type = "toggle",
							name = (spellTable.sortname ~= nil and "|T"..icon..":24:24:0:0:64:64:6:58:6:58|t "..spellTable.sortname) or (type(spellInfo) == "number" and (GetSpellInfo(spellInfo) .. " [#" .. spellInfo .. "]") or "|T"..icon..":24:24:0:0:64:64:6:58:6:58|t "..spellInfo),
							desc =  spellTable.desc or string.format("Plays sound for "..(spellTable.sortname or "%s"),spellInfo),
							order = orderIndex2 + spellTable.sort,
							get = function(info) return Display.db.profile.soundspells[spellTable.id] end,
							set = function(info, val)
								if val then
									Display.db.profile.soundspells[spellTable.id] = val
									Display.db.profile.soundspellsoptions[spellTable.id] = {id = spellTable.id, EnemyCaster = false, NotTargetMe = false, TargetMe = false, FriendlyCaster = false, NotSelf = false, CDUsed = false, CDReady = false,
										Self = false, PlayerClassEnable = false, Spec1 = false, Spec2 = false, EnableCustomSound = false, CustomSound = "None",
										PlayerClass = {DEATHKNIGHT = false, DRUID = false, HUNTER = false, MAGE = false, PALADIN = false, PRIEST = false, ROGUE = false, SHAMAN = false, WARLOCK = false, WARRIOR = false}
									}
								else
									Display.db.profile.soundspells[spellTable.id] = nil
									Display.db.profile.soundspellsoptions[spellTable.id] = nil
								end
								FatCooldowns.RefreshFrameListOptionsAndVariables();
							end,
							cmdHidden = true,
						}
						tempsortingcount2 = tempsortingcount2 + 1
					end
				end
				orderIndex2 = orderIndex2 + tempsortingcount2 + 1 tempsortingcount2 = 0
			end 
		end

		options.args.soundspells.args.soundspellsoptions.args = {
			descr = {
				type = "description",
				name =  "Select which Spells Sounds you would like to enable.\n\nNote: Not every spell option has been tested please report if you find a broken one, if a sound no longer works after an update try disabling the sound and re-enable it",
				width = "full",
				fontSize  = "medium",
				order = 1,
			},
		};
	
		local orderIndex = 2 
		for spellID, on in pairs(Display.db.profile.soundspells) do 
			local tempname = nil
			local ssname, ssrank, ssicon, sscastTime, ssminRange, ssmaxRange, ssspellID = GetSpellInfo(spellID)

			for _, class in ipairs(classes) do
				for spellInfo, spellTable in pairs(FatCooldowns.cooldowns[class]) do
					if spellTable.id == spellID then tempname = spellTable.sortname end
					if spellTable.id == spellID and spellTable.icon ~= nil then ssicon = spellTable.icon end
				end
			end

			options.args.soundspells.args.soundspellsoptions.args[tostring(spellID)] =  {
				type = "header",
				name =  (tempname ~= nil and "|T"..ssicon..":24:24:0:0:64:64:6:58:6:58|t "..tempname) or ("|T"..ssicon..":24:24:0:0:64:64:6:58:6:58|t "..string.format("%s",GetSpellInfo(spellID))),
				order = orderIndex,
				width = "full",
			};
			options.args.soundspells.args.soundspellsoptions.args[tostring(spellID).."CDUsed"] =  {
				type = "toggle",
				name =  "Spell Used",
				desc =  "this will make the sound active only when the spell is used.",
				get = function(v) return Display.db.profile.soundspellsoptions[spellID].CDUsed end,
				set = function(info, v) Display.db.profile.soundspellsoptions[spellID].CDUsed = v end,
				order = orderIndex + 0.1,
				width = "normal",
			};
			options.args.soundspells.args.soundspellsoptions.args[tostring(spellID).."CDReady"] =  {
				type = "toggle",
				name =  "Spell Ready",
				desc =  "this will make the sound active only when the spell has become ready.\n\nNote: you will need to also track the spell via bars for this sound to work.",
				get = function(v) return Display.db.profile.soundspellsoptions[spellID].CDReady end,
				set = function(info, v) Display.db.profile.soundspellsoptions[spellID].CDReady = v end,
				order = orderIndex + 0.2,
				width = "normal",
			};
			options.args.soundspells.args.soundspellsoptions.args[tostring(spellID).."EnemyCaster"] =  {
				type = "toggle",
				name =  "Enemy Caster",
				desc =  "this will make the sound active only when the spell is cast by an enemy player.",
				get = function(v) return Display.db.profile.soundspellsoptions[spellID].EnemyCaster end,
				set = function(info, v) Display.db.profile.soundspellsoptions[spellID].EnemyCaster = v end,
				order = orderIndex + 0.3,
				width = "normal",
			};
			options.args.soundspells.args.soundspellsoptions.args[tostring(spellID).."FriendlyCaster"] =  {
				type = "toggle",
				name =  "Friendly Caster",
				desc =  "this will make the sound active only when the spell is cast by an friendly player.",
				get = function(v) return Display.db.profile.soundspellsoptions[spellID].FriendlyCaster end,
				set = function(info, v) Display.db.profile.soundspellsoptions[spellID].FriendlyCaster = v end,
				order = orderIndex + 0.4,
				width = "normal",
			};
			options.args.soundspells.args.soundspellsoptions.args[tostring(spellID).."TargetMe"] =  {
				type = "toggle",
				name =  "Targeting Me",
				desc =  "this will make the sound active only when the spell targeting you.",
				get = function(v) return Display.db.profile.soundspellsoptions[spellID].TargetMe end,
				set = function(info, v) Display.db.profile.soundspellsoptions[spellID].TargetMe = v end,
				order = orderIndex + 0.5,
				width = "normal",
			};
			options.args.soundspells.args.soundspellsoptions.args[tostring(spellID).."NotTargetMe"] =  {
				type = "toggle",
				name =  "Not Targeting Me",
				desc =  "this will make the sound active only when the spell is not targeting you.",
				get = function(v) return Display.db.profile.soundspellsoptions[spellID].NotTargetMe end,
				set = function(info, v) Display.db.profile.soundspellsoptions[spellID].NotTargetMe = v end,
				order = orderIndex + 0.6,
				width = "normal",
			};
			options.args.soundspells.args.soundspellsoptions.args[tostring(spellID).."NotSelf"] =  {
				type = "toggle",
				name =  "Not Cast By Me",
				desc =  "this will make the sound active only when the spell is not cast by you.",
				get = function(v) return Display.db.profile.soundspellsoptions[spellID].NotSelf end,
				set = function(info, v) Display.db.profile.soundspellsoptions[spellID].NotSelf = v end,
				order = orderIndex + 0.7,
				width = "normal",
			};
			options.args.soundspells.args.soundspellsoptions.args[tostring(spellID).."Self"] =  {
				type = "toggle",
				name =  "Cast By Me",
				desc =  "this will make the sound active only when the spell is cast by you.",
				get = function(v) return Display.db.profile.soundspellsoptions[spellID].Self end,
				set = function(info, v) Display.db.profile.soundspellsoptions[spellID].Self = v end,
				order = orderIndex + 0.8,
				width = "normal",
			};
			options.args.soundspells.args.soundspellsoptions.args[tostring(spellID).."PlayerClassEnable"] =  {
				type = "toggle",
				name =  "Player Class Enable",
				desc =  "this will enable the player class option.",
				get = function(v) return Display.db.profile.soundspellsoptions[spellID].PlayerClassEnable end,
				set = function(info, v) Display.db.profile.soundspellsoptions[spellID].PlayerClassEnable = v end,
				order = orderIndex + 0.81,
				width = "normal",
			};
			options.args.soundspells.args.soundspellsoptions.args[tostring(spellID).."Spec1"] =  {
				type = "toggle",
				name =  "Primary Spec",
				desc =  "this will make the sound active only when you have your Primary Spec active.",
				disabled = function() if Display.db.profile.soundspellsoptions[spellID].Spec2 then Display.db.profile.soundspellsoptions[spellID].Spec1 = false return true else return false end end,
				get = function(v) return Display.db.profile.soundspellsoptions[spellID].Spec1 end,
				set = function(info, v) Display.db.profile.soundspellsoptions[spellID].Spec1 = v end,
				order = orderIndex + 0.811,
				width = "normal",
			};
			options.args.soundspells.args.soundspellsoptions.args[tostring(spellID).."Spec2"] =  {
				type = "toggle",
				name =  "Secondary Spec",
				desc =  "this will make the sound active only when you have your Secondary Spec active.",
				disabled = function() if Display.db.profile.soundspellsoptions[spellID].Spec1 then Display.db.profile.soundspellsoptions[spellID].Spec2 = false return true else return false end end,
				get = function(v) return Display.db.profile.soundspellsoptions[spellID].Spec2 end,
				set = function(info, v) Display.db.profile.soundspellsoptions[spellID].Spec2 = v end,
				order = orderIndex + 0.812,
				width = "normal",
			};
			options.args.soundspells.args.soundspellsoptions.args[tostring(spellID).."EnableCustomSound"] =  {
				type = "toggle",
				name =  "Enable Custom Sound",
				desc =  "this will enable the Custom set sound to play instead of the spell name.",
				get = function(v) return Display.db.profile.soundspellsoptions[spellID].EnableCustomSound end,
				set = function(info, v) Display.db.profile.soundspellsoptions[spellID].EnableCustomSound = v end,
				order = orderIndex + 0.813,
				width = "normal",
			};
			options.args.soundspells.args.soundspellsoptions.args[tostring(spellID).."CustomSound"] =  {
				type = "select",
				name =  "Custom Sound",
				desc =  "this will enable the Custom set sound to play instead of the spell name.",
				hidden = function() if Display.db.profile.soundspellsoptions[spellID].EnableCustomSound then return false elseif not Display.db.profile.soundspellsoptions[spellID].EnableCustomSound then return true end end,
				values = function()
				local SoundName = {}
					for CustomSoundName, CustomSoundPath in pairs(FatCooldowns.FCDSounds) do
						SoundName[CustomSoundName] = CustomSoundName
					end
					return SoundName
				end,
				get = function(info, v, v2) return Display.db.profile.soundspellsoptions[spellID].CustomSound
				end,
				set = function(info, v, v2) Display.db.profile.soundspellsoptions[spellID].CustomSound = v end,
				order = orderIndex + 0.814,
				width = "normal",
			};
			options.args.soundspells.args.soundspellsoptions.args[tostring(spellID).."PlayerClass"] =  {
				type = "multiselect",
				name =  "Player Class",
				hidden = function() if Display.db.profile.soundspellsoptions[spellID].PlayerClassEnable then return false elseif not Display.db.profile.soundspellsoptions[spellID].PlayerClassEnable then return true end end,

				disabled = function() if Display.db.profile.soundspellsoptions[spellID].PlayerClassEnable then return false elseif not Display.db.profile.soundspellsoptions[spellID].PlayerClassEnable then
					for val, key in pairs(Display.db.profile.soundspellsoptions[spellID].PlayerClass) do
						Display.db.profile.soundspellsoptions[spellID].PlayerClass[val] = false
					end
					return true end end,
				desc =  "this will make the sound active only when the player class matchers one of the selected.",
				values = {DEATHKNIGHT = "DEATHKNIGHT", DRUID = "DRUID", HUNTER = "HUNTER", MAGE = "MAGE", PALADIN = "PALADIN", PRIEST = "PRIEST", ROGUE = "ROGUE", SHAMAN = "SHAMAN", WARLOCK = "WARLOCK", WARRIOR = "WARRIOR"},
				get = function(info, v) return Display.db.profile.soundspellsoptions[spellID].PlayerClass[v] end,
				set = function(info, v, v2) Display.db.profile.soundspellsoptions[spellID].PlayerClass[v] = v2 end,
				order = orderIndex + 0.82,
				width = "normal",
			};

			orderIndex = orderIndex + 1
		end

			optArgs["frame"..i].name = Display.db.profile.frames[i].name .. " Options";			
		else
			optArgs["frame"..i] = nil; -- hide config
		end	
	end
	
	if not options.args.spellOrder.args["WARRIOR"] then
		local tab = options.args.spellOrder.args
		local orderIndex = 2 
		local tempsortingcount = 0
		
		for _, class in ipairs(classes) do
			if class == "DEATHKNIGHT" or class == "DRUID" or class == "MAGE" or class == "PALADIN" or class == "PRIEST" or class == "ROGUE" or
			class == "SHAMAN" or class == "WARLOCK" or class == "HUNTER" or class == "WARRIOR" then
			tab[class] = {
				type = "header",
				name =  class,
				cmdHidden = true,
				order = orderIndex,
			}
			orderIndex = orderIndex + 1
			for spellInfo, spellTable in pairs(FatCooldowns.cooldowns[class]) do
				local name, rank, icon, castTime, minRange, maxRange, spellID = GetSpellInfo(spellTable.id)
				if spellTable.icon ~= nil then icon = spellTable.icon end
				if spellTable.id <= 89999 then
					tab[tostring(spellTable.id)] = {
						type = "toggle",
						name = (spellTable.sortname ~= nil and "|T"..icon..":24:24:0:0:64:64:6:58:6:58|t "..spellTable.sortname) or (type(spellInfo) == "number" and (GetSpellInfo(spellInfo) .. " [#" .. spellInfo .. "]") or "|T"..icon..":24:24:0:0:64:64:6:58:6:58|t "..spellInfo),
						desc =  string.format("Select %s",spellInfo),
						order = orderIndex + spellTable.sort,
						get = function(info) return Display.db.profile.orderSpells[spellTable.id] end,
						set = function(info, val)
							if val then
								Display.db.profile.orderSpells[spellTable.id] = val;
							else
								Display.db.profile.orderSpells[spellTable.id] = nil;
								Display.db.profile.orderSpellPriorities[spellTable.id] = nil;
								FatCooldowns.spellInfoTable[spellTable.id] = 500;
							end
							FatCooldowns.RefreshFrameListOptionsAndVariables();
						end,
						cmdHidden = true,
					}
				end
				tempsortingcount = tempsortingcount + 1
			end 
			orderIndex = orderIndex + tempsortingcount + 1 tempsortingcount = 0
		end	
	end

		for _, class in ipairs(classes) do
			if class == "ITEMS" or class == "RACIALS" or class == "CONSUMABLES" or class == "OTHER BARS" then
				tab[class] = {
					type = "header",
					name =  class,
					cmdHidden = true,
					order = orderIndex,
				}
				orderIndex = orderIndex + 1
				for spellInfo, spellTable in pairs(FatCooldowns.cooldowns[class]) do
					local name, rank, icon, castTime, minRange, maxRange, spellID = GetSpellInfo(spellTable.id)
					if spellTable.icon ~= nil then icon = spellTable.icon end
					if spellTable.id <= 89999 then
						tab[tostring(spellTable.id)] = {
							type = "toggle",
							name = (spellTable.sortname ~= nil and "|T"..icon..":24:24:0:0:64:64:6:58:6:58|t "..spellTable.sortname) or (type(spellInfo) == "number" and (GetSpellInfo(spellInfo) .. " [#" .. spellInfo .. "]") or "|T"..icon..":24:24:0:0:64:64:6:58:6:58|t "..spellInfo),
							desc =  string.format("Select %s",(spellTable.sortname or spellInfo)),
							order = orderIndex,
							get = function(info) return Display.db.profile.orderSpells[spellTable.id] end,
							set = function(info, val)
								if val then
									Display.db.profile.orderSpells[spellTable.id] = val;
								else
									Display.db.profile.orderSpells[spellTable.id] = nil;
									Display.db.profile.orderSpellPriorities[spellTable.id] = nil;
									FatCooldowns.spellInfoTable[spellTable.id] = 500;
								end
								FatCooldowns.RefreshFrameListOptionsAndVariables();
							end,
							cmdHidden = true,
						}
						orderIndex = orderIndex + 1
					end
				end
			end
		end
	end	
	
	options.args.spellOrder.args.spells.args = {
		descr = {
			type = "description",
			name =  "All unselected spells have priority 500 - select higher or lower to move your spell higher or lower in priority list. Higher priority is closer to anchor.",
			width = "full",
			fontSize  = "medium",
			order = 1,
		},
	};
	
	local orderIndex = 2 
	for spellID, on in pairs(Display.db.profile.orderSpells) do 
		local tempname = nil
		local soname, sorank, soicon, socastTime, sominRange, somaxRange, sospellID = GetSpellInfo(spellID)
		for _, class in ipairs(classes) do
			for spellInfo, spellTable in pairs(FatCooldowns.cooldowns[class]) do
				if spellTable.id == spellID then tempname = spellTable.sortname end
				if spellTable.id == spellID and spellTable.icon ~= nil then soicon = spellTable.icon end
			end
		end
		options.args.spellOrder.args.spells.args[tostring(spellID)] =  {
			type = "range",
			name =  (tempname ~= nil and "|T"..soicon..":24:24:0:0:64:64:6:58:6:58|t "..tempname) or ("|T"..soicon..":24:24:0:0:64:64:6:58:6:58|t "..string.format("%s",GetSpellInfo(spellID))),
			desc =  "Set spell's display order priority",
			min = 1, max = 1000, step = 1, bigStep = 10,
			get = function(info) 
				if Display.db.profile.orderSpellPriorities[spellID] then FatCooldowns.spellInfoTable[spellID].order = Display.db.profile.orderSpellPriorities[spellID]; end
				return Display.db.profile.orderSpellPriorities[spellID] or 500 
			end,
			set = function(info, val)
				Display.db.profile.orderSpellPriorities[spellID] = val
			end,
			order = 2,
			width = "full",
		};
		orderIndex = orderIndex + 1
	end
	Display:UpdateDisplay()
end


options = {
	name = "FCD |cffFF7C0AShekles|r Version",
	type = "group",
	args = {
		BlizOptions ={
			type = "group",
			name = "Open Standalone Dialog",
			args={
				config = {
					order= 0.1,
					type = "execute",
					name = "/FCD",
					desc = "Opens the setup options in a movable standalone dialog",
					func = function() FatCooldowns:OpenConfigDialog() end
				},
			},
		},
		test = {
			type = "execute",
			name =  "Test",
			desc =  "Tests all the tracked spells",
			order = 1.1,
			func = Display.Test,
			width = "half"
		},
		reset = {
			type = "execute",
			name =  "Reset",
			desc =  "Reset the cooldown on all tracked spells",
			order = 1.2,
			func = Display.Reset,
			width = "half"
		},
		resetspells = {
			type = "execute",
			name =  "Reset Spells",
			desc =  "Rests all tracked spells, you will no longer be tracking any spells.",
			order = 1.3,
			func = function() Display:resetspells() end,
			width = "normal",
			confirm = true
		},
		display = {
			type = "group",
			name =  "General Options",
			desc =  "General Options",
			order = 1.9,
			cmdHidden = true,
			args = {
				HideAllFrames = {
					type = 'toggle',
					name =  "Disable Addon",
					desc =  "this will hide all the frames which will disable the addon",
					get = function(v) return Display.db.profile.HideAllFrames end,
					set = function(info, v) Display.db.profile.HideAllFrames = v; Display:UpdateDisplay() end,
					order = 1,
				},
				HidePVP = {
					type = 'toggle',
					name =  "Hide in PVP",
					desc =  "This will hide/disable the addon in arena and battlegrounds",
					get = get,
					set = set,
					order = 2,
				},
				locked = {
					type = "toggle",
					name = "Lock Bars",
					desc = "Locks the bars in place and prevents it from being dragged.",
					get = get,
					set = set,
					order = 3,
				},
				clamped = {
					type = 'toggle',
					name =  "Clamp to screen",
					desc =  "Prevent the anchor from moving off screen.",
					get = get,
					set = set,
					order = 4,
				},
				MaxLvL = {
					type = 'toggle',
					name =  "Max Level",
					desc =  "Will only auto load permanent bars for max level players when they join your group.\n\nNote: This will not block permanent bars from being shown when the player uses the spell.",
					get = get,
					set = set,
					order = 5,
				},
				ArenaMode = {
					type = 'toggle',
					name =  "Arena Mode",
					desc =  "will attempt  to track CDs from people who are not in your party.\n\nNote: this will work with focus, target and arena1-5",
					get = get,
					set = set,
					order = 6,
				},
				fontbar = {
					type = "header",
					name =  "Bar Options",
					width = "full",
					order = 7,
				},
				orientation = {
					type = "select",
					name =  "Orientation",
					values = {  "Right to Left",  "Left to Right" },
					-- "2" in LibBars is top to bottom, but we only have 2 choices, so this is a bit of a cheat
					get = function(info) return (Display.db.profile.orientation == 3) and 2 or 1 end,
					set = function(info, v)
						Display.db.profile.orientation = (v == 2) and 3 or 1
						Display:UpdateDisplay()
					end,
					order = 8,
					width = nil,
				},
				texture = {
					type = "select",
					name =  "Texture",
					desc =  "The texture that the bar will use",
					values = textures,
					get = function(info) return GetLSMIndex("statusbar", Display.db.profile.texture) end,
					set = function(info, v)
						Display.db.profile.texture = Media:List("statusbar")[v]
						Display:UpdateDisplay()
					end,
					order = 9,
				},
				SymbolsStart = {
					type = "select",
					name =  "Start Symbol",
            		values =  {"None", "(",")", ">", "<","- ","+ ","@  ","* ","[","]","|","\\","/","->","<-"},
					desc =  "The Starting Symbol for the targeted person",
            		get = function(info)  
            		if Display.db.profile.SymbolsStart == "" then return 1 end
            		if Display.db.profile.SymbolsStart == "(" then return 2 end
            		if Display.db.profile.SymbolsStart == ")" then return 3 end
            		if Display.db.profile.SymbolsStart == ">" then return 4 end
            		if Display.db.profile.SymbolsStart == "<" then return 5 end
            		if Display.db.profile.SymbolsStart == "- " then return 6 end
            		if Display.db.profile.SymbolsStart == "+ " then return 7 end
            		if Display.db.profile.SymbolsStart == "@ " then return 8 end
            		if Display.db.profile.SymbolsStart == "* " then return 9 end
            		if Display.db.profile.SymbolsStart == "[" then return 10 end
            		if Display.db.profile.SymbolsStart == "]" then return 11 end
            		if Display.db.profile.SymbolsStart == "| " then return 12 end
            		if Display.db.profile.SymbolsStart == "\\" then return 13 end
            		if Display.db.profile.SymbolsStart == "/" then return 14 end
            		if Display.db.profile.SymbolsStart == "->" then return 15 end
            		if Display.db.profile.SymbolsStart == "<-" then return 16 end
            		end,
					set = function(t, value)
					if value == 1 then Display.db.profile.SymbolsStart = "" end
					if value == 2 then Display.db.profile.SymbolsStart = "(" end
					if value == 3 then Display.db.profile.SymbolsStart = ")" end
					if value == 4 then Display.db.profile.SymbolsStart = ">" end
					if value == 5 then Display.db.profile.SymbolsStart = "<" end
					if value == 6 then Display.db.profile.SymbolsStart = "- " end
					if value == 7 then Display.db.profile.SymbolsStart = "+ " end
					if value == 8 then Display.db.profile.SymbolsStart = "@ " end
					if value == 9 then Display.db.profile.SymbolsStart = "* " end
					if value == 10 then Display.db.profile.SymbolsStart = "[" end
					if value == 11 then Display.db.profile.SymbolsStart = "]" end
					if value == 12 then Display.db.profile.SymbolsStart = "| " end
					if value == 13 then Display.db.profile.SymbolsStart = "\\" end
					if value == 14 then Display.db.profile.SymbolsStart = "/" end
					if value == 15 then Display.db.profile.SymbolsStart = "->" end
					if value == 16 then Display.db.profile.SymbolsStart = "<-" end
						Display:UpdateDisplay()
					end,
					order = 10,
				},
				SymbolsEnd = {
					type = "select",
					name =  "End Symbol",
            		values =  {"None", "(",")", ">", "<"," -"," +"," @"," *","[","]","|","\\","/","->","<-"},
					desc =  "The Ending Symbol for the targeted person",
            		get = function(info)  
            		if Display.db.profile.SymbolsEnd == "" then return 1 end
            		if Display.db.profile.SymbolsEnd == "(" then return 2 end
            		if Display.db.profile.SymbolsEnd == ")" then return 3 end
            		if Display.db.profile.SymbolsEnd == ">" then return 4 end
            		if Display.db.profile.SymbolsEnd == "<" then return 5 end
            		if Display.db.profile.SymbolsEnd == " -" then return 6 end
            		if Display.db.profile.SymbolsEnd == " +" then return 7 end
            		if Display.db.profile.SymbolsEnd == " @" then return 8 end
            		if Display.db.profile.SymbolsEnd == " *" then return 9 end
            		if Display.db.profile.SymbolsEnd == "[" then return 10 end
            		if Display.db.profile.SymbolsEnd == "]" then return 11 end
            		if Display.db.profile.SymbolsEnd == " |" then return 12 end
            		if Display.db.profile.SymbolsEnd == "\\" then return 13 end
            		if Display.db.profile.SymbolsEnd == "/" then return 14 end
            		if Display.db.profile.SymbolsEnd == "->" then return 15 end
            		if Display.db.profile.SymbolsEnd == "<-" then return 16 end
            		end,
					set = function(t, value)
					if value == 1 then Display.db.profile.SymbolsEnd = "" end
					if value == 2 then Display.db.profile.SymbolsEnd = "(" end
					if value == 3 then Display.db.profile.SymbolsEnd = ")" end
					if value == 4 then Display.db.profile.SymbolsEnd = ">" end
					if value == 5 then Display.db.profile.SymbolsEnd = "<" end
					if value == 6 then Display.db.profile.SymbolsEnd = " -" end
					if value == 7 then Display.db.profile.SymbolsEnd = " +" end
					if value == 8 then Display.db.profile.SymbolsEnd = " @" end
					if value == 9 then Display.db.profile.SymbolsEnd = " *" end
					if value == 10 then Display.db.profile.SymbolsEnd = "[" end
					if value == 11 then Display.db.profile.SymbolsEnd = "]" end
					if value == 12 then Display.db.profile.SymbolsEnd = " |" end
					if value == 13 then Display.db.profile.SymbolsEnd = "\\" end
					if value == 14 then Display.db.profile.SymbolsEnd = "/" end
					if value == 15 then Display.db.profile.SymbolsEnd = "->" end
					if value == 16 then Display.db.profile.SymbolsEnd = "<-" end
						Display:UpdateDisplay()
					end,
					order = 11,
				},
				loadmore = {
					type = 'toggle',
					name =  "Load More Bars",
					desc =  "This will load more textures for the bars.\n\nNote: when you disable you will need to relog/reload",
					get = function(v) return Display.db.profile.loadmore end,
					set = function(info, v)
						Display.db.profile.loadmore = v
						Display:loadbars()
					end,
					order = 12,
				},
				FillBars = {
					type = 'toggle',
					name =  "Fill Bars",
					desc =  "This will change the direction the timer goes and will fill permanent bars background",
					get = function(v) return Display.db.profile.FillBars end,
					set = function(info, v)
						Display.db.profile.FillBars = v
						Display:UpdateDisplay("yes")
					end,
					order = 13,
				},
				removebackground = {
					type = 'toggle',
					name =  "Background Textures: Remove",
					disabled = function() if Display.db.profile.FillBackGround then Display.db.profile.removebackground = false return true else return false end end,
					desc =  "This will remove the background for permanent bars when they are ready\n\nNote: this will not remove the background from permanent bars already added",
					get = function(v) return Display.db.profile.removebackground end,
					set = function(info, v)
						Display.db.profile.removebackground = v
						Display:UpdateDisplay("yes")
					end,
					order = 13.5,
				},
				FillBackGround = {
					type = 'toggle',
					name =  "Background Textures: Fill",
					disabled = function() if Display.db.profile.removebackground then Display.db.profile.FillBackGround = false return true else return false end end,
					desc =  "This will fill the background for permanent bars when they are ready\n\nNote: this will not fill the background for permanent bars already added",
					get = function(v) return Display.db.profile.FillBackGround end,
					set = function(info, v)
						Display.db.profile.FillBackGround = v
						Display:UpdateDisplay("yes")
					end,
					order = 13.9,
				},
				EnableBGColor = {
					type = "toggle",	
					name =  "Enable Custom Background Color",
					desc =  "this will change the color of the bars background",
					get = get,
					set = set,
					order = 13.91,
				},
				BGColor = {
					type = "color",	
					name =  "Custom Background Color",
					disabled = function() if Display.db.profile.EnableBGColor then return false else return true end end,
					desc =  "this will change the color of the background to the set color",
					hasAlpha = true,
					get = function(info) return Display.db.profile.BGColor["r"], Display.db.profile.BGColor["g"], Display.db.profile.BGColor["b"], Display.db.profile.BGColor["a"] end,
					set = function(info, r, g, b, a)
						Display.db.profile.BGColor["r"] = r
						Display.db.profile.BGColor["g"] = g
						Display.db.profile.BGColor["b"] = b
						Display.db.profile.BGColor["a"] = a
						Display:UpdateDisplay("yes")
					end,
					order = 13.92,
				},
				iconzoom = {
					type = 'toggle',
					name =  "Icon Zoom",
					desc =  "Zoom in Icons, this will remove the border around the icon.\n\nWarning: may lower FPS.",
					get = get,
					set = function(info, v)
						Display.db.profile.iconzoom = v
						Display:UpdateDisplay("yes")
					end,
					order = 14,
				},
				removeglow = {
					type = 'toggle',
					name =  "Remove Spark",
					desc =  "This will remove the glow/spark at the end of the bar",
					get = get,
					set = function(info, v)
						Display.db.profile.removeglow = v
						Display:UpdateDisplay("yes")
					end,
					order = 15,
				},
				SortOrderTime = {
					type = 'toggle',
					name =  "Sort Order: Time",
					disabled = function() if Display.db.profile.SortOrderBarLength then Display.db.profile.SortOrderTime = false return true else return false end end,
					desc =  "Will change the sort order to ignore all other sorting and just order by time, disabled for perma bars",
					get = get,
					set = set,
					order = 16,
				},
				SortOrderBarLength = {
					type = 'toggle',
					name =  "Sort Order: Bar Length",
					disabled = function() if Display.db.profile.SortOrderTime then Display.db.profile.SortOrderBarLength = false return true else return false end end,
					desc =  "Will change the sort order to ignore all other sorting and just order by bar length, disabled for perma bars",
					get = get,
					set = set,
					order = 16.1,
				},
				SortOrderDirection = {
					type = 'toggle',
					name =  "Sort Order: Direction",
					desc =  "Will change the sort direction for Sort Order: Bar Length and Sort Order: Time",
					get = get,
					set = set,
					order = 16.2,
				},
				PermaMoveingBars = {
					type = 'toggle',
					name =  "Moving Perma Bars",
					desc =  "this will toggle perma bars to allow/prevent them from moving when cd is triggered or finished",
					get = get,
					set = set,
					order = 16.5,
				},
				Removal = {
					type = 'toggle',
					name =  "Removal Bars",
					desc =  "this will toggle removeal of some bars when the aura is removed",
					get = get,
					set = set,
					order = 16.5,
				},
				Border = {
					type = 'toggle',
					name =  "Border Bars",
					desc =  "this will toggle the border around bars",
					get = get,
					set = function(info, v)
						Display.db.profile.Border = v
						Display:UpdateDisplay("yes")
					end,
					order = 16.9,
				},
				BorderThickness = {
					type = 'range',
					name =  "Border Thickness",
					desc =  "this will change the Thickness of the border\n\nNote: its best to reload after changing this setting",
					disabled = function() if Display.db.profile.Border then return false else Display.db.profile.BorderThickness = 0 return true end end,
					min = 0, max = 3, step = 0.1, bigStep = 0.1,
					get = get,
					set = function(info, v)
						Display.db.profile.BorderThickness = v
						Display:UpdateDisplay("yes")
					end,
					order = 16.9,
				},
				CustomBarColor = {
					type = "toggle",	
					name =  "Custom Bar Color",
					desc =  "this will change the color of the bars from class to the set color",
					get = get,
					set = set,
					order = 16.91,
				},
				CustomBarColorPicked = {
					type = "color",	
					name =  "Custom Bar Color",
					disabled = function() if Display.db.profile.CustomBarColor then return false else return true end end,
					desc =  "this will change the color of the bars from class to the set color",
					hasAlpha = true,
					get = function(info) return Display.db.profile.CustomBarColorPicked["r"], Display.db.profile.CustomBarColorPicked["g"], Display.db.profile.CustomBarColorPicked["b"], Display.db.profile.CustomBarColorPicked["a"] end,
					set = function(info, r, g, b, a)
						Display.db.profile.CustomBarColorPicked["r"] = r
						Display.db.profile.CustomBarColorPicked["g"] = g
						Display.db.profile.CustomBarColorPicked["b"] = b
						Display.db.profile.CustomBarColorPicked["a"] = a
					end,
					order = 16.92,
				},
				SpellIconAnimation = {
					type = "toggle",	
					name =  "Spell Icon Animation",
					desc =  "this will add animation to the spell icon",
					get = get,
					set = set,
					order = 16.93,
				},
				SpellIconAnimationReverse = {
					type = "toggle",	
					name =  "Animation Reverse",
					desc =  "this will reverse the animation to the spell icon",
					disabled = function() if Display.db.profile.SpellIconAnimation then return false else Display.db.profile.SpellIconAnimationReverse = false return true end end,
					get = get,
					set = set,
					order = 16.94,
				},
				font = {
					type = "header",
					name =  "Font Options",
					width = "full",
					order = 17,
				},
				fontFace = {
					type = "select",
					name =  "Label Font",
					desc =  "The font that the bar labels will use",
					values = fonts,
					get = function(info) return GetLSMIndex("font", Display.db.profile.fontFace) end,
					set = function(info, v)
						Display.db.profile.fontFace = Media:List("font")[v]
						Display:UpdateDisplay()
					end,
					order = 18,
				},	
				outline = {
        		    type = "select",
           			name = "Outline",
            		values =  {"None", "MONOCHROME", "OUTLINE", "THICKOUTLINE"},
            		get = function(info)  
            		if Display.db.profile.outline == "None" then return 1 end
            		if Display.db.profile.outline == "MONOCHROME" then return 2 end
            		if Display.db.profile.outline == "OUTLINE" then return 3 end
            		if Display.db.profile.outline == "THICKOUTLINE" then return 4 end end,
					set = function(t, value)
					if value == 1 then Display.db.profile.outline = "None" end
					if value == 2 then Display.db.profile.outline = "MONOCHROME" end
					if value == 3 then Display.db.profile.outline = "OUTLINE" end
					if value == 4 then Display.db.profile.outline = "THICKOUTLINE" end
						Display:UpdateDisplay()
					end,
					order = 19,
       			},
				removereadytext = {
					type = 'toggle',
					name =  "Remove Ready",
					desc =  "this will remove the R - from ready permanent bars",
					get = get,
					set = set,
					order = 21,
				},	
				availability = {
					type = 'toggle',
					name =  "Spell Availability",
					desc =  "shows if the spell is available by adding Zone, Dead, Offline to permanent bars.",
					get = get,
					set = set,
					order = 22,
				},
				AbbrevName = {
					type = 'toggle',
					name =  "Abbrevate Names",
					desc =  "toggles abbrevate names e.g. T. L. King.",
					get = get,
					set = set,
					order = 22.1,
				},
				ReTarget = {
					type = 'toggle',
					name =  "Change Target Location",
					desc =  "changes the targets name location",
					get = function(info) if Display.db.profile.ReTarget == "" then return true else return false end end,
					set = function(info, v) if v == true then Display.db.profile.ReTarget = "" else Display.db.profile.ReTarget = nil end Display:UpdateDisplay() end,
					order = 23,
				},					
				TargetOrientation = {
					type = "select",
					name =  "Target Orientation",
					disabled = function() if Display.db.profile.ReTarget then return false else return true end end,
					values = {  "TOP",  "BOTTOM" },
					get = function(info) return Display.db.profile.TargetOrientation end,
					set = function(info, v)
						Display.db.profile.TargetOrientation = v
						Display:UpdateDisplay()
					end,
					order = 23.5,
					width = nil,
				},
				ColorCaster = {
					type = 'toggle',
					name =  "Color Casters Names",
					desc =  "changes the names to the class colors",
					get = get,
					set = set,
					order = 24,
				},	
				ColorTarget = {
					type = 'toggle',
					name =  "Color Target Names",	
					desc =  "changes the names to the class colors",
					get = get,
					set = set,
					order = 25,
				},
				CustomNameColor = {
					type = "toggle",	
					name =  "Custom Name Color",
					desc =  "this will change the color of the bars from class to the set color",
					get = get,
					set = set,
					order = 25.5,
				},
				CustomNameColorPicked = {
					type = "color",	
					name =  "Custom Bar Color",
					disabled = function() if Display.db.profile.CustomNameColor then return false else return true end end,
					desc =  "this will change the color of the bars from class to the set color",
					hasAlpha = true,
					get = function(info) return Display.db.profile.CustomNameColorPicked["r"], Display.db.profile.CustomNameColorPicked["g"], Display.db.profile.CustomNameColorPicked["b"], Display.db.profile.CustomNameColorPicked["a"] end,
					set = function(info, r, g, b, a)
						Display.db.profile.CustomNameColorPicked["r"] = r
						Display.db.profile.CustomNameColorPicked["g"] = g
						Display.db.profile.CustomNameColorPicked["b"] = b
						Display.db.profile.CustomNameColorPicked["a"] = a
					end,
					order = 25.6,
				},
				fontDel = {
					type = "header",
					name =  "",
					width = "full",
					order = 26,
				},
				unclickDes2 = {
					type = "description",
					name =  "If you are having problems with this addon you can try enabling the options below, If you are not having problems its best to have these options unticked.\n",
					width = "full",
					fontSize  = "medium",
					order = 30,
				},
				DisableSync = {
					type = 'toggle',
					name =  "Disable Sync",
					desc =  "Disable's the Sync to try and fix errors",
					get = function(info) return Display.db.profile.DisableSync end,
					set = function(info, v)
						Display.db.profile.DisableSync = v
					end,
					order = 31,
				},
				DisableScan = {
					type = 'toggle',
					name =  "Disable Scan",
					desc =  "Disable's the built in scan for talents",
					get = function(info) return Display.db.profile.DisableScan end,
					set = function(info, v)
						Display.db.profile.DisableScan = v
					end,
					order = 32,
				},
				Backupcdused = {
					type = 'toggle',
					name =  "Disable Backup Trigger",
					width = "double",
					desc =  "Disable's the built 2nd trigger for tracking spells.\n\nWarning: The 2nd trigger event does not have a target so the bar currently uses on the old target. better code maybe added in later updates",
					get = function(info) return Display.db.profile.Backupcdused end,
					set = function(info, v)
						Display.db.profile.Backupcdused = v
					end,
					order = 33,
				},
				DisableClassStoreInfo = {
					type = 'toggle',
					name =  "Disable Class Storage Info",
					desc =  "Disable's the saving of players class info, good for pvp if you dont pvp disable this",
					get = function(info) return not Display.db.profile.StoreClaSSInfo end,
					set = function(info, v)
						Display.db.profile.StoreClaSSInfo = not v
					end,
					--width = "double",
					order = 34,
				},
				DisableDeepClassScan = {
					type = 'toggle',
					name =  "Disable Deep Class Scan",
					desc =  "Disable's deeper scaning of class info, good for pvp if you dont pvp disable this",
					get = function(info) return not Display.db.profile.DeepClassScan end,
					set = function(info, v)
						Display.db.profile.DeepClassScan = not v
					end,
					--width = "double",
					order = 35,
				},
			},
		},
		frames = {
			type = "group",
			name = "Frames",
			desc = "Configure all cooldown frames",
			cmdHidden = true,
			order = 2,
			args = {
				frameCount = {
					type = "range",
					name = "Frame Count",
					desc =  "Allows you to create more frames. if this is disabled you need to unlock your frames in the General options tab",
					disabled = function() if not Display.db.profile.locked then return false elseif Display.db.profile.locked then return true end end,
					min = 1, max = 10, step = 1, bigStep = 1,
					get = get,
					set = function(t, value)
						Display.db.profile[t[#t]] = value
						FatCooldowns.RefreshFrameListOptionsAndVariables()
						Display:MissingSettings()
					end,
					order = 10,
				},
				descr5 = {
					type = "description",
					name =  "If frames are disabled you will need to untick 'Lock Bars' in the General tab, on the left, to enable editing.\n",
					width = "full",
					fontSize  = "medium",
					order = 0.1,
				},	
				FH1 = {
					type = "header",
					name =  "Copy Settings From Frame 1 To Frame 2",
					width = "full",
					order = 10.1,
				},
				FrameX = {
					type = "select",
					name =  "Frame 1",
					values = function()
					local FrameXNames = {}
						for i = 1, 10, 1 do
							if i <= Display.db.profile.frameCount then
								if Display.db.profile.frames[i] then
									if Display.db.profile.frames[i].name ~= nil then
										FrameXNames[i] = Display.db.profile.frames[i].name
									end
								end
							end
						end
						return FrameXNames
					end,
					get = function(info) return TempFrameXNames end,
					set = function(info, v)	TempFrameXNames = v end,
					order = 11,
					width = "normal",
				},
				FrameZ = {
					type = "select",
					name =  "Frame 2",
					values = function()
					local FrameZNames = {}
						for i = 1, 10, 1 do
							if i <= Display.db.profile.frameCount then
								if Display.db.profile.frames[i] then
									if Display.db.profile.frames[i].name ~= nil then
										FrameZNames[i] = Display.db.profile.frames[i].name
									end
								end
							end
						end
						return FrameZNames
					end,
					get = function(info) return TempFrameZNames end,
					set = function(info, v)	TempFrameZNames = v end,
					order = 12,
					width = "normal",
				},
				IncSpells = {
					type = 'toggle',
					name =  "Inc Spells",
					desc =  "Include Spells to be copied",
					get = function(info) return TempFrameNamesSpells end,
					set = function(info, v)	TempFrameNamesSpells = v end,
					width = "normal",
					order = 12.5,
				},
				CopyButton = {
					type = "execute",
					name =  "Copy Settings",
					desc =  "Copys Settings from one from to an other frame",
					order = 13,
					func = function()
						if TempFrameXNames ~= nil and TempFrameZNames ~= nil and TempFrameXNames ~= TempFrameZNames then
							Display.db.profile.frames[TempFrameZNames].growUp = Display.db.profile.frames[TempFrameXNames].growUp
							Display.db.profile.frames[TempFrameZNames].hideSelf = Display.db.profile.frames[TempFrameXNames].hideSelf
							Display.db.profile.frames[TempFrameZNames].readyMsg = Display.db.profile.frames[TempFrameXNames].readyMsg
							Display.db.profile.frames[TempFrameZNames].scale = Display.db.profile.frames[TempFrameXNames].scale
							Display.db.profile.frames[TempFrameZNames].alpha = Display.db.profile.frames[TempFrameXNames].alpha
							Display.db.profile.frames[TempFrameZNames].width = Display.db.profile.frames[TempFrameXNames].width
							Display.db.profile.frames[TempFrameZNames].fontsize = Display.db.profile.frames[TempFrameXNames].fontsize
							Display.db.profile.frames[TempFrameZNames].height = Display.db.profile.frames[TempFrameXNames].height
							Display.db.profile.frames[TempFrameZNames].maxTextLength = Display.db.profile.frames[TempFrameXNames].maxTextLength
							Display.db.profile.frames[TempFrameZNames].permanent = Display.db.profile.frames[TempFrameXNames].permanent
							Display.db.profile.frames[TempFrameZNames].anchor = Display.db.profile.frames[TempFrameXNames].anchor
							Display.db.profile.frames[TempFrameZNames].hideFrame = Display.db.profile.frames[TempFrameXNames].hideFrame
							Display.db.profile.frames[TempFrameZNames].hidetarget = Display.db.profile.frames[TempFrameXNames].hidetarget
							Display.db.profile.frames[TempFrameZNames].RaidMsg = Display.db.profile.frames[TempFrameXNames].RaidMsg
							Display.db.profile.frames[TempFrameZNames].UsedMsg = Display.db.profile.frames[TempFrameXNames].UsedMsg
							Display.db.profile.frames[TempFrameZNames].HideLabel = Display.db.profile.frames[TempFrameXNames].HideLabel
							Display.db.profile.frames[TempFrameZNames].EnemyFCDCaster = Display.db.profile.frames[TempFrameXNames].EnemyFCDCaster
							Display.db.profile.frames[TempFrameZNames].FriendlyCaster = Display.db.profile.frames[TempFrameXNames].FriendlyCaster
							Display.db.profile.frames[TempFrameZNames].SpellNameLabel = Display.db.profile.frames[TempFrameXNames].SpellNameLabel
							Display.db.profile.frames[TempFrameZNames].onlySelf = Display.db.profile.frames[TempFrameXNames].onlySelf
							if TempFrameNamesSpells then Display.db.profile.frames[TempFrameZNames].spells = Display.db.profile.frames[TempFrameXNames].spells end

							TempFrameXNames = nil
							TempFrameZNames = nil
							FatCooldowns.RefreshFrameListOptionsAndVariables()
						end
					end,
					width = "normal",
					confirm = true
				},
			},
		},
		soundspells = {
			type = "group",
			name = "Spells Sounds",
			desc = "Configure all Spells Sounds options",
			cmdHidden = true,
			order = 3,
			args = {
				descr = {
					type = "description",
					name =  "Select which Spells Sounds you would like to enable.",
					width = "full",
					fontSize  = "medium",
					order = 1,
				},
				soundspellsoptions = {
					type = "group",
					name = "Spell Sound Options",
					desc = "Set options for each spell sound",
					cmdHidden = true,
					order = 2,
					args = {
						descr = {
							type = "description",
							name =  "Select which options you would like to enable for each sound",
							width = "full",
							fontSize  = "medium",
							order = 1,
						},
					}
				},				
			},
		},
		spellOrder = {
			type = "group",
			name = "Spell Order",
			desc = "Configure the order in which spells are displayed",
			cmdHidden = true,
			order = 4,
			args = {
				descr = {
					type = "description",
					name =  "Select which spells should have modified priority over the default (class > spellid > caster > cooldown) sorting attributes.",
					width = "full",
					fontSize  = "medium",
					order = 1,
				},
				spells = {
					type = "group",
					name = "Spell priorities",
					desc = "Set priorities of selected spells",
					cmdHidden = true,
					order = 2,
					args = {
						descr = {
							type = "description",
							name =  "All unselected spells have priority 500 - select higher or lower to move your spell higher or lower in priority list.",
							width = "full",
							fontSize  = "medium",
							order = 1,
						},
					},
				},
			},
		},
		ButtonClicks = {
			type = "group",
			name = "Button Clicks",
			desc = "Configure Button Clicks options",
			cmdHidden = true,
			order = 5,
			args = {
				resetbutton = {
					type = "execute",
					name =  "Defualt Clicks",
					desc =  "Rests all button clicks to there default option",
					order = 0.7,
					func = function() Display.db.profile.LClick = 1
										Display.db.profile.RClick = 1
										Display.db.profile.MClick = 1
										Display.db.profile.SLClick = 2
										Display.db.profile.SRClick = 3
										Display.db.profile.SMClick = 4
										Display.db.profile.ALClick = 6
										Display.db.profile.ARClick = 7
										Display.db.profile.AMClick = 5
					end,
					width = "normal",
					confirm = true
				},
				unclickable = {
					type = 'toggle',
					name =  "Make bars unclickable",
					desc =  "Disables right clicks on cooldown bars.",
					width = "full",
					get = function(info) return Display.db.profile.unclickable end,
					set = function(info, v)
						Display.db.profile.unclickable = v
						Display:ClickableChange();
					end,
					order = 0.8,
				},
				BH1 = {
					type = "header",
					name =  "",
					width = "full",
					order = 0.9,
				},
				LClick = {
					type = "select",
					name =  "Left-Click",
					values = { "None", "Report Cooldown to Raid", "Whisper Cooldown to Caster", "List Ready Cooldowns to Raid", "List Not Ready Cooldowns to Raid", "Print Last Target", "Remove Bar"},
					get = function(info) return Display.db.profile.LClick end,
					set = function(info, v)	Display.db.profile.LClick = v end,
					order = 1,
					width = "double",
				},
				RClick = {
					type = "select",
					name =  "Right-Click",
					values = { "None", "Report Cooldown to Raid", "Whisper Cooldown to Caster", "List Ready Cooldowns to Raid", "List Not Ready Cooldowns to Raid", "Print Last Target", "Remove Bar"},
					get = function(info) return Display.db.profile.RClick end,
					set = function(info, v)	Display.db.profile.RClick = v end,
					order = 2,
					width = "double",
				},
				MClick = {
					type = "select",
					name =  "Middle-Click",
					values = { "None", "Report Cooldown to Raid", "Whisper Cooldown to Caster", "List Ready Cooldowns to Raid", "List Not Ready Cooldowns to Raid", "Print Last Target", "Remove Bar"},
					get = function(info) return Display.db.profile.MClick end,
					set = function(info, v)	Display.db.profile.MClick = v end,
					order = 3,
					width = "double",
				},
				BH2 = {
					type = "header",
					name =  "",
					width = "full",
					order = 3.9,
				},
				SLClick = {
					type = "select",
					name =  "Shift-Left-Click",
					values = { "None", "Report Cooldown to Raid", "Whisper Cooldown to Caster", "List Ready Cooldowns to Raid", "List Not Ready Cooldowns to Raid", "Print Last Target", "Remove Bar"},
					get = function(info) return Display.db.profile.SLClick end,
					set = function(info, v)	Display.db.profile.SLClick = v end,
					order = 4,
					width = "double",
				},
				SRClick = {
					type = "select",
					name =  "Shift-Right-Click",
					values = { "None", "Report Cooldown to Raid", "Whisper Cooldown to Caster", "List Ready Cooldowns to Raid", "List Not Ready Cooldowns to Raid", "Print Last Target", "Remove Bar"},
					get = function(info) return Display.db.profile.SRClick end,
					set = function(info, v)	Display.db.profile.SRClick = v end,
					order = 5,
					width = "double",
				},
				SMClick = {
					type = "select",
					name =  "Shift-Middle-Click",
					values = { "None", "Report Cooldown to Raid", "Whisper Cooldown to Caster", "List Ready Cooldowns to Raid", "List Not Ready Cooldowns to Raid", "Print Last Target", "Remove Bar"},
					get = function(info) return Display.db.profile.SMClick end,
					set = function(info, v)	Display.db.profile.SMClick = v end,
					order = 6,
					width = "double",
				},
				BH3 = {
					type = "header",
					name =  "",
					width = "full",
					order = 6.9,
				},
				ALClick = {
					type = "select",
					name =  "Alt-Left-Click",
					values = { "None", "Report Cooldown to Raid", "Whisper Cooldown to Caster", "List Ready Cooldowns to Raid", "List Not Ready Cooldowns to Raid", "Print Last Target", "Remove Bar"},
					get = function(info) return Display.db.profile.ALClick end,
					set = function(info, v)	Display.db.profile.ALClick = v end,
					order = 7,
					width = "double",
				},
				ARClick = {
					type = "select",
					name =  "Alt-Right-Click",
					values = { "None", "Report Cooldown to Raid", "Whisper Cooldown to Caster", "List Ready Cooldowns to Raid", "List Not Ready Cooldowns to Raid", "Print Last Target", "Remove Bar"},
					get = function(info) return Display.db.profile.ARClick end,
					set = function(info, v)	Display.db.profile.ARClick = v end,
					order = 8,
					width = "double",
				},
				AMClick = {
					type = "select",
					name =  "Alt-Middle-Click",
					values = { "None", "Report Cooldown to Raid", "Whisper Cooldown to Caster", "List Ready Cooldowns to Raid", "List Not Ready Cooldowns to Raid", "Print Last Target", "Remove Bar"},
					get = function(info) return Display.db.profile.AMClick end,
					set = function(info, v)	Display.db.profile.AMClick = v end,
					order = 9,
					width = "double",
				},
			},
		},
		other = {
			type = "group",
			name = "Other (Personal)",
			desc = "Configure all other options",
			cmdHidden = true,
			order = 6,
			args = {
				descr2 = {
					type = "description",
					name =  "Below are additional features this addon provides.",
					width = "full",
					fontSize  = "medium",
					order = 1,
				},
				LH01 = {
					type = "header",
					name =  "Tooltip",
					width = "full",
					order = 1101,
				},
				GameTooltipHide = {
					type = "toggle",
					name =  "Combat Hide Tooltip",
					desc =  "Hides the Tooltip in the bottom right corner when in combat",
					get = function(info) return Display.db.profile.GameTooltipHide end,
					set = function(info, v)	Display.db.profile.GameTooltipHide = v	end,
					order = 1101.5,
					width = "double",
				},
				GameTooltipHideShift = {
					type = "toggle",
					name =  "Combat Tooltip Show on Shift",
					desc =  "Shows the Tooltip when you hold down shift",
					disabled = function() if Display.db.profile.GameTooltipHide then return false else Display.db.profile.GameTooltipHideShift = false return true end end,
					get = function(info) return Display.db.profile.GameTooltipHideShift end,
					set = function(info, v)	Display.db.profile.GameTooltipHideShift = v	end,
					order = 1101.6,
					width = "double",
				},
				LH1 = {
					type = "header",
					name =  "Auto Loot",
					width = "full",
					order = 1102,
				},
				GLoot = {
					type = "select",
					name =  "Green Loot",
					desc = "Auto Roll on Green itmes",
					values = { "None", "Pass", "DE > Greed", "Greed", "Need", "Raid: Pass", "Raid: DE > Greed", "Raid: Greed", "Raid: Need", "Party: Pass", "Party: DE > Greed", "Party: Greed", "Party: Need"},
					get = function(info) return Display.db.profile.GLoot end,
					set = function(info, v)	Display.db.profile.GLoot = v end,
					order = 1103,
					width = "Half",
				},
				BLoot = {
					type = "select",
					name =  "Blue Loot",
					desc = "Auto Roll on Blue itmes",
					values = { "None", "Pass", "DE > Greed", "Greed", "Need", "Raid: Pass", "Raid: DE > Greed", "Raid: Greed", "Raid: Need", "Party: Pass", "Party: DE > Greed", "Party: Greed", "Party: Need"},
					get = function(info) return Display.db.profile.BLoot end,
					set = function(info, v)	Display.db.profile.BLoot = v end,
					order = 1104,
					width = "Half",
				},
				PLoot = {
					type = "select",
					name =  "Purple Loot",
					desc = "Auto Roll on Purple itmes",
					values = { "None", "Pass", "DE > Greed", "Greed", "Need", "Raid: Pass", "Raid: DE > Greed", "Raid: Greed", "Raid: Need", "Party: Pass", "Party: DE > Greed", "Party: Greed", "Party: Need"},
					get = function(info) return Display.db.profile.PLoot end,
					set = function(info, v)	Display.db.profile.PLoot = v end,
					order = 1105,
					width = "Half",
				},
				ILvlAvg = {
					type = "toggle",
					name =  "Avg ILvl 232+",
					desc =  "Only Auto Roll when your Avg ILvl is above 232 (about 5k gs)\n\nCurrently: "..string.format("%.1f", FatCooldowns:AvgIlvl()),
					get = function(info) return Display.db.profile.ILvlAvg end,
					set = function(info, v)	Display.db.profile.ILvlAvg = v	end,
					order = 1105.5,
					width = "nomral",
				},
				AddLootBlackList = {
					type = "input",
					name =  "Add Item To Blacklist",
					get = function(info) return TempLootBlackList end,
					set = function(info, v) if v == nil then return end
						local ItemName = GetItemInfo(v)
						if ItemName ~= nil then
							Display.db.profile.LootBlackList[ItemName] = ItemName
						else 
							print("Warning: Failed to add Item "..v..", Please enter the Item ID, Shift Click the item or Drag and drop the Item. Note: To add the item as plain text it must have been equiped, in your bags or in your bank once in this session")
						end
					end,
					order = 1106,
					width = "double",
				},
				LootBlackList = {
					type = "select",
					name =  "Blacklist",
					values = function(info) 
					local RealBlackList = {}
						for x,y in pairs(Display.db.profile.LootBlackList) do
							if x == y then RealBlackList[x] = y end
						end
						return RealBlackList end,
					get = function(info) return TempLootBlackList end,
					set = function(info, v)	TempLootBlackList = v end,
					order = 1107,
					width = "normal",
				},
				RemoveLootBlackList = {
					type = "execute",
					name =  "Remove",
					func = function() Display.db.profile.LootBlackList[TempLootBlackList] = "false" TempLootBlackList = nil end,
					order = 1108,
					width = "normal",
				},
				LH2 = {
					type = "header",
					name =  "Auto Delete Loot",
					width = "full",
					order = 1200,
				},
				EnablePopup = {
					type = "toggle",
					name =  "Destroy Poor Items",
					desc =  "Destroy items below set price when low on bag space",
					get = function(info) return Display.db.profile.EnablePopup end,
					set = function(info, v)	Display.db.profile.EnablePopup = v Display:FCDDelPopup() end,
					order = 1201,
					width = "nomral",
				},
				AutoSell = {
					type = "toggle",
					name =  "Auto Sell Poor Items",
					desc =  "Auto sell poor items and the items on the sell list",
					get = function(info) return Display.db.profile.AutoSell end,
					set = function(info, v)	Display.db.profile.AutoSell = v	end,
					order = 1201.5,
					width = "nomral",
				},
				SellSilence = {
					type = "toggle",
					name =  "Silent Selling",
					desc =  "Prevents the printing in chat of items being sold/Destroy.",
					get = function(info) return Display.db.profile.SellSilence end,
					set = function(info, v)	Display.db.profile.SellSilence = v	end,
					order = 1201.6,
					width = "nomral",
				},
				PriceRange = {
					type = "range",
					name = function () return "Max Price "..GetCoinTextureString(Display.db.profile.PriceRange) end,
					desc = "Auto delete poor items below this price when low on bag space",
					min = 1, max = 200000, step = 1, bigStep = 1,
					get = function(v) return Display.db.profile.PriceRange end,
					set = function(info, v) Display.db.profile.PriceRange = v end,
					order = 1202,
					width = "full",
				},
				KeepSpaceFree = {
					type = "range",
					name = "Bag Space",
					desc = "Auto delete poor items when below this bag space",
					min = 1, max = 80, step = 1, bigStep = 1,
					get = function(v) return Display.db.profile.KeepSpaceFree end,
					set = function(info, v) Display.db.profile.KeepSpaceFree = v end,
					order = 1203,
					width = "full",
				},
				SellList = {
					type = "select",
					name =  "Sell List",
					values = function(info) 
					local RealSellList = {}
						for x,y in pairs(Display.db.profile.SellList) do
							if x == y then RealSellList[x] = y end
						end
						return RealSellList end,
					get = function(info) return TempSellList end,
					set = function(info, v)	TempSellList = v end,
					order = 1204,
					width = "double",
				},
				RemoveFromSellList = {
					type = "execute",
					name =  "Remove",
					func = function() Display.db.profile.SellList[TempSellList] = "false" TempSellList = nil end,
					order = 1205,
					width = "normal",
				},
				AddLootSellList = {
					type = "input",
					name =  "Add Item To SellList",
					get = function(info) return TempSellList end,
					set = function(info, v) if v == nil then return end
						local ItemName = GetItemInfo(v)
						if ItemName ~= nil then
							Display.db.profile.SellList[ItemName] = ItemName
						else 
							print("Warning: Failed to add Item "..v..", Please enter the Item ID, Shift Click the item or Drag and drop the Item. Note: To add the item as plain text it must have been equiped, in your bags or in your bank once in this session")
						end
					end,
					order = 1206,
					width = "double",
				},
				AddSellList = {
					type = "execute",
					name =  "Add",
					func = function() Display.db.profile.SellList[TempSellList] = TempSellList TempSellList = nil end,
					order = 1207,
					width = "normal",
				},
				BH2 = {
					type = "header",
					name =  "Badges Bar",
					width = "full",
					order = 1207.5,
				},
				BadagesBar = {
					type = "toggle",
					name =  "Enable Badges Bar",
					desc =  "Enables the Badges bar.",
					get = function(info) return Display.db.profile.BadagesBar end,
					set = function(info, v)	Display.db.profile.BadagesBar = v	end,
					order = 1207.9,
					width = "double",
				},
				BadagesBarConfirm = {
					type = "toggle",
					name =  "Badages Bar Confirm",
					desc =  "Adds a comfim to buying with the badages bar.",
					get = function(info) return Display.db.profile.BadagesBarConfirm end,
					set = function(info, v)	Display.db.profile.BadagesBarConfirm = v	end,
					order = 1208,
					width = "double",
				},
				BadagesBarCount = {
					type = "range",
					name = function () return Display.db.profile.BadagesBarCount end,
					desc = "Set the Amount of badages you would like to trade at once",
					min = 1, max = 200, step = 1, bigStep = 1,
					get = function(v) return Display.db.profile.BadagesBarCount end,
					set = function(info, v) Display.db.profile.BadagesBarCount = v end,
					order = 1209,
					width = "full",
				},
			},
		},
		OtherPersonal = {
			type = "group",
			name = "Other (Leader)",
			desc = "Configure all other options",
			cmdHidden = true,
			order = 6.5,
			args = {
				descr2 = {
					type = "description",
					name =  "Below are additional features this addon provides. You will need to be a Leader within the raid for these settings",
					width = "full",
					fontSize  = "medium",
					order = 1,
				},
				fontDel3 = {
					type = "header",
					name =  "",
					width = "full",
					order = 1.1,
				},	
				descr = {
					type = "description",
					name =  "The Auto Icon Features will not remove icons from people and will not replace an icon already on a person. Note: DBM will place Circle, Diamond and Triangle on the valks its best not to use these icons for the valk stacking point.",
					width = "full",
					fontSize  = "medium",
					order = 1.11,
				},
				AutoIconValk = {
					type = "toggle",
					name =  "Auto Icon Valk Stacking",
					desc =  "Auto adds icon to a player for stacking on valks\n\nNote: if icon is already on someone it will not remove and if you want the icon to always be on yourself you can set the Player Name to player",
					get = function(info) return Display.db.profile.AutoIconValk end,
					set = function(info, v)	Display.db.profile.AutoIconValk = v	end,
					order = 1.2,
					width = "double",
				},
				AutoIconValkName = {
					type = "select",
					name =  "Player Name",
					values = function(info)	return RaidPlayersNames() end,
					disabled = function() if Display.db.profile.AutoIconValk then return false elseif not Display.db.profile.AutoIconValk then return true end end,
					desc = "Enter the name of the player you would like to place the icon on, if you always want to stack on yourself then you can enter player instead of your name",
					get = function(v) return Display.db.profile.AutoIconValkName end,
					set = function(info, v) Display.db.profile.AutoIconValkName = v end,
					width = "normal",
					order = 1.3,
				},
				AutoIconValkIcon = {
					type = "select",
					name =  "Icon",
					disabled = function() if Display.db.profile.AutoIconValk then return false elseif not Display.db.profile.AutoIconValk then return true end end,
					values = { "None", "Star", "Circle", "Diamond", "Triangle", "Moon", "Square", "Cross", "Skull" },
					get = function(info) return Display.db.profile.AutoIconValkIcon end,
					set = function(info, v)	Display.db.profile.AutoIconValkIcon = v end,
					order = 1.4,
					width = "half",
				},
				fontDel4 = {
					type = "header",
					name =  "",
					width = "full",
					order = 1.5,
				},
				AutoIconFrostmourne = {
					type = "toggle",
					name =  "Auto Icon Frostmourne Stacking",
					desc =  "Auto adds icon to a player for stacking on Frostmourne\n\nNote: if icon is already on someone it will not remove and if you want the icon to always be on yourself you can set the 'Player Name' to player",
					get = function(info) return Display.db.profile.AutoIconFrostmourne end,
					set = function(info, v) Display.db.profile.AutoIconFrostmourne = v end,
					order = 1.6,
					width = "double",
				},
				AutoIconFrostmourneName = {
					type = "select",
					name =  "Player Name",
					values = function(info)	return RaidPlayersNames() end,disabled = function() if Display.db.profile.AutoIconValk then return false elseif not Display.db.profile.AutoIconValk then return true end end,
					desc = "Enter the name of the player you would like to place the icon on, if you always want to stack on yourself then you can enter player instead of your name",
					disabled = function() if Display.db.profile.AutoIconFrostmourne then return false elseif not Display.db.profile.AutoIconFrostmourne then return true end end,
					get = function(v) return Display.db.profile.AutoIconFrostmourneName end,
					set = function(info, v) Display.db.profile.AutoIconFrostmourneName = v end,
					width = "normal",
					order = 1.7,
				},
				AutoIconFrostmourneIcon = {
					type = "select",
					name =  "Icon",
					disabled = function() if Display.db.profile.AutoIconFrostmourne then return false elseif not Display.db.profile.AutoIconFrostmourne then return true end end,
					values = { "None", "Star", "Circle", "Diamond", "Triangle", "Moon", "Square", "Cross", "Skull" },
					get = function(info) return Display.db.profile.AutoIconFrostmourneIcon end,
					set = function(info, v)	Display.db.profile.AutoIconFrostmourneIcon = v end,
					order = 1.9,
					width = "half",
				},
				fontDel5 = {
					type = "header",
					name =  "",
					width = "full",
					order = 1.901,
				},
				KeepIcon1Toggle = {
					type = "toggle",
					name =  "Keep Icon1 on Player",
					desc =  "Keeps the selected icon on the named player\n\nNote: if icon 1 and 2 are the same this will disable this function",
					get = function(info) return Display.db.profile.KeepIcon1Toggle end,
					set = function(info, v) Display.db.profile.KeepIcon1Toggle = v end,
					order = 1.91,
					width = "double",
				},
				KeepIcon1 = {
					type = "select",
					name =  "Player Name",
					values = function(info)	return RaidPlayersNames() end,
					get = function(info) return Display.db.profile.KeepIcon1 end,
					set = function(info, v)	Display.db.profile.KeepIcon1 = v end,
					disabled = function() if Display.db.profile.KeepIcon1Toggle then return false elseif not Display.db.profile.KeepIcon1Toggle then return true end end,
					order = 1.92,
					width = "normal",
				},
				KeepIcon1Icon = {
					type = "select",
					name =  "Icon",
					values = { "None", "Star", "Circle", "Diamond", "Triangle", "Moon", "Square", "Cross", "Skull" },
					get = function(info) return Display.db.profile.KeepIcon1Icon end,
					set = function(info, v)	Display.db.profile.KeepIcon1Icon = v end,
					disabled = function() if Display.db.profile.KeepIcon1Toggle then return false elseif not Display.db.profile.KeepIcon1Toggle then return true end end,
					order = 1.93,
					width = "half",
				},
				fontDel6 = {
					type = "header",
					name =  "",
					width = "full",
					order = 1.931,
				},
				KeepIcon2Toggle = {
					type = "toggle",
					name =  "Keep Icon2 on Player",
					desc =  "Keeps the selected icon on the named player\n\nNote: if icon 1 and 2 are the same this will disable this function",
					get = function(info) return Display.db.profile.KeepIcon2Toggle end,
					set = function(info, v) Display.db.profile.KeepIcon2Toggle = v end,
					order = 1.94,
					width = "double",
				},
				KeepIcon2 = {
					type = "select",
					name =  "Player Name",
					values = function(info)	return RaidPlayersNames() end,
					get = function(info) return Display.db.profile.KeepIcon2 end,
					set = function(info, v)	Display.db.profile.KeepIcon2 = v end,
					disabled = function() if Display.db.profile.KeepIcon2Toggle then return false elseif not Display.db.profile.KeepIcon2Toggle then return true end end,
					order = 1.95,
					width = "normal",
				},
				KeepIcon2Icon = {
					type = "select",
					name =  "Icon",
					values = { "None", "Star", "Circle", "Diamond", "Triangle", "Moon", "Square", "Cross", "Skull" },
					get = function(info) return Display.db.profile.KeepIcon2Icon end,
					set = function(info, v)	Display.db.profile.KeepIcon2Icon = v end,
					disabled = function() if Display.db.profile.KeepIcon2Toggle then return false elseif not Display.db.profile.KeepIcon2Toggle then return true end end,
					order = 1.96,
					width = "half",
				},
				fontDel7 = {
					type = "header",
					name =  "Auto Loot Changer",
					width = "full",
					order = 1.97,
				},
				GLOnBoss = {
					type = "toggle",
					name =  "Auto Group Loot",
					desc =  "Auto Changes the Loot to Group Loot after a boss fight.\n\nNote: there is a delay of 40 sec (so you can loot the boss) and you need to be the leader",
					get = function(info) return Display.db.profile.GLOnBoss end,
					set = function(info, v) Display.db.profile.GLOnBoss = v end,
					order = 1.98,
					width = "normal",
				},
				MLOnBoss = {
					type = "toggle",
					name =  "Auto Master Loot",
					desc =  "Auto Changes the Loot to Master Loot when in a boss fight.\n\nNote: you need to be the leader",
					get = function(info) return Display.db.profile.MLOnBoss end,
					set = function(info, v) Display.db.profile.MLOnBoss = v end,
					order = 1.99,
					width = "normal",
				},
				MLOnBossName = {
					type = "select",
					name =  "Master Looter Player Name",
					values = function(info)	return RaidPlayersNames() end,
					get = function(info) return Display.db.profile.MLOnBossName end,
					set = function(info, v)	Display.db.profile.MLOnBossName = v end,
					disabled = function() if Display.db.profile.MLOnBoss then return false elseif not Display.db.profile.MLOnBoss then return true end end,
					order = 1.991,
					width = "double",
				},	
				ICCnRSML = {
					type = "toggle",
					name =  "RS & ICC Only",
					desc =  "Auto Changes loot only when inside RS and ICC",
					get = function(info) return Display.db.profile.MLOnBoss end,
					set = function(info, v) Display.db.profile.MLOnBoss = v end,
					order = 1.9911,
					width = "normal",
				},	
				fontDel18 = {
					type = "header",
					name =  "Custom Master Looter Window",
					width = "full",
					order = 1.9919,
				},
				CustomMasterLooterWindow = {
					type = "toggle",
					name =  "Custom Master Looter Window",
					desc =  "Changes the master looter window to color in players names and add Raid tab",
					disabled = function() if Display.db.profile.CustomMasterLooterWindowV2 then Display.db.profile.CustomMasterLooterWindow = false return true else return false end end,
					get = get,
					set = function(info, v)
						Display.db.profile.CustomMasterLooterWindow = v
						Display:CMasterLooterWindow()
					end,
					order = 1.992,
					width = "double",
				},	
				CustomMasterLooterWindowV2 = {
					type = "toggle",
					name =  "Custom Master Looter Window V2",
					desc =  "Changes the master looter window removing groups and coloring in players names",
					disabled = function() if Display.db.profile.CustomMasterLooterWindow then Display.db.profile.CustomMasterLooterWindowV2 = false return true else return false end end,
					get = get,
					set = function(info, v)
						Display.db.profile.CustomMasterLooterWindowV2 = v
						Display:CMasterLooterWindow()
					end,
					order = 1.99201,
					width = "double",
				},	
				fontDel8 = {
					type = "header",
					name =  "Auto Loot As Master Looter",
					width = "full",
					order = 1.9921,
				},		
				MLAutoLoot = {
					type = "toggle",
					name =  "Auto Loot Items When Master Looter",
					desc =  "Auto loot items when you are the master looter",
					get = function(info) return Display.db.profile.MLAutoLoot end,
					set = function(info, v) Display.db.profile.MLAutoLoot = v end,
					order = 2,
					width = "double",
				},
				RemoveMasterLootBlackList = {
					type = "execute",
					name =  "Add",
					func = function() Display.db.profile.MasterLootBlackList[TempMBlackList] = TempMBlackList TempMBlackList = nil end,
					order = 2.5,
					width = "normal",
				},
				AddMasterLootBlackList = {
					type = "execute",
					name =  "Remove",
					func = function() Display.db.profile.MasterLootBlackList[TempMBlackList] = "false" TempMBlackList = nil end,
					order = 2.9,
					width = "normal",
				},
				AddLootBlackList = {
					type = "input",
					name =  "Add Item To Master Looter Blacklist",
					get = function(info) return TempMBlackList end,
					set = function(info, v) if v == nil then return end
						local ItemName = GetItemInfo(v)
						if ItemName ~= nil then
							Display.db.profile.MasterLootBlackList[ItemName] = ItemName
						else 
							print("Warning: Failed to add Item "..v..", Please enter the Item ID, Shift Click the item or Drag and drop the Item. Note: To add the item as plain text it must have been equiped, in your bags or in your bank once in this session")
						end
					end,
					order = 3,
					width = "double",
				},
				MLAutoLootBlacklist = {
					type = "select",
					name =  "Master Loot Blacklist",
					values = function(info) 
					local RealMasterBlackList = {}
						for x,y in pairs(Display.db.profile.MasterLootBlackList) do
							if x == y then RealMasterBlackList[x] = y end
						end
						return RealMasterBlackList end,
					get = function(info) return TempMBlackList end,
					set = function(info, v)	TempMBlackList = v end,
					order = 4,
					width = "double",
				},	
				MLAutoLootRSICC = {
					type = "toggle",
					name =  "RS & ICC Only",
					desc =  "Limits the Auto Master Looter for when you are in RS and ICC",
					get = function(info) return Display.db.profile.MLAutoLootRSICC end,
					set = function(info, v) Display.db.profile.MLAutoLootRSICC = v end,
					order = 5,
					width = "double",
				},
				fontDe20 = {
					type = "header",
					name =  "Auto Assist and Guild Inv",
					width = "full",
					order = 6,
				},	
				AutoAssist = {
					type = "select",
					name =  "Auto Assist",
					desc =  "Auto Assist people with the guild rank and above",
					values = function(info)
					local GuildRanks = {}
						for i = 1, GuildControlGetNumRanks() do
							local rankName = GuildControlGetRankName(i)
							if GuildRanks[i] == nil then GuildRanks[i] = rankName end
						end
						return GuildRanks
					end,
					get = function(info)
					 	for i = 1, GuildControlGetNumRanks() do
							local rankName = GuildControlGetRankName(i)
					 		if rankName == Display.db.profile.AutoAssist[GetGuildInfo("player")] then return i end
					 	end
					 return Display.db.profile.AutoAssist[GetGuildInfo("player")] end,
					set = function(info, v)	Display.db.profile.AutoAssist[GetGuildInfo("player")] = GuildControlGetRankName(v) end,
					order = 7,
					width = "double",
				},
				GuildInviteButton = {
					type = "select",
					name =  "Guild Inv Rank",
					desc =  "Guild Inv Button will only inv selected rank and above",
					values = function(info)
					local GuildRanks = {}
						for i = 1, GuildControlGetNumRanks() do
							local rankName = GuildControlGetRankName(i)
							if GuildRanks[i] == nil then GuildRanks[i] = rankName end
						end
						return GuildRanks
					end,
					get = function(info)
					 	for i = 1, GuildControlGetNumRanks() do
							local rankName = GuildControlGetRankName(i)
					 		if rankName == Display.db.profile.GuildInviteButton[GetGuildInfo("player")] then return i end
					 	end
					 return Display.db.profile.GuildInviteButton[GetGuildInfo("player")] end,
					set = function(info, v)	Display.db.profile.GuildInviteButton[GetGuildInfo("player")] = GuildControlGetRankName(v) end,
					order = 8,
					width = "double",
				},		
			},
		},
		ChatReporter = {
			type = "group",
			name = "Reporter",
			desc = "Configure all Chat Reporter options",
			cmdHidden = true,
			order = 7,
			args = {
				descr = {
					type = "description",
					name =  "Select which reporter options you would like enable.\n\nNote: there are 2 anti-spam features built into this addon. 1st will check if you have raid lead/assist, if you do not have lead/assist then it will print the messages to yourself only. 2nd will check if your raid leader/assist has this addon then blocks your reporting if he/she does have the addon, 'Disable Anti-Spam' (in the Other tab on the left) will disable the 2nd check which allows you to report in raid chat even if you leader has this addon but you will still need leader/assist.",
					width = "full",
					fontSize  = "medium",
					order = 1,
				},
			},
		},
		ChatFilter = {
			type = "group",
			name = "Chat Filter",
			desc = "Configure all Chat Filter options",
			cmdHidden = true,
			order = 8,
			args = {
				descr = {
					type = "description",
					name =  "Select which chat filter you would like to enable, if you would like to see the messages that gets filtered you can do so via the chatfilter reporter in the Other tab (on the left).",
					width = "full",
					fontSize  = "medium",
					order = 1,
				},
				ChatFilterReporter2 = {
					type = "group",
					name = "Chat Filter Reporter Options",
					desc = "Set options for each filtered option, the options will allow you to print the filtered messages in a selected (numbers below) chat window",
					cmdHidden = true,
					order = 2,
					args = {
						descr = {
							type = "description",
							name =  "Select which options you would like to enable for each filter option",
							width = "full",
							fontSize  = "medium",
							order = 1,
						},
					}
				},	
				
			},
		},	
		About = {
			type = "group",
			name = "About",
			desc = "Extra Info",
			cmdHidden = true,
			order = 9,
			args = {
				descr1 = {
					type = "description",
					name =  "Welcome to FCD (FatCooldowns) |cffFF7C0AShekles|r Version below is some extra information about this addon.\n\n",
					width = "full",
					fontSize  = "large",
					order = 1,
				},
				descr2 = {
					type = "description",
					name =  "|cffFFB74D1Q. Some of my permanent bars are missing up, what can i do?|r\n" ..
						"You can force a rescan to fix any missing bars, /fcd raidupdate will force a rescan.\n",
					width = "full",
					fontSize  = "medium",
					order = 2,
				},
				descr3 = {
					type = "description",
					name =  "|cffFFB74D2Q. Some of my bars are messed up/look funny, what can i do?|r" ..
						"Sometimes bars can get messed up/look funny after changing settings a simple relog or reload ui should fix this.\n",
					width = "full",
					fontSize  = "medium",
					order = 3,
				},
				descr4 = {
					type = "description",
					name =  "|cffFFB74D3Q. What are the commands for this addon?|r\n" ..
						"You can do /fcd help for a full list of commands.\n",
					width = "full",
					fontSize  = "medium",
					order = 4,
				},	
				descr5 = {
					type = "description",
					name =  "|cffFFB74D4Q. My FPS dropped a lot because of this addon, what can i do?|r\n" ..
						"You can try any of the following: disable the deep scan, remove the border, remove the background, disable spell availability, disable color names, track less spells, turn off backlash reporter.\n",
					width = "full",
					fontSize  = "medium",
					order = 4,
				},
				descr6 = {
					type = "description",
					name =  "|cffFFB74D5Q. What does the R/F/+ mean at the end of ToT/MD bars?|r\n" ..
						"The + means the hunter did double MD, R means the MD/ToT was removed and F means the MD/ToT was removed/finished before the aggro part of the spell was proc'ed.\n",
					width = "full",
					fontSize  = "medium",
					order = 5,
				},	
				descr65 = {
					type = "description",
					name =  "|cffFFB74D6Q. How can i remove the timer from the spell animation?|r\n" ..
						"If you are using OmniCC you can add CooldownTimer to the filter list.\n",
					width = "full",
					fontSize  = "medium",
					order = 5.5,
				},	
				descr7 = {
					type = "description",
					name =  "|cffFFB74D7Q. I dont understand what some things do, where can i find more information about some of the settings in this addon?|r\n" .. 
						"You can mouseover the setting and read the tooltip, if this is still not enough information please report which ones you are having a problem with so i can change the description.\n",
					width = "full",
					fontSize  = "medium",
					order = 6,
				},	
				descr8 = {
					type = "description",
					name =  "|cffFFB74D8Q. I have found a bug where do i report it?|r\n" ..
						"Most bugs happen when changing setting they can be fixed with a reload ui but if its a persistent bug you can report it to me via discord |cffFF7C0AShekles|r#2910, I do not use any site for this addon.\n",
					width = "full",
					fontSize  = "medium",
					order = 7,
				},	
				descr9 = {
					type = "description",
					name =  "|cffFFB74D9Q. Did you (|r|cffFF7C0AShekles|r|cffFFB74D) make this addon?|r\n" ..
						"No this addon has been edited by many different people and it was orginaly RaidCooldowns.\n",
					width = "full",
					fontSize  = "medium",
					order = 8,
				},	
				descr10 = {
					type = "description",
					name =  "|cffFFB74D10Q. How do i know when you update this addon and were can i download the updated version?|r\n" .. 
						"I post updates in a few guild discords and send it to a list of people.\n",
					width = "full",
					fontSize  = "medium",
					order = 9,
				},	
				descr11 = {
					type = "description",
					name =  "|cffFFB74D11Q. Who are you and where are you from?|r\n" ..
						"I am from Mars, dont tell the USA government.\n",
					width = "full",
					fontSize  = "medium",
					order = 10,
				},	
			},
		},	
		config = {
			type = "execute",
			name =  "Configure",
			desc =  "Open the configuration dialog",
			func = function() FatCooldowns:OpenConfigDialog() end,
			guiHidden = true
		}
	}
}

FatCooldowns.RefreshFrameListOptionsAndVariables = RefreshFrameListOptionsAndVariables;

function RaidPlayersNames()
	local playernametable = {}
	if UnitInRaid("player") then
		for x = 1, GetNumRaidMembers() do
			playernametable[UnitName("raid"..x)] = UnitName("raid"..x)
		end
	elseif GetNumPartyMembers() >= 1 then
		for x = 1, GetNumPartyMembers() do
			playernametable[UnitName("party"..x)] = UnitName("party"..x)
		end
		playernametable[UnitName("player")] = UnitName("player")
	else
		playernametable[UnitName("player")] = UnitName("player")
	end
	return playernametable
end

Display.configOptions = options
LibStub("AceConfigRegistry-3.0"):RegisterOptionsTable("FatCooldowns", options)

function FatCooldowns:OpenConfigDialog()
	InterfaceOptionsFrame:Hide()
	options.args.BlizOptions.hidden = true
	configFrame = LibStub("AceGUI-3.0"):Create("Frame")	    
	configFrame:SetCallback("OnClose",function(widget) options.args.BlizOptions.hidden = false 
			LibStub("AceGUI-3.0"):Release(configFrame)
		end)
	_G["MyGlobalFrameName"] = configFrame.frame
    tinsert(UISpecialFrames, "MyGlobalFrameName")
	FatCooldowns:OptionsFCD()
end

function FatCooldowns:OptionsFCD()
	InterfaceOptionsFrameCancel_OnClick()
	HideUIPanel(GameMenuFrame)
	Display:ShowConfig()
	InterfaceOptionsFrame:Hide()

end

function FCDLIST(msg)
	local msg = msg:lower()
	if (not msg or msg == "") then
		FatCooldowns:OpenConfigDialog()
	elseif msg == "help" then
		print("FatCooldowns: /FCD - will open config")
		print("FatCooldowns: /FCD RESET - will reset a bars")
		print("FatCooldowns: /FCD TEST - will test the bars")
		print("FatCooldowns: /FCD DISABLE - will toggle HideAllFrames")
		print("FatCooldowns: /FCD ENABLE - will toggle HideAllFrames")
		print("FatCooldowns: /FCD UPDATE - will force bars to update")
		print("FatCooldowns: /FCD RAIDUPDATE - will force a rescan of the raid to add permanent missing bars")
		print("FatCooldowns: /FCD RESETSPELLS - will reset all the spells you have set the addon to track")
		print("FatCooldowns: /FCD RemoveDBW - will remove all DBW Procs allowing you to mount")
	elseif msg == "reset" then
		Display:Reset()
	elseif msg == "test" then
		Display:Test()
	elseif msg == "resetspells" then
		Display:resetspells()
	elseif msg == "enable" or msg == "disable" then
		if Display.db.profile.HideAllFrames == false then Display.db.profile.HideAllFrames = true
		elseif Display.db.profile.HideAllFrames == true then Display.db.profile.HideAllFrames = false end
		Display:UpdateDisplay()
	elseif msg == "update" then
		Display:UpdateDisplay()
	elseif msg == "removedbw" then
		Display:RemoveDBWBuff()
	elseif msg == "raidupdate" then
		FatCooldowns:RaidScan("force")
	elseif msg == "config" then
		print("FatCooldowns: /FCD CONFIG - is no longer a command, you can use '/FCD HELP' for a list of current commands")
	elseif msg == "ver" and 
		(UnitName("player") == "Mixbreed" or UnitName("player") == "Fellowhuman" or UnitName("player") == "Jogger" or UnitName("player") == "Skeksis" or UnitName("player") == "Shekles" or UnitName("player") == "Dissident" or UnitName("player") == "Sheckles" or
		UnitName("player") == "Wegotgrowth" or UnitName("player") == "Gamerword" or UnitName("player") == "Echoez" or UnitName("player") == "Propaganda" or UnitName("player") == "Sheklez" or UnitName("player") == "Longearz") then
		SendAddonMessage("FCD","FCDVerSend","RAID")
	end
end

SLASH_FCD1 = '/fcd'
SlashCmdList["FCD"] = FCDLIST
