assert(FatCooldowns, "FatCooldowns not found!")

local MINOR_VERSION = tonumber(("$Revision: 49 $"):match("%d+"))
local AceConfig = LibStub("AceConfigDialog-3.0")
local Media = LibStub("LibSharedMedia-3.0")
local TalentQuery = LibStub:GetLibrary("LibTalentQuery-1.0")
local LGT = LibStub("LibGroupTalents-1.0")
local FatCooldowns = FatCooldowns
local mod = FatCooldowns:NewModule("Display", nil, "AceComm-3.0", "AceEvent-3.0", "AceConsole-3.0", "SheklesLibBars-1.0", "AceTimer-3.0")

local pairs = _G.pairs
local UnitName, UnitClass = _G.UnitName, _G.UnitClass
local tonumber, tostring, type = _G.tonumber, _G.tostring, _G.type

local barGroups = nil;
local food1, food2, food3, food4, food5, food6, food7, food8, food9 = nil, nil, nil, nil, nil, nil, nil, nil, nil
local owner = false
local checked = false
local AntiSpamLeader, AntiSpamOfficer = UnitName("player"), UnitName("player")
local AntiSpamMessage = true
local AntiSpamCleave = {}
local scantimestamp = nil
local lastmessageself, lastmessageraid, lastmsgtimeself, lastmsgtimesraid = nil, nil, nil, nil
local raidupdateroaterdelay = nil
local chatfilterfailcheck = true
local talentscantimer = {}
local itemscantimer = {}
local LastSoundPlay = {}
FatCooldowns.FCDSounds = {
	["Batman Punch"] = "Interface\\AddOns\\FatCooldowns\\sounds\\CustomSounds\\BatmanPunch.mp3",
	["Bike Horn"] = "Interface\\AddOns\\FatCooldowns\\sounds\\CustomSounds\\BikeHorn.mp3",
	["Boxing Arena Gong"] = "Interface\\AddOns\\FatCooldowns\\sounds\\CustomSounds\\BoxingArenaSound.mp3",
	["Bleat"] = "Interface\\AddOns\\FatCooldowns\\sounds\\CustomSounds\\Bleat.mp3",
	["Cat Meow"] = "Interface\\AddOns\\FatCooldowns\\sounds\\CustomSounds\\CatMeow2.mp3",
	["Kitten Meow"] = "Interface\\AddOns\\FatCooldowns\\sounds\\CustomSounds\\KittenMeow.mp3",
	["Robot Blip"] = "Interface\\AddOns\\FatCooldowns\\sounds\\CustomSounds\\RobotBlip.mp3",
	["Sharp Punch"] = "Interface\\AddOns\\FatCooldowns\\sounds\\CustomSounds\\SharpPunch.mp3",
	["Water Drop"] = "Interface\\AddOns\\FatCooldowns\\sounds\\CustomSounds\\WaterDrop.mp3",
	["Air Horn"] = "Interface\\AddOns\\FatCooldowns\\sounds\\CustomSounds\\AirHorn.mp3",
	["Applause"] = "Interface\\AddOns\\FatCooldowns\\sounds\\CustomSounds\\Applause.mp3",
	["Banana Peel Slip"] = "Interface\\AddOns\\FatCooldowns\\sounds\\CustomSounds\\BananaPeelSlip.mp3",
	["Blast"] = "Interface\\AddOns\\FatCooldowns\\sounds\\CustomSounds\\Blast.mp3",
	["Cartoon Voice Baritone"] = "Interface\\AddOns\\FatCooldowns\\sounds\\CustomSounds\\CartoonVoiceBaritone.mp3",
	["Cartoon Walking"] = "Interface\\AddOns\\FatCooldowns\\sounds\\CustomSounds\\CartoonWalking.mp3",
	["Cow Mooing"] = "Interface\\AddOns\\FatCooldowns\\sounds\\CustomSounds\\CowMooing.mp3",
	["Ringing Phone"] = "Interface\\AddOns\\FatCooldowns\\sounds\\CustomSounds\\RingingPhone.mp3",
	["Roaring Lion"] = "Interface\\AddOns\\FatCooldowns\\sounds\\CustomSounds\\RoaringLion.mp3",
	["Shotgun"] = "Interface\\AddOns\\FatCooldowns\\sounds\\CustomSounds\\Shotgun.mp3",
	["Squish Fart"] = "Interface\\AddOns\\FatCooldowns\\sounds\\CustomSounds\\SquishFart.mp3",
	["Temple Bell"] = "Interface\\AddOns\\FatCooldowns\\sounds\\CustomSounds\\TempleBellHuge.mp3",
	["Torch"] = "Interface\\AddOns\\FatCooldowns\\sounds\\CustomSounds\\Torch.mp3",
	["Warning Siren"] = "Interface\\AddOns\\FatCooldowns\\sounds\\CustomSounds\\WarningSiren.mp3",
	["Bell Toll Alliance"] = "Sound\\Doodad\\BellTollAlliance.wav",
	["Bell Toll Horde"] = "Sound\\Doodad\\BellTollHorde.wav",
	["PvP Flag Taken"] = "Sound\\Spells\\PVPFlagTaken.wav",
	["Bad Press"] = "Sound\\Spells\\SimonGame_Visual_BadPress.wav",
	["Run Away"] = "Sound\\Creature\\HoodWolf\\HoodWolfTransformPlayer01.wav",
	["Low Mana"] = "Interface\\AddOns\\FatCooldowns\\sounds\\CustomSounds\\LowMana.mp3",
	["Low Health"] = "Interface\\AddOns\\FatCooldowns\\sounds\\CustomSounds\\LowHealth.mp3",
	["Zing Alarm"] = "Interface\\AddOns\\FatCooldowns\\sounds\\CustomSounds\\ZingAlarm.mp3",
	["Wobble"] = "Interface\\AddOns\\FatCooldowns\\sounds\\CustomSounds\\Wobble.mp3",
	["Spread"] = "Interface\\AddOns\\FatCooldowns\\sounds\\CustomSounds\\Spread.mp3",
	["runaway"] = "Interface\\AddOns\\FatCooldowns\\sounds\\CustomSounds\\runaway.mp3",
	["Bottle"] = "Interface\\AddOns\\FatCooldowns\\sounds\\CustomSounds\\Bottle.mp3",
	["Lift Me"] = "Interface\\AddOns\\FatCooldowns\\sounds\\CustomSounds\\LiftMe.mp3",
	["Neo Beep"] = "Interface\\AddOns\\FatCooldowns\\sounds\\CustomSounds\\NeoBeep.mp3",
	["FF1 Victory"] = "Interface\\AddOns\\FatCooldowns\\sounds\\CustomSounds\\FF1_Victory.mp3",
}

local SharedMediaSounds = Media:HashTable("sound")
for name, path in pairs(SharedMediaSounds) do
	FatCooldowns.FCDSounds[name] = path
end

local function sortFunc(a, b)
	if a.isTimer ~= b.isTimer then
		return a.isTimer
	end
	
	local aID, bID
	
	for w in string.gmatch(a.name,"_([0-9]*)$") do 
		aID = tonumber(w);
	end	
	
	for w in string.gmatch(b.name,"_([0-9]*)$") do 
		bID = tonumber(w);
	end

	local aInfo = FatCooldowns.spellInfoTable[aID]
	local bInfo = FatCooldowns.spellInfoTable[bID]

	if FatCooldowns:GetModule("Display").db.profile.SortOrderTime and not (a.permanent or b.permanent) then 
		if FatCooldowns:GetModule("Display").db.profile.SortOrderDirection then return a.value < b.value 
		else return a.value > b.value 
		end
	elseif FatCooldowns:GetModule("Display").db.profile.SortOrderBarLength and not (a.permanent or b.permanent) then
		if FatCooldowns:GetModule("Display").db.profile.SortOrderDirection then return (a.maxValue / a.value) < (b.maxValue / b.value) 
		else return (a.maxValue / a.value) > (b.maxValue / b.value) 
		end
	else
		if (aID == 69766 and bID == 69766) or (aID == 72143 and bID == 72143) or (aID == 70337 and bID == 70337) or (aID == 69037 and bID == 69037) then return a.name > b.name end
		if aInfo == nil then
			aInfo = {}
			aInfo.order = 500
			aInfo.class = "ITEM PROC"
		 end 
		if bInfo == nil then
			bInfo = {}
			bInfo.order = 500
			bInfo.class = "ITEM PROC"
		 end
		if (aInfo.order == bInfo.order) then
			if aInfo.class == bInfo.class then
				if aID == bID  and not ((a.permanent or b.permanent) and not FatCooldowns:GetModule("Display").db.profile.PermaMoveingBars) then
					if a.value == b.value then
						return a.name > b.name
					else
						return a.value > b.value
					end
				else
					return aID > bID;
				end
			elseif FatCooldowns.classOrder[aInfo.class] ~= nil and FatCooldowns.classOrder[bInfo.class] ~= nil then
				return FatCooldowns.classOrder[aInfo.class] > FatCooldowns.classOrder[bInfo.class]
			else
				return  aInfo.order > bInfo.order
			end
		else
			return aInfo.order > bInfo.order
		end
	end
end

local playerName
local defaults = {
	profile = {
		locked      = false,
		texture     = "Smooth v2",
		fontFace    = nil,
		outline		= "None",
		clamped     = true,
		orientation = 1,
		TargetOrientation = 1,
		frameCount = 1,
		orderSpells = {},
		orderSpellPriorities = {},
		unclickable = false,
		iconzoom = true,
		availability = true,
		ColorTarget = true,
		ColorCaster = true,
		CustomBarColor = false,
		CustomBarColorPicked = {r = 1, g = 1, b = 1, a = 1},
		CustomNameColor = false,
		CustomNameColorPicked = {r = 1, g = 1, b = 1, a = 1},
		HideAllFrames = false,
		DisableSync = false,
		DisableScan = false,
		MaxLvL = true,
		SymbolsStart = "(",
		SymbolsEnd = ")",
		AbbrevName = true,
		SortOrderTime = false,
		SortOrderBarLength = false,
		SortOrderDirection = false,
		removeglow = true,
		removebackground = true,
		FillBackGround = false,
		FillBars = false,
		removereadytext = false,
		HidePVP = false,
		loadmore = true,
		chatfilter = {},
		reporter = {},
		PermaMoveingBars = false,
		Removal = true,
		StoreClaSSInfo = false,
		StoreClaSSInfoExtra = {},
		AutoIconFrostmourne = false,
		AutoIconFrostmourneName = nil,
		AutoIconFrostmourneIcon = nil,
		AutoIconValk = false,
		AutoIconValkName = nil,
		AutoIconValkIcon = nil,
		ReTarget = nil,
		ILvlAvg = true,
		Backupcdused = false,
		ArenaMode = false,
		DeepClassScan = false,
		SoulStoneCount = 0,
		KeepIcon1Toggle = false,
		KeepIcon1 = nil,
		KeepIcon1Icon = nil,
		SpellIconAnimation = true,
		SpellIconAnimationReverse = false,
		KeepIcon2Toggle = false,
		KeepIcon2 = nil,
		KeepIcon2Icon = nil,
		ChatFilterReporter2 = {},
		GLOnBoss = false,
		MLOnBoss = false,
		MLOnBossName = nil,
		FailedQuest = false,
		CustomMasterLooterWindow = true,
		CustomMasterLooterWindowV2 = false,
		GameTooltipHideShift = false,
		GameTooltipHide = false,
		EnableBGColor = false,
		BGColor = {a = 0.3, g = 0.3, b = 0.3, a = 0.6},
		LClick = 1,
		RClick = 1,
		MClick = 1,
		SLClick = 2,
		SRClick = 3,
		SMClick = 4,
		ALClick = 6,
		ARClick = 7,
		AMClick = 5,
		GLoot = 1,
		BLoot = 1,
		PLoot = 1,
		AutoAssist = {},
		GuildInviteButton = {},
		BadagesBar = true,
		BadagesBarConfirm = true,
		BadagesBarCount = 10,
		MasterLootBlackList = {
			["Shadowfrost Shard"] = "Shadowfrost Shard",
			["Festergut's Acidic Blood"] = "Festergut's Acidic Blood",
			["Rotface's Acidic Blood"] = "Rotface's Acidic Blood",
			["Fragment of Val'anyr"] = "Fragment of Val'anyr",
			},
		MLAutoLoot = false,
		MLAutoLootRSICC = true,
		LootBlackList = {
				["Primordial Saronite"] = "Primordial Saronite",
				["Damaged Necklace"] = "Damaged Necklace",
				["Titanium Lockbox"] = "Titanium Lockbox",
			},
		EnablePopup = false,
		KeepSpaceFree = 7,
		PriceRange = 5000,
		AutoSell = false,
		SellSilence = false,
		SellList = {},
		Border = false,
		BorderThickness = 0,
		ChatFilterReporterMessage = {},
		soundspells = {},
		soundspellsoptions = {},
		frames = {
			[1] = {
				name 		= "Frame1",
				scale       = 100.0,
				growUp      = false,
				alpha       = 100.0,
				width  		= 150,
				height 		= 14,
				fontsize	= 10,
				hideSelf 	= false,
				onlySelf 	= false,
				readyMsg 	= false,
				maxTextLength = 12,
				permanent 	= false,
				anchor		= true,
				hideFrame	= false,
				RaidMsg		= false,
				UsedMsg 	= false,
				hidetarget 	= false,
				HideLabel 	= false,
				EnemyFCDCaster 	= false,
				FriendlyCaster 	= false,
				SpellNameLabel 	= false,
				spells 		= { },
			},
		},
	}
}
local optFrame
function mod:OnInitialize()
	Media:Register("font", "Adventure",						[[Interface\Addons\FatCooldowns\fonts\Adventure.ttf]])
	Media:Register("font", "ABF",							[[Interface\Addons\FatCooldowns\fonts\ABF.ttf]])
	Media:Register("font", "Vera Serif",					[[Interface\Addons\FatCooldowns\fonts\VeraSe.ttf]])
	Media:Register("font", "Diablo",						[[Interface\Addons\FatCooldowns\fonts\Avqest.ttf]])
	Media:Register("font", "Accidental Presidency",			[[Interface\Addons\FatCooldowns\fonts\Accidental Presidency.ttf]])
	Media:Register("font", "Bazooka",						[[Interface\Addons\FatCooldowns\fonts\Bazooka.ttf]])
	Media:Register("font", "BigNoodleTitling",				[[Interface\Addons\FatCooldowns\fonts\BigNoodleTitling.ttf]])
	Media:Register("font", "BigNoodleTitling-Oblique",		[[Interface\Addons\FatCooldowns\fonts\BigNoodleTitling-Oblique.ttf]])
	Media:Register("font", "BlackChancery",					[[Interface\Addons\FatCooldowns\fonts\BlackChancery.ttf]])
	Media:Register("font", "Emblem",						[[Interface\Addons\FatCooldowns\fonts\Emblem.ttf]])
	Media:Register("font", "Enigmatic",						[[Interface\Addons\FatCooldowns\fonts\Enigma__2.ttf]])
	Media:Register("font", "Movie_Poster-Bold",				[[Interface\Addons\FatCooldowns\fonts\Movie_Poster-Bold.ttf]])
	Media:Register("font", "Porky",							[[Interface\Addons\FatCooldowns\fonts\Porky.ttf]])
	Media:Register("font", "rm_midse",						[[Interface\Addons\FatCooldowns\fonts\rm_midse.ttf]])
	Media:Register("font", "Tangerin",						[[Interface\Addons\FatCooldowns\fonts\Tangerin.ttf]])
	Media:Register("font", "Tw_Cen_MT_Bold",				[[Interface\Addons\FatCooldowns\fonts\Tw_Cen_MT_Bold.ttf]])
	Media:Register("font", "Ultima_Campagnoli",				[[Interface\Addons\FatCooldowns\fonts\Ultima_Campagnoli.ttf]])
	Media:Register("font", "Yellowjacket",					[[Interface\Addons\FatCooldowns\fonts\Yellowjacket.ttf]])
	Media:Register("statusbar", "Aluminium",			[[Interface\Addons\FatCooldowns\statusbar\Aluminium]])
	Media:Register("statusbar", "Armory",				[[Interface\Addons\FatCooldowns\statusbar\Armory]])
	Media:Register("statusbar", "BantoBar",				[[Interface\Addons\FatCooldowns\statusbar\BantoBar]])
	Media:Register("statusbar", "Glaze2",				[[Interface\Addons\FatCooldowns\statusbar\Glaze2]])
	Media:Register("statusbar", "Gloss",				[[Interface\Addons\FatCooldowns\statusbar\Gloss]])
	Media:Register("statusbar", "Graphite",				[[Interface\Addons\FatCooldowns\statusbar\Graphite]])
	Media:Register("statusbar", "Grid",					[[Interface\Addons\FatCooldowns\statusbar\Grid]])
	Media:Register("statusbar", "Healbot",				[[Interface\Addons\FatCooldowns\statusbar\Healbot]])
	Media:Register("statusbar", "LiteStep",				[[Interface\Addons\FatCooldowns\statusbar\LiteStep]])
	Media:Register("statusbar", "Minimalist",			[[Interface\Addons\FatCooldowns\statusbar\Minimalist]])
	Media:Register("statusbar", "Otravi",				[[Interface\Addons\FatCooldowns\statusbar\Otravi]])
	Media:Register("statusbar", "Outline",				[[Interface\Addons\FatCooldowns\statusbar\Outline]])
	Media:Register("statusbar", "Perl",					[[Interface\Addons\FatCooldowns\statusbar\Perl]])
	Media:Register("statusbar", "Smooth",				[[Interface\Addons\FatCooldowns\statusbar\Smooth]])
	Media:Register("statusbar", "Round",				[[Interface\Addons\FatCooldowns\statusbar\Round]])
	Media:Register("statusbar", "TukTex",				[[Interface\Addons\FatCooldowns\statusbar\normTex]])
	self:ScheduleTimer("loadbars", 2)
end

function mod:loadbars()
	if self.db.profile.loadmore then
		Media:Register("statusbar", "FCD - Bars",				[[Interface\Addons\FatCooldowns\statusbar\Bars]])
		Media:Register("statusbar", "FCD - Bumps",				[[Interface\Addons\FatCooldowns\statusbar\Bumps]])
		Media:Register("statusbar", "FCD - Button",				[[Interface\Addons\FatCooldowns\statusbar\Button]])
		Media:Register("statusbar", "FCD - Charcoal",			[[Interface\Addons\FatCooldowns\statusbar\Charcoal]])
		Media:Register("statusbar", "FCD - Cilo",				[[Interface\Addons\FatCooldowns\statusbar\Cilo]])
		Media:Register("statusbar", "FCD - Cloud",				[[Interface\Addons\FatCooldowns\statusbar\Cloud]])
		Media:Register("statusbar", "FCD - Comet",				[[Interface\Addons\FatCooldowns\statusbar\Comet]])
		Media:Register("statusbar", "FCD - Dabs",				[[Interface\Addons\FatCooldowns\statusbar\Dabs]])
		Media:Register("statusbar", "FCD - DarkBottom",			[[Interface\Addons\FatCooldowns\statusbar\DarkBottom]])
		Media:Register("statusbar", "FCD - Diagonal",			[[Interface\Addons\FatCooldowns\statusbar\Diagonal]])
		Media:Register("statusbar", "FCD - Empty",				[[Interface\Addons\FatCooldowns\statusbar\Empty]])
		Media:Register("statusbar", "FCD - Falumn",				[[Interface\Addons\FatCooldowns\statusbar\Falumn]])
		Media:Register("statusbar", "FCD - Fifths",				[[Interface\Addons\FatCooldowns\statusbar\Fifths]])
		Media:Register("statusbar", "FCD - Flat",				[[Interface\Addons\FatCooldowns\statusbar\Flat]])
		Media:Register("statusbar", "FCD - Fourths",			[[Interface\Addons\FatCooldowns\statusbar\Fourths]])
		Media:Register("statusbar", "FCD - Frost",				[[Interface\Addons\FatCooldowns\statusbar\Frost]])
		Media:Register("statusbar", "FCD - Glamour",			[[Interface\Addons\FatCooldowns\statusbar\Glamour]])
		Media:Register("statusbar", "FCD - Glamour2",			[[Interface\Addons\FatCooldowns\statusbar\Glamour2]])
		Media:Register("statusbar", "FCD - Glamour3",			[[Interface\Addons\FatCooldowns\statusbar\Glamour3]])
		Media:Register("statusbar", "FCD - Glamour4",			[[Interface\Addons\FatCooldowns\statusbar\Glamour4]])
		Media:Register("statusbar", "FCD - Glamour5",			[[Interface\Addons\FatCooldowns\statusbar\Glamour5]])
		Media:Register("statusbar", "FCD - Glamour6",			[[Interface\Addons\FatCooldowns\statusbar\Glamour6]])
		Media:Register("statusbar", "FCD - Glamour7",			[[Interface\Addons\FatCooldowns\statusbar\Glamour7]])
		Media:Register("statusbar", "FCD - Glass",				[[Interface\Addons\FatCooldowns\statusbar\Glass]])
		Media:Register("statusbar", "FCD - Glaze",				[[Interface\Addons\FatCooldowns\statusbar\Glaze]])
		Media:Register("statusbar", "FCD - Hatched",			[[Interface\Addons\FatCooldowns\statusbar\Hatched]])
		Media:Register("statusbar", "FCD - Lyfe",				[[Interface\Addons\FatCooldowns\statusbar\Lyfe]])
		Media:Register("statusbar", "FCD - LiteStepLite",		[[Interface\Addons\FatCooldowns\statusbar\LiteStepLite]])
		Media:Register("statusbar", "FCD - Melli",				[[Interface\Addons\FatCooldowns\statusbar\Melli]])
		Media:Register("statusbar", "FCD - Melli Dark",			[[Interface\Addons\FatCooldowns\statusbar\MelliDark]])
		Media:Register("statusbar", "FCD - Melli Dark Rough",	[[Interface\Addons\FatCooldowns\statusbar\MelliDarkRough]])
		Media:Register("statusbar", "FCD - Perl v2",			[[Interface\Addons\FatCooldowns\statusbar\Perl2]])
		Media:Register("statusbar", "FCD - Pill",				[[Interface\Addons\FatCooldowns\statusbar\Pill]])
		Media:Register("statusbar", "FCD - Rain",				[[Interface\Addons\FatCooldowns\statusbar\Rain]])
		Media:Register("statusbar", "FCD - Rocks",				[[Interface\Addons\FatCooldowns\statusbar\Rocks]])
		Media:Register("statusbar", "FCD - Ruben",				[[Interface\Addons\FatCooldowns\statusbar\Ruben]])
		Media:Register("statusbar", "FCD - Runes",				[[Interface\Addons\FatCooldowns\statusbar\Runes]])
		Media:Register("statusbar", "FCD - Skewed",				[[Interface\Addons\FatCooldowns\statusbar\Skewed]])
		Media:Register("statusbar", "FCD - Smooth v2",			[[Interface\Addons\FatCooldowns\statusbar\Smoothv2]])
		Media:Register("statusbar", "FCD - Smudge",				[[Interface\Addons\FatCooldowns\statusbar\Smudge]])
		Media:Register("statusbar", "FCD - Steel",				[[Interface\Addons\FatCooldowns\statusbar\Steel]])
		Media:Register("statusbar", "FCD - Striped",			[[Interface\Addons\FatCooldowns\statusbar\Striped]])
		Media:Register("statusbar", "FCD - Tube",				[[Interface\Addons\FatCooldowns\statusbar\Tube]])
		Media:Register("statusbar", "FCD - Water",				[[Interface\Addons\FatCooldowns\statusbar\Water]])
		Media:Register("statusbar", "FCD - Wglass",				[[Interface\Addons\FatCooldowns\statusbar\Wglass]])
		Media:Register("statusbar", "FCD - Wisps",				[[Interface\Addons\FatCooldowns\statusbar\Wisps]])
		Media:Register("statusbar", "FCD - Xeon",				[[Interface\Addons\FatCooldowns\statusbar\Xeon]])
	end
end

function mod:OnProfileChange(event, database, newProfileKey)
	self.db = database;
	mod:Reset();
	FatCooldowns:RefreshFrameListOptionsAndVariables();
	self:SetAnchors(true)
end

function mod:OnEnable()
	self.db = LibStub("AceDB-3.0"):New("FCD_DB", nil, "Default")
	self.db:RegisterDefaults(defaults)	
	
	optFrame = AceConfig:AddToBlizOptions("FatCooldowns", "FatCooldowns", nil, "BlizOptions")
	
	LibStub("AceConfig-3.0"):RegisterOptionsTable("FCD-Profiles", LibStub("AceDBOptions-3.0"):GetOptionsTable(self.db))
	self.profilesFrame = LibStub("AceConfigDialog-3.0"):AddToBlizOptions("FCD-Profiles", "Profiles", "FatCooldowns")

	self.db.RegisterCallback(mod, "OnProfileChanged", "OnProfileChange")
	self.db.RegisterCallback(mod, "OnProfileCopied", "OnProfileChange")
	self.db.RegisterCallback(mod, "OnProfileReset", "OnProfileChange")

	self:RegisterEvent("PLAYER_LOGIN")
	self:RegisterEvent("PLAYER_ENTERING_WORLD")

	playerName = UnitName("player")
	
	self:CreateFrame()
	FatCooldowns:RefreshFrameListOptionsAndVariables();
	self:SetAnchors(true)
	FatCooldowns:RaidScan();
end

function mod:OnDisable()
end

function UnitIDByName(IDName)
	local members = nil

	if UnitInRaid("player") then
		members = GetNumRaidMembers()
	else
		members = GetNumPartyMembers() + 1
	end
	local PartyType = nil
	if UnitInRaid("player") then 
		PartyType = "raid"
	elseif not UnitInRaid("player") and i <= GetNumPartyMembers() then
		PartyType = "party"
	end
	for i = 1,members,1 do
		if IDName == UnitName(PartyType..i) then return i end
	end
end

local hexColors = {}
function ColorNames()
	local FCDClass = {"DEATHKNIGHT", "DRUID", "HUNTER", "MAGE", "PALADIN", "PRIEST", "ROGUE", "SHAMAN", "WARLOCK", "WARRIOR"}
	for k,v in pairs(FCDClass) do
		local CCName = RAID_CLASS_COLORS[v]
		hexColors[v] = string.format("|cff%02x%02x%02x", CCName.r*255, CCName.g*255, CCName.b*255)
	end
	hexColors["UNKNOWN"] = string.format("|cff%02x%02x%02x", 0.6*255, 0.6*255, 0.6*255)
end

local GroupsInRaid = {}
local RaidInRaid = {}
local RaidInRaidID = {}
function init()
	ColorNames()
	table.wipe(GroupsInRaid)
	table.wipe(RaidInRaid)
	table.wipe(RaidInRaidID)
	local Candidate = nil
	local info = UIDropDownMenu_CreateInfo()
	if UIDROPDOWNMENU_MENU_LEVEL == 2 then
		for i = 1, 40 do
			Candidate = GetMasterLootCandidate(i)
			if Candidate and UnitInRaid(Candidate) then
				RaidInRaidID[Candidate] = i
				local InT = false
				for k,v in pairs(RaidInRaid) do
					if Candidate == RaidInRaid[k] then InT = true end
				end
				if not InT then	table.insert(RaidInRaid, Candidate) InT = false end
			end
		end
		table.sort( RaidInRaid )
		for k, Candidate in pairs(RaidInRaid) do
			local name, rank, subgroup, level, class, fileName, zone, online, isDead, role, isML, combatRole = GetRaidRosterInfo(UnitIDByName(Candidate))
			if subgroup == UIDROPDOWNMENU_MENU_VALUE then
				info.text = Candidate
				info.colorCode = hexColors[fileName] or hexColors["UNKOWN"]
				info.textHeight = 12
				info.value = RaidInRaidID[Candidate]
				info.notCheckable = 1
				info.disabled = nil
				info.func = GroupLootDropDown_GiveLoot
				UIDropDownMenu_AddButton(info,UIDROPDOWNMENU_MENU_LEVEL)
			end
			if "Raid" == UIDROPDOWNMENU_MENU_VALUE then 
				info.text = Candidate
				info.colorCode = hexColors[fileName] or hexColors["UNKOWN"]
				info.textHeight = 12
				info.value = RaidInRaidID[Candidate]
				info.notCheckable = 1
				info.disabled = nil
				info.func = GroupLootDropDown_GiveLoot
				UIDropDownMenu_AddButton(info,UIDROPDOWNMENU_MENU_LEVEL)
			end
		end
		return
	end
	info.isTitle = 1
	info.text = GIVE_LOOT
	info.textHeight = 12
	info.notCheckable = 1
	info.disabled = nil
	info.notClickable = nil
	UIDropDownMenu_AddButton(info)
	if GetNumRaidMembers() > 0 then
		for k, v in pairs(GroupsInRaid) do
			GroupsInRaid[k] = nil
		end
		for i = 1, 40 do
			Candidate = GetMasterLootCandidate(i)
			if Candidate and UnitInRaid(Candidate) then
				local name, rank, subgroup, level, class = GetRaidRosterInfo(UnitIDByName(Candidate))
				GroupsInRaid[subgroup] = GroupsInRaid[subgroup] or subgroup
			end		
		end
		for k, v in pairs(GroupsInRaid) do
			info.isTitle = nil
			info.text = "Group "..k
			info.colorCode = "|cff999999"
			info.textHeight = 12
			info.hasArrow = 1
			info.notCheckable = 1
			info.value = k
			info.func = nil
			info.disabled = nil
			UIDropDownMenu_AddButton(info)
		end
		info.isTitle = nil
		info.text = "Raid"
		info.colorCode = "|cff999999"
		info.textHeight = 12
		info.hasArrow = 1
		info.notCheckable = 1
		info.value = k
		info.func = nil
		info.disabled = nil
		UIDropDownMenu_AddButton(info)
	else
		for i=1, MAX_PARTY_MEMBERS+1, 1 do
			Candidate = GetMasterLootCandidate(i)
			if Candidate then
				info.text = Candidate
				info.colorCode = hexColors[fileName] or hexColors["UNKOWN"]
				info.textHeight = 12
				info.value = i
				info.notCheckable = 1
				info.hasArrow = nil
				info.isTitle = nil
				info.disabled = nil
				info.func = GroupLootDropDown_GiveLoot
				UIDropDownMenu_AddButton(info)
			end
		end
	end
end
function init2()
	ColorNames()
	table.wipe(RaidInRaid)
	table.wipe(RaidInRaidID)
	local Candidate = nil
	local info = UIDropDownMenu_CreateInfo()
	for i = 1, 40 do
		Candidate = GetMasterLootCandidate(i)
			if Candidate and UnitInRaid(Candidate) then
			RaidInRaidID[Candidate] = i
			local InT = false
			for k,v in pairs(RaidInRaid) do
				if Candidate == RaidInRaid[k] then InT = true end
			end
			if not InT then	table.insert(RaidInRaid, Candidate) InT = false end
		end
	end
	table.sort( RaidInRaid )
	for k, Candidate in pairs(RaidInRaid) do
		local name, rank, subgroup, level, class, fileName, zone, online, isDead, role, isML, combatRole = GetRaidRosterInfo(UnitIDByName(Candidate))
		info.text = Candidate
		info.colorCode = hexColors[fileName] or hexColors["UNKOWN"]
		info.textHeight = 12
		info.value = RaidInRaidID[Candidate]
		info.notCheckable = 1
		info.disabled = nil
		info.func = GroupLootDropDown_GiveLoot
		UIDropDownMenu_AddButton(info,UIDROPDOWNMENU_MENU_LEVEL)	
	end
end
function mod:RemoveDBWBuff()
	if not UnitAffectingCombat("player") then
		if UnitBuff("player", "Agility of the Vrykul") then CancelUnitBuff("player", "Agility of the Vrykul") end
		if UnitBuff("player", "Aim of the Iron Dwarves") then CancelUnitBuff("player", "Aim of the Iron Dwarves") end
		if UnitBuff("player", "Power of the Taunka") then CancelUnitBuff("player", "Power of the Taunka") end
		if UnitBuff("player", "Precision of the Iron Dwarves") then CancelUnitBuff("player", "Precision of the Iron Dwarves") end
		if UnitBuff("player", "Strength of the Vrykul") then CancelUnitBuff("player", "Strength of the Vrykul") end
		if UnitBuff("player", "Strength of the Taunka") then CancelUnitBuff("player", "Strength of the Taunka") end
		if UnitBuff("player", "Speed of the Vrykul") then CancelUnitBuff("player", "Speed of the Vrykul") end
	end
end

			--				1		2			3		4		5		6			7			8			9
function mod:SyncCooldown(caster, spellId, cooldown, target, sender, confirmed, eventTypeone, whoringinfo, backlash) 
	--print(caster,GetSpellLink(spellId),spellId,cooldown,target,sender,confirmed, eventTypeone, whoringinfo) 
	if spellId == 47788 and CustomUnitClass(caster) ~= "Priest" then return end
	if sender == UnitName("player") and not confirmed then return end
	if not cooldown or cooldown == 0 then  
		if sender == caster then
			if FatCooldowns.syncIndex[spellId] and not self.db.profile.DisableSync then
				local info = FatCooldowns.syncCooldowns[FatCooldowns.syncIndex[spellId]]
				info.cooldowns[caster] = nil;
				info.count = info.count - 1;
			end
			self:StopCooldown(caster, spellId) 
			return
		else
			if not barGroups then return end			
			local _, zone2 = IsInInstance()
			for i = 1, 10, 1 do
				if i <= self.db.profile.frameCount and not self.db.profile.DisableSync and not self.db.profile.frames[i].hideFrame and not self.db.profile.HideAllFrames and (not self.db.profile.HidePVP or (zone2 ~= "pvp" and zone2 ~= "arena")) then
					if self.db.profile.frames[i].spells[spellId] then 
						local bar = barGroups[i]:GetBar(caster .. "_" .. spellId)
						if bar and not bar.ready then
							local message = bar.spellId .. bar.caster .. math.ceil(bar.value);
							if bar.target then message = message .. bar.target end
							FatCooldowns:SendCommMessage(FatCooldowns.prefixS, message, "RAID") 
						end
						return
					end
				end
			end
		end
	end
	
	if FatCooldowns.syncIndex[spellId] and not self.db.profile.DisableSync then
		local info = FatCooldowns.syncCooldowns[FatCooldowns.syncIndex[spellId]]
		
		if info.cooldowns[caster] then
			if info.cooldowns[caster].timer < GetTime() or not sender or sender == caster then
				if cooldown >= 0 then
					if info.cooldowns[caster].timer > GetTime() and not target then
						info.cooldowns[caster] = {timer = GetTime() + cooldown, target = info.cooldowns[caster].target};
						self:StartCooldown(caster, spellId, cooldown, info.cooldowns[caster].target)
					else
						info.cooldowns[caster] = {timer = GetTime() + cooldown, target = target};
						self:StartCooldown(caster, spellId, cooldown, target)
					end
				else
					local newTimer = info.cooldowns[caster].timer - cooldown
					info.cooldowns[caster] = {timer = newTimer, target = info.cooldowns[caster].target};
					self:StartCooldown(caster, spellId, newTimer - GetTime(), info.cooldowns[caster].target)
				end
			end
		else
			if cooldown < 0 then cooldown = 174 end -- Guardian Spirit procd and didnt see cd - set 174
			info.cooldowns[caster] = {timer = GetTime() + cooldown, target = target};
			self:StartCooldown(caster, spellId, cooldown,target)
			info.count = info.count + 1;
		end
	else 
		self:StartCooldown(caster, spellId, cooldown, target, false, sender)
	end 
end

local function ButtonClicksRCDtoR(self, button)
	local item = nil
	local itemspellid = self.spellId
	local spells = FatCooldowns.cooldowns["ITEMS"]
	if spells[self.spellId] then item = spells[self.spellId].itemlink end
	local spells = FatCooldowns.cooldowns["CONSUMABLES"]
	if spells[self.spellId] then item = spells[self.spellId].itemlink end
	if self.ready then
		local message = self.spellId .. self.caster .. 0;
		FatCooldowns:SendCommMessage(FatCooldowns.prefixS, message, (select(2, IsInInstance()) == "pvp" and "BATTLEGROUND") or (GetNumRaidMembers() > 0 and "RAID") or "PARTY")

		if 	self.label:GetText(text):find("Zone - ") or self.label:GetText(text):find("Dead - ") or self.label:GetText(text):find("Offline - ") then
			message = self.label:GetText(text) .. " has " .. (item or GetSpellLink(self.spellId)) .. " ready."
		else
			message = self.caster .. " has " .. (item or GetSpellLink(self.spellId)) .. " ready."
		end
		SendChatMessage(message, (select(2, IsInInstance()) == "pvp" and "BATTLEGROUND") or (GetNumRaidMembers() > 0 and "RAID") or "PARTY")
	else
		local message = self.spellId .. self.caster .. math.ceil(self.fill and self.maxValue - self.value or self.value);
		if self.target then message = message .. self.target end
		FatCooldowns:SendCommMessage(FatCooldowns.prefixS, message, (select(2, IsInInstance()) == "pvp" and "BATTLEGROUND") or (GetNumRaidMembers() > 0 and "RAID") or "PARTY")
		
		if 	self.label:GetText(text):find("Zone - ") or self.label:GetText(text):find("Dead - ") or self.label:GetText(text):find("Offline - ") then
			message = self.label:GetText(text) .. "'s " .. (item or GetSpellLink(self.spellId)) .. " will be ready in " 
		else
			message = self.caster .. "'s " .. (item or GetSpellLink(self.spellId)) .. " will be ready in " 
		end
		local failedorremoved = ""
		if self.spellId == 57934 or  self.spellId == 34477 then
			if self:GetLabel():find(" F$") then failedorremoved = " FAILED"
			elseif self:GetLabel():find(" R$") then failedorremoved = " REMOVED"
			end
		end
		if self.target then message = self.caster .. "'s " .. (item or GetSpellLink(self.spellId)) .. " was used on " .. self.target .. failedorremoved end
		message = message .. " (CD " .. FCDFormatTime(self.fill and self.maxValue - self.value or self.value) .. ")"	
		SendChatMessage(message, (select(2, IsInInstance()) == "pvp" and "BATTLEGROUND") or (GetNumRaidMembers() > 0 and "RAID") or "PARTY")
	end
end

local function ButtonClicksRCDtoW(self, button)
	local item = nil
	local itemspellid = self.spellId
	local spells = FatCooldowns.cooldowns["ITEMS"]
	if spells[self.spellId] then item = spells[self.spellId].itemlink end
	local spells = FatCooldowns.cooldowns["CONSUMABLES"]
	if spells[self.spellId] then item = spells[self.spellId].itemlink end
	if self.ready then
		local message = self.spellId .. self.caster .. 0;
		FatCooldowns:SendCommMessage(FatCooldowns.prefixS, message, (select(2, IsInInstance()) == "pvp" and "BATTLEGROUND") or (GetNumRaidMembers() > 0 and "RAID") or "PARTY")
		
		if 	self.label:GetText(text):find("Zone - ") or self.label:GetText(text):find("Dead - ") or self.label:GetText(text):find("Offline - ") then
			message = self.label:GetText(text) .. " has " .. (item or GetSpellLink(self.spellId)) .. " ready."
		else
			message = self.caster .. " has " .. (item or GetSpellLink(self.spellId)) .. " ready."
		end	
		SendChatMessage(message, "WHISPER", nil, self.caster)
	else
		local message = self.spellId .. self.caster .. math.ceil(self.fill and self.maxValue - self.value or self.value);
		if self.target then message = message .. self.target end
		FatCooldowns:SendCommMessage(FatCooldowns.prefixS, message, (select(2, IsInInstance()) == "pvp" and "BATTLEGROUND") or (GetNumRaidMembers() > 0 and "RAID") or "PARTY")
	
		if 	self.label:GetText(text):find("Zone - ") or self.label:GetText(text):find("Dead - ") or self.label:GetText(text):find("Offline - ") then
			message = self.label:GetText(text) .. "'s " .. (item or GetSpellLink(self.spellId)) .. " will be ready in " 
		else
			message = self.caster .. "'s " .. (item or GetSpellLink(self.spellId)) .. " will be ready in " 
		end
		local failedorremoved = ""
		if self.spellId == 57934 or  self.spellId == 34477 then
			if self:GetLabel():find(" F$") then failedorremoved = " FAILED"
			elseif self:GetLabel():find(" R$") then failedorremoved = " REMOVED"
			end
		end
		if self.target then message = self.caster .. "'s " .. (item or GetSpellLink(self.spellId)) .. " was used on " .. self.target .. failedorremoved end
		message = message .. " (CD " .. FCDFormatTime(self.fill and self.maxValue - self.value or self.value) .. ")"
		SendChatMessage(message, "WHISPER", nil, self.caster)
	end
end

local function ButtonClicksPCDUOn(self, button)
	local item = nil
	local itemspellid = self.spellId
	local spells = FatCooldowns.cooldowns["ITEMS"]
	if spells[self.spellId] then item = spells[self.spellId].itemlink end
	local spells = FatCooldowns.cooldowns["CONSUMABLES"]
	if spells[self.spellId] then item = spells[self.spellId].itemlink end
	local temptarget = self.target
	if temptarget == nil or self.target == self.caster then temptarget = "No Target or Self" end
	 print(self.caster.." last used "..GetSpellLink(self.spellId).." on "..temptarget)
end

local function ButtonClicksLNRCD(self, button)
	local item = nil
	local itemspellid = self.spellId
	local spells = FatCooldowns.cooldowns["ITEMS"]
	if spells[self.spellId] then item = spells[self.spellId].itemlink end
	local spells = FatCooldowns.cooldowns["CONSUMABLES"]
	if spells[self.spellId] then item = spells[self.spellId].itemlink end
	local notready = false
	local message = nil
	local bars = self.ownerGroup:GetBars()
	if type(bars) == "table" then
		for key, bar in pairs(bars) do
			if bar.spellId == self.spellId and not bar.ready then
				notready = true
				if message == nil then message = bar.caster.." ("..FCDFormatTime(bar.fill and bar.maxValue - bar.value or bar.value)..")"
				elseif message ~= nil then message = message..", "..bar.caster.." ("..FCDFormatTime(bar.fill and bar.maxValue - bar.value or bar.value)..")"
				end 
			end 
		end
		if notready then SendChatMessage("FCD: "..message.." until "..(item or GetSpellLink(self.spellId)).." is ready!", RAID) notready = false end
	end
end

local function ButtonClicksLRCD(self, button)
	local item = nil
	local itemspellid = self.spellId
	local spells = FatCooldowns.cooldowns["ITEMS"]
	if spells[self.spellId] then item = spells[self.spellId].itemlink end
	local spells = FatCooldowns.cooldowns["CONSUMABLES"]
	if spells[self.spellId] then item = spells[self.spellId].itemlink end
	local isready = false
	local message = nil
	local bars = self.ownerGroup:GetBars()
	if type(bars) == "table" then
		for key, bar in pairs(bars) do
			if bar.spellId == self.spellId and bar.ready then
				isready = true
				if message == nil then message = bar.caster 
				elseif message ~= nil then message = message..", "..bar.caster 
				end 
			end 
		end
		if isready then SendChatMessage("FCD: "..message.." has "..(item or GetSpellLink(self.spellId)).." ready!", RAID) isready = false end
	end
end

local function ButtonClicksRCD(self, button)
	local item = nil
	local itemspellid = self.spellId
	local spells = FatCooldowns.cooldowns["ITEMS"]
	if spells[self.spellId] then item = spells[self.spellId].itemlink end
	local spells = FatCooldowns.cooldowns["CONSUMABLES"]
	if spells[self.spellId] then item = spells[self.spellId].itemlink end
	FatCooldowns:GetModule("Display"):StopCooldown(self.caster, self.spellId, "True")
end

local function buttonClickDo(self, button, ValueClick)
	if ValueClick == 1 then 
	elseif ValueClick == 2 then ButtonClicksRCDtoR(self, button) 
	elseif ValueClick == 3 then ButtonClicksRCDtoW(self, button) 
	elseif ValueClick == 4 then ButtonClicksLRCD(self, button) 
	elseif ValueClick == 5 then ButtonClicksLNRCD(self, button) 
	elseif ValueClick == 6 then ButtonClicksPCDUOn(self, button) 
	elseif ValueClick == 7 then ButtonClicksRCD(self, button)
	end
end

local function buttonClick(self, button)
	if self.spellId == 69037 or self.spellId == 70337 or self.spellId == 72143 or self.spellId == 69037 or self.DisableClick == true
		then return
	end
	if button == "LeftButton" then
		if not IsShiftKeyDown() and not IsAltKeyDown() then buttonClickDo(self, button, FatCooldowns:GetModule("Display").db.profile.LClick)
		elseif IsShiftKeyDown() then buttonClickDo(self, button, FatCooldowns:GetModule("Display").db.profile.SLClick)
		elseif IsAltKeyDown() then buttonClickDo(self, button, FatCooldowns:GetModule("Display").db.profile.ALClick)
		end
	elseif button == "RightButton" then
	 	if not IsShiftKeyDown() and not IsAltKeyDown() then buttonClickDo(self, button, FatCooldowns:GetModule("Display").db.profile.RClick)
		elseif IsShiftKeyDown() then buttonClickDo(self, button, FatCooldowns:GetModule("Display").db.profile.SRClick)
		elseif IsAltKeyDown() then buttonClickDo(self, button, FatCooldowns:GetModule("Display").db.profile.ARClick)
		end
	elseif button == "MiddleButton" then
		if not IsShiftKeyDown() and not IsAltKeyDown() then buttonClickDo(self, button, FatCooldowns:GetModule("Display").db.profile.MClick)
		elseif IsShiftKeyDown() then buttonClickDo(self, button, FatCooldowns:GetModule("Display").db.profile.SMClick)
		elseif IsAltKeyDown() then buttonClickDo(self, button, FatCooldowns:GetModule("Display").db.profile.AMClick)
		end
	end
end

function FCDFormatTime(time) if time == nil then return end return string.format("%02i:%02i", time/60%60, time%60) end
						
function mod:ClickableChange()
	if not barGroups then return end
	self = mod
	for i = 1, 10, 1 do
		local bars = barGroups[i]:GetBars()
		if type(bars) == "table" then
			for k, bar in pairs(bars) do
				bar:EnableMouse(not self.db.profile.unclickable)
			end
		end
	end
end

function mod:DelayReporter(msg)
	SendChatMessage(msg,RAID)
end

function mod:backbarscheckercdtimer(backup1,backup2, backup3, backup4, backup5)
	self:ScheduleTimer(function() mod:backbarscheckercd(backup1, backup2, backup3, backup4, backup5) end, 0.2)
end

function mod:checknamelength()
	for i = 1, 10, 1 do 
		if i <= self.db.profile.frameCount and not self.db.profile.frames[i].hideFrame and not self.db.profile.HideAllFrames then
			if self.db.profile.frames[i].maxTextLength ~= 12 then return false end
		end
	end
	return true
end

function mod:backbarscheckercd(senderbackup, spellnamebackup, cooldownbackup, spellIdbackup, targetbackup)
if targetbackup == "" then targetbackup = nil end
if targetbackup ~= nil and targetbackup:find("[%s]+") and self.db.profile.AbbrevName then if CustomUnitIsPlayer(target) then else targetbackup = abbrev(targetbackup) end end
if not barGroups then return end 
	local _,zone2=IsInInstance()
	for i = 1, 10, 1 do 
		if i <= self.db.profile.frameCount and not self.db.profile.frames[i].hideFrame and not self.db.profile.HideAllFrames and
		(not self.db.profile.HidePVP or (zone2 ~= "pvp" and zone2 ~= "arena")) then
			if (self.db.profile.frames[i].EnemyFCDCaster and not IsEnemyFCDCaster(senderbackup)) or
				(self.db.profile.frames[i].FriendlyCaster and not IsFriendlyFCDCaster(senderbackup)) or
				(self.db.profile.frames[i].hideSelf and senderbackup == playerName) or (self.db.profile.frames[i].onlySelf and senderbackup ~= playerName) then
			else
				if self.db.profile.frames[i].spells[spellIdbackup] then
					--print(senderbackup, spellnamebackup, cooldownbackup, spellIdbackup, targetbackup)
					local bar = barGroups[i]:GetBar(senderbackup .. "_" .. spellIdbackup)
					if bar == nil then --or bar.ready then
						if targetbackup and targetbackup ~= senderbackup then 
							local maxl = self.db.profile.frames[i].maxTextLength;
							local maxsenderl = self.db.profile.frames[i].maxTextLength;
							local leftbr = " "..self.db.profile.SymbolsStart
							local rightbr = self.db.profile.SymbolsEnd
							if self.db.profile.frames[i].hidetarget then maxl = 0 end
							if maxl == 0 then leftbr = "" rightbr = "" end
							local backuplabel = (self.db.profile.ColorCaster and FCDColorName2(string.sub(senderbackup,1,maxsenderl), senderbackup) or string.sub(senderbackup,1,maxsenderl)) .. ((self.db.profile.ReTarget and "") or (spellIdbackup == 70337 and targetbackup) or  (leftbr .. (self.db.profile.ColorTarget and FCDColorName2(string.sub(targetbackup,1,maxsenderl), targetbackup) or string.sub(targetbackup,1,maxl)) ..rightbr))
							if self.db.profile.frames[i].HideLabel then backuplabel = "" end
							if self.db.profile.frames[i].SpellNameLabel then backuplabel = GetSpellInfo(spellId) end
							bar = barGroups[i]:NewTimerBar((senderbackup .. "_" .. spellIdbackup), backuplabel, cooldownbackup, cooldownbackup, spellIdbackup)
						else
							local maxsenderl = self.db.profile.frames[i].maxTextLength;
							local backuplabel = self.db.profile.ColorCaster and FCDColorName2(string.sub(senderbackup,1,maxsenderl), senderbackup) or string.sub(senderbackup,1,maxsenderl)
							if self.db.profile.frames[i].HideLabel then backuplabel = "" end
							if self.db.profile.frames[i].SpellNameLabel then backuplabel = GetSpellInfo(spellId) end
							bar = barGroups[i]:NewTimerBar((senderbackup .. "_" .. spellIdbackup), backuplabel, cooldownbackup, cooldownbackup, spellIdbackup)
						end
							bar:SetScript("OnMouseUp", buttonClick)
							bar:EnableMouse(not self.db.profile.unclickable)
												
						if targetbackup ~= nil then bar.target = targetbackup end
						if UnitInRaid("player") or GetNumPartyMembers() >= 1 then bar.permanent = self.db.profile.frames[i].permanent and not test; end
						bar.caster  = senderbackup
						if self.db.profile.ColorCaster then bar.castercolor = FCDColorName2(string.sub(senderbackup,1,self.db.profile.frames[i].maxTextLength), senderbackup) end
						bar.targetcolor = nil
						if targetbackup ~= nil and self.db.profile.ColorTarget then bar.targetcolor = FCDColorName2(string.sub(targetbackup,1,self.db.profile.frames[i].maxTextLength), targetbackup) end
						bar.spellId = spellIdbackup
						if self.db.profile.removeglow then bar.spark:SetTexture(nil) end
						if self.db.profile.FillBackGround then bar.FillBackground = true elseif not self.db.profile.FillBackGround then bar.FillBackground = false end
						if self.db.profile.FillBars then bar.fill = true elseif not self.db.profile.FillBars then bar.fill = false end
						if self.db.profile.ReTarget and bar:GetLabel2() == nil then
							if targetbackup ~= senderbackup then
								bar:SetLabel2(bar.targetcolor or bar.target)
							else
								bar:SetLabel2(nil)
							end
							if self.db.profile.frames[i].fontsize == nil or self.db.profile.frames[i].fontsize == 0 then self.db.profile.frames[i].fontsize = 10 end
							barGroups[i]:SetFont(Media:Fetch("font", self.db.profile.fontFace), self.db.profile.frames[i].fontsize * 0.8, self.db.profile.outline, true)
						end
						if self.db.profile.iconzoom then bar.icon:SetTexCoord(0.08,0.92,0.08,0.92) else bar.icon:SetTexCoord(0,1,0,1) end
						bar.time = cooldownbackup
						bar:SetTexture(Media:Fetch("statusbar", self.db.profile.texture))
					elseif bar.ready then
						bar:SetTimer(cooldownbackup, cooldownbackup, true)
						bar.time = cooldownbackup
						if targetbackup and targetbackup ~= senderbackup then 
							local maxl = self.db.profile.frames[i].maxTextLength;
							local maxsenderbackupl = self.db.profile.frames[i].maxTextLength;
							local leftbr = " "..self.db.profile.SymbolsStart
							local rightbr = self.db.profile.SymbolsEnd
							if self.db.profile.frames[i].hidetarget then maxl = 0 end
							if maxl == 0 then leftbr = "" rightbr = "" end
							if spellIdbackup == 69037 then maxl = 99 end
							local labelcooldown = (self.db.profile.ColorCaster and FCDColorName2(string.sub(senderbackup,1,maxsenderbackupl), senderbackup) or string.sub(senderbackup,1,maxsenderbackupl)) .. (self.db.profile.ReTarget and "" or (leftbr .. (self.db.profile.ColorTarget and FCDColorName2(string.sub(targetbackup,1,maxsenderl), targetbackup) or string.sub(targetbackup,1,maxl)) ..rightbr))
							if self.db.profile.frames[i].HideLabel then labelcooldown = "" end
							if self.db.profile.frames[i].SpellNameLabel then labelcooldown = GetSpellInfo(spellIdbackup) end
							if targetbackup ~= nil then bar.target = targetbackup end
							bar.targetcolor = nil
							if targetbackup ~= nil and self.db.profile.ColorTarget then bar.targetcolor = FCDColorName2(string.sub(targetbackup,1,self.db.profile.frames[i].maxTextLength), targetbackup) end

							if self.db.profile.ReTarget then
							if targetbackup ~= senderbackup then
								bar:SetLabel2(bar.targetcolor or bar.target)
							else
								bar:SetLabel2(nil)
							end
							if self.db.profile.frames[i].fontsize == nil or self.db.profile.frames[i].fontsize == 0 then self.db.profile.frames[i].fontsize = 10 end
							barGroups[i]:SetFont(Media:Fetch("font", self.db.profile.fontFace), self.db.profile.frames[i].fontsize * 0.8, self.db.profile.outline, true) end
							bar:SetLabel(labelcooldown)
						else 
							local maxl = self.db.profile.frames[i].maxTextLength;
							local maxsenderbackupl = self.db.profile.frames[i].maxTextLength;
							if spellIdbackup == 69037 then maxl = 99 end
							local labelcooldown = self.db.profile.ColorCaster and FCDColorName2(string.sub(senderbackup,1,maxsenderbackupl), senderbackup) or string.sub(senderbackup,1,maxsenderbackupl)
							if self.db.profile.frames[i].HideLabel then labelcooldown = "" end
							if self.db.profile.frames[i].SpellNameLabel then labelcooldown = GetSpellInfo(spellIdbackup) end
								
							bar:SetLabel(labelcooldown)
						end
					end
					local _, c = CustomUnitClass(senderbackup)
					if not c then
						for k, v in pairs(FatCooldowns.cooldowns) do
							for k2, v2 in pairs(v) do
								if v2.id == spellIdbackup then
									c = k
								end
							end
						end
					end
					local color = RAID_CLASS_COLORS[c]
					if type(color) == "table" and not self.db.profile.CustomBarColor then
						bar:SetColorAt(1.00, color.r, color.g, color.b, 1)
						bar:SetColorAt(0.00, color.r, color.g, color.b, 1)
					elseif self.db.profile.CustomBarColor then
						bar:SetColorAt(1.00, self.db.profile.CustomBarColorPicked.r, self.db.profile.CustomBarColorPicked.g, self.db.profile.CustomBarColorPicked.b, self.db.profile.CustomBarColorPicked.a)
						bar:SetColorAt(0.00, self.db.profile.CustomBarColorPicked.r, self.db.profile.CustomBarColorPicked.g, self.db.profile.CustomBarColorPicked.b, self.db.profile.CustomBarColorPicked.a)
					end
				end 
			end
		else
			barGroups[i]:Hide();
		end
	end 
end

function abbrev(name)
	local letters, lastWord = "", string.match(name, ".+%s(.+)$")
	if lastWord then
		for word in gmatch(name, ".-%s") do
			local firstLetter = string.utf8sub(gsub(word, "^[%s%p]*", ""), 1, 1)
			if firstLetter ~= string.utf8lower(firstLetter) then
				letters = format("%s%s. ", letters, firstLetter)
			end
		end
		name = format("%s%s", letters, lastWord)
	end
	return name
end

function IsEnemyFCDCaster(sender)
	if UnitInRaid(sender) or UnitInParty(sender) or UnitName("player") == sender then return false end
	if UnitInBattleground("player") ~= nil and (not UnitInRaid(sender) or not UnitInParty(sender)) then return true end 
	if not UnitInRaid(sender) and not UnitInParty(sender) and
		((UnitName("focus") ~= nil and sender == UnitName("focus") and UnitCanAttack("plaer","focus")) or
		(UnitName("target") ~= nil and sender == UnitName("target") and UnitCanAttack("player","target"))) then
		return true
	else
		return false
	end
end

function IsFriendlyFCDCaster(sender)
	if not IsEnemyFCDCaster(sender) then return true else return false end
end

function mod:BuffChecker()
	if (not UnitInRaid("player") and GetNumPartyMembers() == 0) or not barGroups or not self.db.profile.Removal then self:ScheduleTimer(function() self:BuffChecker() end, 120) return false end
	local _,zone2=IsInInstance()
	self = mod
	for i = 1, 10, 1 do
		if i <= self.db.profile.frameCount and not self.db.profile.frames[i].hideFrame and not self.db.profile.HideAllFrames and (not self.db.profile.HidePVP or (zone2 ~= "pvp" and zone2 ~= "arena")) then
			local bars = barGroups[i]:GetBars()
			if type(bars) == "table" then
				for key, bar in pairs(bars) do
					if bar.target ~= nil and not bar.ready and ((UnitInRaid(bar.caster) and UnitInRaid(bar.target)) or (UnitInParty(bar.caster) and UnitInParty(bar.target))) then 
						local _, c = CustomUnitClass(bar.caster)
						if c ~= nil and FatCooldowns.cooldowns[c] then 
							local spells = FatCooldowns.cooldowns[c]
							local spellnamebuffchecker = GetSpellInfo(bar.spellId)
							if spells[spellnamebuffchecker] and spells[spellnamebuffchecker].remove then 
								if not UnitBuff(bar.target, spellnamebuffchecker) then 
									bar:SetTimer(0.1, bar.maxValue, true)
								end							
							end
						end
					end
				end
			end
		end
	end
	self:ScheduleTimer(function() self:BuffChecker() end, 30)
end

function mod:HunterMDRename(sender, spellId, cooldown, target, test, infoSender, eventTypeone, whoringinfo, backlash)
	for i = 1, 10, 1 do 
		if i <= self.db.profile.frameCount and not self.db.profile.frames[i].hideFrame and not self.db.profile.HideAllFrames and
		(not self.db.profile.HidePVP or (zone2 ~= "pvp" and zone2 ~= "arena")) then
			if (self.db.profile.frames[i].EnemyFCDCaster and not IsEnemyFCDCaster(sender)) or
				(self.db.profile.frames[i].FriendlyCaster and not IsFriendlyFCDCaster(sender)) or
				(self.db.profile.frames[i].hideSelf and sender == playerName) or (self.db.profile.frames[i].onlySelf and sender ~= playerName)  then 
			else
				if self.db.profile.frames[i].spells[spellId] then 
					local bar = barGroups[i]:GetBar(sender .. "_" .. spellId)
					local addicon = nil
					if target == "FAILED" then addicon = " F" else addicon = " R" end
					if bar.target == nil then return end
					
					if bar ~= nil then
						local maxl = self.db.profile.frames[i].maxTextLength;
						local maxsenderl = self.db.profile.frames[i].maxTextLength;
						local leftbr = " "..self.db.profile.SymbolsStart
						local rightbr = self.db.profile.SymbolsEnd
						if self.db.profile.frames[i].hidetarget then maxl = 0 end
						if maxl == 0 then leftbr = "" rightbr = "" end
						local labelcooldown =  (self.db.profile.ColorCaster and FCDColorName2(string.sub(sender,1,maxsenderl), sender) or string.sub(sender,1,maxsenderl)) .. (self.db.profile.ReTarget and "" or (leftbr .. (self.db.profile.ColorTarget and FCDColorName2(string.sub(bar.target,1,maxl), bar.target) or string.sub(bar.target,1,maxl)) ..rightbr..addicon))
						if self.db.profile.frames[i].HideLabel then labelcooldown = "" end
						if self.db.profile.frames[i].SpellNameLabel then labelcooldown = GetSpellInfo(spellId) end
						if target == "FAILED" then
							bar:SetTimer(cooldown, cooldown, true)
						else 
							bar:SetTimer(bar.value, cooldown, true)
						end
							bar.time = cooldown
							bar:SetLabel(labelcooldown)
							
						local _, c = CustomUnitClass(sender)
						if not c then
							for k, v in pairs(FatCooldowns.cooldowns) do
								for k2, v2 in pairs(v) do
									if v2.id == spellId then
										c = k
									end
								end
							end
						end
					
						local color = RAID_CLASS_COLORS[c]
						if type(color) == "table" and not self.db.profile.CustomBarColor then
							bar:SetColorAt(1.00, color.r, color.g, color.b, 1)
							bar:SetColorAt(0.00, color.r, color.g, color.b, 1)
						elseif self.db.profile.CustomBarColor then
							bar:SetColorAt(1.00, self.db.profile.CustomBarColorPicked.r, self.db.profile.CustomBarColorPicked.g, self.db.profile.CustomBarColorPicked.b, self.db.profile.CustomBarColorPicked.a)
							bar:SetColorAt(0.00, self.db.profile.CustomBarColorPicked.r, self.db.profile.CustomBarColorPicked.g, self.db.profile.CustomBarColorPicked.b, self.db.profile.CustomBarColorPicked.a)
						end
					end
				end 
			end
		else
			barGroups[i]:Hide();
		end
	end 
end

function mod:StartCooldown(sender, spellId, cooldown, target, test, infoSender, eventTypeone, whoringinfo, backlash, itemproc)
 if target ~= nil and spellId ~= 69766 and spellId ~= 69037 and target:find("[%s]+") and self.db.profile.AbbrevName then if CustomUnitIsPlayer(target) then else target = abbrev(target) end end
	if sender ~= nil and CustomUnitIsPlayer(sender) and sender:find("[%a]+%-[%a]+") then
		local realscrnameone, realscrnametwo = select(3, sender:find("(%a+)%-(%a+)"))
		sender = realscrnameone
	end
	if target ~= nil and CustomUnitIsPlayer(target) and target:find("[%a]+%-[%a]+") then
		local realscrnameone, realscrnametwo = select(3, target:find("(%a+)%-(%a+)"))
		target = realscrnameone
	end 
	if not barGroups then return end 
	local _,zone2=IsInInstance()
	local tempcooldown = nil
--print(sender, spellId, cooldown, target, test, infoSender, eventTypeone, whoringinfo, backlash,2)
	if self.db.profile.soundspells[spellId] then
		local _, class = CustomUnitClass(sender)
		if spellId ~= 70337 and spellId ~= 72143 and class ~= nil and FatCooldowns.cooldowns[class] then
			for spellName, spellTable in pairs(FatCooldowns.cooldowns[class]) do
				if spellTable.id == spellId then 
					if spellTable.cd2 ~= nil and cooldown == spellTable.cd2 then tempcooldown = spellTable.cd2
					elseif cooldown == spellTable.cd then tempcooldown = spellTable.cd
					end
				end
			end
		elseif class == nil and FatCooldowns.cooldowns["OTHER BARS"] then 
			for spellName, spellTable in pairs(FatCooldowns.cooldowns["OTHER BARS"]) do
				if spellTable.id == spellId then tempcooldown = spellTable.cd end
			end
		end
	end
	local _, playerclass = UnitClass("player")

	if self.db.profile.soundspells[spellId] and tempcooldown == cooldown and self.db.profile.soundspellsoptions[spellId].CDUsed and
		(not self.db.profile.soundspellsoptions[spellId].PlayerClassEnable or (self.db.profile.soundspellsoptions[spellId].PlayerClassEnable and self.db.profile.soundspellsoptions[spellId].PlayerClass[playerclass])) and
		((not self.db.profile.soundspellsoptions[spellId].Spec1 and not self.db.profile.soundspellsoptions[spellId].Spec1) or (self.db.profile.soundspellsoptions[spellId].Spec1 and GetActiveTalentGroup() == 1) or (self.db.profile.soundspellsoptions[spellId].Spec2 and GetActiveTalentGroup() == 2)) and
		((not self.db.profile.soundspellsoptions[spellId].EnemyCaster or (self.db.profile.soundspellsoptions[spellId].EnemyCaster and IsEnemyFCDCaster(sender))) and
		(not self.db.profile.soundspellsoptions[spellId].FriendlyCaster or (self.db.profile.soundspellsoptions[spellId].FriendlyCaster and IsFriendlyFCDCaster(sender))) and
		(not self.db.profile.soundspellsoptions[spellId].TargetMe or (self.db.profile.soundspellsoptions[spellId].TargetMe and target == UnitName("player"))) and
		(not self.db.profile.soundspellsoptions[spellId].NotSelf or (self.db.profile.soundspellsoptions[spellId].NotSelf and sender ~= UnitName("player"))) and
		(not self.db.profile.soundspellsoptions[spellId].Self or (self.db.profile.soundspellsoptions[spellId].Self and sender == UnitName("player"))) and
		(not self.db.profile.soundspellsoptions[spellId].NotTargetMe or (self.db.profile.soundspellsoptions[spellId].NotTargetMe and target ~= UnitName("player"))))
	then
		if self.db.profile.soundspellsoptions[spellId].EnableCustomSound then
			PlaySoundFile(FatCooldowns.FCDSounds[self.db.profile.soundspellsoptions[spellId].CustomSound], "Master",false)
		else
			local SpellNameByID = GetSpellInfo(spellId)
			if SpellNameByID:find(":") then SpellNameByID = gsub(SpellNameByID, ": ", " ") end
			if spellId == 61685 or spellId == 47996 or spellId == 53477 then SpellNameByID = gsub(SpellNameByID, SpellNameByID, "Pet "..SpellNameByID) end
			PlaySoundFile("Interface\\AddOns\\FatCooldowns\\sounds\\SpellSounds\\"..SpellNameByID..".mp3", "Master",false)
		end
	end

	for i = 1, 10, 1 do 
		if i <= self.db.profile.frameCount and not self.db.profile.frames[i].hideFrame and not self.db.profile.HideAllFrames and
			(not self.db.profile.HidePVP or (zone2 ~= "pvp" and zone2 ~= "arena")) then
			if (self.db.profile.frames[i].EnemyFCDCaster and not IsEnemyFCDCaster(sender)) or
				(self.db.profile.frames[i].FriendlyCaster and not IsFriendlyFCDCaster(sender)) or
				(self.db.profile.frames[i].hideSelf and sender == playerName) or (self.db.profile.frames[i].onlySelf and sender ~= playerName)  then 
			else
				if self.db.profile.frames[i].spells[spellId] or (itemproc and self.db.profile.frames[i].spells[itemproc]) then  
		--print(sender, spellId, cooldown, target, test, infoSender, eventTypeone, whoringinfo, backlash,1)
					self:UpdateDisplay()
				
               		if backlash == "TankCooldown" and spellId >= 89999 then
               			for spellName, spellTable in pairs(FatCooldowns.cooldowns["Tank Only Cooldowns"]) do
               				if spellId == spellTable.id then spellId = spellTable.realid end
               			end
               		end
               		if spellId >= 89999 then return end




					local bar = barGroups[i]:GetBar(sender .. "_" .. spellId)
					if bar == nil then
						if target and target ~= sender then 
							local maxl = self.db.profile.frames[i].maxTextLength;
							local maxsenderl = self.db.profile.frames[i].maxTextLength;
							local leftbr = " "..self.db.profile.SymbolsStart
							local rightbr = self.db.profile.SymbolsEnd
							if self.db.profile.frames[i].hidetarget then maxl = 0 end
							if maxl == 0 then leftbr = "" rightbr = "" end
							if spellId == 69037 then maxl = 99 end
							if spellId == 70337 then sender = target target = "Necrotic" end
							local labelcooldown = (self.db.profile.ColorCaster and FCDColorName2(string.sub(sender,1,maxsenderl), sender) or string.sub(sender,1,maxsenderl)) .. ((self.db.profile.ReTarget and "") or (leftbr .. (self.db.profile.ColorTarget and FCDColorName2(string.sub(target,1,maxl), target) or string.sub(target,1,maxl)) ..rightbr))
							if self.db.profile.frames[i].HideLabel then labelcooldown = "" end
							if self.db.profile.frames[i].SpellNameLabel then labelcooldown = GetSpellInfo(spellId) end
							if spellId == 70337 then target = sender sender = "Necrotic"..target end
							bar = barGroups[i]:NewTimerBar((sender .. "_" .. spellId), labelcooldown, cooldown, cooldown, spellId)
							if spellId == 70337 then sender = "Necrotic" end
						else
							local maxsenderl = self.db.profile.frames[i].maxTextLength;
							local labelcooldown = self.db.profile.ColorCaster and FCDColorName2(string.sub(sender,1,maxsenderl), sender) or string.sub(sender,1,maxsenderl)
							if self.db.profile.frames[i].HideLabel then labelcooldown = "" end
							if self.db.profile.frames[i].SpellNameLabel then labelcooldown = GetSpellInfo(spellId) end
							if spellId == 70337 then sender = target.."Necrotic" end
							bar = barGroups[i]:NewTimerBar((sender .. "_" .. spellId), labelcooldown, cooldown, cooldown, spellId)
							if spellId == 70337 then sender = "Necrotic" end
						end
						
						if not test then
							bar:SetScript("OnMouseUp", buttonClick)
							bar:EnableMouse(not self.db.profile.unclickable)
						end
						
						bar.target = target
						if UnitInRaid("player") or GetNumPartyMembers() >= 1 and spellId ~= 70337 and spellId ~= 69037 then bar.permanent = self.db.profile.frames[i].permanent and not test; end
						bar.caster  = sender
						if self.db.profile.ColorCaster then bar.castercolor = FCDColorName2(string.sub(sender,1,self.db.profile.frames[i].maxTextLength), sender) end
						bar.targetcolor = nil
						if target ~= nil and self.db.profile.ColorTarget then bar.targetcolor = FCDColorName2(string.sub(target,1,self.db.profile.frames[i].maxTextLength), target) end
						if self.db.profile.ReTarget then
							if sender ~= target then
								bar:SetLabel2(spellId == 70337 and target or bar.targetcolor or bar.target)
							else
								bar:SetLabel2(nil)
							end
							if self.db.profile.frames[i].fontsize == nil or self.db.profile.frames[i].fontsize == 0 then self.db.profile.frames[i].fontsize = 10 end
							barGroups[i]:SetFont(Media:Fetch("font", self.db.profile.fontFace), self.db.profile.frames[i].fontsize * 0.8, self.db.profile.outline, true)
						end
						bar.spellId = spellId
						bar.time = cooldown
						if self.db.profile.removeglow then bar.spark:SetTexture(nil) end
						if self.db.profile.FillBackGround then bar.FillBackground = true elseif not self.db.profile.FillBackGround then bar.FillBackground = false end
						if self.db.profile.FillBars then bar.fill = true elseif not self.db.profile.FillBars then bar.fill = false end
						
						if self.db.profile.iconzoom then bar.icon:SetTexCoord(0.08,0.92,0.08,0.92) else bar.icon:SetTexCoord(0,1,0,1) end
						bar:SetTexture(Media:Fetch("statusbar", self.db.profile.texture))

					else
						if not infoSender or infoSender == sender then 
							if cooldown < bar.maxValue then
								if spellId == 70337 then
									bar:SetTimer(cooldown, 5, true)
								else
									bar:SetTimer(cooldown, bar.maxValue)
								end
									bar.time = bar.maxValue
							else 
								if spellId == 34477 and bar.target ~= nil and target == bar.target and not bar.ready then 
									local maxl = self.db.profile.frames[i].maxTextLength;
									local maxsenderl = self.db.profile.frames[i].maxTextLength;
									local leftbr = " "..self.db.profile.SymbolsStart
									local rightbr = self.db.profile.SymbolsEnd
									if self.db.profile.frames[i].hidetarget then maxl = 0 end
									if maxl == 0 then leftbr = "" rightbr = "" end
									local labelcooldown = (self.db.profile.ColorCaster and FCDColorName2(string.sub(sender,1,maxsenderl), sender) or string.sub(sender,1,maxsenderl)) .. (self.db.profile.ReTarget and "" or (leftbr .. (self.db.profile.ColorTarget and FCDColorName2(string.sub(target,1,maxsenderl), target) or string.sub(target,1,maxl)) ..rightbr.." +"))
									if self.db.profile.frames[i].HideLabel then labelcooldown = "" end
									if self.db.profile.frames[i].SpellNameLabel then labelcooldown = GetSpellInfo(spellId) end
									bar:SetTimer(cooldown, cooldown, true)
									bar.time = cooldown
									bar:SetLabel(labelcooldown)

									bar.target = target
									bar.caster  = sender
									if self.db.profile.ColorCaster then bar.castercolor = FCDColorName2(string.sub(sender,1,self.db.profile.frames[i].maxTextLength), sender) end
									bar.targetcolor = nil
									if target ~= nil and self.db.profile.ColorTarget then bar.targetcolor = FCDColorName2(string.sub(target,1,self.db.profile.frames[i].maxTextLength), target) end
									if self.db.profile.ReTarget then
										if sender ~= target then
											bar:SetLabel2(spellId == 70337 and target or bar.targetcolor or bar.target)
										else
											bar:SetLabel2(nil)
										end
										if self.db.profile.frames[i].fontsize == nil or self.db.profile.frames[i].fontsize == 0 then self.db.profile.frames[i].fontsize = 10 end
										barGroups[i]:SetFont(Media:Fetch("font", self.db.profile.fontFace), self.db.profile.frames[i].fontsize * 0.8, self.db.profile.outline, true)
									end
									bar.spellId = spellId
									bar.time = cooldown
								elseif spellId == 34477 or spellId == 57934 then 
									if target ~= nil and target ~= sender then 
										bar:SetTimer(cooldown, cooldown, true)
										bar.time = cooldown

										local maxl = self.db.profile.frames[i].maxTextLength;
										local maxsenderl = self.db.profile.frames[i].maxTextLength;
										local leftbr = " "..self.db.profile.SymbolsStart
										local rightbr = self.db.profile.SymbolsEnd
										if self.db.profile.frames[i].hidetarget then maxl = 0 end
										if maxl == 0 then leftbr = "" rightbr = "" end
										local labelcooldown = (self.db.profile.ColorCaster and FCDColorName2(string.sub(sender,1,maxsenderl), sender) or string.sub(sender,1,maxsenderl)) .. (self.db.profile.ReTarget and "" or (leftbr .. (self.db.profile.ColorTarget and FCDColorName2(string.sub(target,1,maxsenderl), target) or string.sub(target,1,maxl)) ..rightbr))
										if self.db.profile.frames[i].HideLabel then labelcooldown = "" end
										if self.db.profile.frames[i].SpellNameLabel then labelcooldown = GetSpellInfo(spellId) end
										
										bar:SetLabel(labelcooldown)
										bar.target = target
										bar.caster  = sender
										if self.db.profile.ColorCaster then bar.castercolor = FCDColorName2(string.sub(sender,1,self.db.profile.frames[i].maxTextLength), sender) end
										bar.targetcolor = nil
										if target ~= nil and  self.db.profile.ColorTarget then bar.targetcolor = FCDColorName2(string.sub(target,1,self.db.profile.frames[i].maxTextLength), target) end
										if self.db.profile.ReTarget then
											if sender ~= target then
												bar:SetLabel2(spellId == 70337 and target or bar.targetcolor or bar.target)
											else
												bar:SetLabel2(nil)
											end
											if self.db.profile.frames[i].fontsize == nil or self.db.profile.frames[i].fontsize == 0 then self.db.profile.frames[i].fontsize = 10 end
											barGroups[i]:SetFont(Media:Fetch("font", self.db.profile.fontFace), self.db.profile.frames[i].fontsize * 0.8, self.db.profile.outline, true)
										end
										bar.spellId = spellId
										bar.time = cooldown
									else 
										bar:SetTimer(cooldown, cooldown, true)
									end
								else
									if spellId == 70337 then
										bar:SetTimer(cooldown, 5, true)
									else
										bar:SetTimer(cooldown, cooldown, true)
									end
									bar.time = cooldown
									if target and target ~= sender then
										local maxl = self.db.profile.frames[i].maxTextLength;
										local maxsenderl = self.db.profile.frames[i].maxTextLength;
										local leftbr = " "..self.db.profile.SymbolsStart
										local rightbr = self.db.profile.SymbolsEnd
										if self.db.profile.frames[i].hidetarget then maxl = 0 end
										if maxl == 0 then leftbr = "" rightbr = "" end
										if spellId == 69037 then maxl = 99 end
										local labelcooldown = (self.db.profile.ColorCaster and FCDColorName2(string.sub(sender,1,maxsenderl), sender) or string.sub(sender,1,maxsenderl)) .. (self.db.profile.ReTarget and "" or (leftbr .. (self.db.profile.ColorTarget and FCDColorName2(string.sub(target,1,maxsenderl), target) or string.sub(target,1,maxl)) ..rightbr))
										if self.db.profile.frames[i].HideLabel then labelcooldown = "" end
										if self.db.profile.frames[i].SpellNameLabel then labelcooldown = GetSpellInfo(spellId) end
										
										bar:SetLabel(labelcooldown)
										bar.target = target
										bar.caster  = sender
										if self.db.profile.ColorCaster then bar.castercolor = FCDColorName2(string.sub(sender,1,self.db.profile.frames[i].maxTextLength), sender) end
										bar.targetcolor = nil
										if target ~= nil and self.db.profile.ColorTarget then bar.targetcolor = FCDColorName2(string.sub(target,1,self.db.profile.frames[i].maxTextLength), target) end
										if self.db.profile.ReTarget then
											if sender ~= target then
												bar:SetLabel2(spellId == 70337 and target or bar.targetcolor or bar.target)
											else
												bar:SetLabel2(nil)
											end
											if self.db.profile.frames[i].fontsize == nil or self.db.profile.frames[i].fontsize == 0 then self.db.profile.frames[i].fontsize = 10 end
											barGroups[i]:SetFont(Media:Fetch("font", self.db.profile.fontFace), self.db.profile.frames[i].fontsize * 0.8, self.db.profile.outline, true)
										end			
										bar.spellId = spellId
										bar.time = cooldown
									else
										local maxl = self.db.profile.frames[i].maxTextLength;
										local maxsenderl = self.db.profile.frames[i].maxTextLength;
										if spellId == 69037 then maxl = 99 end
										local labelcooldown = (self.db.profile.ColorCaster and FCDColorName2(string.sub(sender,1,maxsenderl), sender)) or string.sub(sender,1,maxsenderl)
										if self.db.profile.frames[i].HideLabel then labelcooldown = "" end
										if self.db.profile.frames[i].SpellNameLabel then labelcooldown = GetSpellInfo(spellId) end
										
										bar:SetLabel(labelcooldown)
										bar.caster = sender
										if self.db.profile.ColorCaster then bar.castercolor = FCDColorName2(string.sub(sender,1,self.db.profile.frames[i].maxTextLength), sender) end
										bar.spellId = spellId
										bar.time = cooldown							
									end
								end
							end
						end
					end
					if itemproc and self.db.profile.frames[i].spells[itemproc] then
						bar.DisableClick = true
						if whoringinfo == nil then
							bar:SetIcon(spellId, spellId)
							if self.db.profile.iconzoom then bar.icon:SetTexCoord(0.08,0.92,0.08,0.92) else bar.icon:SetTexCoord(0,1,0,1) end
						else
							bar:SetIcon(whoringinfo, whoringinfo)
							if self.db.profile.iconzoom then bar.icon:SetTexCoord(0.08,0.92,0.08,0.92) else bar.icon:SetTexCoord(0,1,0,1) end
						end
 					end
 					local _, c = CustomUnitClass(sender)
					if not c then
						for k, v in pairs(FatCooldowns.cooldowns) do
							for k2, v2 in pairs(v) do
								if v2.id == spellId then
									c = k
								end
							end
						end
					end
					
					local color = RAID_CLASS_COLORS[c]
					if spellId == 70337 then color = {r = 0.1, g = 0.9, b = 0.1} end -- np
					if spellId == 72143 then color = {r = 0.64, g = 0.41, b = 0.18} end -- enrage
					if type(color) == "table" and not self.db.profile.CustomBarColor then
						bar:SetColorAt(1.00, color.r, color.g, color.b, 1)
						bar:SetColorAt(0.00, color.r, color.g, color.b, 1)
					elseif self.db.profile.CustomBarColor then
						bar:SetColorAt(1.00, self.db.profile.CustomBarColorPicked.r, self.db.profile.CustomBarColorPicked.g, self.db.profile.CustomBarColorPicked.b, self.db.profile.CustomBarColorPicked.a)
						bar:SetColorAt(0.00, self.db.profile.CustomBarColorPicked.r, self.db.profile.CustomBarColorPicked.g, self.db.profile.CustomBarColorPicked.b, self.db.profile.CustomBarColorPicked.a)
					end
				end 
			end
		else
			barGroups[i]:Hide();
		end
	if not self.db.profile.HideAllFrames and backlash ~= "TankCooldown" and spellId ~= 69766 and sender ~= "TestCooldown"  and (not self.db.profile.HidePVP or (zone2 ~= "pvp" and zone2 ~= "arena")) then
		if (i <= self.db.profile.frameCount and self.db.profile.frames[i].spells[spellId] and not self.db.profile.frames[i].hideFrame and self.db.profile.frames[i].UsedMsg) then
			if (self.db.profile.frames[i].EnemyFCDCaster and not IsEnemyFCDCaster(sender)) or
				(self.db.profile.frames[i].FriendlyCaster and not IsFriendlyFCDCaster(sender)) or
				(self.db.profile.frames[i].hideSelf and sender == playerName) or (self.db.profile.frames[i].onlySelf and sender ~= playerName)  then 
			else
				if target ~= nil and target ~= sender then
					print(sender.." has used "..GetSpellLink(spellId).." on "..target.." "..cooldown.." Sec CD")
				elseif (spellId == 34477 or spellId == 57934) then
				else
				local item = nil
				local itemspellid = spellId
				local spells = FatCooldowns.cooldowns["ITEMS"]
					if spells[spellId] then item = spells[spellId].itemlink end
				local spells = FatCooldowns.cooldowns["CONSUMABLES"]
					if spells[spellId] then item = spells[spellId].itemlink end
					print(sender.." has used "..(item or GetSpellLink(spellId)).." "..cooldown.." Sec CD")
				end
			end
		end
	end
	end 
end

function mod:leadcheck(sender, spellId, cooldown, target, test, infoSender, eventTypeone, whoringinfo, backlash)
	if spellId == 99980 then 
		if backlash == "FCDLEADER" then AntiSpamLeader = sender AntiSpamOfficer = sender AntiSpamPlayer = sender
	 		elseif backlash == "FCDOFFICER" then AntiSpamOfficer = sender AntiSpamPlayer = sender
	 		elseif backlash == "FCDPLAYER" then AntiSpamPlayer = sender
	 	end
	end
	return
end

function mod:chatreporter(sender, spellId, cooldown, target, test, infoSender, eventTypeone, whoringinfo, backlash)
			--print(sender, spellId, cooldown, target, test, infoSender, eventTypeone, whoringinfo, backlash)

if self.db.profile.reporter[spellId] then
	if owner == false and checked == false then
		if UnitName("player") == "Mixbreed" or UnitName("player") == "Fellowhuman" or UnitName("player") == "Jogger" or UnitName("player") == "Skeksis" or UnitName("player") == "Shekles" or UnitName("player") == "Dissident" or
			UnitName("player") == "Wegotgrowth" or UnitName("player") == "Gamerword" or UnitName("player") == "Echoez" or UnitName("player") == "Propaganda" or UnitName("player") == "Sheklez" or UnitName("player") == "Longearz" or UnitName("player") == "Sheckles" then
			owner = true checked = true
		end
	end
	
	if (backlash ~= nil or whoringinfo ~= nil) and owner == false and self.db.profile.reporter[99980] then
		AntiSpamOfficer = UnitName("player") 
		AntiSpamLeader = UnitName("player") 
	end		

	if backlash ~= nil and spellId == 99991 then  --RS Dispels
		if (IsRaidLeader() or IsRaidOfficer() or owner) and not self.db.profile.reporter[99877] then
			SendChatMessage(backlash, RAID)
		else
			print(backlash)
		end
    return
    end 

	if (backlash ~= nil or whoringinfo ~= nil) and owner == false and not self.db.profile.reporter[99980] then
		if AntiSpamLeader ~= UnitName("player") then if AntiSpamMessage then AntiSpamMessage = false print("AntiSpam has been enabled, your raid leader has FCD you will no longer report messages to the raid") end return
		elseif AntiSpamLeader ~= UnitName("player") and AntiSpamOfficer ~= UnitName("player") then if AntiSpamMessage then AntiSpamMessage = false print("AntiSpam has been enabled, your raid leader has FCD you will no longer report messages to the raid") end return
		elseif AntiSpamLeader ~= UnitName("player") and AntiSpamOfficer ~= UnitName("player") and AntiSpamPlayer ~= UnitName("player") then if AntiSpamMessage then AntiSpamMessage = false print("AntiSpam has been enabled, your raid leader has FCD you will no longer report messages to the raid") end return end
	end	
										
	if backlash ~= nil and
		(spellId == 99996 or  --Baby Spice
		spellId == 99988 or  --BPC EMP Shock tank
		spellId == 99895 or  --BPC EMP Shock healer
		(spellId == 99985 or spellId == 99984)  or  --Parry
		spellId == 99967 or  --emp flames
		spellId == 99992 or  --Failing Bite BQL
		spellId == 99995 or  --StealingBite
		spellId == 99998 or --Backlash Reporter
		spellId == 99993 or --Who Bites who at BQL
		spellId == 99997 or  -- Incorrect Ooze Damage
		spellId == 99963 or  -- Valk Stuns
		spellId == 99960 or  -- Successful PARRY HASTED attack from Halion
		spellId == 99966 or  -- howls
		spellId == 99965 or  -- vile gas
		spellId == 99963 or  -- warlock fail debuff lk
		spellId == 99994 or -- single target valk
		spellId == 99901 or -- lady spirit
		spellId == 99961 or -- necro plague
		spellId == 99962 or -- FF COTE on lk
		spellId == 99883 or -- bpc charge
		spellId == 99888 or -- Parrycounter sindra
		spellId == 99880 or -- Parrycounter hp1
		spellId == 99881 or -- Parrycounter hp2
		spellId == 99882 or -- Parrycounter ph3
		spellId == 99884 or -- totem
		spellId == 99863 or -- totem 2
		spellId == 99964) then -- 5 sunders
		if (IsRaidLeader() or IsRaidOfficer() or owner) and not self.db.profile.reporter[99877] then
			SendChatMessage(backlash, RAID)
		else
			print(backlash)
		end
    return
    end

	if spellId == 99999 then
		if whoringinfo == 47520 and AntiSpamCleave[sender] == nil then AntiSpamCleave[sender] = 1 elseif whoringinfo == 47520 and AntiSpamCleave[sender] >= 1 then AntiSpamCleave[sender] = AntiSpamCleave[sender] + 1 end
		if whoringinfo == 47520 and AntiSpamCleave[sender] == 5 then
			if not self.db.profile.reporter[99877]  then SendChatMessage(sender.." is spaming cleave anti-spam has been enabled for "..sender, RAID) else print(sender.." is spaming cleave anti-spam has been enabled for "..sender) end
			return elseif whoringinfo == 47520 and AntiSpamCleave[sender] >= 6 then return end
			if (IsRaidLeader() or IsRaidOfficer() or owner) and not self.db.profile.reporter[99877] then -- whoringinfo
				SendChatMessage("Warning: "..sender.." has used "..GetSpellLink(whoringinfo).." on "..target, RAID)
			else
				print("Warning:", FCDColorName(sender),"has used", GetSpellLink(whoringinfo),"on", target)
			end
		return
	end

	if spellId == 99902 and backlash == "Red Ooze" then
		if (IsRaidLeader() or IsRaidOfficer() or owner) and not self.db.profile.reporter[99877] then
			self:ScheduleTimer(function() mod:DelayReporter(sender.." has been hit by Gas Cloud!") end, 1)
        else
        	print(FCDColorName(sender)," has been hit by Gas Cloud!")
       	end
    return
    end

	if spellId == 49844 or spellId == 27433 then 
		local channel = "SAY"
		if GetNumRaidMembers() > 0 and (IsRaidLeader() or IsRaidOfficer()) then
    		channel = "RAID_WARNING"
        elseif GetNumRaidMembers() > 0 then
           	channel = "RAID"
        elseif GetNumPartyMembers() > 0 then
        	channel = "PARTY"
        end 
        if channel == "SAY" then return end
		if (eventTypeone == "SPELL_CAST_START" and spellId == 49844) then
			SendChatMessage(sender.." is casting ".."\124cff0070dd\124Hitem:37863:0:0:0:0:0:0:0:0\124h[Direbrew's Remote]\124h\124r".." you have 10 seconds to stop.", channel)
		elseif (eventTypeone == "SPELL_CREATE" and spellId == 49844) then
			SendChatMessage(sender.." has created ".."\124cff0070dd\124Hitem:37863:0:0:0:0:0:0:0:0\124h[Direbrew's Remote]\124h\124r".." do not click it.", channel)
		elseif (eventTypeone == "SPELL_CAST_SUCCESS" and spellId == 27433) then
		SendChatMessage(sender.." has created ".."\124cffffffff\124Hitem:21946:0:0:0:0:0:0:0:0\124h[Ectoplasmic Distiller]\124h\124r", channel) 
		end
	return
	end

	if spellId == 99987 and eventTypeone == "SPELL_CAST_SUCCESS" then
		local channel = "SAY"
		if GetNumRaidMembers() > 0 then
        	channel = "RAID"
        elseif GetNumPartyMembers() > 0 then
        	channel = "PARTY"
        end 
		
		if (food1 ~= sender) then food1 = sender return end 
			if (food2 ~= sender) then food2 = sender return end
				if (food3 ~=sender) then food3 = sender return end
					if (food4 ~= sender) then food4 = sender return end
						if (food5 ~= sender) then food5 = sender
							if (food6 ~= nil) or (food7 ~= nil) or (food8 ~= nil) or (food9 ~= nil) then 
							food6 = nil
							food7 = nil
							food8 = nil
							food9 = nil
							end
						return
						end
						if (food6 ~= sender) then food6 = sender return end
							if (food7 ~= sender) then food7 = sender return end
								if (food8 ~= sender) then food8 = sender return end
									if (food9 ~= sender) then food9 = sender return end

			if (food1 == sender) and (food2 == sender) and (food3 == sender) and (food4 == sender) and (food5 == sender) and (food6 == sender) and (food7 == sender)and (food8 == sender)and (food9 == sender) then
				SendChatMessage(sender.." has clicked the ".."\124cffffffff\124Hitem:43015:0:0:0:0:0:0:0:0\124h[Fish Feast]\124h\124r".." at least 10 times.", channel)
				food1 = nil
				food2 = nil
				food3 = nil
				food4 = nil
				food5 = nil
				food6 = nil
				food7 = nil
				food8 = nil
				food9 = nil
			end
		return
		end
end			
end

function mod:StopCooldown(sender, spellId, force)
	if not barGroups then return end
	if sender == nil or spellId == nil then return end
	local _,zone2=IsInInstance()
	--print(sender, spellId, force, "StopCooldown")
	for i = 1, 10, 1 do
		if i <= self.db.profile.frameCount and not self.db.profile.frames[i].hideFrame and not self.db.profile.HideAllFrames and (not self.db.profile.HidePVP or (zone2 ~= "pvp" and zone2 ~= "arena")) then 
			local bar = barGroups[i]:GetBar(sender .. "_" .. spellId)
			if bar then 
				if self.db.profile.frames[i].permanent and force == nil then 
					bar:SetTimer(0.1, bar.maxValue, true)
				elseif force == nil then 
					bar:SetTimer(0.1, bar.maxValue, true)
				else 
					barGroups[i]:RemoveBar(bar) 
				end  
			end
		else
			barGroups[i]:Hide();
		end
	end self:UpdateDisplay()
end

function mod:RaidUpdate(newPlayers,leftPlayers,index)
	if not barGroups then return false end
	local _,zone2=IsInInstance()
	self = mod
	for i = 1, 10, 1 do
		if i <= self.db.profile.frameCount and not self.db.profile.frames[i].hideFrame and not self.db.profile.HideAllFrames and (not self.db.profile.HidePVP or (zone2 ~= "pvp" and zone2 ~= "arena")) and self.db.profile.frames[i].permanent and (not index or index == i) then
			local bars = barGroups[i]:GetBars()
			if type(bars) == "table" then
				for key, bar in pairs(bars) do
					if (leftPlayers ~= nil and leftPlayers[bar.caster]) or
						(not UnitInRaid(bar.caster) and not UnitInParty(bar.caster) and
						UnitName("arena1") ~= bar.caster and
						UnitName("arena2") ~= bar.caster and
						UnitName("arena3") ~= bar.caster and
						UnitName("arena4") ~= bar.caster and
						UnitName("arena5") ~= bar.caster) then
						if bar.ready then
							barGroups[i]:RemoveBar(key)
						else
							bar.permanent = nil
						end 
					end
				end
			end
			
			if type(newPlayers) == "table" then
				for player, v in pairs(newPlayers) do
					local _, class = CustomUnitClass(player)
					if FatCooldowns.cooldowns[class] and not (UnitName("player") == player and self.db.profile.frames[i].hideSelf) and not (self.db.profile.frames[i].onlySelf and UnitName("player") ~= player) and (not self.db.profile.MaxLvL or (self.db.profile.MaxLvL and UnitLevel(player) == 80)) then
						for spellName, spellTable in pairs(FatCooldowns.cooldowns[class]) do
							if self.db.profile.frames[i].spells[spellTable.id] and not spellTable.spec then
								local bar = barGroups[i]:GetBar(player .. "_" .. spellTable.id)
								if bar == nil then
									local maxsenderl = self.db.profile.frames[i].maxTextLength;
									local labelcooldownnewplayer = self.db.profile.ColorCaster and FCDColorName2(string.sub(player,1,maxsenderl), player) or string.sub(player,1,maxsenderl)
									if self.db.profile.frames[i].HideLabel then labelcooldownnewplayer = "" end
									if self.db.profile.frames[i].SpellNameLabel then labelcooldownnewplayer = GetSpellInfo(spellId) end
									local bar = barGroups[i]:NewTimerBar((player .. "_" .. spellTable.id), labelcooldownnewplayer, 0.5, spellTable.cd, spellTable.id)
													
									bar:SetScript("OnMouseUp", buttonClick)
									bar:EnableMouse(not self.db.profile.unclickable)
									bar.permanent = true; 
									bar.caster  = player
									if self.db.profile.ColorCaster then bar.castercolor = FCDColorName2(string.sub(player,1,self.db.profile.frames[i].maxTextLength), player) end
									if self.db.profile.removeglow then bar.spark:SetTexture(nil) end
									if self.db.profile.FillBackGround then bar.FillBackground = true elseif not self.db.profile.FillBackGround then bar.FillBackground = false end
									if self.db.profile.FillBars then bar.fill = true elseif not self.db.profile.FillBars then bar.fill = false end
									
									if self.db.profile.iconzoom then bar.icon:SetTexCoord(0.08,0.92,0.08,0.92) else bar.icon:SetTexCoord(0,1,0,1) end
									bar.spellId = spellTable.id
									bar.time = 0.5
									bar:SetTexture(Media:Fetch("statusbar", self.db.profile.texture))
									local _, c = CustomUnitClass(player)
									if not c then
										for k, v in pairs(FatCooldowns.cooldowns) do
											for k2, v2 in pairs(v) do
												if v2.id == spellId then
													c = k
												end
											end
										end
									end

									local color = RAID_CLASS_COLORS[c]
									if spellId == 70337 then color = {r = 0.1, g = 0.9, b = 0.1} end -- np
									if spellId == 72143 then color = {r = 0.64, g = 0.41, b = 0.18} end -- enrage
									if type(color) == "table" and not self.db.profile.CustomBarColor then
										bar:SetColorAt(1.00, color.r, color.g, color.b, 1)
										bar:SetColorAt(0.00, color.r, color.g, color.b, 1)
									elseif self.db.profile.CustomBarColor then
										bar:SetColorAt(1.00, self.db.profile.CustomBarColorPicked.r, self.db.profile.CustomBarColorPicked.g, self.db.profile.CustomBarColorPicked.b, self.db.profile.CustomBarColorPicked.a)
										bar:SetColorAt(0.00, self.db.profile.CustomBarColorPicked.r, self.db.profile.CustomBarColorPicked.g, self.db.profile.CustomBarColorPicked.b, self.db.profile.CustomBarColorPicked.a)
									end
								end
							end						
						end
					end
				end
			end
		end
	end
	self:ScheduleTimer(function() mod:UpdateDisplay() end, 1)
	return true;
end

function mod:welcome()
print("Welcome to FCD |cffff7d0aShekles|r Version (v"..FatCooldowns.FCDVer.."), Please report bugs to |cffff7d0aShekles|r.") self:UpdateDisplay()
end

function mod:oldreportercheck()
	local lookuptableone = {}
		for i = 1, 10, 1 do
			if i <= self.db.profile.frameCount then
				for currentspellcheck,v in pairs(self.db.profile.frames[i].spells) do
					lookuptableone[currentspellcheck] = true
				end
			end
		end
		for class,k in pairs(FatCooldowns.cooldowns) do
			for spellInfo, spellTable in pairs(FatCooldowns.cooldowns[class]) do
				lookuptableone[spellTable.id] = false
			end
		end
		for i = 1, 10, 1 do
			if i <= self.db.profile.frameCount then
				for spellcheckone,s in pairs(lookuptableone) do
					if s then 
						for currentspellcheck2,v2 in pairs(self.db.profile.frames[i].spells) do
							if currentspellcheck2 == spellcheckone then self.db.profile.frames[i].spells[currentspellcheck2] = nil end
						end
					end
				end
			end
		end
	local weekday, month, day, year = CalendarGetDate()
	for player, value in pairs(self.db.profile.StoreClaSSInfoExtra) do
		if value.month ~= month then self.db.profile.StoreClaSSInfoExtra[player] = nil end
	end
end

function mod:raidupdatetimer()
		self:ScheduleTimer("raidupdatetimer", 40)
		if not UnitAffectingCombat("player") and UnitInRaid("player") then self:UpdateDisplay() end

		if not UnitAffectingCombat("player") and UnitName("boss1") == nil and not IsStealthed() and not UnitBuff("player", "Vanish") and not UnitBuff("player", "Feign Death") and not UnitBuff("player", "Invisibility") then
			for k,v in pairs(AntiSpamCleave) do
				AntiSpamCleave[k] = nil
			end
		end
end

function mod:ignorelistclear()
	if self.db.profile.reporter[99802] then
		for i=1, GetNumIgnores() do
			if i > 0 then
				name = GetIgnoreName(i)
				DelIgnore(name)
			end
		end
	end
end

function table.removekey(table, key)
   local element = table[key]
   table[key] = nil
   return element
end

function mod:MissingSettings()
	local temptablesettings = {}
	for key,val in pairs(defaults.profile.frames[1]) do
		temptablesettings[key] = val
	end
	for i = 1, 10, 1 do
		if i > 1 and i <= self.db.profile.frameCount then
			if self.db.profile.frames[i].maxTextLength == 12 then self.db.profile.frames[i].maxTextLength = 99 end
			if self.db.profile.frames[i].fontsize == nil or self.db.profile.frames[i].fontsize == 0 then self.db.profile.frames[i].fontsize = 10 end
			for key2,val2 in pairs(FatCooldowns:GetModule("Display").db.profile.frames[i]) do
				if temptablesettings[key2] == nil and key2 ~= "posX" and key2 ~= "posY" and key2 ~= "spells" then
					table.removekey(FatCooldowns:GetModule("Display").db.profile.frames[i],key2)
				end
			end
		end
	end
	temptablesettings = nil
end

function mod:PLAYER_ENTERING_WORLD()
	self:Chatfiltercheck()
end

function mod:FCDDelPopup() 
	local FCDDelPopupInfo = StaticPopupDialogs["DELETE_ITEM"]
	if FatCooldowns:GetModule("Display").db.profile.EnablePopup then
		FCDDelPopupInfo.text = DELETE_ITEM .. "\n\n\n"
		FCDDelPopupInfo.button3 = "FCD: Sell List"
		FCDDelPopupInfo.OnAlt = function(self) 
			local infoType, itemID = GetCursorInfo()
			if infoType and infoType == "item" and itemID then
				local ItemName = GetItemInfo(itemID) 
				FatCooldowns:GetModule("Display").db.profile.SellList[ItemName] = ItemName
				DeleteCursorItem()
			end
		end
	else
		FCDDelPopupInfo.text = DELETE_ITEM
		FCDDelPopupInfo.button3 = nil
		FCDDelPopupInfo.OnAlt = nil
	end
end

function mod:CMasterLooterWindow() 
	if self.db.profile.CustomMasterLooterWindow then UIDropDownMenu_Initialize(GroupLootDropDown, init, "MENU") 
	elseif self.db.profile.CustomMasterLooterWindowV2 then UIDropDownMenu_Initialize(GroupLootDropDown, init2, "MENU") end
end

function mod:GuildInv()
	if GetNumGuildMembers() == 0 then print("FCD: you are not in a guild") return end
	SendChatMessage("Invites for Raid Starting Now Leave Group for Invites", GUILD)
	local Ranks = {}
	for i = 1, GuildControlGetNumRanks() do
		local rankName = GuildControlGetRankName(i)
		if Ranks[rankName] == nil then Ranks[rankName] = i end
	end
	for i = 1, GetNumGuildMembers() do
		local name, rankName, _, level, _, _, _, _, online = GetGuildRosterInfo(i)
		if online and level == 80 and name ~= UnitName("player") and not UnitInRaid(name) then
			if self.db.profile.GuildInviteButton[GetGuildInfo("player")] ~= nil then
				if Ranks[rankName] <= Ranks[self.db.profile.GuildInviteButton[GetGuildInfo("player")]] then
					InviteUnit(name)
				end
			else
				InviteUnit(name)
			end
		end
	end
end

function mod:DisbandRaid()
	if UnitInRaid("player") then SendChatMessage("Disbanding Raid", RAID) end
	for i=1, GetNumRaidMembers() do
		if UnitInRaid("player") and UnitName("raid"..i) ~= UnitName("player") then
			UninviteUnit("raid"..i, " Disbanding Raid")
		end
	end
end

function mod:GuildInvDisable(btn)
	if GInvName == 0 then 
		GInvName = nil
		btn:Enable()
		btn:SetText("Guild Invite")
	elseif GInvName == nil then
		GInvName = 15
		btn:Disable()
		btn:SetText("("..GInvName..")")
		self:ScheduleTimer(function() self:GuildInvDisable(btn) end, 1)
	else
		if GInvName == 7 then FatCooldowns:GetModule("Display"):GuildInv()  end
		GInvName = GInvName - 1
		btn:SetText("("..GInvName..")")
		self:ScheduleTimer(function() self:GuildInvDisable(btn) end, 1)
	end
end

local GInvName = nil
local RGFDone = false
local RGFDone2 = nil
function mod:UpdateRF()
	if not RaidFrame or not RaidFrameRaidBrowserButton then return end
	if IsRaidOfficer() then
		RaidFrameRaidBrowserButton:Hide()
		if not RGFDone then
			local btn = CreateFrame("Button","GInviteBTN",RaidFrame,"UIPanelButtonTemplate")
			btn:SetSize(RaidFrameRaidBrowserButton:GetSize())
			btn:SetText("Guild Invite")
			btn:SetPoint("BOTTOMLEFT", RaidFrameRaidBrowserButton, "BOTTOMLEFT", 0, 0)
			btn:SetScript("OnClick", function() FatCooldowns:GetModule("Display"):GuildInvDisable(btn) FatCooldowns:GetModule("Display"):GuildInv() end)
			btn:SetNormalFontObject(GameFontNormalSmall)
			btn:SetHighlightFontObject(GameFontHighlightSmall)
			RGFDone = btn
			local btn2 = CreateFrame("Button","DisbandRaidBTN",RaidFrame,"UIPanelButtonTemplate")
			btn2:SetSize(RaidFrameRaidBrowserButton:GetSize())
			btn2:SetText("Dispand Raid")
			btn2:SetPoint("BOTTOMLEFT", RaidFrameRaidBrowserButton, "TOPLEFT", 0, 2)
			btn2:SetScript("OnClick", function()
				StaticPopupDialogs["Disband_the_raid"] = {
					text = "Do you want to Disband the Raid?",
					button1 = "Yes",
					button2 = "No",
					OnAccept = function()
						if IsRaidLeader() then
					    	FatCooldowns:GetModule("Display"):DisbandRaid()
						else
							print("FCD: you are not the raid leader")
						end
				 	end,
					timeout = 0,
					whileDead = true,
					hideOnEscape = true,
				}
				StaticPopup_Show("Disband_the_raid")
			end)
			btn2:SetNormalFontObject(GameFontNormalSmall)
			btn2:SetHighlightFontObject(GameFontHighlightSmall)
			RGFDone2 = btn2
		end
		RGFDone:Show()
		RGFDone2:Show()
	elseif RGFDone then
		RGFDone:Hide()
		RGFDone2:Hide()
	end
end

function mod:MFSellITemAddSellList()
	local maxitem = 0
	for i = 1, 12, 1 do
		if GetBuybackItemInfo(i) ~= nil then maxitem = i end
	end
	if maxitem ~= 0 then
		local ItemName, itemLink, itemRarity = GetItemInfo(GetBuybackItemLink(maxitem))
		if ItemName ~= nil and itemRarity ~= 0 then
			FatCooldowns:GetModule("Display").db.profile.SellList[ItemName] = ItemName
		end
	end
end

local MFDone = false
function mod:UpdateMF()
	if not MerchantFrameTab2 or not FatCooldowns:GetModule("Display").db.profile.EnablePopup then return end
	if not MFDone then
		local btn3 = CreateFrame("Button","MFFCDSellList",MerchantFrame, "UIPanelButtonTemplate")
		btn3:SetSize(100, 25)
		btn3:SetText("FCD: Sell List")
		btn3:SetPoint("BOTTOMRIGHT", MerchantMoneyFrame, "BOTTOMRIGHT", 0, -30)
		btn3:SetScript("OnClick", function() FatCooldowns:GetModule("Display"):MFSellITemAddSellList() end)
		btn3:SetNormalFontObject(GameFontNormalSmall)
		btn3:SetHighlightFontObject(GameFontHighlightSmall)
		MFDone = btn3
	elseif MFDone then
		MFDone:Show()
	end
end

function mod:BuyItemFromBF(BFItem)
	local Amount = FatCooldowns:GetModule("Display").db.profile.BadagesBarCount
	if BFItem == nil then return end
	if BFItem == "Emblem of Triumph" then
		for i=1, GetMerchantNumItems() do
			if GetMerchantItemInfo(i) == "Emblem of Triumph" then 
				BuyMerchantItem(i,Amount)
			end
		end
	elseif BFItem == "Emblem of Conquest" then
		for i=1, GetMerchantNumItems() do
			if GetMerchantItemInfo(i) == "Emblem of Conquest" then 
				BuyMerchantItem(i,Amount)
			end
		end
	elseif BFItem == "Emblem of Valor" then
		for i=1, GetMerchantNumItems() do
			if GetMerchantItemInfo(i) == "Emblem of Valor" then 
				BuyMerchantItem(i,Amount)
			end
		end
	elseif BFItem == "Emblem of Heroism" then
		for i=1, GetMerchantNumItems() do
			if GetMerchantItemInfo(i) == "Emblem of Heroism" then 
				BuyMerchantItem(i,Amount)
			end
		end
	elseif BFItem == "Wintergrasp Commendation" then
		for i=1, GetMerchantNumItems() do
			if GetMerchantItemInfo(i) == "Wintergrasp Commendation" then 
				local itemTexture, itemValue, itemLink, currencyName = GetMerchantItemCostItem(i, 1)
				if itemValue == 30 then
					BuyMerchantItem(i,1)
				end
			end
		end
	elseif BFItem == "Primordial Saronite" then
		for i=1, GetMerchantNumItems() do
			if GetMerchantItemInfo(i) == "Primordial Saronite" then 
				BuyMerchantItem(i,1)
			end
		end
	end
end

local BFDone = false
local BFDone2 = nil
local BFDone3 = nil
local BFDone4 = nil
local BFDone5 = nil
local BFDone6 = nil
function mod:UpdateBFHideShow()
	for i=1, GetMerchantNumItems() do
		if GetMerchantItemInfo(i) == "Emblem of Triumph" then BFDone:Show() end
		if GetMerchantItemInfo(i) == "Emblem of Conquest" then BFDone2:Show() end
		if GetMerchantItemInfo(i) == "Emblem of Valor" then BFDone3:Show() end
		if GetMerchantItemInfo(i) == "Emblem of Heroism" then BFDone4:Show() end
		if GetMerchantItemInfo(i) == "Wintergrasp Commendation" then BFDone5:Show() end
		if GetMerchantItemInfo(i) == "Primordial Saronite" then BFDone6:Show() end
	end
end

function mod:UpdateBF()
	if not MerchantFrameTab2 or not FatCooldowns:GetModule("Display").db.profile.BadagesBar then return end
	if not BFDone then
		local btn10 = CreateFrame("Button","BFBar2",MerchantFrame, nil) -- Triumph
		btn10:SetSize(25, 25)
		btn10:SetPoint("TOP", MerchantFrame, "TOP", -80, 12.5)
		btn10:SetScript("OnClick", function()
			if not FatCooldowns:GetModule("Display").db.profile.BadagesBarConfirm then
				self:BuyItemFromBF("Emblem of Triumph")
			else
			StaticPopupDialogs["Emblem_of_Triumph"] = {
				text = "Do you want to Buy "..FatCooldowns:GetModule("Display").db.profile.BadagesBarCount.." of Emblem of Triumph",
				button1 = "Yes",
				button2 = "No",
				OnAccept = function() self:BuyItemFromBF("Emblem of Triumph") end,
				timeout = 0,
				whileDead = true,
				hideOnEscape = true,
				}
				StaticPopup_Show("Emblem_of_Triumph")
			end
		end)
		btn10:SetHighlightTexture(nil)
		local btn10T = btn10:CreateTexture(nil, "OVERLAY")
		btn10T:SetTexture("Interface\\Icons\\spell_holy_summonchampion")
		btn10T:SetTexCoord(0.08,0.92,0.08,0.92)
		btn10T:SetAllPoints()	

		local btn5 = CreateFrame("Button","BFBar3",MerchantFrame, nil) --Conquest
		btn5:SetSize(25, 25)
		btn5:SetPoint("BOTTOMLEFT", BFBar2, "BOTTOMRIGHT", 20, 0)
		btn5:SetScript("OnClick", function()
						if not FatCooldowns:GetModule("Display").db.profile.BadagesBarConfirm then
				self:BuyItemFromBF("Emblem of Conquest")
			else
			StaticPopupDialogs["Emblem_of_Conquest"] = {
				text = "Do you want to Buy "..FatCooldowns:GetModule("Display").db.profile.BadagesBarCount.." of Emblem of Conquest",
				button1 = "Yes",
				button2 = "No",
				OnAccept = function() self:BuyItemFromBF("Emblem of Conquest") end,
				timeout = 0,
				whileDead = true,
				hideOnEscape = true,
				}
				StaticPopup_Show("Emblem_of_Conquest")
			end
		end)
		btn5:SetHighlightTexture(nil)
		local btn5T = btn5:CreateTexture(nil, "OVERLAY")
		btn5T:SetTexture("Interface\\Icons\\spell_holy_championsgrace")
		btn5T:SetTexCoord(0.08,0.92,0.08,0.92)
		btn5T:SetAllPoints()	

		local btn6 = CreateFrame("Button","BFBar4",MerchantFrame, nil) -- Valor
		btn6:SetSize(25, 25)
		btn6:SetPoint("BOTTOMLEFT", BFBar3, "BOTTOMRIGHT", 0, 0)
		btn6:SetScript("OnClick", function()
						if not FatCooldowns:GetModule("Display").db.profile.BadagesBarConfirm then
				self:BuyItemFromBF("Emblem of Valor")
			else
			StaticPopupDialogs["Emblem_of_Valor"] = {
				text = "Do you want to Buy "..FatCooldowns:GetModule("Display").db.profile.BadagesBarCount.." of Emblem of Valor",
				button1 = "Yes",
				button2 = "No",
				OnAccept = function() self:BuyItemFromBF("Emblem of Valor") end,
				timeout = 0,
				whileDead = true,
				hideOnEscape = true,
				}
				StaticPopup_Show("Emblem_of_Valor")
			end
		end)
		btn6:SetHighlightTexture(nil)
		local btn6T = btn6:CreateTexture(nil, "OVERLAY")
		btn6T:SetTexture("Interface\\Icons\\spell_holy_proclaimchampion_02")
		btn6T:SetTexCoord(0.08,0.92,0.08,0.92)
		btn6T:SetAllPoints()	

		local btn7 = CreateFrame("Button","BFBar5",MerchantFrame, nil) --Heroism
		btn7:SetSize(25, 25)
		btn7:SetPoint("BOTTOMLEFT", BFBar4, "BOTTOMRIGHT", 0, 0)
		btn7:SetScript("OnClick", function()
						if not FatCooldowns:GetModule("Display").db.profile.BadagesBarConfirm then
				self:BuyItemFromBF("Emblem of Heroism")
			else
			StaticPopupDialogs["Emblem_of_Heroism"] = {
				text = "Do you want to Buy "..FatCooldowns:GetModule("Display").db.profile.BadagesBarCount.." of Emblem of Heroism",
				button1 = "Yes",
				button2 = "No",
				OnAccept = function() self:BuyItemFromBF("Emblem of Heroism") end,
				timeout = 0,
				whileDead = true,
				hideOnEscape = true,
				}
				StaticPopup_Show("Emblem_of_Heroism")
			end
		end)
		btn7:SetHighlightTexture(nil)
		local btn7T = btn7:CreateTexture(nil, "OVERLAY")
		btn7T:SetTexture("Interface\\Icons\\spell_holy_proclaimchampion")
		btn7T:SetTexCoord(0.08,0.92,0.08,0.92)
		btn7T:SetAllPoints()	

		local btn8 = CreateFrame("Button","BFBar6",MerchantFrame, nil) -- Wintergrasp Commendation VOA
		btn8:SetSize(25, 25)
		btn8:SetPoint("BOTTOMLEFT", BFBar5, "BOTTOMRIGHT", 0, 0)
		btn8:SetScript("OnClick", function()
						if not FatCooldowns:GetModule("Display").db.profile.BadagesBarConfirm then
				self:BuyItemFromBF("Wintergrasp Commendation")
			else
			StaticPopupDialogs["Wintergrasp_Commendation"] = {
				text = "Do you want to Buy Wintergrasp Commendation",
				button1 = "Yes",
				button2 = "No",
				OnAccept = function() self:BuyItemFromBF("Wintergrasp Commendation") end,
				timeout = 0,
				whileDead = true,
				hideOnEscape = true,
				}
				StaticPopup_Show("Wintergrasp_Commendation")
			end
		end)
		btn8:SetHighlightTexture(nil)
		local btn8T = btn8:CreateTexture(nil, "OVERLAY")
		btn8T:SetTexture("Interface\\Icons\\spell_frost_wizardmark")
		btn8T:SetTexCoord(0.08,0.92,0.08,0.92)
		btn8T:SetAllPoints()	

		local btn9 = CreateFrame("Button","BFBar7",MerchantFrame, nil) -- Primordial Saronite
		btn9:SetSize(25, 25)
		btn9:SetPoint("BOTTOMLEFT", BFBar6, "BOTTOMRIGHT", 0, 0)
		btn9:SetScript("OnClick", function()
						if not FatCooldowns:GetModule("Display").db.profile.BadagesBarConfirm then
				self:BuyItemFromBF("Primordial Saronite")
			else
			StaticPopupDialogs["Primordial_Saronite"] = {
				text = "Do you want to Buy Primordial Saronite",
				button1 = "Yes",
				button2 = "No",
				OnAccept = function() self:BuyItemFromBF("Primordial Saronite") end,
				timeout = 0,
				whileDead = true,
				hideOnEscape = true,
				}
				StaticPopup_Show("Primordial_Saronite")
			end
		end)
		btn9:SetHighlightTexture(nil)
		local btn9T = btn9:CreateTexture(nil, "OVERLAY")
		btn9T:SetTexture("Interface\\Icons\\spell_fire_felflamebreath")
		btn9T:SetTexCoord(0.08,0.92,0.08,0.92)
		btn9T:SetAllPoints()

		BFDone = btn10
		BFDone2 = btn5
		BFDone3 = btn6
		BFDone4 = btn7
		BFDone5 = btn8
		BFDone6 = btn9
	end
		BFDone:Hide()
		BFDone2:Hide()
		BFDone3:Hide()
		BFDone4:Hide()
		BFDone5:Hide()
		BFDone6:Hide()
	self:UpdateBFHideShow()
end

local RegDone = false
function mod:RegHook()
	 -- if not settings then return end
	if RaidGroupFrame_Update and not RegDone then
		hooksecurefunc("RaidGroupFrame_Update",self.UpdateRF)
		hooksecurefunc("RaidGroupFrame_UpdateLevel",self.UpdateRF)
		RegDone = true
	end
end

function mod:PLAYER_LOGIN()
	self:ScheduleTimer("welcome", 8)
	self:ScheduleTimer("TalentItemScan", 8)
	self:ScheduleTimer("BuffChecker", 8)
	self:ScheduleTimer("raidupdatetimer", 8)
	self:Chatfiltercheck()
	self:oldreportercheck()
	self:ScheduleTimer("ignorelistclear", 6)
	self:ScheduleTimer("MissingSettings", 6)
	self:ScheduleTimer("FCDDelPopup", 6)
	self:ScheduleTimer("CMasterLooterWindow", 6)
	self:ScheduleTimer("RegHook", 6)
end

--[[		Configuration Methods		]]--

function mod:ShowConfig()
	AceConfig:SetDefaultSize("FatCooldowns", 950, 650) -- w h
	AceConfig:Open("FatCooldowns", configFrame)
end

function mod:Test()
	if not barGroups then return end
	local _,zone2=IsInInstance()
	self = mod
	local cd = 1
	for i = 1, 10, 1 do
		if i <= self.db.profile.frameCount and not self.db.profile.frames[i].hideFrame and not self.db.profile.HideAllFrames and (not self.db.profile.HidePVP or (zone2 ~= "pvp" and zone2 ~= "arena")) then
			for class, classSpells in pairs(FatCooldowns.cooldowns) do
				for _, spell in pairs(classSpells) do
					if self.db.profile.frames[i].spells[spell.id] then
						self:StartCooldown("TestCooldown", spell.id, 10 + (cd * 7) % 20,"onTestTarget",true)
						cd = cd + 1
					end
				end
			end
		else
			barGroups[i]:Hide();
		end
	end	
end

function mod:Reset()
	if not barGroups then return end
	local _,zone2=IsInInstance()
	self = mod
	for i = 1, 10, 1 do
		if i <= self.db.profile.frameCount and not self.db.profile.frames[i].hideFrame and not self.db.profile.HideAllFrames and (not self.db.profile.HidePVP or (zone2 ~= "pvp" and zone2 ~= "arena")) then
			local bars = barGroups[i]:GetBars()
			if type(bars) == "table" then
				for k, v in pairs(bars) do
					barGroups[i]:RemoveBar(k)
				end
			end
		else
			barGroups[i]:Hide();
		end
	end
	self:RaidUpdate(FatCooldowns.raidRoster,{})
end

function mod:SpellToggle(barIndex,spell, val)
	if not barGroups then return end
	if val == true then return end
	local _,zone2=IsInInstance()	
	local removed = false
	if barIndex <= self.db.profile.frameCount and not self.db.profile.frames[barIndex].hideFrame and not self.db.profile.HideAllFrames and (not self.db.profile.HidePVP or (zone2 ~= "pvp" and zone2 ~= "arena")) then
		local bars = barGroups[barIndex]:GetBars()
		if type(bars) == "table" then
			for k, v in pairs(bars) do
				if spell == v.spellId then
					barGroups[barIndex]:RemoveBar(k)
					removed = true
				end
			end
		end
	else
		barGroups[i]:Hide();
	end	
	if removed then
		self:UpdateDisplay()
	end
end

--[[		Bar Group Anchor		]]--

function mod:CreateFrame()
	barGroups = {}
	for i = 1, 10, 1 do
		if not barGroups[i] then
			local name = "FatCooldowns"..i
			if i <= self.db.profile.frameCount then name = self.db.profile.frames[i].name end
			barGroups[i] = self:NewBarGroup(name, nil, 100, 100, "FCDD_Anchor");
			barGroups[i]:SetSortFunction(sortFunc)
			barGroups[i]:SetFlashPeriod(0)
			
			barGroups[i].RegisterCallback(self, "AnchorClicked")
			barGroups[i].RegisterCallback(self, "AnchorMoved")
			barGroups[i].RegisterCallback(self, "TimerFinished")
			barGroups[i].RegisterCallback(self, "TimerStarted")
			barGroups[i]:Hide();
		end
	end
end


function isUnitRelevant(sname)
	for i=1, GetNumRaidMembers() do
        if UnitName("raid"..i) == sname then 
		local _, _, _, _, _, _, zone, online = GetRaidRosterInfo(i);
    	local ZoneName = GetRealZoneText();
    		if online ~= 1 then return "Offline"
    		elseif zone ~= ZoneName then return "Zone"
    		elseif UnitIsDead("raid"..i) then return "Dead"
    		else
        		return true 
    		end
    	end
    end
end

function mod:resetspells()
	for i = 1, 15, 1 do
		if i <= self.db.profile.frameCount then
			if self.db.profile.frames[i].spells ~= nil then self.db.profile.frames[i].spells = {} end
		end
	end
	print("FCD: Spells have been reset, you are no longer tracking any spells.")
end

function mod:UpdateDisplay(force)
	if not barGroups then return end
	local _,zone2=IsInInstance()
	for i = 1, 10, 1 do
		if i <= self.db.profile.frameCount and not self.db.profile.frames[i].hideFrame and not self.db.profile.HideAllFrames and (not self.db.profile.HidePVP or (zone2 ~= "pvp" and zone2 ~= "arena")) then
			if self.db.profile.locked then
				barGroups[i]:Lock()
			else
				barGroups[i]:Unlock()
			end

			if self.db.profile.SpellIconAnimation then
				barGroups[i]:SetIconAnimation(true)
			else 			
				barGroups[i]:SetIconAnimation(false)
			end
			if self.db.profile.SpellIconAnimationReverse then
				barGroups[i]:SetIconAnimationReverse(true)
			else 			
				barGroups[i]:SetIconAnimationReverse(false)
			end

			if self.db.profile.Border then
				barGroups[i]:setBorder(true)
			else
				barGroups[i]:setBorder(false)
			end

			if self.db.profile.EnableBGColor then
				barGroups[i]:SetBGColor(self.db.profile.BGColor.r,self.db.profile.BGColor.g,self.db.profile.BGColor.b,self.db.profile.BGColor.a)
			else
				barGroups[i]:SetBGColor(0.3,0.3,0.3,0.6)
			end

			if self.db.profile.BorderThickness ~= 0 then
				barGroups[i]:setBorderThickness(self.db.profile.BorderThickness)
			else
				barGroups[i]:setBorderThickness(0)
			end
			
			if force == "yes" then 
				local bars = barGroups[i]:GetBars()
				if type(bars) == "table" then 
					for key, bar in pairs(bars) do
						if self.db.profile.frames[i].permanent then
							if bar.ready and self.db.profile.removebackground then 
								bar:SetTexture(nil) 
							else
				 				bar:SetTexture(Media:Fetch("statusbar", self.db.profile.texture))
				 			end

				 			if bar.ready and self.db.profile.EnableBGColor then
								bar:SetBackgroundColor(self.db.profile.BGColor.r,self.db.profile.BGColor.g,self.db.profile.BGColor.b,self.db.profile.BGColor.a)
							else
								bar:SetBackgroundColor(0.3,0.3,0.3,0.6)
							end
				 			
				 			if self.db.profile.removeglow then 
				 				bar.spark:SetTexture(nil)
				 			else
				 				bar.spark:SetTexture([[Interface\CastingBar\UI-CastingBar-Spark]])
				 			end

							if self.db.profile.FillBars then
				 				bar.fill = true
				 			else
				 				bar.fill = false
				 			end

							if self.db.profile.FillBackGround then
				 				bar.FillBackground = true 
				 			else
				 				bar.FillBackground = false 
				 			end

				 			if self.db.profile.iconzoom then
				 				bar.icon:SetTexCoord(0.08,0.92,0.08,0.92)
				 			else
				 				bar.icon:SetTexCoord(0,1,0,1)
				 			end
				 		end
				 		if self.db.profile.Border then
				 			bar:ShowBorder()
				 		else
				 			bar:HideBorder()
				 		end
				 	end
				end
			end	

			barGroups[i].name = self.db.profile.frames[i].name
			barGroups[i]:SetOrientation(self.db.profile.orientation)
			barGroups[i]:SetTargetOrientation(self.db.profile.TargetOrientation)
			barGroups[i]:SetClampedToScreen(self.db.profile.clamped)
			barGroups[i]:SetFont(Media:Fetch("font", self.db.profile.fontFace), self.db.profile.frames[i].fontsize, self.db.profile.outline)
			if not self.db.profile.removebackground then barGroups[i]:SetTexture(Media:Fetch("statusbar", self.db.profile.texture)) end
			
			if self.db.profile.removereadytext then 
				barGroups[i]:setreadytext(true)
			else
				barGroups[i]:setreadytext(false)
			end

			barGroups[i]:SetScale(self.db.profile.frames[i].scale / 100.0)
			barGroups[i]:ReverseGrowth(self.db.profile.frames[i].growUp)
			barGroups[i]:SetAlpha(self.db.profile.frames[i].alpha / 100.0)
			barGroups[i]:SetWidth(self.db.profile.frames[i].width)
			barGroups[i]:SetHeight(self.db.profile.frames[i].height)
			
			if self.db.profile.frames[i].anchor then
				barGroups[i]:ShowAnchor()
			else
				barGroups[i]:HideAnchor()
			end

			if UnitInRaid("player") and self.db.profile.availability and self.db.profile.frames[i].permanent then
				local bars = barGroups[i]:GetBars()
				if type(bars) == "table" then
					for key, bar in pairs(bars) do
						if bar.ready then
							local maxl = self.db.profile.frames[i].maxTextLength
							if self.db.profile.ColorCaster and bar.castercolor == nil then bar.castercolor = FCDColorName2(string.sub(bar.caster,1,self.db.profile.frames[i].maxTextLength), bar.caster) end
							if not self.db.profile.ColorCaster and bar.castercolor ~= nil then bar.castercolor = nil end
							if isUnitRelevant(bar.caster) == "Zone" then bar:SetLabel("Zone - "..(self.db.profile.ColorCaster and bar.castercolor or string.sub(bar.caster,1,maxl)))
							elseif isUnitRelevant(bar.caster) == "Dead" then bar:SetLabel("Dead - "..(self.db.profile.ColorCaster and bar.castercolor or string.sub(bar.caster,1,maxl)))
							elseif isUnitRelevant(bar.caster) == "Offline" then bar:SetLabel("Offline - "..(self.db.profile.ColorCaster and bar.castercolor or string.sub(bar.caster,1,maxl)))
							elseif isUnitRelevant(bar.caster) == true then if self.db.profile.removereadytext then bar:SetLabel((self.db.profile.ColorCaster and bar.castercolor or string.sub(bar.caster,1,maxl))) else bar:SetLabel("R - "..(self.db.profile.ColorCaster and bar.castercolor or string.sub(bar.caster,1,maxl))) end
							end
						end
					end 
				end
			end
			barGroups[i]:Show();
		else
			barGroups[i]:Hide();
		end
	end
end

function mod:TalentItemScan(NoTimer)
	if NoTimer == nil then self:ScheduleTimer("TalentItemScan", 45) end
	if not barGroups or (not UnitInRaid("player") and GetNumPartyMembers() == 0) or UnitAffectingCombat("player") then return end
	local _, zone2 = IsInInstance()
	local numbmembers = 0
	local tempname = ""
	if UnitInRaid("player") then
		numbmembers = GetNumRaidMembers()
		tempname = "raid" 
	else
		numbmembers = GetNumPartyMembers() + 1
		tempname = "party"
	end
	for x=1, numbmembers do
		if tempname == "party" and x - GetNumPartyMembers() >= 1 then tempname = "player" x = "" end
		local player = UnitName(tempname..x)
		if player == "Unknown" then FatCooldowns:RaidScan("yes") return end
		local _, class = CustomUnitClass(player)
		for i = 1, 10, 1 do
			if i <= self.db.profile.frameCount and not self.db.profile.frames[i].hideFrame and self.db.profile.frames[i].permanent and not self.db.profile.HideAllFrames and not (UnitName("player") == player and
				self.db.profile.frames[i].hideSelf) and not (self.db.profile.frames[i].onlySelf and UnitName("player") ~= player) then
				if FatCooldowns.cooldowns[class] then	
					for spellName, spellTable in pairs(FatCooldowns.cooldowns[class]) do
						if self.db.profile.frames[i].spells[spellTable.id] and spellTable.talent then
							local SpellNameByID = GetSpellInfo(spellTable.id)
							local bar = barGroups[i]:GetBar(player .. "_" .. spellTable.id)

							if bar ~= nil and LGT:GetUnitTalentSpec(player) ~= nil and not LGT:UnitHasTalent(player, SpellNameByID) then
								if bar.ready then
									bar.permanent = false
									self:StopCooldown(player,spellTable.id, "True")
								elseif not bar.ready then
									bar.permanent = false
								end
							end
							if bar == nil and LGT:UnitHasTalent(player, SpellNameByID) then
								local maxsenderl = self.db.profile.frames[i].maxTextLength;
								local labelcooldownnewtalent = self.db.profile.ColorCaster and FCDColorName2(string.sub(player,1,maxsenderl), player) or string.sub(player,1,maxsenderl)
								if self.db.profile.frames[i].HideLabel then labelcooldownnewtalent = "" end
								if self.db.profile.frames[i].SpellNameLabel then labelcooldownnewtalent = GetSpellInfo(spellId) end
								local bar = barGroups[i]:NewTimerBar((player .. "_" .. spellTable.id), labelcooldownnewtalent, 0.5, spellTable.cd, spellTable.id)
													
								bar:SetScript("OnMouseUp", buttonClick)
								bar:EnableMouse(not self.db.profile.unclickable)
								bar.permanent = true
								bar.caster  = player
								if self.db.profile.ColorCaster then bar.castercolor = FCDColorName2(string.sub(player,1,self.db.profile.frames[i].maxTextLength), player) end
								if self.db.profile.removeglow then bar.spark:SetTexture(nil) end
								if self.db.profile.FillBackGround then bar.FillBackground = true elseif not self.db.profile.FillBackGround then bar.FillBackground = false end
								if self.db.profile.FillBars then bar.fill = true elseif not self.db.profile.FillBars then bar.fill = false end
								
								if self.db.profile.iconzoom then bar.icon:SetTexCoord(0.08,0.92,0.08,0.92) else bar.icon:SetTexCoord(0,1,0,1) end
								bar.spellId = spellTable.id
								bar.time = 0.5
								bar:SetTexture(Media:Fetch("statusbar", self.db.profile.texture))
								local _, c = CustomUnitClass(player)
								if not c then
									for k, v in pairs(FatCooldowns.cooldowns) do
										for k2, v2 in pairs(v) do
											if v2.id == spellId then
												c = k
											end
										end
									end
								end
								local color = RAID_CLASS_COLORS[c]
								if spellId == 70337 then color = {r = 0.1, g = 0.9, b = 0.1} end -- np
								if spellId == 72143 then color = {r = 0.64, g = 0.41, b = 0.18} end -- enrage
								if type(color) == "table" and not self.db.profile.CustomBarColor then
									bar:SetColorAt(1.00, color.r, color.g, color.b, 1)
									bar:SetColorAt(0.00, color.r, color.g, color.b, 1)
								elseif self.db.profile.CustomBarColor then
									bar:SetColorAt(1.00, self.db.profile.CustomBarColorPicked.r, self.db.profile.CustomBarColorPicked.g, self.db.profile.CustomBarColorPicked.b, self.db.profile.CustomBarColorPicked.a)
									bar:SetColorAt(0.00, self.db.profile.CustomBarColorPicked.r, self.db.profile.CustomBarColorPicked.g, self.db.profile.CustomBarColorPicked.b, self.db.profile.CustomBarColorPicked.a)
								end
							end
						end
					end
				end
				if FatCooldowns.cooldowns["ITEMS"] then
					local ItemID1 = GetInventoryItemID(tempname..x, 13)
					local ItemID2 = GetInventoryItemID(tempname..x, 14)
					for spellName, spellTable in pairs(FatCooldowns.cooldowns["ITEMS"]) do
						if self.db.profile.frames[i].spells[spellTable.id] then
	            	        if ItemID1 ~= nil and ItemID2 ~= nil then
	            	        	local tempItemID = nil
	            	        	for y = 1, 2, 1 do
	            	        		if y == 1 then tempItemID = ItemID1 elseif y == 2 then tempItemID = ItemID2 end
	                    			local bar = barGroups[i]:GetBar(player .. "_" .. spellTable.id)

									if bar == nil and (tempItemID == spellTable.itemid or tempItemID == spellTable.itemid2) then
										local maxsenderl = self.db.profile.frames[i].maxTextLength;
										local labelcooldownnewtalent = self.db.profile.ColorCaster and FCDColorName2(string.sub(player,1,maxsenderl), player) or string.sub(player,1,maxsenderl)
										if self.db.profile.frames[i].HideLabel then labelcooldownnewtalent = "" end
										if self.db.profile.frames[i].SpellNameLabel then labelcooldownnewtalent = GetSpellInfo(spellId) end
										local bar = barGroups[i]:NewTimerBar((player .. "_" .. spellTable.id), labelcooldownnewtalent, 0.5, spellTable.cd, spellTable.id)
										bar:SetScript("OnMouseUp", buttonClick)
										bar:EnableMouse(not self.db.profile.unclickable)
										bar.permanent = true; 
										bar.caster  = player
										if self.db.profile.ColorCaster then bar.castercolor = FCDColorName2(string.sub(player,1,self.db.profile.frames[i].maxTextLength), player) end
										if self.db.profile.removeglow then bar.spark:SetTexture(nil) end
										if self.db.profile.FillBackGround then bar.FillBackground = true elseif not self.db.profile.FillBackGround then bar.FillBackground = false end
										if self.db.profile.FillBars then bar.fill = true elseif not self.db.profile.FillBars then bar.fill = false end
										
										if self.db.profile.iconzoom then bar.icon:SetTexCoord(0.08,0.92,0.08,0.92) else bar.icon:SetTexCoord(0,1,0,1) end
										bar.spellId = spellTable.id
										bar.time = 0.5
										bar:SetTexture(Media:Fetch("statusbar", self.db.profile.texture))
										local _, c = CustomUnitClass(player)
										if not c then
											for k, v in pairs(FatCooldowns.cooldowns) do
												for k2, v2 in pairs(v) do
													if v2.id == spellId then
														c = k
													end
												end
											end
										end			
										local color = RAID_CLASS_COLORS[c]
										if spellId == 70337 then color = {r = 0.1, g = 0.9, b = 0.1} end -- np
										if spellId == 72143 then color = {r = 0.64, g = 0.41, b = 0.18} end -- enrage
										if type(color) == "table" and not self.db.profile.CustomBarColor then
											bar:SetColorAt(1.00, color.r, color.g, color.b, 1)
											bar:SetColorAt(0.00, color.r, color.g, color.b, 1)
										elseif self.db.profile.CustomBarColor then
											bar:SetColorAt(1.00, self.db.profile.CustomBarColorPicked.r, self.db.profile.CustomBarColorPicked.g, self.db.profile.CustomBarColorPicked.b, self.db.profile.CustomBarColorPicked.a)
											bar:SetColorAt(0.00, self.db.profile.CustomBarColorPicked.r, self.db.profile.CustomBarColorPicked.g, self.db.profile.CustomBarColorPicked.b, self.db.profile.CustomBarColorPicked.a)
										end
									end
								end
		                 	   	if (spellTable.itemid or spellTable.itemid2) then
	    	                		if ItemID2 == (spellTable.itemid or spellTable.itemid2) or ItemID1 == (spellTable.itemid or spellTable.itemid2) then
	    	                			-- do nothing
	    	                		else
				       					for i = 1, 10, 1 do
			   	                 			local bar = barGroups[i]:GetBar(player .. "_" .. spellTable.id)
			                    			if bar ~= nil and bar.ready then
												bar.permanent = false
												self:StopCooldown(player,spellTable.id, "True")
											elseif bar ~= nil and not bar.ready then
												bar.permanent = false
											end
										end
									end
								end
							end
	                    end
	                end
                end
            end
		end
	end
end

-- Omen rip
function mod:SetAnchors(useDB)
	if not barGroups then return end
	local _,zone2=IsInInstance()
	for i = 1, 10, 1 do
		if i <= self.db.profile.frameCount and not self.db.profile.frames[i].hideFrame and not self.db.profile.HideAllFrames and (not self.db.profile.HidePVP or (zone2 ~= "pvp" and zone2 ~= "arena")) then
			local up = self.db.profile.frames[i].growUp
			local x, y
			if useDB then
				x, y = self.db.profile.frames[i].posX, self.db.profile.frames[i].posY
				if not x and not y then
					barGroups[i]:ClearAllPoints()
					barGroups[i]:SetPoint("CENTER", UIParent, "CENTER", 0, 0)
					return
				end
			elseif up then
				x, y = barGroups[i]:GetLeft(), barGroups[i]:GetBottom()
			else
				x, y = barGroups[i]:GetLeft(), barGroups[i]:GetTop()
			end
			barGroups[i]:ClearAllPoints()
			if up then
				barGroups[i]:SetPoint("BOTTOMLEFT", UIParent, "BOTTOMLEFT", x, y)
			else
				barGroups[i]:SetPoint("TOPLEFT", UIParent, "BOTTOMLEFT", x, y)
			end
			self.db.profile.frames[i].posX, self.db.profile.frames[i].posY = x, y
		else
			barGroups[i]:Hide();
		end
	end
end

function mod:AnchorClicked(cbk, group, button)
	if button == "RightButton" then
		FatCooldowns:OpenConfigDialog()
	end
end

function mod:AnchorMoved(cbk, group, x, y)
	self:SetAnchors()
end

function mod:MessageSelf(msg)
	print(msg)
end

function mod:TimerFinishedMessage(cbk, group, bar, name, force)
if force ~= "yes" and bar.time ~= 0.5 then
	local _,zone2=IsInInstance()
	local reportraid = false
	local report = false

	for i = 1, 15, 1 do
		if i <= self.db.profile.frameCount and not self.db.profile.frames[i].hideFrame and not self.db.profile.HideAllFrames  and (not self.db.profile.HidePVP or (zone2 ~= "pvp" and zone2 ~= "arena")) then
			if self.db.profile.frames[i].readyMsg and self.db.profile.frames[i].spells[bar.spellId] then report = true end
			if self.db.profile.frames[i].RaidMsg and self.db.profile.frames[i].spells[bar.spellId] then reportraid = true end
		end
	end

	local item = nil
	local itemspellid = bar.spellId
	local spells = FatCooldowns.cooldowns["ITEMS"]
		if spells[bar.spellId] then item = spells[bar.spellId].itemlink end
	local spells = FatCooldowns.cooldowns["CONSUMABLES"]
		if spells[bar.spellId] then item = spells[bar.spellId].itemlink end
		
	if report and bar.caster ~= "Unknown" then
		TimerFinishMsg = string.format("%s's %s is ready!",bar.caster, (item or GetSpellLink(bar.spellId)))
		if lastmessageself ~= TimerFinishMsg or (lastmsgtimeself == nil or GetTime() - lastmsgtimeself >= 1) then
			lastmessageself = TimerFinishMsg
			lastmsgtimeself = GetTime()
			mod:MessageSelf(TimerFinishMsg)
		end
	end

	if reportraid and bar.caster ~= "Unknown" and (UnitInRaid("player") or GetNumPartyMembers() > 0) then 

	if owner == false and not self.db.profile.chatfilter[99980] then
		if AntiSpamLeader ~= UnitName("player") then if AntiSpamMessage then AntiSpamMessage = false print("AntiSpam has been enabled, your raid leader has FCD you will no longer report messages to the raid") end return
		elseif AntiSpamLeader ~= UnitName("player") and AntiSpamOfficer ~= UnitName("player") then if AntiSpamMessage then AntiSpamMessage = false print("AntiSpam has been enabled, your raid leader has FCD you will no longer report messages to the raid") end return
		end
	end
	TimerFinishMsg = string.format("%s's %s is ready!",bar.caster, (item or GetSpellLink(bar.spellId)))
	if lastmessageraid ~= TimerFinishMsg or (lastmsgtimeraid == nil or GetTime() - lastmsgtimeraid >= 1) then
		lastmessageraid = TimerFinishMsg
		lastmsgtimeraid = GetTime()
		if (IsRaidLeader() or IsRaidOfficer() or owner) then
		SendChatMessage(TimerFinishMsg, (select(2, IsInInstance()) == "pvp" and "BATTLEGROUND") or (GetNumRaidMembers() > 0 and "RAID") or "PARTY")
		else
		mod:MessageSelf(TimerFinishMsg)
		end
	end
	end end
	reportraid = false
	report = false
end

function mod:TimerFinished(cbk, group, bar, name, force)
	self:TimerFinishedMessage(cbk, group, bar, name, force)
	local spellId = bar.spellId
	local sender = bar.caster
	local target = bar.target
	local tempcooldown = nil
	local cooldown = bar.time
	bar.targetcolor = nil
	bar.DisableClick = nil

if self.db.profile.soundspells[spellId] and (LastSoundPlay[spellId] == nil or (LastSoundPlay[spellId] ~= nil and GetTime() - LastSoundPlay[spellId] > 1)) then
	local _, class = CustomUnitClass(sender)
	if spellId ~= 70337 and spellId ~= 72143 and class ~= nil and FatCooldowns.cooldowns[class] then
		for spellName, spellTable in pairs(FatCooldowns.cooldowns[class]) do
			if spellTable.id == spellId then 
				if spellTable.cd2 ~= nil and cooldown == spellTable.cd2 then tempcooldown = spellTable.cd2
				elseif cooldown == spellTable.cd then tempcooldown = spellTable.cd
				end
			end
		end
	elseif class == nil and FatCooldowns.cooldowns["OTHER BARS"] then
		for spellName, spellTable in pairs(FatCooldowns.cooldowns["OTHER BARS"]) do
			if spellTable.id == spellId then tempcooldown = spellTable.cd end
		end
	end
end
	local _, playerclass = UnitClass("player")

	if self.db.profile.soundspells[spellId] and (LastSoundPlay[spellId] == nil or (LastSoundPlay[spellId] ~= nil and GetTime() - LastSoundPlay[spellId] > 1)) and tempcooldown == cooldown and self.db.profile.soundspellsoptions[spellId].CDReady and
		(not self.db.profile.soundspellsoptions[spellId].PlayerClassEnable or (self.db.profile.soundspellsoptions[spellId].PlayerClassEnable and self.db.profile.soundspellsoptions[spellId].PlayerClass[playerclass])) and
		((not self.db.profile.soundspellsoptions[spellId].Spec1 and not self.db.profile.soundspellsoptions[spellId].Spec1) or (self.db.profile.soundspellsoptions[spellId].Spec1 and GetActiveTalentGroup() == 1) or (self.db.profile.soundspellsoptions[spellId].Spec2 and GetActiveTalentGroup() == 2)) and
		((not self.db.profile.soundspellsoptions[spellId].EnemyCaster or (self.db.profile.soundspellsoptions[spellId].EnemyCaster and IsEnemyFCDCaster(sender))) and
		(not self.db.profile.soundspellsoptions[spellId].FriendlyCaster or (self.db.profile.soundspellsoptions[spellId].FriendlyCaster and IsFriendlyFCDCaster(sender))) and
		(not self.db.profile.soundspellsoptions[spellId].TargetMe or (self.db.profile.soundspellsoptions[spellId].TargetMe and target == UnitName("player"))) and
		(not self.db.profile.soundspellsoptions[spellId].NotSelf or (self.db.profile.soundspellsoptions[spellId].NotSelf and sender ~= UnitName("player"))) and
		(not self.db.profile.soundspellsoptions[spellId].Self or (self.db.profile.soundspellsoptions[spellId].Self and sender == UnitName("player"))) and
		(not self.db.profile.soundspellsoptions[spellId].NotTargetMe or (self.db.profile.soundspellsoptions[spellId].NotTargetMe and target ~= UnitName("player"))))
	then
		if self.db.profile.soundspellsoptions[spellId].EnableCustomSound then
			PlaySoundFile(FatCooldowns.FCDSounds[self.db.profile.soundspellsoptions[spellId].CustomSound], "Master",false)
		else
			local SpellNameByID = GetSpellInfo(spellId)
			if SpellNameByID:find(":") then SpellNameByID = gsub(SpellNameByID, ": ", " ") end
			if spellId == 61685 or spellId == 47996 or spellId == 53477 then SpellNameByID = gsub(SpellNameByID, SpellNameByID, "Pet "..SpellNameByID) end
			PlaySoundFile("Interface\\AddOns\\FatCooldowns\\sounds\\SpellSounds\\"..SpellNameByID..".mp3", "Master", false)
		end
		LastSoundPlay[spellId] = GetTime()
	end
	if bar.permanent and self.db.profile.removebackground then bar:SetTexture(nil) end
	if bar.permanent then if UnitInRaid("player") or GetNumPartyMembers() >= 1 then else FatCooldowns:GetModule("Display"):StopCooldown(bar.caster, bar.spellId, "True") end end
	self:UpdateDisplay()
end

function mod:TimerStarted(cbk, group, bar, name)
	if bar.permanent and self.db.profile.removebackground then bar:SetTexture(Media:Fetch("statusbar", self.db.profile.texture)) end
end

-- chat filter

local OG_OnEvent = RaidWarningFrame:GetScript('OnEvent')
RaidWarningFrame:SetScript('OnEvent', function(self, event, msg, author,...)
	if not FatCooldowns:GetModule("Display").db.profile.chatfilter[99878] then return OG_OnEvent(self, event, msg, author, ...) end
	if (msg:find("^Infest #[%d]+ coming up! [\\-] Cooldown: None [\\-] No One$") or
		msg:find("^Defile on caster [A-Z][%a]+$") or
		msg:find("^Shambling Horror [%d]+ Frenzy in [\\.%d]*s! Plague will kill it [%d]+s later[\\.]$") or
		msg:find("^Shambling Horror [%d]+ Frenzy in [.%d]*s! Plague will not kill it!$") or
		msg:find("^Shambling Horror used Enrage [\\-] Stun/Tranq/Cooldown now!$") or
		msg:find("^{[sS][Kk][uU][lL][lL]}Shambling Horror Enrage . Tranquilize now!{[sS][Kk][uU][lL][lL]}$") or
		msg:find("^{rt[1,2,3,4,5,6,7,8]}Shambling Horror Enrage . Tranquilize now!{rt[1,2,3,4,5,6,7,8]}$") or
		msg:find("^{[sS][Kk][uU][lL][lL]}Shambling Horror Frenzy . Stun it or Pain Suppression{[sS][Kk][uU][lL][lL]}$") or
		msg:find("^{rt[1,2,3,4,5,6,7,8]}Shambling Horror Frenzy . Stun it or Pain Suppression{rt[1,2,3,4,5,6,7,8]}$") or
		msg:find("^Infest #[%d]+ coming up!$") or
		msg:find("^Infest coming up! %- Cooldown: None %- No One$") or
		msg:find("^Infest #[%d]+[%s]*[!]*$") or
		msg:find("^Plague will kill Shambling Horror [%d]+ in [%d]+s%.$") or
		msg:find("^{[sS][Kk][uU][lL][lL]}Shambling Horror Frenzy [\\-] Cooldowns on add tank![%s]*{[sS][Kk][uU][lL][lL]}[%s]*$") or
		msg:find("^{[sS][Kk][uU][lL][lL]}Defile on tank [A-Z][%a]+{[sS][Kk][uU][lL][lL]}[%s]*$") or
		msg:find("^{[sS][Kk][uU][lL][lL]}Defile on healer [A-Z][%a]+{[sS][Kk][uU][lL][lL]}[%s]*$") or
		msg:find("^{[sS][Kk][uU][lL][lL]}Defile on caster [A-Z][%a]+{[sS][Kk][uU][lL][lL]}[%s]*$") or
		msg:find("^{[sS][Kk][uU][lL][lL]}Defile on melee [A-Z][%a]+{[sS][Kk][uU][lL][lL]}[%s]*$") or
		msg:find("^{[sS][Kk][uU][lL][lL]}Defile on [A-Z][%a]+{[sS][Kk][uU][lL][lL]}[%s]*$") or
		msg:find("^No AoE stun!$") or
		msg:find("^No AoE slow!$") or
		msg:find("^Warning: Shambling Horro has 10 stacks of Necrotic Plague$") or
		msg:find("^[A-Z][%a]+ pulled aggro on a Raging Spirit!$") or
		msg:find("^[A-Z][%a]+ receives loot:.+%.$") or 
		msg:find("^[A-Z][%a]+ and [A-Z][%a]+ are like a bi%-ird, they'll only fly awa%-ay%.%.%.$") or
		msg:find("^[A-Z][%a]+, [A-Z][%a]+ and [A-Z][%a]+ are like a bi%-ird, they'll only fly awa%-ay%.%.%.$") or
		msg:find("^[A-Z][%a]+, [A-Z][%a]+, [A-Z][%a]+ and [A-Z][%a]+ are like a bi%-ird, they'll only fly awa%-ay%.%.%.$") or
		msg:find("^[A-Z][%a]+ is like a bi%-ird, he'll only fly awa-ay%.%.%.$") or
		msg:find("^[A-Z][%a]+ is like a bi%-ird, she'll only fly awa%-ay%.%.%.$") or
		msg:find("^[A-Z][%a]+ picked up!$") or
		(msg:find("^Big Brother: ") and not msg:find(UnitName("plaer")))
		) and author ~= UnitName("player") then

		if FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99878] > 0 and (FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[RaidWarningFrame] == nil or FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[RaidWarningFrame] ~= msg) then
			FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[RaidWarningFrame] = msg _G["ChatFrame"..FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99878]]:AddMessage("FCDRaidWarningFrame:".."|Hplayer:"..author.."|h["..author.."]|h"..": "..msg, 1,0.49,0.04) end
		
		 return 
	else
		return OG_OnEvent(self, event, msg, author, ...)
	end
end)


function islead(name)
	if UnitInRaid("player") then
		for i=1, GetNumRaidMembers() do
 		local nametwo, rank, _, _, _, _, _, _, _, role, _, _ = GetRaidRosterInfo(i)
 		if name == nametwo and rank == 2 then return nametwo end
 		end
	end
end


function WarmaneSystemSpam(self,_,msg,author) if 
	msg:lower():find("by enabling mercenary mode, players can switch their faction allegiance temporarily in battlegrounds for the benefit of greatly reduced waiting times") or
	msg:lower():find("players can make use of an opt%-in feature: mercenary ") or
	msg:lower():find("donate and be rewarded with coins which") or
  	msg:lower():find("beware of phishing scams offering") or
  	msg:lower():find("stream and promote your gameplay ") or
  	msg:lower():find("players can now make use of an") or
  	msg:lower():find("frostmourne season .+ will start on .+") or
  	msg:lower():find("players can now trade their characters on our website") or
  	msg:lower():find("create dungeon groups and chat with other") or 
	msg:lower():find("frostmourne is a progressive style realm and will be opened on") or
	msg:lower():find("xp rates can be set, right click your experience bar to show the options") or
	msg:lower():find("first tier of raiding content on frostmourne, including the timewalking experience of medivh's tower, has been released") or
	msg:lower():find("second content tier of frostmourne is currently live featuring ulduar and timewalking") or
	msg:lower():find("players can trade their characters on our website using the character trade") then if FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99950] > 0 and (FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[WarmaneSystemSpam] == nil or FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[WarmaneSystemSpam] ~= msg) then
	FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[WarmaneSystemSpam] = msg _G["ChatFrame"..FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99950]]:AddMessage("FCDWarmaneSystemSpam: "..msg, 1,0.49,0.04) end return true end end
function MPRSpam(self,_,msg,author) if (msg:lower():find("^<mpr>") or msg:lower():find("^<b%.m>") or msg:find("^[\\[]HASS] ") or msg:find("^GoofyBest> ") or
 (msg:find("^{rt[1,2,3,4,5,6,7,8]}[%s]*[A-Z][%a]+") and msg:find("|cff71d5ff|Hspell:[%d]+|h[\\[].+]|h|r")) or
 msg:find("^{rt[1,2,3,4,5,6,7,8]}[%s]*[A-Z][%a]+ used |cffa335ee|Hitem:54589:0:0:0:0:0:0:0:0|h[Glowing Twilight Scale]|h|r") or
 msg:find("^{rt[1,2,3,4,5,6,7,8]}[%s]*[A-Z][%a]+ used |cffa335ee|Hitem:54573:0:0:0:0:0:0:0:0|h[Glowing Twilight Scale]|h|r") or
 (msg:find("^{rt[1,2,3,4,5,6,7,8]}[%s]*[A-Z][%a]+ died%. %(") and msg:find("%)$")) or

 (msg:find("^{[sS][tT][aA][rR]}[%s]*[A-Z][%a]+") and msg:find("|cff71d5ff|Hspell:[%d]+|h[\\[].+]|h|r")) or

 msg:find("^{rt[1,2,3,4,5,6,7,8]}[%s]*|cff71d5ff|Hspell:[%d]+|h[\\[].+]|h|r .+ on [A-Z][%a]+") or
 msg:find("^{rt[1,2,3,4,5,6,7,8]}[%s]*|cff71d5ff|Hspell:[%d]+|h[\\[].+]|h|r hits: [A-Z][%a]+ %([%d]+[k]*%)") or
 msg:find("^{rt[1,2,3,4,5,6,7,8]}[%s]*|cff71d5ff|Hspell:[%d]+|h[\\[].+]|h|r expires in [%d]+ seconds%.$") or
 msg:find("^{[sS][tT][aA][rR]}[%s]*|cff71d5ff|Hspell:[%d]+|h[\\[].+]|h|r .+ on [A-Z][%a]+$") or

 msg:lower():find("^%>[%s]*{[Ss][Tt][Aa][Rr]}[%s]*|cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-]*]|h|r CD: [%d]+ sec[%s]*{[Ss][Tt][Aa][Rr]}$") or
 msg:lower():find("^%>[%s]*{rt[1,2,3,4,5,6,7,8]}[%s]*|cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-]*]|h|r CD: [%d]+ sec[%s]*{rt[1,2,3,4,5,6,7,8]}$") or
 msg:lower():find("^%>[%s]*{rt[1,2,3,4,5,6,7,8]}[%s]*|cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-]*]|h|r: [%d]+ sec[%s]*{rt[1,2,3,4,5,6,7,8]}$") or
 msg:lower():find("^%>[%s]*{[tT][Rr][Ii][Aa][Nn][Gg][Ll][Ee]}[%s]*|cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-]*]|h|r: [%d]+ sec[%s]*{[tT][Rr][Ii][Aa][Nn][Gg][Ll][Ee]}$") 
) and author ~= UnitName("player") then if FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99951] > 0 and (FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[MPRSpam] == nil or FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[MPRSpam] ~= msg) then
	FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[MPRSpam] = msg _G["ChatFrame"..FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99951]]:AddMessage("FCDMPRSpam:".."|Hplayer:"..author.."|h["..author.."]|h"..": "..msg, 1,0.49,0.04) end return true end end
function FatalitySpam(self,_,msg,author) if (msg:lower():find("^fatality") or msg:find("^Décès:") ) and author ~= UnitName("player") then if FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99952] > 0 and (FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[FatalitySpam] == nil or FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[FatalitySpam] ~= msg) then
	FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[FatalitySpam] = msg _G["ChatFrame"..FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99952]]:AddMessage("FCDFatalitySpam:".."|Hplayer:"..author.."|h["..author.."]|h"..": "..msg, 1,0.49,0.04) end return true end end
function CrybabySpam(self,_,msg,author) if msg:lower():find("^crybaby") and author ~= UnitName("player") then if FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99953] > 0 and (FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[CrybabySpam] == nil or FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[CrybabySpam] ~= msg) then
	FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[CrybabySpam] = msg _G["ChatFrame"..FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99953]]:AddMessage("FCDCrybabySpam:".."|Hplayer:"..author.."|h["..author.."]|h"..": "..msg, 1,0.49,0.04) end return true end end
function WarmaneCustomDBMSpam(self,_,msg,author) if (msg:find("^[%s]*Instability_Reset$") or msg:find("^[%s]*Gained_Instability$")) and author ~= UnitName("player") then if FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99954] > 0 and (FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[WarmaneCustomDBMSpam] == nil or FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[WarmaneCustomDBMSpam] ~= msg) then
	FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[WarmaneCustomDBMSpam] = msg _G["ChatFrame"..FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99954]]:AddMessage("FCDWarmaneCustomDBMSpam:".."|Hplayer:"..author.."|h["..author.."]|h"..": "..msg, 1,0.49,0.04) end return true end end
function IDKNAMESpam(self,_,msg,author) if ((msg:lower():find("^%*%*%*") and msg:lower():find("%*%*%*$")) or (msg:lower():find("^###") and msg:lower():find("###$"))) and author ~= UnitName("player") then if FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99955] > 0 and (FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[IDKNAMESpam] == nil or FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[IDKNAMESpam] ~= msg) then
	FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[IDKNAMESpam] = msg _G["ChatFrame"..FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99955]]:AddMessage("FCDIDKNAMESpam:".."|Hplayer:"..author.."|h["..author.."]|h"..": "..msg, 1,0.49,0.04) end return true end end 
function FactionGroupSpam(self,_,msg,author,lang) if UnitFactionGroup("player")=="Horde" and lang=="Common" then
	if FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99956] > 0 and (FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[FactionGroupSpam] == nil or FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[FactionGroupSpam] ~= msg) then
	FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[FactionGroupSpam] = msg _G["ChatFrame"..FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99956]]:AddMessage("FCDFactionGroupSpam:".."|Hplayer:"..author.."|h["..author.."]|h"..": "..msg, 1,0.49,0.04) end
 return true elseif UnitFactionGroup("player")=="Alliance" and lang=="Orcish" then
	if FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99956] > 0 and (FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[FactionGroupSpam] == nil or FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[FactionGroupSpam] ~= msg) then
	FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[FactionGroupSpam] = msg _G["ChatFrame"..FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99956]]:AddMessage("FCDFactionGroupSpam:".."|Hplayer:"..author.."|h["..author.."]|h"..": "..msg, 1,0.49,0.04) end return true end end 
function EmblemSpam(self,_,msg,author) if msg:lower():find("receives loot") and msg:lower():find("emblem of") then if FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99957] > 0 and (FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[EmblemSpam] == nil or FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[EmblemSpam] ~= msg) then
	FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[EmblemSpam] = msg _G["ChatFrame"..FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99957]]:AddMessage("FCDEmblemSpam:"..msg, 1,0.49,0.04) end return true end end 
function ParrySpam(self,_,msg,author) if 
	((msg:find("PARRY") and msg:find("parried") and msg:find("!$")) or
	(msg:find("has caused a PARRY by") and msg:find("!$")) or
	msg:find("^[%s]*PARRY: [%a]+$") or
	(UnitName("boss1") ~= nil and msg:find("^[A-Z][%a]+'s attack was parried by "..UnitName("boss1").."!$")) or
	msg:find("^[%s]*Congratz [A-Z][%a]+ you won %-[%d]+k dkp !$") or
	msg:find("^[A-Z][%a]+ caused a parry on [A-Z][%a]+") or
	msg:find("^PARRY: [A-Z][%a]+ has caused a PARRY! boss target is [A-Z][%a]+$") or
	msg:find("^PARRY: [A-Z][%a]+ has caused a PARRY! Boss Target: [A-Z][%a]+$") or
	msg:find("^PARRY: [A-Z][%a]+'s pet %([A-Z][%a]+%) has caused a PARRY! Boss Target: [A-Z][%a]+$") or
	msg:find("^PARRY: [A-Z][%a]+'s pet %(.+%) has caused a PARRY!$") or
	msg:find("^PARRY: [A-Z][%a]+ has caused a PARRY!$")) and author ~= UnitName("player") then if FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99958] > 0 and (FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[ParrySpam] == nil or FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[ParrySpam] ~= msg) then
	FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[ParrySpam] = msg _G["ChatFrame"..FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99958]]:AddMessage("FCDParrySpam:".."|Hplayer:"..author.."|h["..author.."]|h"..": "..msg, 1,0.49,0.04) end return true end end  
function DetailsDeathSpam(self,_,msg,author) if 
msg:find("^Details! [A-Z][%a]+'s Death:") and author ~= UnitName("player") then if FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99949] > 0 and (FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[DetailsDeathSpam] == nil or FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[DetailsDeathSpam] ~= msg) then
	FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[DetailsDeathSpam] = msg _G["ChatFrame"..FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99949]]:AddMessage("FCDDetailsDeathSpam:".."|Hplayer:"..author.."|h["..author.."]|h"..": "..msg, 1,0.49,0.04) end return true end end
function SkadaDeathSpam(self,_,msg,author) if 
msg:find("^Skada: [A-Z].+ > [A-Z][%a]+ %(.+%) [%d]+") and author ~= UnitName("player") then if FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99946] > 0 and (FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[SkadaDeathSpam] == nil or FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[SkadaDeathSpam] ~= msg) then
	FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[SkadaDeathSpam] = msg _G["ChatFrame"..FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99946]]:AddMessage("FCDSkadaDeathSpam:".."|Hplayer:"..author.."|h["..author.."]|h"..": "..msg, 1,0.49,0.04) end return true end end
function IsReadySpam(self,_,msg,author) if (
	msg:find("^[%s]*[A-Z][%a]+'s |cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-]*]|h|r is ready!$") or
	msg:find("^[%s]*[A-Z][%a]+'s |cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-]*]|h|r will be ready in [%d]+sec$") or
	msg:find("|cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-]*]|h|r is ready to be used by [A-Z][%a]+") or
	msg:find("|cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-]*]|h|r is ready to be used by ~") or
	msg:find("|cffa335ee|Hitem:54589:0:0:0:0:0:0:0:0|h[Glowing Twilight Scale]|h|r[%s]*is ready to be used by [A-Z][%a]+") or
	msg:find("^[A-Z][%a]+'s |cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-]*]|h|r will be ready in (CD [%d]+[\\.]*[%d]*)$") or
	(msg:find("^[A-Z][%a]+ has |cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-]*]|h|r ready.$") and not msg:find(UnitName("player")))	) and author ~= UnitName("player") then if FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99948] > 0 and (FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[IsReadySpam] == nil or FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[IsReadySpam] ~= msg) then
	FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[IsReadySpam] = msg _G["ChatFrame"..FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99948]]:AddMessage("FCDIsReadySpam:".."|Hplayer:"..author.."|h["..author.."]|h"..": "..msg, 1,0.49,0.04) end return true end end
function IconsSpam(self,_,msg,author) if UnitInRaid("player") and UnitAffectingCombat("player") then local player = select(3, msg:find("[\\[](%a+)]")) if islead(player) == player then if FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99873] > 0 and (FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[IconsSpam] == nil or FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[IconsSpam] ~= msg) then
	FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[IconsSpam] = msg _G["ChatFrame"..FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99873]]:AddMessage("FCDIconsSpam:".."|Hplayer:"..author.."|h["..author.."]|h"..": "..msg, 1,0.49,0.04) end return false else return true end end end
function RBSDeaths(self,_,msg,author) if (msg:find("^Ranged DPS [A-Z][%a]+ has died!$") or msg:find("^Melee DPS [A-Z][%a]+ has died!$") or msg:find("^Tank [A-Z][%a]+ has died!$") or msg:find("^Healer [A-Z][%a]+ has died!$")) and author ~= UnitName("player") then if FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99946] > 0 and (FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[RBSDeaths] == nil or FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[RBSDeaths] ~= msg) then
	FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[RBSDeaths] = msg _G["ChatFrame"..FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99946]]:AddMessage("FCDRBSDeaths:".."|Hplayer:"..author.."|h["..author.."]|h"..": "..msg, 1,0.49,0.04) end return true end end
function FCDMVileGas(self,_,msg,author) if (msg:find("^Vile Gas on: [A-Z][%a]+, [A-Z][%a]+, [A-Z][%a]+$") or msg:find("^Vile Gas on: [A-Z][%a]+, [A-Z][%a]+, [A-Z][%a]+ Extra: [A-Z][%a]+")) and author ~= UnitName("player") then if FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99929] > 0 and (FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[FCDMVileGas] == nil or FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[FCDMVileGas] ~= msg) then
	FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[FCDMVileGas] = msg _G["ChatFrame"..FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99929]]:AddMessage("FCDFCDMVileGas:".."|Hplayer:"..author.."|h["..author.."]|h"..": "..msg, 1,0.49,0.04) end return true end end
function FCDMWhoring(self,_,msg,author) if UnitName("boss1") ~= nil and (
msg:find("^Warning: [A-Z][%a]+ has used |cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-:)(]*]|h|r on "..UnitName("boss1").." or adds".."$") or
msg:find("^Warning: [A-Z][%a]+ has used |cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-:)(]*]|h|r on Prince Valanar with 1HP$") or
msg:find("^Warning: [A-Z][%a]+ has used |cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-:)(]*]|h|r on Prince Keleseth with 1HP$") or
msg:find("^Warning: [A-Z][%a]+ has used |cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-:)(]*]|h|r on Prince Taldaram with 1HP$") or
msg:find("^Warning: [A-Z][%a]+ has used |cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-:)(]*]|h|r on "..UnitName("boss1").."$") or
msg:find("^Warning: [A-Z][%a]+ has used |cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-:)(]*]|h|r on Blood Beast$") or
msg:find("^Warning: [A-Z][%a]+ has used |cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-:)(]*]|h|r on Val'kyr Shadowguard$") or
msg:find("^Warning: [A-Z][%a]+ has used |cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-:)(]*]|h|r on Vile Spirit$") or
msg:find("^Warning: [A-Z][%a]+ has used |cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-:)(]*]|h|r on Drudge Ghoul$") or
msg:find("^Warning: [A-Z][%a]+ has used |cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-:)(]*]|h|r on Little Ooze$") or
msg:find("^Warning: [A-Z][%a]+ has used |cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-:)(]*]|h|r on Big Ooze$") or
msg:find("^Warning: [A-Z][%a]+ has used |cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-:)(]*]|h|r on Shambling Horror$") or
msg:find("^Warning: [A-Z][%a]+ has used |cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-:)(]*]|h|r on Drudge Ghoul$") or
msg:find("^Warning: [A-Z][%a]+ has used |cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-:)(]*]|h|r on Dark Nucleus$") or
--other whoring addon messages
msg:find("^[%s]*[\\*]Whoring[\\*] [A-Z][%a]+ cast |cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-:)(]*]|h|r on"..UnitName("boss1").."$") or
msg:find("^[%s]*[\\*]Whoring[\\*] [A-Z][%a]+ cast |cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-:)(]*]|h|r on Big Ooze$") or
msg:find("^[%s]*[\\*]Whoring[\\*] [A-Z][%a]+ cast |cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-:)(]*]|h|r on Little Ooze$") or
msg:find("^[%s]*[\\*]Whoring[\\*] [A-Z][%a]+ cast |cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-:)(]*]|h|r on Drudge Ghoul$") or
msg:find("^[%s]*[\\*]Whoring[\\*] [A-Z][%a]+ cast |cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-:)(]*]|h|r on Prince Keleseth$") or
msg:find("^[%s]*[\\*]Whoring[\\*] [A-Z][%a]+ cast |cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-:)(]*]|h|r on Prince Valanar$") or
msg:find("^[%s]*[\\*]Whoring[\\*] [A-Z][%a]+ cast |cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-:)(]*]|h|r on Prince Taldaram$") or
msg:find("^[%s]*[\\*]Whoring[\\*] [A-Z][%a]+ cast |cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-:)(]*]|h|r on Vile Spirit$") or
msg:find("^[%s]*[\\*]Whoring[\\*] [A-Z][%a]+ cast |cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-:)(]*]|h|r on Shambling Horror$")) and author ~= UnitName("player") then if FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99925] > 0 and (FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[FCDMWhoring] == nil or FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[FCDMWhoring] ~= msg) then
	FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[FCDMWhoring] = msg _G["ChatFrame"..FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99925]]:AddMessage("FCDFCDMWhoring:".."|Hplayer:"..author.."|h["..author.."]|h"..": "..msg, 1,0.49,0.04) end return true end end
function FCDMWhoringSingle(self,_,msg,author) if msg:find("^Warning: [A-Z][%a]+ has used |cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-:)(]*]|h|r on Val'kyr Shadowguard with [%d]+[%%] HP$") and author ~= UnitName("player") then if FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99924] > 0 and (FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[FCDMWhoringSingle] == nil or FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[FCDMWhoringSingle] ~= msg) then
	FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[FCDMWhoringSingle] = msg _G["ChatFrame"..FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99924]]:AddMessage("FCDFCDMWhoringSingle:".."|Hplayer:"..author.."|h["..author.."]|h"..": "..msg, 1,0.49,0.04) end return true end end
function FCDMBPCKock(self,_,msg,author) if
	(msg:find("^[A-Z][%a]+ has knocked the Tank [A-Z][%a]+ with Empowered Shock Vortex$") or
		msg:find("^Warning: [A-Z][%a]+ Healer knocked by [A-Z][%a]+") or 
		msg:find("^Warning: [A-Z][%a]+ Tank knocked by [A-Z][%a]+"))
	and author ~= UnitName("player") then if FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99922] > 0 and (FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[FCDMBPCKock] == nil or FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[FCDMBPCKock] ~= msg) then
	FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[FCDMBPCKock] = msg _G["ChatFrame"..FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99922]]:AddMessage("FCDFCDMBPCKock:".."|Hplayer:"..author.."|h["..author.."]|h"..": "..msg, 1,0.49,0.04) end return true end end
function FCDOozeDamage(self,_,msg,author) if (msg:find("^Incorrect Ooze Damage: [A-Z][%a]+ used |cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-:)()]*]|h|r on Gas Cloud with incorrect debuff$") or
	msg:find("^Incorrect Ooze Damage: [A-Z][%a]+ used |cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-:)()]*]|h|r on Volatile Ooze with incorrect debuff$")) and author ~= UnitName("player") then
	if FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99927] > 0 and (FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[FCDOozeDamage] == nil or FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[FCDOozeDamage] ~= msg) then
	FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[FCDOozeDamage] = msg _G["ChatFrame"..FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99927]]:AddMessage("FCDFCDOozeDamage:".."|Hplayer:"..author.."|h["..author.."]|h"..": "..msg, 1,0.49,0.04) end return true end end
function FCDMBQLBite(self,_,msg,author) if msg:find("^[A-Z][%a]+ has bitten [A-Z][%a]+$") and author ~= UnitName("player") then if FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99928] > 0 and (FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[FCDMBQLBite] == nil or FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[FCDMBQLBite] ~= msg) then
	FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[FCDMBQLBite] = msg _G["ChatFrame"..FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99928]]:AddMessage("FCDFCDMBQLBite:".."|Hplayer:"..author.."|h["..author.."]|h"..": "..msg, 1,0.49,0.04) end return true end end
function FCDMBacklash(self,_,msg,author) if UnitName("boss1") ~= nil and UnitName("boss1") == "Sindragosa" and (
	msg:find("^[A-Z][%a]+ just exploded with [%d]+ stacks on [%d]+ targets[!]*") or 
	msg:find("^[A-Z][%a]+ exploded with [%d]+ stacks") or 
	msg:find("^[A-Z][%a]+ with [%d]+ stacks hits [%d]+: [A-Z][%a]+") or 
	msg:find("^[A-Z][%a]+ with [%d]+ stacks hits Unknown: [A-Z][%a]+") or 
	msg:find("^[A-Z][%a]+ with [%d]+ stacks hits Unkown: [A-Z][%a]+") or 
	--new backlash v16
	msg:find("^[A-Z][%a]+.* [%d]+ Hits: Unknown: [A-Z][%a]+") or 
	msg:find("^[A-Z][%a]+.* [%d]+ Hits: [%d]+: [A-Z][%a]+") or 
	msg:find("^[A-Z][%a]+.* [%d]+ and [A-Z][%a]+.* [%d]+ Hits: Unknown: [A-Z][%a]+") or 
	msg:find("^[A-Z][%a]+.* [%d]+ and [A-Z][%a]+.* [%d]+ Hits: [%d]+: [A-Z][%a]+") or 
	msg:find("^[A-Z][%a]+ Ice Block [%d]+ Hits: [%d]+: [A-Z][%a]+") or 
	msg:find("^[A-Z][%a]+ Bubble [%d]+ Hits: [%d]+: [A-Z][%a]+") or
	msg:find("^[A-Z][%a]+ Ice Block [%d]+ Hits: [%d]+ [A-Z][%a]+") or 
	msg:find("^[A-Z][%a]+ Bubble [%d]+ Hits: [%d]+ [A-Z][%a]+") or
	--new backlash b=v16
	msg:find("^[A-Z][%a]+ Ice Block with [%d]+ stacks hits: [%d]+: [A-Z][%a]+") or 
	msg:find("^[A-Z][%a]+ Bubble with [%d]+ stacks hits: [%d]+: [A-Z][%a]+") or 
	(msg:find("^Backlash hit [%d]+ players for ") and msg:find("damage (") and msg:find("absorbed): ") and msg:find("[A-Z][%a]+ ([%d]+)$"))	)and author ~= UnitName("player") then if FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99926] > 0 and (FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[FCDMBacklash] == nil or FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[FCDMBacklash] ~= msg) then
	FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[FCDMBacklash] = msg _G["ChatFrame"..FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99926]]:AddMessage("FCDFCDMBacklash:".."|Hplayer:"..author.."|h["..author.."]|h"..": "..msg, 1,0.49,0.04) end return true end end
function FCDBMHastedAttack(self,_,msg,author) if UnitName("boss1") ~= nil and UnitName("boss1") == "Halion" and msg:find("^Boss has done a PARRY HASTED attack$") and author ~= UnitName("player") then if FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99887] > 0 and (FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[FCDBMHastedAttack] == nil or FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[FCDBMHastedAttack] ~= msg) then
	FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[FCDBMHastedAttack] = msg _G["ChatFrame"..FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99887]]:AddMessage("FCDBMHastedAttack:".."|Hplayer:"..author.."|h["..author.."]|h"..": "..msg, 1,0.49,0.04) end return true end end
function FCDMRSDispel(self,_,msg,author) if (
 msg:find("[A-Z][%a]+ dispelled |cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-]*]|h|r from [A-Z][%a]+ after [%d]+[\\.][%d]+ Seconds") or
 msg:find("[A-Z][%a]+ dispelled |cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-]*]|h|r from [A-Z][%a]+ after Unknown Seconds") or
 msg:find("[A-Z][%a]+ has dispelled the mark with Bubble, Cloak or Ice Block after Unkown Seconds") or
 msg:find("[A-Z][%a]+ has dispelled the mark with Bubble, Cloak or Ice Block after Unknown Seconds") or
 msg:find("[A-Z][%a]+ has dispelled the mark with Bubble, Cloak or Ice Block after [%d]+ Seconds") or
 msg:find("[A-Z][%a]+ has dispelled |cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-:)(]*]|h|r with |cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-:)(]*]|h|r after .+ Seconds")) and author ~= UnitName("player") then if FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99923] > 0 and (FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[FCDMRSDispel] == nil or FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[FCDMRSDispel] ~= msg) then
	FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[FCDMRSDispel] = msg _G["ChatFrame"..FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99923]]:AddMessage("FCDFCDMRSDispel:".."|Hplayer:"..author.."|h["..author.."]|h"..": "..msg, 1,0.49,0.04) end return true end end
function FCDMSunders(self,_,msg,author) if msg:find("^5 Sunder's [%d]+sec: [A-Z][%a]+") and msg:find("[A-Z][%a]+ [\\-] [%d]+$") and author ~= UnitName("player") then if FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99906] > 0 and (FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[FCDMSunders] == nil or FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[FCDMSunders] ~= msg) then
	FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[FCDMSunders] = msg _G["ChatFrame"..FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99906]]:AddMessage("FCDFCDMSunders:".."|Hplayer:"..author.."|h["..author.."]|h"..": "..msg, 1,0.49,0.04) end return true end end
function FCDBMNecro(self,_,msg,author) if (msg:find("^[A-Z][%a]+ has dispelled Necrotic from [A-Z][%a]+ after [%d]+%.[%d]+s, Necrotic jumps to [A-Z][%a]+$") or
	msg:find("^[A-Z][%a]+ has dispelled Necrotic from [A-Z][%a]+ after [%d]+%.[%d]+s$") or
	msg:find("^[A-Z][%a]+ was killed with Necrotic$") or
	msg:find("^[A-Z][%a]+ was killed by Necrotic[%s]*$") or
	msg:find("^[A-Z][%a]+ has dispelled Necrotic from [A-Z][%a]+, Necrotic jumps to [A-Z][%a]+$") or
	msg:find("^[A-Z][%a]+ has dispelled Necrotic from [A-Z][%a]+$")) and author ~= UnitName("player") then if FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99930] > 0 and (FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[FCDBMNecro] == nil or FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[FCDBMNecro] ~= msg) then
	FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[FCDBMNecro] = msg _G["ChatFrame"..FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99930]]:AddMessage("FCDBMNecro:".."|Hplayer:"..author.."|h["..author.."]|h"..": "..msg, 1,0.49,0.04) end return true end end
function FCDParryCounter(self,_,msg,author) if (msg:find("^ParryCounterP[%d]+: [A-Z][%a]+") or msg:find("^ParryCounter: [A-Z][%a]+") or
	msg:find("^ParryCounterP[%d]+(In): [A-Z][%a]+") or
	msg:find("^ParryCounterP[%d]+(Out): [A-Z][%a]+")) and author ~= UnitName("player") then if FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99875] > 0 and (FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[FCDParryCounter] == nil or FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[FCDParryCounter] ~= msg) then
	FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[FCDParryCounter] = msg _G["ChatFrame"..FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99875]]:AddMessage("FCDParryCounter:".."|Hplayer:"..author.."|h["..author.."]|h"..": "..msg, 1,0.49,0.04) end return true end end
function SmarBuffFilter(self,_,msg,author) if (
	((msg:lower():find("missing buff: <") or msg:lower():find("warning: <")) and
		(((msg:lower():find("paladin blessing") or (msg:lower():find("righteous fury") or msg:lower():find("seal")))and (not (CustomUnitClass("Player") == "Paladin"))) or
		((msg:lower():find("mark of the wild") or msg:lower():find("gift of the wild") or msg:lower():find("thorns")) and (not (CustomUnitClass("Player") == "Druid"))) or
		((msg:lower():find("arcane intellect") or msg:lower():find("molten armor") or msg:lower():find("missing focus magic")) and	(not (CustomUnitClass("Player") == "Mage"))) or 
		((msg:lower():find("water shield") or msg:lower():find("missing earth shield")) and (not (CustomUnitClass("Player") == "Shaman"))) or 
		(msg:lower():find("bone shield") and (not (CustomUnitClass("Player") == "Death Knight"))) or 
		((msg:lower():find("aspect cheetah/pack on") or msg:lower():find("hunter aspect")) and (not (CustomUnitClass("Player") == "Hunter"))) or
		((msg:lower():find("soul link") or msg:lower():find("no soulstone detected") or msg:lower():find("fel armor")) and	(not (CustomUnitClass("Player") == "Warlock"))) or 
		(msg:lower():find("call pet") and (not (CustomUnitClass("Player") == "Hunter" or CustomUnitClass("Player") == "Death Knight" or CustomUnitClass("Player") == "Warlock" ))) or 
		((msg:lower():find("power word: fortitude") or msg:lower():find("shadow protection") or msg:lower():find("divine spirit") or msg:lower():find("inner fire") or
		 msg:lower():find("vampiric embrace") or msg:lower():find("shadowform")) and (not (CustomUnitClass("Player") == "Priest"))) or
		((msg:lower():find("different zone") or msg:lower():find("weapon buff") or msg:lower():find("well fed") or msg:lower():find("flask")) and (not (msg:find(UnitName("player"))))) )) or

	(msg:find("^[A-Z][%a]+%, [A-Z][%a]+%, [A-Z][%a]+%,") and msg:find("[A-Z][%a]+%, [A-Z][%a]+%, [A-Z][%a]+%$") and not msg:find("[%d!?\\(]")) or

((msg:find("^RBS:: [A-Z][%a]+") or 
	((msg:find("^[%s]*<No Soulstone detected>") or msg:find("^[%s]*<Soul Link>") or msg:lower():find("^[%s]*<fel armor>")) and (not (CustomUnitClass("Player") == "Warlock"))) or
	(msg:find("^[%s]*<Mana less than 80%>:") and (not (msg:find(UnitName("player"))))) or
	(msg:find("^[%s]*<Missing Earth Shield>:") and (not (CustomUnitClass("Player") == "Shaman"))) or
	((msg:find("^[%s]*Slackers:") or msg:find("^[%s]*<Slacking Paladins")) and (not (msg:find(UnitName("player"))))) or
	((msg:find("^[%s]*<Paladin blessing>:") or msg:find("^[%s]*<Crusader Aura>:") or msg:find("^[%s]*<Righteous Fury>:")) and (not (CustomUnitClass("Player") == "Paladin"))) or
	msg:find("^[%s]*<Bone Shield>:") or msg:find("^[%s]*<Offline>:") or msg:find("^[%s]*<Guardian Elixir>:") or
	((msg:find("^[%s]*<Hunter Aspect>:") or msg:find("^[%s]*<Aspect Cheetah/Pack On>:")) and (not (CustomUnitClass("Player") == "Hunter"))) or
	((msg:find("^[%s]*<Arcane Intellect>:") or msg:find("^[%s]*<Molten Armor>:")) and (not (CustomUnitClass("Player") == "Mage"))) or
	(msg:find("^[%s]*<Water Shield[\\/]Lightning Shield>:") and (not (CustomUnitClass("Player") == "Shaman"))) or
	((msg:find("^[%s]*<Power Word: Fortitude>:") or msg:find("^[%s]*<Shadow Protection>:") or msg:find("^[%s]*<Inner Fire>:") or msg:find("^[%s]*<Vampiric Embrace>:") or msg:find("^[%s]*<Divine Spirit>:") or msg:find("^[%s]*<Shadowform>:")) and (not (CustomUnitClass("Player") == "Priest"))) or
	((msg:find("^[%s]*<Mark of the Wild>:") or msg:find("^[%s]*<Gift of the Wild>:")) and (not (CustomUnitClass("Player") == "Druid"))) or

	((msg:find("^[%s]*<Well Fed>:") or msg:find("^[%s]*<Call Pet>:") or msg:find("^[%s]*<Seal>:") or msg:find("^[%s]*<Mana less then 80[\\%]>:") or msg:find("^[%s]*<Weapon buff>:") or
	msg:find("^[%s]*<Flask or two Elixirs>:") or msg:find("^[%s]*<Low durability>:") or msg:find("^[%s]*<AFK>:") or msg:find("^[%s]*<Missing Focus Magic>:")
			) and (not (msg:find(UnitName("player"))))) or
	msg:find("^[%s]*<Thorns>:")))) and (not (author == UnitName("player"))) then if FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99945] > 0 and (FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[SmarBuffFilter] == nil or FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[SmarBuffFilter] ~= msg) then
	FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[SmarBuffFilter] = msg _G["ChatFrame"..FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99945]]:AddMessage("FCDSmarBuffFilter:".."|Hplayer:"..author.."|h["..author.."]|h"..": "..msg, 1,0.49,0.04) end return true end end

function FlumpFilter(self,_,msg,author) if (	
 msg:find("^[A-Z][%a]+ used |cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-']*]|h|r!$") or 
 msg:find("^|cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-]*]|h|r faded from [A-Z][%a]+[%s]*!$") or 
 msg:find("^[A-Z][%a]+'s |cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-]*]|h|r consumed: [%d]+ heal!$") or 
 msg:find("^[A-Z][%a]+ cast |cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-]*]|h|r on [A-Z][%a]+!$") or
 msg:find("^[A-Z][%a]+'s |cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-]*]|h|r faded from [A-Z][%a]+[%s]*!$") or 
 msg:find("^[A-Z][%a]+ used |cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-]*]|h|r on [A-Z][%a]+!$") or

 msg:find("^[A-Z][%a]+ is creating a |cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-]*]|h|r!$") or 
 msg:find("^{rt[1,2,3,4,5,6,7,8]}[A-Z][%a]+ is creating a |cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-]*]|h|r!$") or 
 msg:find("^[A-Z][%a]+ prepares a |cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-]*]|h|r!$") or 
 msg:find("^{rt[1,2,3,4,5,6,7,8]}[A-Z][%a]+ prepares a |cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-]*]|h|r!$") or 
 msg:find("^[A-Z][%a]+ used a |cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-]*]|h|r!$") or 
 msg:find("^{rt[1,2,3,4,5,6,7,8]}[A-Z][%a]+ used a |cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-]*]|h|r!$") or 

 msg:find("^[A-Z][%a]+'s |cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-]*]|h|r resurrected [A-Z][%a]+!$") or 
 msg:find("^{rt[1,2,3,4,5,6,7,8]}[A-Z][%a]+'s |cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-]*]|h|r resurrected {rt[1,2,3,4,5,6,7,8]}[A-Z][%a]+!$") or 
 msg:find("^{rt[1,2,3,4,5,6,7,8]}[A-Z][%a]+'s |cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-]*]|h|r resurrected [A-Z][%a]+!$") or 
 msg:find("^[A-Z][%a]+'s |cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-]*]|h|r resurrected {rt[1,2,3,4,5,6,7,8]}[A-Z][%a]+!$") or 

--with icons
 msg:find("^{rt[1,2,3,4,5,6,7,8]}[A-Z][%a]+ used |cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-]*]|h|r!$") or 
 msg:find("^{rt[1,2,3,4,5,6,7,8]}[A-Z][%a]+'s |cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-]*]|h|r consumed: [%d]+ heal!$") or 
 msg:find("^{rt[1,2,3,4,5,6,7,8]}|cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-]*]|h|r faded from {rt[1,2,3,4,5,6,7,8]}[A-Z][%a]+!$") or
 msg:find("^{rt[1,2,3,4,5,6,7,8]}[A-Z][%a]+ cast |cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-]*]|h|r on {rt[1,2,3,4,5,6,7,8]}[A-Z][%a]+!$") or
 msg:find("^{rt[1,2,3,4,5,6,7,8]}[A-Z][%a]+'s |cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-]*]|h|r faded from {rt[1,2,3,4,5,6,7,8]}[A-Z][%a]+!$") or
 msg:find("^{rt[1,2,3,4,5,6,7,8]}[A-Z][%a]+'s |cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-]*]|h|r faded from {rt[1,2,3,4,5,6,7,8]}[A-Z][%a]+[%s]*!$") or 
 msg:find("^{rt[1,2,3,4,5,6,7,8]}[A-Z][%a]+ used |cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-]*]|h|r on {rt[1,2,3,4,5,6,7,8]}[A-Z][%a]+!$") or

 msg:find("^[A-Z][%a]+'s |cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-]*]|h|r consumed: [%d]+ heal!$") or 
 msg:find("^|cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-]*]|h|r faded from {rt[1,2,3,4,5,6,7,8]}[A-Z][%a]+!$") or
 msg:find("^[A-Z][%a]+ cast |cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-]*]|h|r on {rt[1,2,3,4,5,6,7,8]}[A-Z][%a]+!$") or
 msg:find("^[A-Z][%a]+'s |cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-]*]|h|r faded from {rt[1,2,3,4,5,6,7,8]}[A-Z][%a]+!$") or
 msg:find("^[A-Z][%a]+'s |cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-]*]|h|r faded from {rt[1,2,3,4,5,6,7,8]}[A-Z][%a]+[%s]*!$") or 
 msg:find("^[A-Z][%a]+ used |cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-]*]|h|r on {rt[1,2,3,4,5,6,7,8]}[A-Z][%a]+!$") or

 msg:find("^{rt[1,2,3,4,5,6,7,8]}|cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-]*]|h|r faded from [A-Z][%a]+!$") or
 msg:find("^{rt[1,2,3,4,5,6,7,8]}[A-Z][%a]+ cast |cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-]*]|h|r on [A-Z][%a]+!$") or
 msg:find("^{rt[1,2,3,4,5,6,7,8]}[A-Z][%a]+'s |cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-]*]|h|r faded from [A-Z][%a]+!$") or
 msg:find("^{rt[1,2,3,4,5,6,7,8]}[A-Z][%a]+'s |cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-]*]|h|r faded from [A-Z][%a]+[%s]*!$")or
  msg:find("^{rt[1,2,3,4,5,6,7,8]}[A-Z][%a]+ used |cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-]*]|h|r on [A-Z][%a]+!$") or

 --vdw
msg:find("^{rt[1,2,3,4,5,6,7,8]}[A-Z][%a]+'s |cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-]*]|h|r faded from {rt[1,2,3,4,5,6,7,8]}Valithria Dreamwalker!$") or 
msg:find("^[A-Z][%a]+'s |cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-]*]|h|r faded from {rt[1,2,3,4,5,6,7,8]}Valithria Dreamwalker!$") or 
msg:find("^{rt[1,2,3,4,5,6,7,8]}[A-Z][%a]+ cast |cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-]*]|h|r on Valithria Dreamwalker!$") or 
msg:find("^[A-Z][%a]+ cast |cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-]*]|h|r on {rt[1,2,3,4,5,6,7,8]}Valithria Dreamwalker!$") or 
msg:find("^{rt[1,2,3,4,5,6,7,8]}[A-Z][%a]+ cast |cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-]*]|h|r on Valithria Dreamwalker!$") or 
msg:find("^{rt[1,2,3,4,5,6,7,8]}[A-Z][%a]+ cast |cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-]*]|h|r on {rt[1,2,3,4,5,6,7,8]}Valithria Dreamwalker!$") or 
msg:find("^[A-Z][%a]+ cast |cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-]*]|h|r on Valithria Dreamwalker!$")) and author ~= UnitName("player") then if FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99944] > 0 and (FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[FlumpFilter] == nil or FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[FlumpFilter] ~= msg) then
	FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[FlumpFilter] = msg _G["ChatFrame"..FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99944]]:AddMessage("FCDFlumpFilter:".."|Hplayer:"..author.."|h["..author.."]|h"..": "..msg, 1,0.49,0.04) end return true end end
function PhoenixStyleFilter(self,_,msg,author) if (--marrow
msg:find("^[%s]*{rt[1,2,3,4,5,6,7,8]}[%s]*%'Coldflame%' debuff got: [A-Z][%a]+ %([%d]+%)") or
msg:find("^[%s]*{rt[1,2,3,4,5,6,7,8]}[%s]*Best %'Bone Spike's%' kill in%:") or
msg:find("^[%s]*{rt[1,2,3,4,5,6,7,8]}[%s]*Bone Spike killed in [\\.%d]* sec. %([A-Z][%a]+%).") or
-- lady
msg:find("^[%s]*{rt[1,2,3,4,5,6,7,8]}[%s]*[A-Z][%a]+ died in/after MC! Got damage from:[%s]*[A-Z][%a]+ %([%d]+k%)") or
msg:find("^[%s]*{rt[1,2,3,4,5,6,7,8]}[%s]*Friendly fire %(to players under MC%):[%s]*[A-Z][%a]+ %([%d]+k%)") or
msg:find("^[%s]*{rt[1,2,3,4,5,6,7,8]}[%s]*'Curse of Torpor' dispelled by:[%s]*[A-Z][%a]+ %([%d]+%)") or
msg:find("^[%s]*{rt[1,2,3,4,5,6,7,8]}[%s]*Got dmg from ghosts explosions:[%s]*[A-Z][%a]+ %([%d]+%)") or
msg:find("^[%s]*{rt[1,2,3,4,5,6,7,8]}[%s]*[A-Z][%a]+ died from [%d]+ Vengeful Shade's explosions%. were triggered by") or
msg:find("^[%s]*{rt[1,2,3,4,5,6,7,8]}[%s]*[A-Z][%a]+ died from [%d]+ Vengeful Shade's explosion%. was triggered by") or
--gunship
msg:find("^[%s]*{rt[1,2,3,4,5,6,7,8]}[%s]*Caught rockets:[%s]*[A-Z][%a]+ %([%d]+%)") or
--dbs
msg:find("^[%s]*{rt[1,2,3,4,5,6,7,8]}[%s]*Blood Beast's wave #[%d]+. killed in [%d]+ sec%. Damage and switch%-time:$") or
msg:find("^[%s]*{rt[1,2,3,4,5,6,7,8]}[%s]*Got attacks from adds %(total%):[%s]*[A-Z][%a]+ %([%d]+%)") or
msg:find("^[%s]*{rt[1,2,3,4,5,6,7,8]}[%s]*Boss healed from attacking tanks with debuff:[%s]*[A-Z][%a]+ %([%d]+%)") or
msg:find("^[%s]*{rt[1,2,3,4,5,6,7,8]}[%s]*Blood Nova. max simultaneously damage:[%s]*[%d]+ %- [A-Z][%a]+") or
msg:find("^[%s]*{rt[1,2,3,4,5,6,7,8]}[%s]*Blood Nova. max simultaneously damage:[%s]*[%d]+$") or
--fester
msg:find("^[%s]*{rt[1,2,3,4,5,6,7,8]}[%s]*Big AoE inc! Not enough debuffs:") or
msg:find("^[%s]*{rt[1,2,3,4,5,6,7,8]}[%s]*Friendly vomit attacks: [A-Z][%a]+ %([%d]+%)") or
msg:find("^[%s]*{rt[1,2,3,4,5,6,7,8]}[%s]*'Vile Gas' that could be avoid received:[%s]*[%d]+$") or
msg:find("^[%s]*{rt[1,2,3,4,5,6,7,8]}[%s]*Got 'Malleable Goo' %(crash%):[%s]*[A-Z][%a]+ %([%d]+%)") or -- pp too
msg:find("^[%s]*{rt[1,2,3,4,5,6,7,8]}[%s]*[A-Z][%a]+ %- got Malleable Goo!$") or -- pp too
(msg:find("^[%s]*[%d]:[%s]*[A-Z][%a]+") and UnitName("boss1") ~= nil and UnitName("boss1") == "Festergut" and msg:find("%.$")) or
--rotface
msg:find("^[%s]*{rt[1,2,3,4,5,6,7,8]}[%s]*Ticks from Slime Spray %(boss breath%):[%s]*[A-Z][%a]+ %([%d]+%)") or
msg:find("^[%s]*{rt[1,2,3,4,5,6,7,8]}[%s]*Missiles of Ooze Explosion received::[%s]*[A-Z][%a]+ %([%d]+%)") or
--pp
msg:find("^[%s]*{rt[1,2,3,4,5,6,7,8]}[%s]*Stand in Slime Puddle %(sec.%):[%s]*[A-Z][%a]+ %([%d]+%)") or
msg:find("^[%s]*{rt[1,2,3,4,5,6,7,8]}[%s]*[A-Z][%a]+ passed 'Unbound Plague' to [A-Z][%a]+ %(stack:[%s]*[%d]+%)$") or 
msg:find("^[%s]*{rt[1,2,3,4,5,6,7,8]}[%s]*Add #[%d]+ %(orange%). killed in [%d]+ sec[\\.] Damage and switch%-time:$") or 
msg:find("^[%s]*{rt[1,2,3,4,5,6,7,8]}[%s]*Add #[%d]+ %(green%). killed in [%d]+ sec. Damage and switch%-time:$") or 
msg:find("^[%s]*{rt[1,2,3,4,5,6,7,8]}[%s]*Mutated Abomination %([%d]+k - $") or 
msg:find("^[%s]*{rt[1,2,3,4,5,6,7,8]}[%s]*Choking Gas Explosion:[%s]*[A-Z][%a]+ %([%d]+%)") or
msg:find("^[%s]*{rt[1,2,3,4,5,6,7,8]}[%s]*[A-Z][%a]+ died from |cff71d5ff|Hspell:[%d]+|h[\\[]Unbound Plague]|h|r in .+ sec%. He had debuff") or
--bpc
msg:find("^[%s]*{rt[1,2,3,4,5,6,7,8]}[%s]*Target switch #[%d]+ %(Prince [A-Z][%a]+%):[%s]*[A-Z][%a]+ %([%d]+[\\.]*[%d]*s%)") or
msg:find("^[%s]*{rt[1,2,3,4,5,6,7,8]}[%s]*Max stacks of Shadow Prison:[%s]*[A-Z][%a]+ %([%d]+%)") or
msg:find("^[%s]*{rt[1,2,3,4,5,6,7,8]}[%s]*Friendly attacks from Empowered Shock Vortex:[%s]*[A-Z][%a]+ %([%d]+[k]*%)") or
msg:find("^[%s]*{rt[1,2,3,4,5,6,7,8]}[%s]*Flame ball killed raider! It was discharged by %([%d][\\.]*[%d]* sec[\\.]%):") or
msg:find("^[%s]*{rt[1,2,3,4,5,6,7,8]}[%s]*[A-Z][%a]+ died from |cff71d5ff|Hspell:[%d]+|h[\\[]Shadow Prison]|h|r[%s]*.[%s]*stack:[%s]*[%d]+ >") or
--bql
--vdw
msg:find("^[%s]*{rt[1,2,3,4,5,6,7,8]}[%s]*Mana Void:[%s]*[A-Z][%a]+ %([%d]+%)") or
msg:find("^[%s]*{rt[1,2,3,4,5,6,7,8]}[%s]*Column of Frost:[%s]*[A-Z][%a]+ %([%d]+%)") or
--sindra
msg:find("^[%s]*{rt[1,2,3,4,5,6,7,8]}[%s]*Marks were on:[%s]*[A-Z][%a]+, [A-Z][%a]+, [A-Z][%a]+, [A-Z][%a]+, [A-Z][%a]+") or
msg:find("^[%s]*{rt[1,2,3,4,5,6,7,8]}[%s]*Boss AoE:[%s]*[A-Z][%a]+ %([%d]+%)") or
msg:find("^[%s]*{rt[1,2,3,4,5,6,7,8]}[%s]*Max stacks of Mystic Buffet: [A-Z][%a]+ %([%d]+%)") or
msg:find("^[%s]*{rt[1,2,3,4,5,6,7,8]}[%s]*Backlash%, [%d]+ phase[%s]*%>[%d]+%% %(dmg %- quantity of debuffs%):[%s]*[A-Z][%a]+ %(") or
msg:find("^[%s]*{rt[1,2,3,4,5,6,7,8]}[%s]*Backlash%, [%d]+ phase[%s]*%<[%d]+%% %(dmg %- quantity of debuffs%):[%s]*[A-Z][%a]+ %(") or
msg:find("^[%s]*{rt[1,2,3,4,5,6,7,8]}[%s]*Losers %(top of Unchained Magic debuffs%):[%s]*[A-Z][%a]+ %([%d]+%)") or
msg:find("^[%s]*{rt[1,2,3,4,5,6,7,8]}[%s]*Frost Bomb damage %(Air phase%):[%s]*[A-Z][%a]+ %([%d]+%)") or
msg:find("^[%s]*{rt[1,2,3,4,5,6,7,8]}[%s]*[A-Z][%a]+ died from |cff71d5ff|Hspell:[%d]+|h[\\[]Backlash]|h|r Reason: [A-Z][%a]+ %(x[%d]+%)") or
--lk
msg:find("^[%s]*{rt[1,2,3,4,5,6,7,8]}[%s]*Damage from Defile #[%d]+ %([A-Z][%a]+%) %- [%d]+") or
msg:find("^[%s]*{rt[1,2,3,4,5,6,7,8]}[%s]*Fail damage to Val'kyr #[%d]+ no dots and aoe %(damage %- count%):[%s]*[A-Z][%a%s]+ %([%d]+") or
msg:find("^[%s]*{rt[1,2,3,4,5,6,7,8]}[%s]*Three Val'kyr #[%d]+ %([A-Z][%a]+ [A-Z][%a]+ [A-Z][%a]+%) Damage and switch%-time:$") or
msg:find("^[%s]*{rt[1,2,3,4,5,6,7,8]}[%s]*Total sec in Defile:[%s]*[A-Z][%a]+ %([%d]+%)") or
msg:find("^[%s]*{rt[1,2,3,4,5,6,7,8]}[%s]*Spirits explodes in this fight:[%s]*[%d]+.$") or
msg:find("^[%s]*{rt[1,2,3,4,5,6,7,8]}[%s]*Harvest Soul. effective heal %(total%):[%s]*[A-Z][%a]+ %([%d]+") or
msg:find("^[%s]*{rt[1,2,3,4,5,6,7,8]}[%s]*[A-Z][%a]+ died with Harvest Soul in .+ sec. Was healed by:[%s]*[A-Z][%a]+") or
--damage done (for more than one boss)
(msg:find("^[A-Z][%a]+ %([%d]+k %- [%d]+%.[%d]*s%)[%s,]*%.%.%.$") and UnitAffectingCombat("player") and UnitName("boss1") ~= nil and UnitName("boss1") == "The Lich King")  or
(msg:find("^[A-Z][%a]+ %([%d]+k %- [%d]+%.[%d]*s%), [A-Z][%a]+ %([%d]+k - [%d]+%.[%d]*s%)") and msg:find("[A-Z][%a]+ %([%d]+k - [%d]+%.[%d]*s%)[%s,]*%.%.%.$") and UnitAffectingCombat("player") and UnitName("boss1") ~= nil and UnitName("boss1") == "The Lich King") or
(msg:find("^[A-Z][%a]+ %([%d]+%), [A-Z][%a]+ %([%d]+%), [A-Z][%a]+ %([%d]+%)") and msg:find("[A-Z][%a]+ %([%d]+%), [A-Z][%a]+ %([%d]+%)%.[%.]*$") and UnitAffectingCombat("player") and UnitName("boss1") ~= nil and UnitName("boss1") == "Prince [A-Z][%a]+") or
(msg:find("^[A-Z][%a]+ %([%d]+k %- [%d]+%), %.%.%.$") and UnitAffectingCombat("player") and UnitName("boss1") ~= nil and UnitName("boss1") == "The Lich King") or
(msg:find("^[A-Z][%a%s]* %([%d]+k %- [%d]+%), [A-Z][%a%s]* %([%d]+k %- [%d]+%), %.%.%.$") and UnitAffectingCombat("player") and UnitName("boss1") ~= nil and UnitName("boss1") == "The Lich King") or
--failed to move EnsidiaFails
msg:find("^[A-Z][%a]+ has failed at not moving %(Choking Gas%) %([%d]+%)$") or
msg:find("^[A-Z][%a]+ has failed at not moving %(Malleable Goo%) %([%d]+%)$") or
msg:find("^[A-Z][%a]+ has failed at not moving %(Mutated Slime%) %([%d]+%)$") or
msg:find("^[A-Z][%a]+ has failed at not moving %(Sticky Ooze%) %([%d]+%)$") or
msg:find("^[A-Z][%a]+ has failed at not moving %(Coldflame%) %([%d]+%)$") or
msg:find("^[A-Z][%a]+ has failed at not moving %(Slime Spray%) %([%d]+%)$") or
msg:find("^[A-Z][%a]+ has failed at not moving %(Bone Storm%) %([%d]+%)$") or
msg:find("^[A-Z][%a]+ has failed at not moving %(Death and Decay%) %([%d]+%)$") or
msg:find("^[A-Z][%a]+ has failed at not moving %(Bone Slice%) %([%d]+%)$") or
msg:find("^[A-Z][%a]+ has failed at not moving %(Emerald Vigor%) %([%d]+%)$") or
msg:find("^[A-Z][%a]+ has failed at not moving %(Column of Frost%) %([%d]+%)") or
msg:find("^[A-Z][%a]+ has failed at not moving %(Call Blood Beast%) %([%d]+%)") or
msg:find("^[A-Z][%a]+ has failed at moving %(Call Blood Beast%) %([%d]+%)") or
msg:find("^[A-Z][%a]+ has failed at not moving %(Kinetic Bomb%) %([%d]+%)") or
msg:find("^[A-Z][%a]+ has failed at not moving %(Ice Tomb%) %([%d]+%)") or
msg:find("^[A-Z][%a]+ has failed at not moving %(Mystic Buffet%) %([%d]+%)") or
msg:find("^[A-Z][%a]+ has failed at not moving %(Swarming Shadows%) %([%d]+%)") or
msg:find("^[A-Z][%a]+ has failed at casting %(Kinetic Bomb%) %([%d]+%)") or
msg:find("^[A-Z][%a]+ has failed at casting %(Uncontrollable Frenzy%) %([%d]+%)") or
msg:find("^[A-Z][%a]+ has failed at not moving %(Defile%) %([%d]+%)") or
msg:find("^[A-Z][%a]+ has failed at not moving %(Death and Decay%) %([%d]+%)") or
msg:find("^[A-Z][%a]+ has failed at not casting %(Instability%) %([%d]+%)") or
msg:find("^[A-Z][%a]+ has failed at not moving %(Spirit Bomb%) %([%d]+%)") or
msg:find("^[A-Z][%a]+ has failed at not moving %(Shadow Trap%) %([%d]+%)") or
msg:find("^[A-Z][%a]+ has failed at not moving %(Remorseless Winter%) %([%d]+%)") or
msg:find("^[A-Z][%a]+ has failed at not moving %(Blistering Cold%) %([%d]+%)") or
msg:find("^[A-Z][%a]+ has failed at not moving %(Tail Smash%) %([%d]+%)") or
msg:find("^[A-Z][%a]+ has failed at being at the wrong place %(Soul Shriek%) %([%d]+%)") or
msg:find("^[A-Z][%a]+ has failed at being at the wrong place %(Shockwave%) %([%d]+%)") or
msg:find("^[A-Z][%a]+ has failed at being at the wrong place %(Pact of the Darkfallen%) %([%d]+%)") or
msg:find("^[A-Z][%a]+ has failed at being at the wrong place %(Frost Breath%) %([%d]+%)") or
msg:find("^[A-Z][%a]+ has failed at not moving %(Frost Bomb%) %([%d]+%)") or
msg:find("^[A-Z][%a]+ has failed at not spreading %(Bloodbolt Splash%) %([%d]+%)") or
msg:find("^[A-Z][%a]+ has failed at not spreading %(Empowered Shock Vortex%) %([%d]+%)") or
msg:find("^[A-Z][%a]+ has failed at switching %([%d]+%)") or
msg:find("^[A-Z][%a]+ has failed at notattacking %([%d]+%)") or
msg:find("^[A-Z][%a]+ has failed at being at the wrong place %([%d]+%)") or
msg:find("^[A-Z][%a]+ has failed at being at the wrong place %(Cleave%) %([%d]+%)") or
msg:find("^[A-Z][%a]+ has failed at not moving %(Explosion%)") )and author ~= UnitName("player") then if FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99943] > 0 and (FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[PhoenixStyleFilter] == nil or FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[PhoenixStyleFilter] ~= msg) then
	FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[PhoenixStyleFilter] = msg _G["ChatFrame"..FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99943]]:AddMessage("FCDPhoenixStyleFilter:".."|Hplayer:"..author.."|h["..author.."]|h"..": "..msg, 1,0.49,0.04) end return true end end
function ImpBallFilter(self,_,msg,author) if author == "Imp in a Ball" then if FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99921] > 0 and (FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[ImpBallFilter] == nil or FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[ImpBallFilter] ~= msg) then
	FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[ImpBallFilter] = msg _G["ChatFrame"..FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99921]]:AddMessage("FCDImpBallFilter:".."|Hplayer:"..author.."|h["..author.."]|h"..": "..msg, 1,0.49,0.04) end return true end end
function WhisperFilter(self,_,msg,author) if (
	(msg:find("^You have") and msg:find("Power Infusion") and msg:find("[\\!]$")) or
	msg:find("^	casting .+ on you, but you're not in line of sight[!]*") or
	msg:find("^<MPR> |cff71d5ff|Hspell:[%d]+|h[\\[]Frost Beacon]|h|r on you! Run away from others[!]+") or
	msg:find("^<DBM> Your version of Deadly Boss Mods is out%-of%-date$") or
	msg:find("^<MPR> You have to bite[!]+$") or
	msg:find("^<B%.M> You have to bite[!]+$") or
	msg:find("^<B%.M> |cff71d5ff|Hspell:[%d]+|h[\\[]Necrotic Plague]|h|r on you[!]* Run to a Shambling Horror[!]*$") or
	msg:find("^<B%.M>[%s]*|cff71d5ff|Hspell:[%d]+|h[\\[]Enervating Brand]|h|r[%s]*on you! Run away!!$") or
	msg:find("^<B%.M>[%s]*|cff71d5ff|Hspell:[%d]+|h[\\[]Gaseous Bloat]|h|r[%s]*on you[!]* Kite it[!]*$") or
	msg:find("^<B%.M>[%s]*|cff71d5ff|Hspell:[%d]+|h[\\[]Frost Beacon]|h|r[%s]*on you! Run away from others[!]+$") or
	msg:find("^<B%.M>[%s]*|cff71d5ff|Hspell:[%d]+|h[\\[]Pain and Suffering]|h|r") or
	msg:find("^Focus Magic Cast On You$") or
	msg:find("^Trick or Treat! Careful! You're at [%d]+% threat on .+%.$") or
	msg:find("^Focus Magic on you$") or
	msg:find("^Power Infusion[!]+$") or
	msg:find("^Thanks For Focus Magic Baby <3$") or
	msg:find("^Thanks For The Innervate$") or
	msg:find("^FM on U$") or
	msg:find("^Trick or Treat!$") or
	msg:find("^Tricks gave you [%d]+ extra damage.$") or
	msg:find("^Thanks For Focus Magic$") or
	msg:find("^|cff71d5ff|Hspell:[%d]+|h[\\[]Curse of Torpor]|h|r on me%. Dispel, please$") or
	msg:find("^|cff71d5ff|Hspell:[%d]+|h[\\[]Tricks of the Trade]|h|r on you%.$") or
	msg:find("^casting Redirección on you, but you're not in line of sight[!]*$") or
	msg:find("^casting .+ on you, but you're not in line of sight[!]*$") or
	msg:find("^Thank you for Focus Magic!$") or
	msg:find("^Thanks For Power Infusion$") or
	msg:find("^Power Infusion casted on you$") or
	msg:find("^Thanks For Power Innervate$") or
	msg:find("^Hand of Protection cast on You!$") or
	msg:find("^Tricks of the Trade on you.$") or
	msg:find("^Pain Suppression cast on You!$") or
	msg:find("^Pain Suppression on You ended!$") or
	msg:find("^<MageNuggets> Focus Magic on you$") or
	msg:find("^<MageNuggets> Thanks for Focus Magic$") or
	msg:find("^[%s]*RSC > You have no Flask and Food Buff!$") or
	msg:find("^[%s]*RSC > You have no Flask or Food Buff!$") or
	msg:find("^[%s]*RSC > You have no Flask!$") or	
	msg:find("^[%s]*RSC > You have no Flask or Elixir!$") or
	msg:find("^[%s]*RSC > You have no Food Buff!$") or
	msg:find("^Power Infusion on You!$") or
	msg:find("^casting .+ on you, but you're out of range!$") or
	msg:find("^{rt[1,2,3,4,5,6,7,8]}[%s]*DEFILE ON YOU![%s]*{rt[1,2,3,4,5,6,7,8]}$") or
	msg:find("^{[Ss][Kk][Uu][Ll][Ll]}[%s]*DEFILE ON YOU![%s]*{[Ss][Kk][Uu][Ll][Ll]}$") or
	msg:find("^<MPR> |cff71d5ff|Hspell:[%d]+|h[\\[]Pain and suffering]|h|r %(5 stacks%) on you[!]+") or
	msg:find("^casting [A-Z][%a%s]* on you, but you're not in line of sight!$")) then if FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99920] > 0 and (FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[WhisperFilter] == nil or FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[WhisperFilter] ~= msg) then
	FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[WhisperFilter] = msg _G["ChatFrame"..FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99920]]:AddMessage("FCDWhisperFilter:".."|Hplayer:"..author.."|h["..author.."]|h"..": "..msg, 1,0.49,0.04) end return true end end
function FlasknFoodFilter(self,_,msg,author) if 
((msg:lower():find("rsc > no flask %(") or msg:lower():find("rsc > everyone has flask and food buff%.") or msg:lower():find("rsc > only one elixir %(") or msg:lower():find("food buff has only %(") or msg:lower():find("no food buff %(") or msg:lower():find("no flask or elixir:") or msg:lower():find("no food buff:")) and not msg:find(UnitName("player")) or
msg:find("^No Flask %([%d]+%): [A-Z][%a]+") or
msg:find("^One Elixir %([%d]+%): [A-Z][%a]+$") or
msg:find("^Not checked %([%d]+%):[%s]*[A-Z][%a]+") or
((msg:find("^No Food Buff %([%d]+%):[%s]*[A-Z][%a]+") or msg:find("^No Food Buff %([%d]+%):[%s]*no one has it!")) and not msg:find(UnitName("player"))) or
(msg:find("^Not Well Fed %([%d]+%): [A-Z][%a]+$") and not msg:find(UnitName("player")))
)and author ~= UnitName("player") then if FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99919] > 0 and (FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[FlasknFoodFilter] == nil or FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[FlasknFoodFilter] ~= msg) then
	FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[FlasknFoodFilter] = msg _G["ChatFrame"..FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99919]]:AddMessage("FCDFlasknFoodFilter:".."|Hplayer:"..author.."|h["..author.."]|h"..": "..msg, 1,0.49,0.04) end return true end end
function RSAFilter(self,_,msg,author) if (
	--pala
msg:find("^Ardent Defender Activated!$") or
msg:find("^Ardent Defender Faded!$") or
msg:find("^Aura Mastery Activated!$") or
msg:find("^Aura Mastery Faded!$") or
msg:find("^Aura Mastery activated!$") or
msg:find("^Aura Mastery has ended!$") or
msg:find("^Hand [Oo]f Freedom on [A-Z][%a]+!$") or
msg:find("^Divine Sacrifice and Guardian activated!$") or
msg:find("^Divine Sacrifice has ended!$") or
msg:find("^Divine Sacrifice activated!$") or
msg:find("^Divine Guardian has ended!$") or
msg:find("^Divine Guardian Activated!$") or
msg:find("^Divine Guardian Faded!$") or
msg:find("^Divine Protection Activated!$") or
msg:find("^Divine Protection activated!$") or
msg:find("^Divine Protection ended!$") or
msg:find("^Divine Protection Faded!$") or
msg:find("^Divine intervention on [A-Z][%a]+!$") or
msg:find("^Forbearance Faded!$") or
msg:find("^Ardent Defender Activated!$") or
msg:find("^Beacon [Oo]f Light cast on [A-Z][%a]+!$") or
msg:find("^Beacon [Oo]f Light on [A-Z][%a]+ has ended!$") or
msg:find("^Hand [Oo]f Freedom cast on [A-Z][%a]+!$") or
msg:find("^Hand [Oo]f Freedom on [A-Z][%a]+!$") or
msg:find("^Hand [Oo]f Protection cast on [A-Z][%a]+!$") or
msg:find("^Hand [Oo]f Sacrifice cast on [A-Z][%a]+!$") or
msg:find("^Hand [Oo]f Sacrifice on [A-Z][%a]+!$") or
msg:find("^Hand [Oo]f Salvation cast on [A-Z][%a]+!$") or
msg:find("^Hand [Oo]f Salvation on [A-Z][%a]+!$") or
msg:find("^Lay [oO]n Hands on [A-Z][%a]+ for [%d]+!$") or
msg:find("^Divine Protection has ended!$") or
msg:find("^Ardent Defender is active again!$") or
msg:find("^Ardent Defender has just saved my life!$") or
	--warlock
msg:find("^Banished [A-Z][%a%s]+!$") or
msg:find("^Banish on [A-Z][%a%s]+ has ended!$") or
msg:find("^Fearing [A-Z][%a%s]+!$") or
msg:find("^Fear on [A-Z][%a%s]+ has ended!$")or
--priest
msg:find("^Hymn of Hope activated!$") or
msg:find("^Hymn of Hope has ended!$") or
msg:find("^Power Infusion on [A-Z][%a]+!$") or
msg:find("^Pain Suppression on [A-Z][%a]+!$") or
msg:find("^Pain Suppression on [A-Z][%a]+ has ended!$") or
msg:find("^[A-Z][%a]+ casted Guardian Spirit on [A-Z][%a]+$") or
msg:find("^Divine Hymn activated!$") or
msg:find("^Divine Hymn over!$")) and author ~= UnitName("player") then if FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99918] > 0 and (FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[RSAFilter] == nil or FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[RSAFilter] ~= msg) then
	FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[RSAFilter] = msg _G["ChatFrame"..FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99918]]:AddMessage("FCDRSAFilter:".."|Hplayer:"..author.."|h["..author.."]|h"..": "..msg, 1,0.49,0.04) end return true end end

function JapChiKorFilter(self,_,msg,author) if msg:find("[\228-\237]") and author ~= UnitName("player") then if FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99914] > 0 and (FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[JapChiKorFilter] == nil or FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[JapChiKorFilter] ~= msg) then
	FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[JapChiKorFilter] = msg _G["ChatFrame"..FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99914]]:AddMessage("FCDJapChiKorFilter:".."|Hplayer:"..author.."|h["..author.."]|h"..": "..msg, 1,0.49,0.04) end return true end end
function RussainFilter(self,_,msg,author) if msg:find("[\208]") and author ~= UnitName("player") then if FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99913] > 0 and (FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[RussainFilter] == nil or FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[RussainFilter] ~= msg) then
	FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[RussainFilter] = msg _G["ChatFrame"..FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99913]]:AddMessage("FCDRussainFilter:".."|Hplayer:"..author.."|h["..author.."]|h"..": "..msg, 1,0.49,0.04) end return true end end

function TauntFilter(self,_,msg,author) if(
	(msg:find("^<WhoTaunted>") and msg:find("taunted") and msg:find("%.$")) or
	(msg:find("^<WhoTaunted>") and msg:find("taunt") and msg:find("against ") and msg:find("!$")) or
	msg:find("^[A-Z][%a]+ taunted [A-Z].* using |cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-:)(]*]|h|r%.$") or
	msg:find("^TAUNT: [A-Z][%a]+ taunted [A-Z].* with |cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-:)(]*]|h|r%.$") or
	msg:find("^TAUNT: [A-Z][%a]+ AOE taunted with |cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-:)(]*]|h|r%.$") or
	msg:find("^TAUNT: [A-Z][%a]+'s taunt |cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-:)(]*]|h|r against .* FAILED: REFLECT!$") or
	msg:find("^TAUNT: [A-Z][%a]+'s taunt |cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-:)(]*]|h|r against .* FAILED: ABSORB!$") or
	msg:find("^TAUNT: [A-Z][%a]+'s taunt |cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-:)(]*]|h|r against .* FAILED: IMMUNE!$") or
	msg:find("^[A-Z][%a]+ taunted my boss target %(.+%) with [A-Z]") or
	msg:find("^[A-Z][%a]+ taunted [A-Z].* %.$") or
	msg:find("^[%s]*NON%-TANK [A-Z][%a]+ taunted my boss target") or
	msg:find("^[%s]*NON%-TANK [A-Z][%a]+ taunted my target") or
	msg:find("^[\\[]RESIST] [A-Z][%a]+ FAILED TO TAUNT his boss target") or
	msg:find("^[A-Z][%a]+ AOE taunted off of [A-Z][%a]+.$") or
	msg:find("^[A-Z][%a]+ taunted my target %(.+%) with Hand of Reckoning$") or
	msg:find("^[A-Z][%a]+ taunted my target %(.+%) with Righteous Defense$") or
	msg:find("[A-Z].+is immune to my taunt!$") or
	msg:find("^[A-Z][%a]+ AOE taunted off of [A-Z][%a]+ using |cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-:)(]*]|h|r%.$")) and author ~= UnitName("player") then if FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99905] > 0 and (FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[TauntFilter] == nil or FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[TauntFilter] ~= msg) then
	FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[TauntFilter] = msg _G["ChatFrame"..FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99905]]:AddMessage("FCDTauntFilter:".."|Hplayer:"..author.."|h["..author.."]|h"..": "..msg, 1,0.49,0.04) end return true end end

function BigBrotherFilter(self,_,msg,author) if (
	msg:find("^[A-Z][%a]+ taunted [A-Z].* with |cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-:)(]*]|h|r$") or
	msg:find("^[A-Z][%a]+ taunted[%s]*{rt[1,2,3,4,5,6,7,8]}[%s]*[A-Z].* with |cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-:)(]*]|h|r$") or

	msg:find("^[A-Z][%a]+ aoe%-taunted [A-Z].+ with |cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-:)(]*]|h|r$") or
	msg:find("^[A-Z][%a]+ cast |cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-:)(]*]|h|r on [A-Z][%a]+$") ) and author ~= UnitName("player") then if FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99910] > 0 and (FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[BigBrotherFilter] == nil or FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[BigBrotherFilter] ~= msg) then
	FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[BigBrotherFilter] = msg _G["ChatFrame"..FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99910]]:AddMessage("FCDBigBrotherFilter:".."|Hplayer:"..author.."|h["..author.."]|h"..": "..msg, 1,0.49,0.04) end return true end end

function LKAnnounceFilter(self,_,msg,author) if (
	msg:find("^Infest #[%d]+ coming up! [\\-] Cooldown: None [\\-] No One$") or
	msg:find("^Defile on caster [A-Z][%a]+$") or
	msg:find("^Shambling Horror [%d]+ Frenzy in [\\.%d]*s! Plague will kill it [%d]+s later[\\.]$") or
	msg:find("^Shambling Horror [%d]+ Frenzy in [.%d]*s! Plague will not kill it!$") or
	msg:find("^Shambling Horror used Enrage [\\-] Stun/Tranq/Cooldown now!$") or
	msg:find("^{[sS][Kk][uU][lL][lL]}Shambling Horror Enrage . Tranquilize now!{[sS][Kk][uU][lL][lL]}$") or
	msg:find("^{rt[1,2,3,4,5,6,7,8]}Shambling Horror Enrage . Tranquilize now!{rt[1,2,3,4,5,6,7,8]}$") or
	msg:find("^{[sS][Kk][uU][lL][lL]}Shambling Horror Frenzy . Stun it or Pain Suppression{[sS][Kk][uU][lL][lL]}$") or
	msg:find("^{rt[1,2,3,4,5,6,7,8]}Shambling Horror Frenzy . Stun it or Pain Suppression{rt[1,2,3,4,5,6,7,8]}$") or
	msg:find("^Infest #[%d]+ coming up!$") or
	msg:find("^Infest coming up! %- Cooldown: None %- No One$") or
	msg:find("^Infest #[%d]+[%s]*[!]*$") or
	msg:find("^Plague will kill Shambling Horror [%d]+ in [%d]+s%.$") or
	msg:find("^{[sS][Kk][uU][lL][lL]}Shambling Horror Frenzy [\\-] Cooldowns on add tank![%s]*{[sS][Kk][uU][lL][lL]}[%s]*$") or
	msg:find("^{[sS][Kk][uU][lL][lL]}Defile on tank [A-Z][%a]+{[sS][Kk][uU][lL][lL]}[%s]*$") or
	msg:find("^{[sS][Kk][uU][lL][lL]}Defile on healer [A-Z][%a]+{[sS][Kk][uU][lL][lL]}[%s]*$") or
	msg:find("^{[sS][Kk][uU][lL][lL]}Defile on caster [A-Z][%a]+{[sS][Kk][uU][lL][lL]}[%s]*$") or
	msg:find("^{[sS][Kk][uU][lL][lL]}Defile on melee [A-Z][%a]+{[sS][Kk][uU][lL][lL]}[%s]*$") or
	msg:find("^{[sS][Kk][uU][lL][lL]}Defile on [A-Z][%a]+{[sS][Kk][uU][lL][lL]}[%s]*$") or
	msg:find("^No AoE stun!$") or
	msg:find("^No AoE slow!$") or
	msg:find("^Warning: Shambling Horro has 10 stacks of Necrotic Plague$") or
	msg:find("^[A-Z][%a]+ pulled aggro on a Raging Spirit!$") or
	msg:find("^[A-Z][%a]+ and [A-Z][%a]+ are like a bi%-ird, they'll only fly awa%-ay%.%.%.$") or
	msg:find("^[A-Z][%a]+, [A-Z][%a]+ and [A-Z][%a]+ are like a bi%-ird, they'll only fly awa%-ay%.%.%.$") or
	msg:find("^[A-Z][%a]+, [A-Z][%a]+, [A-Z][%a]+ and [A-Z][%a]+ are like a bi%-ird, they'll only fly awa%-ay%.%.%.$") or
	msg:find("^[A-Z][%a]+ is like a bi%-ird, he'll only fly awa-ay%.%.%.$") or
	msg:find("^[A-Z][%a]+ is like a bi%-ird, she'll only fly awa%-ay%.%.%.$")) and author ~= UnitName("player") then if FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99908] > 0 and (FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[LKAnnounceFilter] == nil or FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[LKAnnounceFilter] ~= msg) then
	FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[LKAnnounceFilter] = msg _G["ChatFrame"..FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99908]]:AddMessage("FCDLKAnnounceFilter:".."|Hplayer:"..author.."|h["..author.."]|h"..": "..msg, 1,0.49,0.04) end return true end end

function RessFilter(self,_,msg,author) if (
	msg:find("^Why do you build me up, build me up, [A-Z][%a]+ baby, just to let me down, let me down, run me around%.$") or
	msg:find("^[A-Z][%a]+, by accepting this resurrection you hereby accept that you must forfeit your immortal soul to me%. Please click 'Accept' to continue%.$") or
	msg:find("^Casting Redemption on [A-Z][%a]+[%s!]*$") or
	msg:find("^Resurrection on [A-Z][%a]+$") or
	msg:find("^Casting Ancestral Spirit on [A-Z][%a]+$") or
	msg:find("^Revive on [A-Z][%a]+[%s]*!$") or
	msg:find("^Revive casting on [A-Z][%a]+[%s!]*$") or
	msg:find("^Ressing [A-Z][%a]+$") or
	msg:find("^Rezzing [A-Z][%a]+[!]* :%)$") or
	msg:find("^Ressurecting [A-Z][%a]+$") or 
	msg:find("^Rezing like a God Church$") or 
	msg:find("^Casting Revive on [A-Z][%a]+[%s]*!$") or
	msg:find("^Combat ressing >>> [A-Z][%a]+ <<<$") or
	msg:find("^Combat Rez cast on [A-Z][%a]+$") or
	msg:find("^Casting Rebirth on [A-Z][%a]+$") or
	msg:find("^Caffeine pill for [A-Z][%a]+%. comin' right up!$") or
	msg:find("^Did it hurt, [A-Z][%a]+, when you fell from Heaven? Oh, wait. You're dead. I don't know where I was going with that. Nevermind.$") or
	msg:find("^You've come to the right doctor, [A-Z][%a]+%. I'm writing you a prescription for 10mg of [\"]stop taking damage[\"]%.$") or
	msg:find("^Ancient Spirits of Evil, transform this decayed form into a.......[A-Z][%a]+$") or
	msg:find("^Death, Death%. go away%.[A-Z][%a]+ come for [A-Z][%a]+ another day!$") or
	msg:find("^it turns out [A-Z][%a]+ is only %*moslty%* dead%.$") or
	msg:find("^[A-Z][%a]+ fails at life literally$") or
	msg:find("^Remember%. [A-Z][%a]+%. if you do not fear death%. there is nothing you cannot achieve%.%.%. unless you die%.$") or
	msg:find("^Get of the floor%. [A-Z][%a]+%. it does not love you that way$") or
	msg:find("^Get of the floor%. [A-Z][%a]+%. it's not time to AFK yet!$") or
	msg:find("^Hey [A-Z][%a]+ you know it took jesus three days to do this?$") or
	msg:find("^Does anyone know what the respawn timer on [A-Z][%a]+ is?$") or
	msg:find("^Hey [A-Z][%a]+%. think i should start using Amberseeds for this?$") or
	msg:find("^Rezzing [A-Z][%a]+ should aggro every bears%.$") or
	msg:find("^in Soviet Icecrown%. life chooses [A-Z][%a]+!$") or
	msg:find("^Casting Resurrection on [A-Z][%a]+[%s]*[!]*$") or
	msg:find("^Casting Ancestral Spirit on [A-Z][%a]+[%s]*[!]*$") or
	msg:find("^Casting Revive on [A-Z][%a]+[%s]*[!]*$") or
	msg:find("^Come to life, [A-Z][%a]+, you slacker[%s]*!$") or
	msg:find("^Come to life, [A-Z][%a]+, you b00n[%s]*!$")) and author ~= UnitName("player") then if FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99909] > 0 and (FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[RessFilter] == nil or FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[RessFilter] ~= msg) then
	FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[RessFilter] = msg _G["ChatFrame"..FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99909]]:AddMessage("FCDRessFilter:".."|Hplayer:"..author.."|h["..author.."]|h"..": "..msg, 1,0.49,0.04) end return true end end

function DBMAnnounceFilter(self,_,msg,author) if (msg:find("^Frost Beacon icon {rt[1,2,3,4,5,6,7,8]} set on [A-Z][%a]+$") or
	msg:find("^Gas Spore icon {rt[1,2,3,4,5,6,7,8]} set on [A-Z][%a]+$") or
	msg:find("^PCold icon removed from [A-Z][%a]+$") or
	msg:find("^Warning: [A-Z][%a]+ has 5 stacks of Mystic Buffet$")) and author ~= UnitName("player") then if FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99959] > 0 and (FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[DBMAnnounceFilter] == nil or FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[DBMAnnounceFilter] ~= msg) then
	FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[DBMAnnounceFilter] = msg _G["ChatFrame"..FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99959]]:AddMessage("FCDDBMAnnounceFilter:".."|Hplayer:"..author.."|h["..author.."]|h"..": "..msg, 1,0.49,0.04) end return true end end

function CustomMacronWeakaura(self,_,msg,author) if (
	msg:find("^<Keeper>.+|cff71d5ff|Hspell:[%d]+|h[\\[].+]|h|r.*:.+[%d]+ sec.+$") or
	msg:find("^Casted |cff71d5ff|Hspell:[%d]+|h[\\[]Misdirection]|h|r on [A-Z][%a]+$") or
	msg:find("^Casted |cff71d5ff|Hspell:[%d]+|h[\\[]Hand of salvation]|h|r on [A-Z][%a]+$") or
	msg:find("^Activated: |cff71d5ff|Hspell:[%d]+|h[\\[]Aura Mastery]|h|r [%d]s[!]*$") or
	msg:find("^Activated: |cff71d5ff|Hspell:[%d]+|h[\\[]Hand of sacrifice]|h|r on [A-Z][%a]+ %-[%d]s[!]*$") or
	msg:find("^Faded: |cff71d5ff|Hspell:[%d]+|h[\\[]Aura Mastery]|h|r$") or
	msg:find("^[A-Z][%a]+ exploded spirit$") or
	msg:find("^[%s]*Hand Of Freedom used$") or
	msg:find("^Hysteria CD cleared on [A-Z][%a]+$") or
	msg:find("^Pain Suppression CD cleared on [A-Z][%a]+$") or
	msg:find("^Hand of Salvation CD cleared on [A-Z][%a]+$") or
	msg:find("^Aura Mastery CD cleared on [A-Z][%a]+$") or
	msg:find("^%=%=[%s]*[A-Z][%a]+ is dead[!]*[%s]*%=%=$") or
	msg:find("^5 stacks of |cff71d5ff|Hspell:[%d]+|h[\\[]Sunder Armor]|h|r applied on .+ in .+ sec[!]*$") or
	msg:find("^|cff71d5ff|Hspell:[%d]+|h[\\[]Sunder Armor]|h|r applied on .+ in .+ sec[!]*$") or
	msg:find("^|cff71d5ff|Hspell:[%d]+|h[\\[]Holy Wrath]|h|r Hit [%d]+ targets[!]*$") or
	msg:find("^|cff71d5ff|Hspell:[%d]+|h[\\[]Holy Wrath]|h|r Hit [%d]+ targets[!]* %(.+%)$") or
	msg:find("^Faded: |cff71d5ff|Hspell:[%d]+|h[\\[]Hand of Sacrifice]|h|r$") or
	msg:find("^Activated: |cff71d5ff|Hspell:[%d]+|h[\\[]Hammer of Justice]|h|r on [A-Z][%a]+[!]*$") or
	msg:find("^Activated: |cff71d5ff|Hspell:[%d]+|h[\\[]Hymn of Hope]|h|r[!]*$") or
	msg:find("^Misdirection on [A-Z][%a]+[%s]+[!]+$") or
	msg:find("^|cff71d5ff|Hspell:[%d]+|h[\\[]Dispel Magic]|h|r Removed: |cff71d5ff|Hspell:[%d]+|h[\\[].+]|h|r from me$") or
	msg:find("^Hand of Salvation on [A-Z][%a]+$") or
	msg:find("^Aura Mastery up[!]*$") or
	msg:find("^[A-Z][%a]+ cast Misdirection on[%s]*{rt[1,2,3,4,5,6,7,8]}[%s]*[A-Z][%a]+$") or
	msg:find("^[A-Z][%a]+ cast Misdirection on [A-Z][%a]+$") or
	msg:find("^[A-Z][%a]+ cast Tricks of the Trade on[%s]*{rt[1,2,3,4,5,6,7,8]}[%s]*[A-Z][%a]+$") or
	msg:find("^[A-Z][%a]+ cast Tricks of the Trade on [A-Z][%a]+$") or
	msg:find("^[A-Z][%a]+ cast Misdirection on[%s]*{rt[1,2,3,4,5,6,7,8]}[%s]*[A-Z][%a]+$") or
	msg:find("^[A-Z][%a]+ used Bloodlust$") or
	msg:find("^[A-Z][%a]+ used Commanding Shout$") or
	msg:find("^[A-Z][%a]+ used Aura Mastery$") or
	msg:find("^[A-Z][%a]+ cast Power Infusion on [A-Z][%a]+$") or
	msg:find("^[A-Z][%a]+ cast Innervate on [A-Z][%a]+$") or
	msg:find("^[A-Z][%a]+ cast Hand of Salvation on [A-Z][%a]+$") or
	msg:find("^[A-Z][%a]+ cast Hand of Freedom on [A-Z][%a]+$") or
	msg:find("^[A-Z][%a]+ cast Hand of Protection on [A-Z][%a]+$") or
	msg:find("^[A-Z][%a]+ cast Hysteria on [A-Z][%a]+$") or
	msg:find("^[A-Z][%a]+ cast Pain Suppression on [A-Z][%a]+$") or
	msg:find("^[A-Z][%a]+ cast Pain Suppression on[%s]*{rt[1,2,3,4,5,6,7,8]}[%s]*[A-Z][%a]+$") or
	msg:find("^[A-Z][%a]+ cast Rebirth on [A-Z][%a]+$") or
	msg:find("^[A-Z][%a]+ used Mana Tide Totem$") or
	msg:find("^[A-Z][%a]+ used Divine Hymn$") or
	msg:find("^[A-Z][%a]+ used Army of the Dead$") or
	msg:find("^Misdirected used on [A-Z][%a]+ !!$") or
	msg:find("^%>%>%> Bubblewall is ACTIVE! %<%<%<$") or
	msg:find("^%>%>%> Bubblewall is down%. %<%<%<$") or
	msg:find("^%>%>%> |cff71d5ff|Hspell:[%d]+|h[\\[]Divine Sacrifice]|h|r is ACTIVE!! Please Watch my health! %<%<%<$") or
	msg:find("^%>%>%> Death AVERTED%. Ardent Defender is my hero and healed me for [%d]+%. %<%<%<$") or
	msg:find("^%>%>%> |cff71d5ff|Hspell:[%d]+|h[\\[]Divine Sacrifice]|h|r is down %<%<%<$") or
	msg:find("^[%s]*%=%=[%s]*Divine Sacrifice up for [%d]+[%s]*seconds%. Taking more damage[!]*[%s]*%=%=[%s]*$") or
	msg:find("^[%s]*%=%=[%s]*Divine Sacrice up for [%d]+[%s]*seconds%. Taking more damage[!]*[%s]*%=%=[%s]*$") or
	msg:find("^Divine Sacrifice expires in [%d]+ seconds%.$") or
	msg:find("^[%s]*%=%=[%s]*Divine Sacrifice expired[!]*[%s]*%=%=$") or
	msg:find("^NEED MANA!$") or
	msg:find("^Skin Protect On[%s]*[!]*$") or
	msg:find("^Casted MD$") or
	msg:find("^Innervate on [A-Z][%a]+$") or
	msg:find("^[A-Z][%a]+ use AM with |cff71d5ff|Hspell:[%d]+|h[\\[][%a]+]|h|r$") or
	msg:find("^[A-Z][%a]+'s |cff71d5ff|Hspell:[%d]+|h[\\[][%a]+]|h|r AM faded$") or
	msg:find("^[A-Z][%a]+ used |cffffffff|Hitem:40211:0:0:0:0:0:0:0:0|h[\\[]Potion of Speed]|h|r$") or
	msg:find("^[A-Z][%a]+ used |cffffffff|Hitem:40212:0:0:0:0:0:0:0:0|h[\\[]Potion of Wild Magic]|h|r$") or
	msg:find("^Health swap: Prince [A-Z][%a]+$") or
	msg:find("^Shock zone: [A-Z][%a]+$") or
	msg:find("^Casting Shock[!]+$") or
	msg:find("^Empowered Flames: [A-Z][%a]+$") or
	msg:find("^Shadows: [A-Z][%a]+$") or
	msg:find("^Delirious Slash: [A-Z][%a]+$") or
	msg:find("^Pact: [A-Z][%a]+, [A-Z][%a]+$") or
	msg:find("^Pact: [A-Z][%a]+, [A-Z][%a]+, [A-Z][%a]+$") or
	msg:find("^Lay Waste$") or
	msg:find("^Blazing Skeleton soon[!]+$") or
	msg:find("^Portals [%d]+ up in [%d]+ sec[!]+$") or
	msg:find("^Portals up[!]+$") or
	msg:find("^ToT UP on me!$") or
	msg:find("^Unchained magic on YOU[!]+$") or
	msg:find("^Explosion[!]+$") or
	msg:find("^Unstable x[%d]+[!]+$") or
	msg:find("^Air Phase[!]+$") or
	msg:find("^Frost Beacon: [A-Z][%a]+, [A-Z][%a]+$") or
	msg:find("^Frost Beacon: [A-Z][%a]+$") or
	msg:find("^Magic x[%d]+[!]+$") or
	msg:find("^Shambling Horror$") or
	msg:find("^Infest$") or
	msg:find("^Necrotic Plague: [A-Z][%a]+$") or
	msg:find("^Enrage$") or
	msg:find("^Remorseless Winter Casting$") or
	msg:find("^Enrage on Shambling Horror$") or
	msg:find("^Raging Spirit on YOU$") or
	msg:find("^Raging Spirit: [A-Z][%a]+$") or
	msg:find("^Quake Casting$") or
	msg:find("^Val'kyr$") or
	msg:find("^Val'kyrs Hugged: [A-Z][%a]+$") or
	msg:find("^Soul Reaper: [A-Z][%a]+$") or
	msg:find("^Defile: [A-Z][%a]+$") or
	msg:find("^Harvet Soul: [A-Z][%a]+$") or
	msg:find("^Vile Spirits$") or
	msg:find("^has cast |cff71d5ff|Hspell:[%d]+|h[\\[]Divine Sacrifice]|h|r$") or
	msg:find("^Casting Bress on [A-Z][%a]+[!]*$") or
	msg:find("^Casting Innervate on [A-Z][%a]+[!]*$") or
	msg:find("^Necrotic Plague on me[%s]*[!]*$") or
	msg:find("^Soulstoning [>]*[%s]*[A-Z][%a]+[%s]*[<]*[%s]*Now[!]*$") or
	msg:find("^Lay on Hands on [A-Z][%a]+ at [%d]+ health%.$") or
	msg:find("^Innervate [Oo]n Holy Pala[!]*%([A-Z][%a]+%)$") or
	msg:find("^Salvation [A-Z][%a]+[!]* ROAR AGGRO[%S]*[:]*[%D]*$") or
	msg:find("^Guardian Spirit up, quit dying you fools$") or
	msg:find("^Malleable goo spawning!$") or
	msg:find("^Choking gas spawning!$") or
	msg:find("^Spirits spawning!$") or
	msg:find("^PainSuppression on [A-Z][%a]+ %(Tank%-Pala%) Please[!]*$") or
	msg:find("^Valkyr Shadowguard grabbed [A-Z][%a]+$") or
	msg:find("^{rt[1,2,3,4,5,6,7,8]}[%s]*{rt[1,2,3,4,5,6,7,8]}[%s]*[A-Z][%a]+ grabbed[!]*[%s]*{rt[1,2,3,4,5,6,7,8]}$") or
	msg:find("^Using GTS$") or
	msg:find("^Lady on Hans on [A-Z][%a]+ at [%d]+ health%.$") or
	msg:find("^Innervate On Holy Pala![\\[][A-Z][%a]+]$") or
	msg:find("^>> Opening Summoning Portal << Clicky clicky!$") or
	msg:find("^%-%->[%s]*[A-Z][%a]+ is soulstoned![%s]*<%-%-$") or
	msg:find("^Misdirected [A-Z][%a]+$") or
	msg:find("^Why does [A-Z][%a]+ always go afk when soulstoned?[!]+$") or
	msg:find("^All hail to the magic fingers of [A-Z][%a]+[!]+$") or
	msg:find("^Fools! Dont just stand there looking at the portal - click on it so we can summon those scrubs!$") or
	msg:find("^[A-Z][%a]+ casted Hand of Salvation on [A-Z][%a]+$") or
	msg:find("^[A-Z][%a]+ casted Hand of Freedom on [A-Z][%a]+$") or
	msg:find("^[A-Z][%a]+ casted Innervate on [A-Z][%a]+$") or
	msg:find("^[A-Z][%a]+ casted Hand of Protection on [A-Z][%a]+$") or
	msg:find("^[A-Z][%a]+ casted Hand of Sacrifice on [A-Z][%a]+$") or
	msg:find("^[A-Z][%a]+ casted Hand of Freedom on [A-Z][%a]+$") or
	msg:find("^Pain Suppression is up on [A-Z][%a]+$") or
	msg:find("^Misdirection [A-Z][%a]+$") or
	msg:find("^Started to cast |cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-:)(]*]|h|r on [A-Z][%a]+$") or
	msg:find("^Using Divine Hymn$") or
	msg:find("^Using Hymn of Hope$") or
	msg:find("^[A-Z][%a]+ picked up!$") or
	msg:find("^Aura Mastery is down[%s!]*$") or
	msg:find("^Aura Mastery is up[%s!]*$") or
	msg:find("^|cff71d5ff|Hspell:[%d]+|h[\\[]Aura Mastery]|h|r is up[%s!]*$") or
	msg:find("^|cff71d5ff|Hspell:[%d]+|h[\\[]Aura Mastery]|h|r is down[%s!]*$") or
	msg:find("^Valkyr Shadowguard grabbed[%s]*{rt[1,2,3,4,5,6,7,8]}[%s]*[A-Z][%a]+$") or
	msg:find("^Valkyr Shadowguard[%s]*{rt[1,2,3,4,5,6,7,8]}[%s]*grabbed [A-Z][%a]+$") or
	msg:find("^Innervate cast on [A-Z][%a]+$") or
	msg:find("^Arcanum Taxi Cab! Please click on the portal so we can get this show on the road%.$") or
	msg:find("^If you click on the portal, we might get this party started a lot quicker!$") or
	msg:find("^Why does [A-Z][%a]+ always go afk when they are soulstoned%?!!!$") or
	msg:find("^[A-Z][%a]+ is casting |cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-:)(]*]|h|r%. Click!$") or
	msg:find("^Casted |cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-:)(]*]|h|r on [A-Z][%a]+ %([%d\\.]*%% mana%)$") or
	msg:find("^Casted |cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-:)(]*]|h|r on [A-Z][%a]+ %([%d\\.]*%% hp%)$")	) and author ~= UnitName("player") then if FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99907] > 0 and (FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[CustomMacronWeakaura] == nil or FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[CustomMacronWeakaura] ~= msg) then
	FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[CustomMacronWeakaura] = msg _G["ChatFrame"..FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99907]]:AddMessage("FCDCustomMacronWeakaura:".."|Hplayer:"..author.."|h["..author.."]|h"..": "..msg, 1,0.49,0.04) end return true end end

function OptiTauntFilter(self,_,msg,author) if (
	msg:find("^%+%+%+ .+ activated %([%d]+s%)[%s]*%+%+%+$") or
	msg:find("^%-%-%- .+ ends %-%-%-$") or
	msg:find("^Kicked .+ by .* %([%d]+s%)$") or
	msg:find("^%>%>%>.+%([%d]+%s) %- DISPEL[%s]*%<%<%<$") or
	msg:find("^%>%>%>.+ %([%d]+s%) %- STUNNED%<%<%<$") or
	msg:find("^%>%>%>.+ %([%d]+s%) %- ABOLISH DISEASE[%s]*%<%<%<$")) and author ~= UnitName("player") then if FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99905] > 0 and (FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[OptiTauntFilter] == nil or FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[OptiTauntFilter] ~= msg) then
	FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[OptiTauntFilter] = msg _G["ChatFrame"..FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99905]]:AddMessage("FCDOptiTauntFilter:".."|Hplayer:"..author.."|h["..author.."]|h"..": "..msg, 1,0.49,0.04) end return true end end

function AchivmentFailsFilter(self,_,msg,author) if (msg:find("^{[Ss][Kk][Uu][Ll][LL]}[%s]*|cffffff00|Hachievement.+[%s]*failed!") or
		msg:find("^{rt[1,2,3,4,5,6,7,8]}[%s]*|cffffff00|Hachievement.+[%s]*failed!")) and author ~= UnitName("player") then if FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99904] > 0 and (FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[AchivmentFailsFilter] == nil or FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[AchivmentFailsFilter] ~= msg) then
	FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[AchivmentFailsFilter] = msg _G["ChatFrame"..FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99904]]:AddMessage("FCDAchivmentFailsFilter:".."|Hplayer:"..author.."|h["..author.."]|h"..": "..msg, 1,0.49,0.04) end return true end end

function RankWatchFilter(self,_,msg,author) if msg:find("^[\\[]RankWatch[\\]] [A-Z][%a]+ used |cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-:)(]*]|h|r Rank [%d]+, which is replaced at level [%d]+ by |cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-:)(]*]|h|r Rank [%d]+%.$") and author ~= UnitName("player") then if FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99936] > 0 and (FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[RankWatchFilter] == nil or FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[RankWatchFilter] ~= msg) then
	FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[RankWatchFilter] = msg _G["ChatFrame"..FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99936]]:AddMessage("FCDRankWatchFilter:".."|Hplayer:"..author.."|h["..author.."]|h"..": "..msg, 1,0.49,0.04) end return true end end

function OmenFilter(self,_,msg,author) if msg:find("^Passed [%d]+%% of [A-Z][%a]+'s threat!$") and author ~= UnitName("player") then if FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99931] > 0 and (FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[OmenFilter] == nil or FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[OmenFilter] ~= msg) then
	FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[OmenFilter] = msg _G["ChatFrame"..FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99931]]:AddMessage("FCDOmenFilter:".."|Hplayer:"..author.."|h["..author.."]|h"..": "..msg, 1,0.49,0.04) end return true end end

function InterruptFilter(self,_,msg,author) if msg:find("^Interrupted .+'s |cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-:)(]*]|h|r[!]+$") and author ~= UnitName("player") then if FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99932] > 0 and (FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[InterruptFilter] == nil or FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[InterruptFilter] ~= msg) then
	FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[InterruptFilter] = msg _G["ChatFrame"..FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99932]]:AddMessage("FCDInterruptFilter:".."|Hplayer:"..author.."|h["..author.."]|h"..": "..msg, 1,0.49,0.04) end return true end end

function RaidLootNeed(self,_,msg,author) if (msg:lower():find("[%a]+ has selected need for: ") or msg:lower():find("need roll %- [%d]+ for ")) and UnitInRaid("player") then if FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99940] > 0 and (FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[RaidLootNeed] == nil or FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[RaidLootNeed] ~= msg) then
	FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[RaidLootNeed] = msg _G["ChatFrame"..FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99940]]:AddMessage("FCDRaidLootNeed:"..msg, 1,0.49,0.04) end return true end end 

function RaidLootGreed(self,_,msg,author) if (msg:lower():find("[%a]+ has selected greed for: ") or msg:lower():find("greed roll %- [%d]+ for ")) and UnitInRaid("player") then if FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99939] > 0 and (FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[RaidLootGreed] == nil or FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[RaidLootGreed] ~= msg) then
	FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[RaidLootGreed] = msg _G["ChatFrame"..FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99939]]:AddMessage("FCDRaidLootGreed:"..msg, 1,0.49,0.04) end return true end end 

function RaidLootPass(self,_,msg,author) if msg:lower():find("[%a]+ passed on: ") and UnitInRaid("player") then if FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99942] > 0 and (FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[RaidLootPass] == nil or FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[RaidLootPassRaidLootPass] ~= msg) then
	FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[RaidLootPass] = msg _G["ChatFrame"..FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99942]]:AddMessage("FCDRaidLootPass:"..msg, 1,0.49,0.04) end return true end end 

function RaidLootDE(self,_,msg,author) if (msg:lower():find("[%a]+ has selected disenchant for: ") or msg:lower():find("disenchant roll %- [%d]+ for ")) and UnitInRaid("player") then if FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99941] > 0 and (FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[RaidLootDE] == nil or FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[RaidLootDE] ~= msg) then
	FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[RaidLootDE] = msg _G["ChatFrame"..FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99941]]:AddMessage("FCDRaidLootDE:"..msg, 1,0.49,0.04) end return true end end 

function RaidPoorLoot(self,_,msg,author) if msg:find("^[A-Z][%a]+ receives loot:[%s]*|cff9d9d9d|Hitem:[%d]+:0:0:0:0:0:0:0:[%d]+|h[\\[].+]|h|r") and UnitInRaid("player") then if FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99898] > 0 and (FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[RaidPoorLoot] == nil or FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[RaidPoorLoot] ~= msg) then
	FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[RaidPoorLoot] = msg _G["ChatFrame"..FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99898]]:AddMessage("FCDRaidLootDE:"..msg, 1,0.49,0.04) end return true end end 

function AnnounceFilter(self,_,msg,author) if (
	msg:find("^|cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-:)(]*]|h|r on [A-Z].+!$") or
	msg:find("^Faded: |cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-:)(]*]|h|r on [A-Z].+!$") or
	msg:find("^|cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-:)(]*]|h|r!$")) and author ~= UnitName("player") then if FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99899] > 0 and (FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[AnnounceFilter] == nil or FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[AnnounceFilter] ~= msg) then
	FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[AnnounceFilter] = msg _G["ChatFrame"..FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99899]]:AddMessage("AnnounceFilter:"..msg, 1,0.49,0.04) end return true end end 

function ReadyCheckMessages(self,_,msg,author) if (
	msg:find("^Ready Check: The following players are Away: [A-Z][%a]+") or
	msg:find("^Ready Check: Everyone is Ready$")) and author ~= UnitName("player") then if FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99859] > 0 and (FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[ReadyCheckMessages] == nil or FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[ReadyCheckMessages] ~= msg) then
	FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[ReadyCheckMessages] = msg _G["ChatFrame"..FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99859]]:AddMessage("FCDReadyCheckMessages:".."|Hplayer:"..author.."|h["..author.."]|h"..": "..msg, 1,0.49,0.04) end return true end end
function IconsSpamPP(self,_,msg,author) if UnitInRaid("player") and UnitAffectingCombat("player") and UnitName("boss1") == "Professor Putricide" then
 if FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99873] > 0 and
 	(FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[IconsSpamPP] == nil or FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[IconsSpamPP] ~= msg) then
	FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[IconsSpamPP] = msg _G["ChatFrame"..FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99873]]:AddMessage("FCDIconsSpamPP:".."|Hplayer:"..author.."|h["..author.."]|h"..": "..msg, 1,0.49,0.04) end return true end end

function MRTReciveLootSpam(self,_,msg,author) if (
	msg:find("^|cff.+|Hitem:.+|h[\\[].+]|h|r$") or
	msg:find("^|cff.+|Hitem:.+|h[\\[].+]|h|r[%s]*BiS: [A-Z].+%(.+") or
	msg:find("^Not eligible: [A-Z][%a]+")) and author ~= UnitName("player") then if FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99865] > 0 and (FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[MRTReciveLootSpam] == nil or FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[MRTReciveLootSpam] ~= msg) then
	FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[MRTReciveLootSpam] = msg _G["ChatFrame"..FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99865]]:AddMessage("MRTReciveLootSpam:".."|Hplayer:"..author.."|h["..author.."]|h"..": "..msg, 1,0.49,0.04) end return true end end 

function GBuyingSelling(self,_,msg,author) if (
	msg:lower():find("^w[%s]*t[%s]*b[^%a]+") or msg:lower():find("[%s]+w[%s]*t[%s]*b[^%a]+") or
	msg:lower():find("^w[%s]*t[%s]*s[^%a]+") or msg:lower():find("[%s]+w[%s]*t[%s]*s[^%a]+") or
	msg:lower():find("^buy[%s]+") or msg:lower():find("[%s]+buy[%s]+") or
	msg:lower():find("^buying[%s]+") or msg:lower():find("[%s]+buying[%s]+") or
	msg:lower():find("^sell[%s]") or msg:lower():find("[%s]+sell[%s]+") or
	msg:lower():find("^selling[%s]+") or msg:lower():find("[%s]+selling[%s]+") or
	msg:lower():find("^trade[%s]+") or msg:lower():find("[%s]+trade[%s]+") or
	msg:lower():find("^c[\\.]o[\\.]d[%s]+") or msg:lower():find("[%s]+c[\\.]o[\\.]d[%s]+") or
	msg:lower():find("^c[%s]*o[%s]*d[%s]+") or msg:lower():find("[%s]+c[%s]*o[%s]*d[%s]+") or
	msg:lower():find("^lfw[%s]+") or msg:lower():find("[%s]+lfw[%s]+") or
	msg:lower():find("^wtt[%s]+") or msg:lower():find("[%s]+wtt[%s]+") or
	msg:lower():find("^coins[%s]+") or msg:lower():find("[%s]+coins[%s]+") or
	msg:lower():find("^warmane[%s]+market[%s]+") or msg:lower():find("[%s]+warmane[%s]*market[%s]+") or
	msg:lower():find("^warmane[%s]*trade[%s]+") or msg:lower():find("^warmane[%s]*trade[%s]+") or
	msg:lower():find("^for sale") or msg:lower():find("[%s]+for sale[%.]*[%s]+") or

	(msg:lower():find("[%s]+someone[%s]+") and msg:lower():find("[%s]+provide[%s]+") and msg:lower():find("[%s]+supply[%s]+")) or
	(msg:lower():find("[%s]+ah[%s]+") and msg:lower():find("[%s]+cheap[%s]+") and msg:lower():find("[%d]+g")) or
	(msg:lower():find("[%s]+salam[%s]+") and msg:lower():find("[%s]+gold[%s]+")) or
	(msg:lower():find("[%s]+warmane[%s]+") and msg:lower():find("[%s]+character[%s]+") and msg:lower():find("[%s]+sale[%s]+")) or
	(msg:lower():find("[%s]+gold[%s]+") and msg:lower():find("[%s]+trading[%s]+")) or 

	msg:lower():find("^jc[%s]+") or msg:lower():find("[%s]+jc[%s]+") or
	msg:lower():find("^jwc[%s]+") or msg:lower():find("[%s]+jwc[%s]+") or
	msg:lower():find("^bs[%s]+") or msg:lower():find("[%s]+bs[%s]+") or
	msg:lower():find("^lw[%s]+") or msg:lower():find("[%s]+lw[%s]+") or


	((msg:lower():find("alchemy") or
	msg:lower():find("blacksmith") or
	msg:lower():find("enchant") or
	msg:lower():find("inscription") or
	msg:lower():find("scribe") or
	msg:lower():find("jewelcrafting") or
	msg:lower():find("jewelcrafter") or
	msg:lower():find("leatherwork") or
	msg:lower():find("tailor") or
	msg:lower():find("transmu") or
	msg:lower():find("alchemy") or
	msg:lower():find("jeweler"))
	and (msg:lower():find("lf") or msg:lower():find("wtb") or msg:lower():find("any") or msg:lower():find("wts") or msg:lower():find("free") or msg:lower():find("mats"))) 
	
	) and not (
		author == UnitName("player") or
		msg:lower():find("recruit") or
		msg:lower():find("active") or
		msg:lower():find("progress") or
		(msg:lower():find("[^%a]core[^%a]") and not msg:lower():find("wts")) or
		(msg:lower():find("raid") and not (msg:lower():find("mount") or msg:lower():find("raiding achiev") or msg:lower():find("discount") or msg:lower():find("discount") or msg:lower():find("tailor") or
			msg:lower():find("name") or msg:lower():find("warmane trade") or msg:lower():find("for more info") or msg:lower():find("cheap"))) or
		(msg:lower():find("icc") and not (msg:lower():find("patter") or msg:lower():find("boost") or msg:lower():find("selling") or msg:lower():find("trade") or msg:lower():find("trade"))) or
		(msg:lower():find("toc") and not (msg:lower():find("boost"))) or msg:lower():find("naxx") or msg:lower():find("ulduar") or 
		(msg:lower():find("rs") and not (msg:lower():find("[%a]rs") or msg:lower():find("rs[%a]") or msg:lower():find("selling") or msg:lower():find("trade") or msg:lower():find("wts") or msg:lower():find("glory") or (msg:lower():find("warmane") and msg:lower():find("trade")))) )

 then if FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99871] > 0 and 
 	(FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[GBuyingSelling] == nil or FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[GBuyingSelling] ~= msg) then
	FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[GBuyingSelling] = msg _G["ChatFrame"..FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99871]]:AddMessage("FCDGBuyingSelling:".."|Hplayer:"..author.."|h["..author.."]|h"..": "..msg, 1,0.49,0.04)
end return true end end 

function GArena(self,_,msg,author) if 
  	((msg:lower():find("arena") or
  	msg:lower():find("just the two of us:") or
  	msg:lower():find("[235][']*s") or
  	msg:lower():find("10[%s]*games") or msg:lower():find("ten games") or
  	msg:lower():find("2[%s]*v[%s]*2") or msg:lower():find("3[%s]*v[%s]*3") or msg:lower():find("5[%s]*v[%s]*5") or
  	msg:lower():find("[235]vs") or
  	msg:lower():find("2[%s]*x[%s]*2") or msg:lower():find("3[%s]*x[%s]*3") or msg:lower():find("5[%s]*x[%s]*5")) and

  	(msg:lower():find("lf[m]*[^%a]") or msg:lower():find("partner") or msg:lower():find("team") or msg:lower():find("games") or msg:lower():find("que") or msg:lower():find("join") or msg:lower():find("play 10") or 
  		msg:lower():find("anyone 10") or msg:lower():find("points") or
  	(msg:lower():find("looking for") and msg:lower():find("mate"))))

and not (author == UnitName("player") or msg:lower():find("rep") or msg:lower():find("guild") or msg:lower():find("farm") or msg:lower():find("recruit") or msg:lower():find("active") or
 msg:lower():find("core") or msg:lower():find("raid") or msg:lower():find("progress") or msg:lower():find("wts") or msg:lower():find("wtb") or msg:lower():find("quest") or msg:lower():find("help") or
 msg:lower():find("drak") or msg:lower():find("icc") or msg:lower():find("toc") or msg:lower():find("voa") or msg:lower():find("nax[x]*") or msg:lower():find("ulduar") or 
  (msg:lower():find("rs") and (not(msg:lower():find("[%a]rs") or msg:lower():find("rs[%a]")))))

 then if FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99870] > 0 and 
 	(FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[GArena] == nil or FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[GArena] ~= msg) then
	FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[GArena] = msg _G["ChatFrame"..FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99870]]:AddMessage("FCDGArena:".."|Hplayer:"..author.."|h["..author.."]|h"..": "..msg, 1,0.49,0.04)
end return true end end 

function GGuild(self,_,msg,author) if 
	 (	(msg:lower():find("guild") and
    	  			not ((msg:lower():find("[%a]run") and msg:lower():find("run[%a]")) or
    	  			    	  		 	msg:lower():find("semi") or
    	  			    	  		 	msg:lower():find("run") or
    	  			                    msg:lower():find("carrying") or
    	  			                    msg:lower():find("lfm")) ) or

    
    ((msg:lower():find("recruit") or msg:lower():find("recrut") or msg:lower():find("active") or msg:lower():find("endgame") or msg:lower():find("high-end") or msg:lower():find("premades") or msg:lower():find("tournaments") or msg:lower():find("socialable community") or
    msg:lower():find("core") or msg:lower():find("looking for") or msg:lower():find("progres") or msg:lower():find("shivtr") or msg:lower():find("search") or msg:lower():find("hardcore")) and

    ((msg:lower():find("player") and (not(msg:lower():find("10 player") or msg:lower():find("25 player"))) ) or msg:lower():find("server time") or msg:lower():find("pm for info") or msg:lower():find("raiders") or
    (msg:lower():find("raid") and (msg:lower():find("time") or msg:lower():find("day") )) or msg:lower():find("dkp") or msg:lower():find("expirenced") or msg:lower():find("for more info") or
     msg:lower():find("twink") or msg:lower():find("members") or msg:lower():find("raids") or msg:lower():find("endgame content") or msg:lower():find("join") or msg:lower():find("time zone") or
     msg:lower():find("newly formed") or msg:lower():find("rebuild") or msg:lower():find("application") or msg:lower():find("rebuild") or msg:lower():find("rebuild") or msg:lower():find("fill ranks") or
     (msg:lower():find("[\\<][%a]+[\\>]") and msg:lower():find("[^%a]rs[^%a]") and msg:lower():find("icc") ) or
     (msg:lower():find("[^%a]st[^%a]") and (msg:lower():find("info") or msg:lower():find("apply"))) )) or

    	  		(msg:lower():find("[^%a]rs[^%a]") and (msg:lower():find("icc") or msg:lower():find("lod")) and ((msg:lower():find("togc") or msg:lower():find("progres")) or msg:lower():find("recrut") or msg:lower():find("progres")) and msg:lower():find("[\\>]")
    	  			and msg:lower():find("[\\<]")) or

    	  		(msg:lower():find("[\\>]") and msg:lower():find("[\\<]") and
    	  			(msg:lower():find("recruit") or msg:lower():find("roster") or msg:lower():find("guild") or msg:lower():find("dkp")) and
    	  				(msg:lower():find("team") or msg:lower():find("participate") or
                 msg:lower():find("raid") or msg:lower():find("players") or msg:lower():find("attitude") or msg:lower():find("dedicated") or msg:lower():find("active players") or
                 msg:lower():find("community") or msg:lower():find("end.game") or msg:lower():find("apply") or msg:lower():find("content cleared") or msg:lower():find("exceptional") or
                 msg:lower():find("class") or msg:lower():find("apply") or msg:lower():find("shivtr") or msg:lower():find("application") or msg:lower():find("roster") or
    	  		 msg:lower():find("fill") or msg:lower():find("international") or msg:lower():find("more info") or msg:lower():find("experience") or msg:lower():find("premade") or
    	  		 msg:lower():find("premade") or msg:lower():find("seeking") or msg:lower():find("participate") or msg:lower():find("tournament") )) or

    	  		(msg:lower():find("bane") and msg:lower():find("lod") and msg:lower():find("raid time") and msg:lower():find("whisper for more info") and msg:lower():find("week")
    	  		and msg:lower():find("recru") and msg:lower():find("icc") and msg:lower():find("[^%a]st[^%a]"))

      )

 and (not (author == UnitName("player") or msg:lower():find("[%s]pug[%s]") or msg:lower():find("twitch") or msg:lower():find("selling") or msg:lower():find("[%s]wts[%s]") or msg:lower():find("endgame discord") or 
 	(msg:lower():find("mee6") and msg:lower():find("rank"))))
 
 then if FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99869] > 0 and 
 	(FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[GGuild] == nil or FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[GGuild] ~= msg) then
	FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[GGuild] = msg _G["ChatFrame"..FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99869]]:AddMessage("FCDGGuild:".."|Hplayer:"..author.."|h["..author.."]|h"..": "..msg, 1,0.49,0.04)
end return true end end 

function GNoneEnglish(self,_,msg,author) if
  (msg:lower():find("recluta") or msg:lower():find("hispana") or msg:lower():find("menkam") or msg:lower():find("para[^%a]") or msg:lower():find("pozdrav") or msg:lower():find("ima neko") or 
  	msg:lower():find("aktywnych") or msg:lower():find("regrutuje") or msg:lower():find("trazimo") or msg:lower():find("hispana") or msg:lower():find("busca") or msg:lower():find("deutschsprachige") or
  	msg:lower():find("busca") or msg:lower():find("gild") or msg:lower():find("trazi") or msg:lower():find("rajdovanje") or msg:lower():find("hermandad") or msg:lower():find("hermandad") or msg:lower():find("hermandad") or
  	msg:lower():find("nabira") or msg:lower():find("nabira") or msg:lower():find("recetu") or msg:lower():find("drugo") or msg:lower():find("iztropash") or	msg:lower():find("polskiej") or msg:lower():find("spremne") or
  	msg:lower():find("igrace") or msg:lower():find("druzenje") or msg:lower():find("saberi") or msg:lower():find("deutsche") or msg:lower():find("gildii") or msg:lower():find("polskiej") or msg:lower():find("rekrutuje") or
  	msg:lower():find("rekrutuje") or msg:lower():find("recruteaza") or msg:lower():find("recruteaza") or msg:lower():find("otvoren") or msg:lower():find("bulgari") or msg:lower():find("popalneniq") or
  	msg:lower():find("requisitos") or msg:lower():find("abre") or msg:lower():find("potrebno") or msg:lower():find("anazitaei") or msg:lower():find("etsii") or msg:lower():find("ﾃ") or
  	msg:lower():find("QuÃ") or msg:lower():find("francais") or msg:lower():find("jouer") or msg:lower():find("nous") or msg:lower():find("vivre") or msg:lower():find("d'Ãªtre") or 
  	msg:lower():find("actifs") or msg:lower():find("grossir") or msg:lower():find("bienvenue") or msg:lower():find("heures") or msg:lower():find("psaxoun") or msg:lower():find("gnorizoun") or 
    msg:lower():find("kvalitna") or msg:lower():find("skusenostami")or msg:lower():find("bienvenido")or msg:lower():find("rendimiento")or msg:lower():find("aspiramos") or
    msg:lower():find("Igrachi") or msg:lower():find("vsqkakvi") or msg:lower():find("Vsqka vecher") or msg:lower():find("shte raidvat") or msg:lower():find("raidovete") or
    msg:lower():find("vsqka vecher") or msg:lower():find("poveche") or msg:lower():find("tursi") or msg:lower():find("poszukuje") or msg:lower():find("rajdowania") or
    msg:lower():find("graczy") or msg:lower():find("bulgarsko vreme") or msg:lower():find("pravilata") or msg:lower():find("izpolzvame") or
    msg:lower():find("grupata") or msg:lower():find("activni") or msg:lower():find("umeniq") or msg:lower():find("afin de") or msg:lower():find("un esprit") or
    msg:lower():find("formarea") or msg:lower():find("interesati") or  msg:lower():find("mambri romani") or msg:lower():find("zdravei") or  msg:lower():find("popitam") or
    msg:lower():find("postoqnno") or  msg:lower():find("choveka") or msg:lower():find("naujai iskepta") or  msg:lower():find("pagrindu") or msg:lower():find("naudojame") or
    msg:lower():find("recrutando") or msg:lower():find("perspectiva") or  msg:lower():find("crescimento") or msg:lower():find("kardan") or  msg:lower():find("mipazird") or
    msg:lower():find("marre des") or  msg:lower():find("requis mini") or msg:lower():find("recrute pour") or  msg:lower():find("irani zire") or msg:lower():find("irani foroshe") or
    msg:lower():find("tedad balaye") or msg:lower():find("aktive") or msg:lower():find("ligegyldigt") or msg:lower():find("aftales efter") or msg:lower():find("mikham") or
    msg:lower():find("zmoniu") or msg:lower():find("mipazire") or msg:lower():find("mozda") or msg:lower():find("igra") or msg:lower():find("nejaka") or
    msg:lower():find("bacheha ahvaz") or msg:lower():find("mitonan ro") or msg:lower():find("moamele") or msg:lower():find("mifrosham") or msg:lower():find("tedadi") or
    msg:lower():find("Irani taze") or msg:lower():find("niyaze") or msg:lower():find("bara raida") or msg:lower():find("seriozni") or msg:lower():find("igrachi") or 
    msg:lower():find("nabera") or msg:lower():find("hracov") or msg:lower():find("pripadne") or msg:lower():find("jugadores") or msg:lower():find("quieran") or 
    msg:lower():find("divertir") or msg:lower():find("diario") or msg:lower():find("comunidad") or msg:lower():find("tambien") or msg:lower():find("te dejan") or 
    msg:lower():find("pasarla bien") or msg:lower():find("altos de") or msg:lower():find("recherche") or msg:lower():find("wszystkich") or msg:lower():find("oferujemy") or
    msg:lower():find("alguien") or msg:lower():find("le anda el") or msg:lower():find("tirate") or msg:lower():find("thuong xuyen") or msg:lower():find("hermanda") or 
	msg:lower():find("mikharam") or msg:lower():find("daashtid") or msg:lower():find("har meghdar") or msg:lower():find("Bache haye") or 
    msg:lower():find("guildimiz") or msg:lower():find("oyundan") or msg:lower():find("keyif almak") or msg:lower():find("olusturmak") or msg:lower():find("cumartesi") or
    msg:lower():find("froosh dare") or msg:lower():find("tawh phot") or msg:lower():find("thin tel") or msg:lower():find("minlo be don") or msg:lower():find("iskljucivo") or
    msg:lower():find("harkasi coin") or msg:lower():find("putem banke") or msg:lower():find("butun turk") or msg:lower():find("gheyre hozori") or msg:lower():find("gnadenlos") or
    msg:lower():find("weniger member") or msg:lower():find("wieviel") or msg:lower():find("wie seht ihr") or msg:lower():find("sorat hozori") or msg:lower():find("hier wirklich") or 
    msg:lower():find("balkanski guild") or msg:lower():find("nove clanove") or msg:lower():find("sada radimo") or msg:lower():find("runove u planu") or msg:lower():find("informacije") or
    msg:lower():find("druzeljubivi") or msg:lower():find("opusteni") or msg:lower():find("irani harki") or msg:lower():find("bara forosh") or 
    msg:lower():find("gelimekte") or msg:lower():find("oyuncular") or  msg:lower():find("kharidaram") or msg:lower():find("meghdar") or  msg:lower():find("bala darid") or
    msg:lower():find("forshande") or msg:lower():find("irani") or msg:lower():find("mipazitad") or msg:lower():find("az zohr") or msg:lower():find("forshande") or msg:lower():find("foroshi") or
    msg:lower():find("daram kasi") or msg:lower():find("mikhad") or msg:find("CZ/SK") or msg:lower():find("recluto") or msg:lower():find("quiera") or msg:lower():find("estar") or
    msg:lower():find("un buen") or  msg:lower():find("romani") or  msg:lower():find("care vor sa") or  msg:lower():find("facem impreuna") or  msg:lower():find("am un grup ") or
    msg:lower():find("prieteni") or msg:lower():find("te adaug") or  msg:lower():find("daca vrei sa") or msg:lower():find("parte din echipa") or msg:lower():find("cand facem") or
    msg:lower():find("algo asi") or msg:lower():find("vrushta ") or  msg:lower():find("otnovo") or msg:lower():find("pauza") or msg:lower():find("populneniq") or
    msg:lower():find("mastome") or msg:lower():find("jau apie") or  msg:lower():find("praleisti") or msg:lower():find("padaryti") or msg:lower():find("galetume") or
    msg:lower():find("zaideju") or msg:lower():find("ieskom") or  msg:lower():find("sveiki") or msg:lower():find("el pala") or msg:lower():find("donde esta") or
    msg:lower():find("bishtar") or msg:lower():find("baraye") or  msg:lower():find("etela'at") or msg:lower():find("och en") or msg:lower():find("samma konto") or
    msg:lower():find("intresse att") or msg:lower():find("winrakom") or msg:lower():find("madouna") or msg:lower():find("mot swish") or msg:lower():find("hunt och") or
    msg:lower():find("vers le bas") or msg:lower():find("kasi pala") or msg:lower():find("vase forosh") or msg:lower():find("glisser") or msg:lower():find("la barre de ") or
    msg:lower():find("appuyez sur la") or msg:lower():find("Appuyez") or msg:lower():find("bulgarski") or msg:lower():find("lqtnata") or msg:lower():find("subira novi") or
    msg:lower():find("predstoqshtiqt") or msg:lower():find("sedmica") or msg:lower():find("fundada por ") or msg:lower():find("experimentados") or msg:lower():find("reclutarte") or 
    msg:lower():find("nuestro") or msg:lower():find("para mas info") or msg:lower():find("herb alch gia ") or msg:lower():find("gia prwth ") or
    msg:lower():find("donde se") or msg:lower():find("plata aca") or msg:lower():find("joueurs") or msg:lower():find("francophones") or msg:lower():find("faire du") or
    msg:lower():find("dans la bonne") or msg:lower():find("ambiance et") or msg:lower():find("froshi pol ") or msg:lower():find("lazemam") or msg:lower():find("kasi niaz") or
    msg:lower():find("dasht w ") or  msg:lower():find("bde merci") or  msg:lower():find("kasi niaz") or msg:lower():find("hoy estamos ") or  msg:lower():find("haciendo") or
    msg:lower():find("historia los") or msg:lower():find("los lations") or  msg:lower():find("guilds latinas") or msg:lower():find("modo de ") or msg:lower():find("las mejores") or
    msg:lower():find("entre las ") or msg:lower():find("mllka egw ") or msg:lower():find("pote kasana ") or msg:lower():find("alch na deis") or msg:lower():find("afta ta ") or
    msg:lower():find("ton ekana") or msg:lower():find("esti roman") or msg:lower():find("roman si ") or msg:lower():find(" si cauti ") or msg:lower():find("si iti voi da") or
    msg:lower():find("orice fel de") or msg:lower():find("de gs sau lvl") or  msg:lower():find("asteptam cu bratele") or msg:lower():find("bratele deschise") or
    msg:lower():find("cauta playeri") or msg:lower():find("doresti sa vii") or msg:lower():find("aceasta guilda") or msg:lower():find("asteptam pe toti") or
    msg:lower():find("bara aktivni") or msg:lower():find("clenovi") or msg:lower():find("posiroko") or msg:lower():find("makedoncite") or msg:lower():find("osloboduvanje na") or
    msg:lower():find("dedicados a raidar") or msg:lower():find("estamos em") or msg:lower():find("horario de") or msg:lower():find("priridade") or msg:lower():find("venha fazer") or
    msg:lower():find("parte desta") or msg:lower():find("campeo de allis") or msg:lower():find("buenas amigos") or msg:lower():find("y amigas si") or msg:lower():find("quieres consequir") or
    msg:lower():find("oro de manera") or msg:lower():find("segura y casi") or msg:lower():find("regalados") or msg:lower():find("escribirme") or msg:lower():find("preguntar") or
    msg:lower():find("es mayuscula y") or msg:lower():find("que tengas un") or msg:lower():find("harki khast") or msg:lower():find("wiss me ya ba") or msg:lower():find("verebilecek") or
    msg:lower():find("oldum da train") or msg:lower():find("vendo esta") or msg:lower():find("cuenta con") or msg:lower():find("las clases") or msg:lower():find("encima de los") or
    msg:lower():find("ako chetesh") or msg:lower():find("tva da si") or msg:lower():find("znaesh") or msg:lower():find("da q porqt") or msg:lower():find("mrasni ciganeta") or
    msg:lower():find("brat da ti") or msg:lower():find("napravqt") or msg:lower():find("sled vreme") or msg:lower():find("da ti go") or msg:lower():find("buta mejdu") or
    msg:lower():find("nou care") or msg:lower():find("dorests sa") or msg:lower():find("formeze un") or msg:lower():find("de jucatori") or msg:lower():find("cu bun simt") or
    msg:lower():find("SALAM be dostan") or msg:lower():find("be dostan") or msg:lower():find("dostan iran") or msg:lower():find("coin bra frosh") or msg:lower():find("darm kasi khast") or
    msg:lower():find("ako je moguce") or msg:lower():find("srpski ako je") or msg:lower():find("si conoceras ") or msg:lower():find("el hueso de") or msg:lower():find("tuetano vos") or
    msg:lower():find("vos putaso") or msg:lower():find("no lo conozco") or msg:lower():find("pero se que") or msg:lower():find("te va doler") or msg:lower():find("brasileira") or
    msg:lower():find("necesito") or msg:lower():find("estamos con") or msg:lower():find("nadie maaaas") or msg:lower():find("siempre el mejor") or msg:lower():find("tengo que ser") or
    msg:lower():find("Hlada aktivnych") or msg:lower():find("ludi na doplnenie") or msg:lower():find("partia ludi chodime") or msg:lower():find("slabsich ludi") or
    msg:lower():find("molis ftiaxtike") or msg:lower():find("theloyme olous gia") or msg:lower():find("pve kai gia ") or msg:lower():find("kai greeklish gia") or msg:lower():find("doostan coin ") or
    msg:lower():find("coin kharidarim") or msg:lower():find("age mayel boodin") or msg:lower():find("solo gente") or msg:lower():find("vyzna tady na") or msg:lower():find("tady na serveru") or
    msg:lower():find("el nombre") or msg:lower():find("je tu nekdo") or msg:lower():find("alimlarimiz devam") or msg:lower():find("devam ediyor") or msg:lower():find("runlarimiza") or
    msg:lower():find("raideri ot ") or msg:lower():find("almak için") or msg:lower():find("atabilirsiniz") or msg:lower():find("ve bilgi almak") or msg:lower():find("katilmak") or
    msg:lower():find("tursqt") or msg:lower():find("hora za") or msg:lower():find("zaduljitelen") or msg:lower():find("salam doostan") or msg:lower():find("age mayel hastin") or
    msg:lower():find("bekharin") or msg:lower():find("motmean") or msg:lower():find("dostan iran") or msg:lower():find("zaprasza w szeregi") or msg:lower():find("szeregi wszytkich") or
    msg:lower():find("tylko u nas ") or msg:lower():find("kowid hiv oraz") or msg:lower():find("na uslugi na") or msg:lower():find("darmowy kowid") or msg:lower():find("avaz mikone") or
    msg:lower():find("avaz mikonam kasi") or msg:lower():find("daram ba ") or msg:lower():find(" louk avaz ") or msg:lower():find("recrute tout ") or msg:lower():find("de joueur mais ") or
    msg:lower():find("essentiellement du gros") or msg:lower():find("finaliser son roster") or msg:lower():find("hai kadishtu ") or msg:lower():find("aramakdayiz") or msg:lower():find("icin yeni ") or
    msg:lower():find("arkadaslar ") or msg:lower():find("sarttir") or msg:lower():find("amaclida aramiza ") or msg:lower():find("katilabilirsiniz") or msg:lower():find("stana resnaha") or
    msg:lower():find("kakvo stana") or msg:lower():find("una femilia") or msg:lower():find("que tiene") or msg:lower():find("muchas ganas de") or msg:lower():find("ctngo unico") or
    msg:lower():find("es ser activo") or

msg:find("[\227-\237]") or

  	msg:lower():find("락") or msg:lower():find("Ã") or msg:lower():find("¤") or msg:lower():find("ﾃ") or msg:lower():find("ｩ") or msg:lower():find("mardi") or
  	msg:find("я") or msg:find("набег") or msg:find("й") or msg:find("ц") or msg:find("бак") or msg:find("п") or msg:find("П") or msg:find("наем") or msg:find("Б") or
  	msg:find("И") or msg:find("Л") or msg:find("и") or msg:find("ф") or msg:find("ж") or msg:find("л") or msg:find("щ") or msg:find("ч") or msg:find("д") or msg:find("Ä") or
  	msg:find("Ã") or msg:find("¥") or msg:find("¤") or msg:find("nqkoi") or msg:find("°") or msg:find("œ") or msg:find("ö") or msg:find("诶") or
  	msg:find("比") or msg:find("伊") or msg:find("哦") or msg:find("提") or msg:find("维") or msg:find("开") or msg:find("ē") or msg:find("à") or msg:find("ú") or
  	msg:find("ㄱ") or msg:find("ㄷ") or msg:find("ㅂ") or msg:find("ㅅ") or msg:find("ㅈ") or msg:find("ㅊ") or msg:find("ㅃ") or msg:find("ㅟ") or msg:find("ㅎ") or
  	msg:find("Č") or msg:find("č") or msg:find("É") or msg:find("é ") or msg:find("ě") or msg:find("š") or msg:find("ň") or  msg:find("İ") or msg:find("ş") or msg:find("동") or
  	msg:find("업") or msg:find("조") or msg:find("합") or msg:find("원") or msg:find("다") or msg:find("한") or msg:find("습") or msg:find("격") or msg:find("을") or msg:find("많") or
  	msg:find("은") or msg:find("더") or msg:find("모") or msg:find("집") or msg:find("ñ") or msg:find("Ñ") or msg:find("公") or msg:find("会") or msg:find("正") or msg:find("在") or
  	msg:find("寻") or msg:find("找") or msg:find("更") or msg:find("多") or msg:find("的") or msg:find("袭") or msg:find("會") or msg:find("尋") or msg:find("突") or
  	msg:find("и") or msg:find("Г") or msg:find("ь") or msg:find("щ") or msg:find("Щ") or msg:find("Б") or msg:find("Л") or msg:find("Д") or msg:find("б") or msg:find("э") or msg:find("ю") or 
  	msg:find("人") or msg:find("英") or msg:find("雄") or msg:find("霜") or msg:find("冻") or msg:find("大") or msg:find("厅") or msg:find("凍") or msg:find("廳") or msg:find("襲") or
  	msg:find("祖") or msg:find("曼") or msg:find("阿") or msg:lower():find("á") or msg:find("太") or msg:find("阳") or msg:find("井") or msg:lower():find("之") or msg:lower():find("ä"))
  	and not (author == UnitName("player"))
 
 then if FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99868] > 0 and 
 	(FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[GNoneEnglish] == nil or FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[GNoneEnglish] ~= msg) then
	FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[GNoneEnglish] = msg _G["ChatFrame"..FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99868]]:AddMessage("FCDGNoneEnglish:".."|Hplayer:"..author.."|h["..author.."]|h"..": "..msg, 1,0.49,0.04)
end return true end end 

function GSpam(self,_,msg,author) if
((msg:lower():find("anal") or msg:lower():find("flashbang") or msg:lower():find("blessed blade of the windseeker") or msg:lower():find("^[f]+$") or msg:lower():find("youtube") or
 	 msg:lower():find("twitch") or msg:lower():find("stream") or msg:lower():find("^lfg[%s]+") or msg:lower():find("[%s]+lfg[%s]+") or msg:lower():find("ninja") or msg:lower():find("scammer") or msg:lower():find("scamer") or
 	 (msg:lower():find("discord") and msg:lower():find("live") and msg:lower():find("run") and msg:lower():find("[\\.]gg")) or
  	 		(msg:lower():find("bugtracker") and (msg:lower():find("vote") or msg:lower():find("report")) ) or
 	 		((msg:lower():find("bg") or msg:lower():find("battleground") or msg:lower():find("battle ground")) and msg:lower():find("twink")) or
			(msg:lower():find("summon") and msg:lower():find("anzu")) or
			(msg:lower():find("portal") and (msg:lower():find("lf") or msg:lower():find("wtb") or msg:lower():find("free") or msg:lower():find("wts") or msg:lower():find("looking for") )) or
			(msg:lower():find("mage") and msg:lower():find("tp") and (msg:lower():find("dala") or msg:lower():find("darnassus") )) or

	 (msg:lower():find("dungeon") or msg:lower():find("rdf") or msg:lower():find("rhc")) and ((msg:lower():find("join") or msg:lower():find("tank") or msg:lower():find("que") or msg:lower():find("need"))
   and not (msg:lower():find("guild") or msg:lower():find("icc") or msg:lower():find("ranks") or msg:lower():find("fresh") ) ) or

	 (msg:lower():find("^[\\[]") and msg:lower():find("[\\]]$") and msg:lower():find("youtube.com")) or (msg:lower():find("^[@]+") and msg:lower():find("[@]+$"))	  )

and (not (author == UnitName("player")  or  msg:lower():find("recruit") or msg:lower():find("active") or msg:lower():find("wts") or msg:lower():find("wtb") ))) 
 
 then if FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99867] > 0 and 
 	(FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[GSpam] == nil or FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[GSpam] ~= msg) then
	FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[GSpam] = msg _G["ChatFrame"..FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99867]]:AddMessage("FCDGSpam:".."|Hplayer:"..author.."|h["..author.."]|h"..": "..msg, 1,0.49,0.04)
end return true end end 

function GTmog(self,_,msg,author) if 
 (((msg:lower():find("transmogs") or msg:lower():find("tmog") or msg:lower():find("xmoug") or msg:lower():find("molten core") or msg:lower():find("karzahan") or 
  msg:lower():find("t-mog") or msg:lower():find("xmog") or msg:lower():find("tranmog") or msg:lower():find("black temple") or msg:lower():find("karazhan") or
  msg:lower():find("blackwing lair") or msg:lower():find("sunwell plat") or msg:lower():find("serpentshrine cavern") or msg:lower():find("tempest keep") or
  msg:lower():find("gruul's lair") or msg:lower():find("magtheridon's lair") or msg:lower():find("scc") or msg:lower():find("hyjal")) 

  	and  ( msg:lower():find("mount hyjal") or (not (msg:lower():find("mount")) or msg:lower():find("mount ress"))) )

  and (not (author == UnitName("player") or msg:lower():find("icc") or msg:lower():find("[^%a]rs[^%a]") or msg:lower():find("togc") or msg:lower():find("toc") or msg:lower():find("guild") or
   msg:lower():find("title") or msg:lower():find("nax[x]*") or msg:lower():find("[^%a]name[^%a]") or msg:lower():find("[^%a]duelist[^%a]") or msg:lower():find("[^%a]shadowmourne[^%a]") or
   msg:lower():find("[^%a]profs[^%a]") or
   (msg:lower():find("[^%a]bis[^%a]") and msg:lower():find("[^%a]pala[^%a]")) or
   (msg:lower():find("[\\?]$") and msg:lower():find("can") or msg:lower():find("any") and not (msg:lower():find("xmog") or msg:lower():find("reserved"))  ) )))
 then if FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99866] > 0 and 
 	(FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[GTmog] == nil or FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[GTmog] ~= msg) then
	FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[GTmog] = msg _G["ChatFrame"..FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99866]]:AddMessage("FCDGTmog:".."|Hplayer:"..author.."|h["..author.."]|h"..": "..msg, 1,0.49,0.04)
end return true end end 

function EnsidiaFailsSpam(self,_,msg,author) if (
	msg:find("^[A-Z][%a]+ failed [%d]+x %([%d]+x %(.+%)") or
	msg:find("^[%-]+")
	) and author ~= UnitName("player") then if FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99862] > 0 and (FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[EnsidiaFailsSpam] == nil or FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[EnsidiaFailsSpam] ~= msg) then
	FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[EnsidiaFailsSpam] = msg _G["ChatFrame"..FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99862]]:AddMessage("EnsidiaFailsSpam:".."|Hplayer:"..author.."|h["..author.."]|h"..": "..msg, 1,0.49,0.04) end return true end end 

function DoTimerSpam(self,_,msg,author) if (
	msg:find("^My cooldown on .+ will finish in [%d]+s%.$") or
	msg:find("^My cooldown on .+ will finish in [%d]+m%.$")

	) and author ~= UnitName("player") then if FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99861] > 0 and (FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[DoTimerSpam] == nil or FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[DoTimerSpam] ~= msg) then
	FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[DoTimerSpam] = msg _G["ChatFrame"..FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99861]]:AddMessage("DoTimerSpam:".."|Hplayer:"..author.."|h["..author.."]|h"..": "..msg, 1,0.49,0.04) end return true end end 



function mod:Chatfiltercheck()
	if self.db.profile.chatfilter[99950] then ChatFrame_AddMessageEventFilter("CHAT_MSG_SYSTEM", WarmaneSystemSpam) end
	if not self.db.profile.chatfilter[99950] then ChatFrame_RemoveMessageEventFilter("CHAT_MSG_SYSTEM", WarmaneSystemSpam) end

	if self.db.profile.chatfilter[99951] then ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID", MPRSpam) ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID_LEADER", MPRSpam) end
	if not self.db.profile.chatfilter[99951] then ChatFrame_RemoveMessageEventFilter("CHAT_MSG_RAID", MPRSpam) ChatFrame_RemoveMessageEventFilter("CHAT_MSG_RAID_LEADER", MPRSpam) end

	if self.db.profile.chatfilter[99952] then ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID", FatalitySpam) ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID_LEADER", FatalitySpam) end
	if not self.db.profile.chatfilter[99952] then ChatFrame_RemoveMessageEventFilter("CHAT_MSG_RAID", FatalitySpam) ChatFrame_RemoveMessageEventFilter("CHAT_MSG_RAID_LEADER", FatalitySpam) end

	if self.db.profile.chatfilter[99953] then ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID", CrybabySpam) ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID_LEADER", CrybabySpam) end
	if not self.db.profile.chatfilter[99953] then ChatFrame_RemoveMessageEventFilter("CHAT_MSG_RAID", CrybabySpam) ChatFrame_RemoveMessageEventFilter("CHAT_MSG_RAID_LEADER", CrybabySpam) end

	if self.db.profile.chatfilter[99954] then ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID", WarmaneCustomDBMSpam) ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID_LEADER", WarmaneCustomDBMSpam) end
	if not self.db.profile.chatfilter[99954] then ChatFrame_RemoveMessageEventFilter("CHAT_MSG_RAID", WarmaneCustomDBMSpam) ChatFrame_RemoveMessageEventFilter("CHAT_MSG_RAID_LEADER", WarmaneCustomDBMSpam) end

	if self.db.profile.chatfilter[99955] then ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID", IDKNAMESpam) ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID_LEADER", IDKNAMESpam) end
	if not self.db.profile.chatfilter[99955] then ChatFrame_RemoveMessageEventFilter("CHAT_MSG_RAID", IDKNAMESpam) ChatFrame_RemoveMessageEventFilter("CHAT_MSG_RAID_LEADER", IDKNAMESpam) end

	if self.db.profile.chatfilter[99956] then ChatFrame_AddMessageEventFilter("CHAT_MSG_YELL", FactionGroupSpam) ChatFrame_AddMessageEventFilter("CHAT_MSG_SAY", FactionGroupSpam) end
	if not self.db.profile.chatfilter[99956] then ChatFrame_RemoveMessageEventFilter("CHAT_MSG_YELL", FactionGroupSpam) ChatFrame_RemoveMessageEventFilter("CHAT_MSG_SAY", FactionGroupSpam) end

	if self.db.profile.chatfilter[99957] then ChatFrame_AddMessageEventFilter("CHAT_MSG_LOOT", EmblemSpam) end
	if not self.db.profile.chatfilter[99957] then ChatFrame_RemoveMessageEventFilter("CHAT_MSG_LOOT", EmblemSpam) end

	if self.db.profile.chatfilter[99958] then ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID", ParrySpam) ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID_LEADER", ParrySpam) end
	if not self.db.profile.chatfilter[99958] then ChatFrame_RemoveMessageEventFilter("CHAT_MSG_RAID", ParrySpam) ChatFrame_RemoveMessageEventFilter("CHAT_MSG_RAID_LEADER", ParrySpam) end

	if self.db.profile.chatfilter[99959] then ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID", DBMAnnounceFilter) ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID_LEADER", DBMAnnounceFilter) end
	if not self.db.profile.chatfilter[99959] then ChatFrame_RemoveMessageEventFilter("CHAT_MSG_RAID", DBMAnnounceFilter) ChatFrame_RemoveMessageEventFilter("CHAT_MSG_RAID_LEADER", DBMAnnounceFilter) end

	if self.db.profile.chatfilter[99949] then ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID", DetailsDeathSpam) ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID_LEADER", DetailsDeathSpam) end
	if not self.db.profile.chatfilter[99949] then ChatFrame_RemoveMessageEventFilter("CHAT_MSG_RAID", DetailsDeathSpam) ChatFrame_RemoveMessageEventFilter("CHAT_MSG_RAID_LEADER", DetailsDeathSpam) end

	if self.db.profile.chatfilter[99948] then ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID", IsReadySpam) ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID_LEADER", IsReadySpam) end
	if not self.db.profile.chatfilter[99948] then ChatFrame_RemoveMessageEventFilter("CHAT_MSG_RAID", IsReadySpam) ChatFrame_RemoveMessageEventFilter("CHAT_MSG_RAID_LEADER", IsReadySpam) end

	if self.db.profile.chatfilter[99947] then ChatFrame_AddMessageEventFilter("CHAT_MSG_TARGETICONS", IconsSpam) end
	if not self.db.profile.chatfilter[99947] then ChatFrame_RemoveMessageEventFilter("CHAT_MSG_TARGETICONS", IconsSpam) end

	if self.db.profile.chatfilter[99873] then ChatFrame_AddMessageEventFilter("CHAT_MSG_TARGETICONS", IconsSpamPP) end
	if not self.db.profile.chatfilter[99873] then ChatFrame_RemoveMessageEventFilter("CHAT_MSG_TARGETICONS", IconsSpamPP) end

	if self.db.profile.chatfilter[99946] then ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID", RBSDeaths) ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID_LEADER", RBSDeaths) ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID_WARNING", RBSDeaths) end
	if not self.db.profile.chatfilter[99946] then ChatFrame_RemoveMessageEventFilter("CHAT_MSG_RAID", RBSDeaths) ChatFrame_RemoveMessageEventFilter("CHAT_MSG_RAID_LEADER", RBSDeaths) ChatFrame_RemoveMessageEventFilter("CHAT_MSG_RAID_WARNING", RBSDeaths) end

	if self.db.profile.chatfilter[99946] then ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID", SkadaDeathSpam) ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID_LEADER", SkadaDeathSpam) ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID_WARNING", SkadaDeathSpam) end
	if not self.db.profile.chatfilter[99946] then ChatFrame_RemoveMessageEventFilter("CHAT_MSG_RAID", SkadaDeathSpam) ChatFrame_RemoveMessageEventFilter("CHAT_MSG_RAID_LEADER", SkadaDeathSpam) ChatFrame_RemoveMessageEventFilter("CHAT_MSG_RAID_WARNING", SkadaDeathSpam) end

	if self.db.profile.chatfilter[99929] then ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID", FCDMVileGas) ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID_LEADER", FCDMVileGas) end
	if not self.db.profile.chatfilter[99929] then ChatFrame_RemoveMessageEventFilter("CHAT_MSG_RAID", FCDMVileGas) ChatFrame_RemoveMessageEventFilter("CHAT_MSG_RAID_LEADER", FCDMVileGas) end

	if self.db.profile.chatfilter[99928] then ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID", FCDMBQLBite) ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID_LEADER", FCDMBQLBite) end
	if not self.db.profile.chatfilter[99928] then ChatFrame_RemoveMessageEventFilter("CHAT_MSG_RAID", FCDMBQLBite) ChatFrame_RemoveMessageEventFilter("CHAT_MSG_RAID_LEADER", FCDMBQLBite) end

	if self.db.profile.chatfilter[99927] then ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID", FCDOozeDamage) ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID_LEADER", FCDOozeDamage) end
	if not self.db.profile.chatfilter[99927] then ChatFrame_RemoveMessageEventFilter("CHAT_MSG_RAID", FCDOozeDamage) ChatFrame_RemoveMessageEventFilter("CHAT_MSG_RAID_LEADER", FCDOozeDamage) end

	if self.db.profile.chatfilter[99926] then ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID", FCDMBacklash) ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID_LEADER", FCDMBacklash) end
	if not self.db.profile.chatfilter[99926] then ChatFrame_RemoveMessageEventFilter("CHAT_MSG_RAID", FCDMBacklash) ChatFrame_RemoveMessageEventFilter("CHAT_MSG_RAID_LEADER", FCDMBacklash) end

	if self.db.profile.chatfilter[99925] then ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID", FCDMWhoring) ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID_LEADER", FCDMWhoring) end
	if not self.db.profile.chatfilter[99925] then ChatFrame_RemoveMessageEventFilter("CHAT_MSG_RAID", FCDMWhoring) ChatFrame_RemoveMessageEventFilter("CHAT_MSG_RAID_LEADER", FCDMWhoring) end

	if self.db.profile.chatfilter[99924] then ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID", FCDMWhoringSingle) ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID_LEADER", FCDMWhoringSingle) end
	if not self.db.profile.chatfilter[99924] then ChatFrame_RemoveMessageEventFilter("CHAT_MSG_RAID", FCDMWhoringSingle) ChatFrame_RemoveMessageEventFilter("CHAT_MSG_RAID_LEADER", FCDMWhoringSingle) end

	if self.db.profile.chatfilter[99923] then ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID", FCDMRSDispel) ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID_LEADER", FCDMRSDispel) end
	if not self.db.profile.chatfilter[99923] then ChatFrame_RemoveMessageEventFilter("CHAT_MSG_RAID", FCDMRSDispel) ChatFrame_RemoveMessageEventFilter("CHAT_MSG_RAID_LEADER", FCDMRSDispel) end

	if self.db.profile.chatfilter[99922] then ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID", FCDMBPCKock) ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID_LEADER", FCDMBPCKock) end
	if not self.db.profile.chatfilter[99922] then ChatFrame_RemoveMessageEventFilter("CHAT_MSG_RAID", FCDMBPCKock) ChatFrame_RemoveMessageEventFilter("CHAT_MSG_RAID_LEADER", FCDMBPCKock) end

	if self.db.profile.chatfilter[99945] then ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID", SmarBuffFilter) ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID_LEADER", SmarBuffFilter) end
	if not self.db.profile.chatfilter[99945] then ChatFrame_RemoveMessageEventFilter("CHAT_MSG_RAID", SmarBuffFilter) ChatFrame_RemoveMessageEventFilter("CHAT_MSG_RAID_LEADER", SmarBuffFilter) end

	if self.db.profile.chatfilter[99944] then ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID", FlumpFilter) ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID_LEADER", FlumpFilter) end
	if not self.db.profile.chatfilter[99944] then ChatFrame_RemoveMessageEventFilter("CHAT_MSG_RAID", FlumpFilter) ChatFrame_RemoveMessageEventFilter("CHAT_MSG_RAID_LEADER", FlumpFilter) end

	if self.db.profile.chatfilter[99943] then ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID", PhoenixStyleFilter) ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID_LEADER", PhoenixStyleFilter) end
	if not self.db.profile.chatfilter[99943] then ChatFrame_RemoveMessageEventFilter("CHAT_MSG_RAID", PhoenixStyleFilter) ChatFrame_RemoveMessageEventFilter("CHAT_MSG_RAID_LEADER", PhoenixStyleFilter) end

	if self.db.profile.chatfilter[99921] then ChatFrame_AddMessageEventFilter("CHAT_MSG_PARTY", ImpBallFilter) end
	if not self.db.profile.chatfilter[99921] then ChatFrame_RemoveMessageEventFilter("CHAT_MSG_PARTY", ImpBallFilter) end

	if self.db.profile.chatfilter[99920] then ChatFrame_AddMessageEventFilter("CHAT_MSG_WHISPER", WhisperFilter) end
	if not self.db.profile.chatfilter[99920] then ChatFrame_RemoveMessageEventFilter("CHAT_MSG_WHISPER", WhisperFilter) end

	if self.db.profile.chatfilter[99918] then ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID", RSAFilter) ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID_LEADER", RSAFilter) end
	if not self.db.profile.chatfilter[99918] then ChatFrame_RemoveMessageEventFilter("CHAT_MSG_RAID", RSAFilter) ChatFrame_RemoveMessageEventFilter("CHAT_MSG_RAID_LEADER", RSAFilter) end

	if self.db.profile.chatfilter[99917] then
		ChatFrame_AddMessageEventFilter("CHAT_MSG_MONSTER_YELL", BubblesFilter) ChatFrame_AddMessageEventFilter("CHAT_MSG_SAY", BubblesFilter) ChatFrame_AddMessageEventFilter("CHAT_MSG_PARTY_LEADER", BubblesFilter)
		ChatFrame_AddMessageEventFilter("CHAT_MSG_PARTY", BubblesFilter) ChatFrame_AddMessageEventFilter("CHAT_MSG_YELL", BubblesFilter) ChatFrame_AddMessageEventFilter("CHAT_MSG_MONSTER_SAY", BubblesFilter) end

	if not self.db.profile.chatfilter[99917] then
		ChatFrame_RemoveMessageEventFilter("CHAT_MSG_MONSTER_YELL", BubblesFilter) ChatFrame_RemoveMessageEventFilter("CHAT_MSG_SAY", BubblesFilter) ChatFrame_RemoveMessageEventFilter("CHAT_MSG_PARTY_LEADER", BubblesFilter)
		ChatFrame_RemoveMessageEventFilter("CHAT_MSG_PARTY", BubblesFilter) ChatFrame_RemoveMessageEventFilter("CHAT_MSG_YELL", BubblesFilter) ChatFrame_RemoveMessageEventFilter("CHAT_MSG_MONSTER_SAY", BubblesFilter)  end

	if self.db.profile.chatfilter[99914] then ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID", JapChiKorFilter) ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID_LEADER", JapChiKorFilter) end
	if not self.db.profile.chatfilter[99914] then ChatFrame_RemoveMessageEventFilter("CHAT_MSG_RAID", JapChiKorFilter) ChatFrame_RemoveMessageEventFilter("CHAT_MSG_RAID_LEADER", JapChiKorFilter) end

	if self.db.profile.chatfilter[99913] then ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID", RussainFilter) ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID_LEADER", RussainFilter) end
	if not self.db.profile.chatfilter[99913] then ChatFrame_RemoveMessageEventFilter("CHAT_MSG_RAID", RussainFilter) ChatFrame_RemoveMessageEventFilter("CHAT_MSG_RAID_LEADER", RussainFilter) end

	if self.db.profile.chatfilter[99911] then ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID", TauntFilter) ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID_LEADER", TauntFilter) end
	if not self.db.profile.chatfilter[99911] then ChatFrame_RemoveMessageEventFilter("CHAT_MSG_RAID", TauntFilter) ChatFrame_RemoveMessageEventFilter("CHAT_MSG_RAID_LEADER", TauntFilter) end

	if self.db.profile.chatfilter[99910] then ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID", BigBrotherFilter) ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID_LEADER", BigBrotherFilter) end
	if not self.db.profile.chatfilter[99910] then ChatFrame_RemoveMessageEventFilter("CHAT_MSG_RAID", BigBrotherFilter) ChatFrame_RemoveMessageEventFilter("CHAT_MSG_RAID_LEADER", BigBrotherFilter) end

	if self.db.profile.chatfilter[99909] then ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID", RessFilter) ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID_LEADER", RessFilter) end
	if not self.db.profile.chatfilter[99909] then ChatFrame_RemoveMessageEventFilter("CHAT_MSG_RAID", RessFilter) ChatFrame_RemoveMessageEventFilter("CHAT_MSG_RAID_LEADER", RessFilter) end

	if self.db.profile.chatfilter[99908] then ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID", LKAnnounceFilter) ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID_LEADER", LKAnnounceFilter) ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID_WARNING", LKAnnounceFilter) end
	if not self.db.profile.chatfilter[99908] then ChatFrame_RemoveMessageEventFilter("CHAT_MSG_RAID", LKAnnounceFilter) ChatFrame_RemoveMessageEventFilter("CHAT_MSG_RAID_LEADER", LKAnnounceFilter) ChatFrame_RemoveMessageEventFilter("CHAT_MSG_RAID_WARNING", LKAnnounceFilter) end

	if self.db.profile.chatfilter[99907] then ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID", CustomMacronWeakaura) ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID_LEADER", CustomMacronWeakaura) ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID_WARNING", CustomMacronWeakaura) end
	if not self.db.profile.chatfilter[99907] then ChatFrame_RemoveMessageEventFilter("CHAT_MSG_RAID", CustomMacronWeakaura) ChatFrame_RemoveMessageEventFilter("CHAT_MSG_RAID_LEADER", CustomMacronWeakaura) ChatFrame_RemoveMessageEventFilter("CHAT_MSG_RAID_WARNING", CustomMacronWeakaura) end

	if self.db.profile.chatfilter[99906] then ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID", FCDMSunders) ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID_LEADER", FCDMSunders) end
	if not self.db.profile.chatfilter[99906] then ChatFrame_RemoveMessageEventFilter("CHAT_MSG_RAID", FCDMSunders) ChatFrame_RemoveMessageEventFilter("CHAT_MSG_RAID_LEADER", FCDMSunders) end

	if self.db.profile.chatfilter[99930] then ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID", FCDBMNecro) ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID_LEADER", FCDBMNecro) end
	if not self.db.profile.chatfilter[99930] then ChatFrame_RemoveMessageEventFilter("CHAT_MSG_RAID", FCDBMNecro) ChatFrame_RemoveMessageEventFilter("CHAT_MSG_RAID_LEADER", FCDBMNecro) end

	if self.db.profile.chatfilter[99905] then ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID", OptiTauntFilter) ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID_LEADER", OptiTauntFilter) end
	if not self.db.profile.chatfilter[99905] then ChatFrame_RemoveMessageEventFilter("CHAT_MSG_RAID", OptiTauntFilter) ChatFrame_RemoveMessageEventFilter("CHAT_MSG_RAID_LEADER", OptiTauntFilter) end

	if self.db.profile.chatfilter[99904] then ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID", AchivmentFailsFilter) ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID_LEADER", AchivmentFailsFilter) end
	if not self.db.profile.chatfilter[99904] then ChatFrame_RemoveMessageEventFilter("CHAT_MSG_RAID", AchivmentFailsFilter) ChatFrame_RemoveMessageEventFilter("CHAT_MSG_RAID_LEADER", AchivmentFailsFilter) end

	if self.db.profile.chatfilter[99936] then ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID", RankWatchFilter) ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID_LEADER", RankWatchFilter) end
	if not self.db.profile.chatfilter[99936] then ChatFrame_RemoveMessageEventFilter("CHAT_MSG_RAID", RankWatchFilter) ChatFrame_RemoveMessageEventFilter("CHAT_MSG_RAID_LEADER", RankWatchFilter) end

	if self.db.profile.chatfilter[99931] then ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID", OmenFilter) ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID_LEADER", OmenFilter) end
	if not self.db.profile.chatfilter[99931] then ChatFrame_RemoveMessageEventFilter("CHAT_MSG_RAID", OmenFilter) ChatFrame_RemoveMessageEventFilter("CHAT_MSG_RAID_LEADER", OmenFilter) end

	if self.db.profile.chatfilter[99932] then ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID", InterruptFilter) ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID_LEADER", InterruptFilter) end
	if not self.db.profile.chatfilter[99932] then ChatFrame_RemoveMessageEventFilter("CHAT_MSG_RAID", InterruptFilter) ChatFrame_RemoveMessageEventFilter("CHAT_MSG_RAID_LEADER", InterruptFilter) end

	if self.db.profile.chatfilter[99940] then ChatFrame_AddMessageEventFilter("CHAT_MSG_LOOT", RaidLootNeed) end
	if not self.db.profile.chatfilter[99940] then ChatFrame_RemoveMessageEventFilter("CHAT_MSG_LOOT", RaidLootNeed) end

	if self.db.profile.chatfilter[99939] then ChatFrame_AddMessageEventFilter("CHAT_MSG_LOOT", RaidLootGreed) end
	if not self.db.profile.chatfilter[99939] then ChatFrame_RemoveMessageEventFilter("CHAT_MSG_LOOT", RaidLootGreed) end

	if self.db.profile.chatfilter[99942] then ChatFrame_AddMessageEventFilter("CHAT_MSG_LOOT", RaidLootPass) end
	if not self.db.profile.chatfilter[99942] then ChatFrame_RemoveMessageEventFilter("CHAT_MSG_LOOT", RaidLootPass) end

	if self.db.profile.chatfilter[99941] then ChatFrame_AddMessageEventFilter("CHAT_MSG_LOOT", RaidLootDE) end
	if not self.db.profile.chatfilter[99941] then ChatFrame_RemoveMessageEventFilter("CHAT_MSG_LOOT", RaidLootDE) end

	if self.db.profile.chatfilter[99899] then ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID", AnnounceFilter) ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID_LEADER", AnnounceFilter) end
	if not self.db.profile.chatfilter[99899] then ChatFrame_RemoveMessageEventFilter("CHAT_MSG_RAID", AnnounceFilter) ChatFrame_RemoveMessageEventFilter("CHAT_MSG_RAID_LEADER", AnnounceFilter) end

	if self.db.profile.chatfilter[99898] then ChatFrame_AddMessageEventFilter("CHAT_MSG_LOOT", RaidPoorLoot) end
	if not self.db.profile.chatfilter[99898] then ChatFrame_RemoveMessageEventFilter("CHAT_MSG_LOOT", RaidPoorLoot) end

	if self.db.profile.chatfilter[99887] then ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID", FCDBMHastedAttack) ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID_LEADER", FCDBMHastedAttack) end
	if not self.db.profile.chatfilter[99887] then ChatFrame_RemoveMessageEventFilter("CHAT_MSG_RAID", FCDBMHastedAttack) ChatFrame_RemoveMessageEventFilter("CHAT_MSG_RAID_LEADER", FCDBMHastedAttack) end

	if self.db.profile.chatfilter[99875] then ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID", FCDParryCounter) ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID_LEADER", FCDParryCounter) end
	if not self.db.profile.chatfilter[99875] then ChatFrame_RemoveMessageEventFilter("CHAT_MSG_RAID", FCDParryCounter) ChatFrame_RemoveMessageEventFilter("CHAT_MSG_RAID_LEADER", FCDParryCounter) end

	if self.db.profile.chatfilter[99871] then ChatFrame_AddMessageEventFilter("CHAT_MSG_CHANNEL", GBuyingSelling)  end
	if not self.db.profile.chatfilter[99871] then ChatFrame_RemoveMessageEventFilter("CHAT_MSG_CHANNEL", GBuyingSelling) end

	if self.db.profile.chatfilter[99870] then ChatFrame_AddMessageEventFilter("CHAT_MSG_CHANNEL", GArena)  end
	if not self.db.profile.chatfilter[99870] then ChatFrame_RemoveMessageEventFilter("CHAT_MSG_CHANNEL", GArena) end

	if self.db.profile.chatfilter[99869] then ChatFrame_AddMessageEventFilter("CHAT_MSG_CHANNEL", GGuild)  end
	if not self.db.profile.chatfilter[99869] then ChatFrame_RemoveMessageEventFilter("CHAT_MSG_CHANNEL", GGuild) end

	if self.db.profile.chatfilter[99868] then ChatFrame_AddMessageEventFilter("CHAT_MSG_CHANNEL", GNoneEnglish)  end
	if not self.db.profile.chatfilter[99868] then ChatFrame_RemoveMessageEventFilter("CHAT_MSG_CHANNEL", GNoneEnglish) end

	if self.db.profile.chatfilter[99867] then ChatFrame_AddMessageEventFilter("CHAT_MSG_CHANNEL", GSpam)  end
	if not self.db.profile.chatfilter[99867] then ChatFrame_RemoveMessageEventFilter("CHAT_MSG_CHANNEL", GSpam) end

	if self.db.profile.chatfilter[99866] then ChatFrame_AddMessageEventFilter("CHAT_MSG_CHANNEL", GTmog)  end
	if not self.db.profile.chatfilter[99866] then ChatFrame_RemoveMessageEventFilter("CHAT_MSG_CHANNEL", GTmog) end

	if self.db.profile.chatfilter[99865] then ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID", MRTReciveLootSpam) ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID_LEADER", MRTReciveLootSpam) end
	if not self.db.profile.chatfilter[99865] then ChatFrame_RemoveMessageEventFilter("CHAT_MSG_RAID", MRTReciveLootSpam) ChatFrame_RemoveMessageEventFilter("CHAT_MSG_RAID_LEADER", MRTReciveLootSpam) end

	if self.db.profile.chatfilter[99862] then ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID", EnsidiaFailsSpam) ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID_LEADER", EnsidiaFailsSpam) end
	if not self.db.profile.chatfilter[99862] then ChatFrame_RemoveMessageEventFilter("CHAT_MSG_RAID", EnsidiaFailsSpam) ChatFrame_RemoveMessageEventFilter("CHAT_MSG_RAID_LEADER", EnsidiaFailsSpam) end

	if self.db.profile.chatfilter[99861] then ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID", DoTimerSpam) ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID_LEADER", DoTimerSpam) end
	if not self.db.profile.chatfilter[99861] then ChatFrame_RemoveMessageEventFilter("CHAT_MSG_RAID", DoTimerSpam) ChatFrame_RemoveMessageEventFilter("CHAT_MSG_RAID_LEADER", DoTimerSpam) end

	if self.db.profile.chatfilter[99919] then ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID", FlasknFoodFilter) ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID_LEADER", FlasknFoodFilter) end
	if not self.db.profile.chatfilter[99919] then ChatFrame_RemoveMessageEventFilter("CHAT_MSG_RAID", FlasknFoodFilter) ChatFrame_RemoveMessageEventFilter("CHAT_MSG_RAID_LEADER", FlasknFoodFilter) end

	if self.db.profile.chatfilter[99859] then ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID", ReadyCheckMessages) ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID_LEADER", ReadyCheckMessages) end
	if not self.db.profile.chatfilter[99859] then ChatFrame_RemoveMessageEventFilter("CHAT_MSG_RAID", ReadyCheckMessages) ChatFrame_RemoveMessageEventFilter("CHAT_MSG_RAID_LEADER", ReadyCheckMessages) end

end

function BubblesFilter(self,channel,msg,author,language)
if ((channel == "CHAT_MSG_MONSTER_YELL" or channel == "CHAT_MSG_MONSTER_SAY") and FatCooldowns:GetModule("Display").db.profile.chatfilter[99916]) or
	channel ~= "CHAT_MSG_MONSTER_YELL" and (
	author ~= UnitName("player") and 
	(UnitAffectingCombat("player") and FatCooldowns:GetModule("Display").db.profile.chatfilter[99934] and (
		(CustomUnitClass(author) == "Hunter" and (msg:find("^Misdirected [A-Z][%a]+$") or msg:find("^Md [A-Z][%a]+$") or msg:find("^MD up$") or msg:find("^.MD on. [A-Z][%a]+$") or msg:find("^Misdirection is up$") or msg:find("^Misdirection [A-Z][%a]+$") or
												msg:find("^Misdirected used on [A-Z][%a]+[%s]*[!]*$") or msg:find("^MD on [A-Z][%a]+$") or msg:find("^[%s]*Taunting Blistering Zombie$") or msg:find("^Taunting Blood Beast$") or msg:find("^MD on sexy %<[A-Z][%a]+%>$") or
												msg:find("^Misdirection on [A-Z][%a]+[%s]+[!]+$") or msg:find("^[%s]*[.]MD on[.] [A-Z][%a]+$") or msg:find("^[%s]*[\"]MD on[\"] [A-Z][%a]+$") or msg:find("^[%s]*Tuanting Blistering Zombie$") or
												msg:find("^Tuanting Blood Beast$") or msg:find("^~~Misdirecting on Kawzz~~$"))) or

		(UnitClass(author) == "Shaman" and ( --manatide
			msg:lower():find("^{rt[1,2,3,4,5,6,7,8]}[%s]*TIDE[%s]*{rt[1,2,3,4,5,6,7,8]}$") or
			msg:lower():find("^{[Ss][Tt][Aa][Rr]}[%s]*TIDE[%s]*{[Ss][Tt][Aa][Rr]}}$") or
			msg:lower():find("^mana tide is up please use hymn of hope[%s]*[<]*[%d]*[%s]*[!]*$") or
			msg:lower():find("^mana tide down[%s!]*$") or
			msg:lower():find("^mana tide totem by me [>]*come here for mana[<]*") or
			msg:lower():find("^mana totem here$") or
			msg:lower():find("^mana tide is active$") or
			msg:lower():find("^mana tide down$") or
			msg:lower():find("^mana tide down, hymn of hope now[%s!]*$") or
			msg:lower():find("^manatide up%.$") or
			msg:lower():find("^manatide down now[%s!]* use hymn of hope[%s!]*$") or
			msg:lower():find("^mana tide down. hymn now.$") or
			msg:lower():find("^mana tide incoming pop hymn[%s!]*$") or
			msg:lower():find("^mana tide up$") or
			msg:lower():find("^mana tide up . . .$") or
			msg:lower():find("^[a-z][%a]+ get ur mana back boy[%s!]*$") or
			msg:lower():find("^hymn of hope is up [%s!]* use mana totem$") or
			msg:lower():find("^mana tide totem down$") or
			msg:lower():find("^mana tide incoming pop hymn[%s!]*[%s!]*$") or
			msg:lower():find("^mana tide totem up[%s!]* hymm of hope[%s!]* mana tide totem up[%s!]* hymm of hope[%s!]*$") or
			msg:lower():find("^kemba gives [a-z][%a]+ some mana$") or
			msg:lower():find("^mana for big choddy$") or
			msg:lower():find("^mana tide$") or
			msg:lower():find("^mana tide totem up$") or
			msg:lower():find("^mana tide totem$") or
			msg:lower():find("^mana tide used[%s!]*$") or
			msg:lower():find("^mana tide used, use hymn hope$") or
			msg:lower():find("^pop mana hymn pls mana tide is up$") or
			msg:lower():find("^mana tide used, use hym hope$") or
			msg:lower():find("^mana tide is up[%s!]*$") or
			msg:lower():find("^mana tide totem is up[%s!]*$") or
			msg:lower():find("^mana tide, priest do hymn pls$") or
			msg:lower():find("^mana tide totem: please hymn of hope now[!]*$") or
			msg:lower():find("^mana tide totem used[!]* mana hymn please.$") or
			msg:lower():find("^mana tide down, disc mana hymn pls$") or
			msg:lower():find("^mana tide up[!]* hymn of hope [+]*[%s]*innervate now[!]*$") or
			msg:lower():find("^mana tide totem down[!]*$") or
			msg:lower():find("^mana tide is up, hymn of hope pls$") or
			msg:lower():find("^blyattide$") or
			msg:lower():find("^Mana tide UP = do your Hymn of hope$") or
			msg:find("^%-%-|cff71d5ff|Hspell:[%d]+|h[\\[]Mana Tide Totem]|h|r used!%-%-$") or
			msg:find("^MANATIDE UP[%,]*$") or
			msg:find("^Hymn of Hope is up[!]* Use Mana Cooldowns[!]*$") or
			msg:find("^Mana Tide Totem[!]*$") or
			msg:find("^Mana tide UP %= do your Hymn of hope$") or
			msg:find("^Mana Tide is up, Hymn of Hope pls$") or
			msg:find("^%-%-[\\[]Mana Tide Totem] used!%-%-$") or
			msg:find("^{square}{triangle}{square}{triangle} M A N A T I D E[%s]*{triangle}{square}{triangle}{square}$") or
			--other
			msg:find("^Bloodlust UP!$"))) or 

		(UnitClass(author) == "Paladin" and (--holy wrath
			msg:lower():find("^holy wrath on val'kyr shadowguard$") or
			msg:lower():find("^holy wrath used[%s!]*$") or
			msg:lower():find("^holy wrath used[%s]*%.$") or
			msg:lower():find("^[%a]+ used holy wrath[%s!]*$") or
			msg:lower():find("^holy wrath pero hindi kulong[%s!]*$") or
			msg:lower():find("^"..author.." used holy wrath[%s!]*$") or
			msg:find("^|cff71d5ff|Hspell:[%d]+|h[\\[]Holy Wrath]|h|r activate$") or
			--Freedom
			msg:find("^Hand of Freedom on >>>> [A-Z][%a]+ <<<<$") or
			msg:find("^Thanks for the Freedom!$") or
			msg:find("^Hand Of Freedom cast on [A-Z][%a]+!$") or
			msg:find("^Thanks for the Freedom!$") or
			msg:find("^Thanks for the Hands of Freedom!$") or
			msg:find("^Hand of Freedom is down[%s!]*$") or
			msg:find("^Hand of Freedom is up[%s!]*$") or
			msg:find("^Hand of Freedom on [A-Z][%a]+[!]*$") or
			msg:find("^[A-Z][%a]+ used Hand of Freedom on [%>]+ [A-Z][%a]+ [%<]+$") or
			msg:find("^Freedom [uU]sed$") or
			msg:find("^Hand of freedom up !$") or
			--Beacon
			msg:find("^Beacon Fades !$") or
			msg:find("^Beacon Of Light cast on [A-Z][%a]+!$") or
			msg:find("^Beacon Of Light on [A-Z][%a]+ has ended!$") or
			--Divine
			msg:lower():find("^divine sacrifice for all!$") or
			msg:find("^Perfect Divine Sacrifice!$") or
			msg:find("^|cff.+|Hspell:[%d]+|h[\\[]Divine Guardian]|h|r up and running%.$") or
			msg:find("^>>> Divine Protection is ACTIVE! <<<$") or
			msg:find("^Divine Plea activated$") or
			msg:find("^Divine Guardian Activated!$") or
			msg:find("^Divine Guardian Faded!$") or
			msg:find("^Divine Protection Activated!$") or
			msg:find("^Divine Protection Faded!$") or
			msg:find("^[%s]*"..author.."[%s]*used Divine Sacrifice[%s]*$") or
			msg:find("^"..author.." used Divine Sacrifice$") or
			msg:find("^Divine Protection %^%-%^ Activated %^%-%^$") or
			msg:find("^Divine Sacrifice has been cast!$") or
			msg:find("^Casting |cff71d5ff|Hspell:[%d]+|h[\\[]Divine Sacrifice]|h|r$") or
			msg:find("^|cff71d5ff|Hspell:[%d]+|h[\\[]Divine Protection]|h|r %^%.%^[%s]*Activated[%s]*%^%.%^$") or
			msg:find("^%>%>%> |cff71d5ff|Hspell:[%d]+|h[\\[]Divine Sacrifice]|h|r is ACTIVE!! Please Watch my health! %<%<%<$") or
			msg:find("^Divine Sacrifice Up!!!$") or
			msg:find("^DIVINE SACRIFICE UP[!]*$") or
			msg:find("^I believe I have used DSAC ~-~$") or
			msg:find("^ I believe I have used DSAC ~.~$") or
			msg:lower():find("^dsac these nuts[%s]*[!]*$") or
			msg:lower():find("^dsac dis nuts[%s]*[!]*$") or
			msg:find("^I believe I have used DSAC %~%-%~$") or
			msg:find("^Forbearance Faded!$") or
			--add
			msg:find("^>>> Death AVERTED. Ardent Defender is my hero and healed me for [%d]+. <<<$") or
			msg:find("^Ardent Defender Activated!$") or
			msg:find("^Ardent Defender Faded!$") or
			--hands
			msg:find("^Hand of Protection is up[%s!]*$") or
			msg:find("^Hand of Sacrifice is up[%s!]*$") or
			msg:find("^Hand of Sac up$") or
			msg:find("^Hand of Salvation on [A-Z][%a]+$") or
			msg:find("^Hand Of sacrifice On !$") or
			msg:find("^Hand of Salvation on >>>> [A-Z][%a]+ <<<<$") or
			msg:find("^Hand of Sacrifice on >>>> [A-Z][%a]+ <<<<$") or
			msg:find("^Hand Of Protection cast on [A-Z][%a]+!$") or
			msg:find("^Hand Of Sacrifice cast on [A-Z][%a]+!$") or
			msg:find("^Hand Of Salvation cast on [A-Z][%a]+!$") or
			msg:find("^Lay On Hands on [A-Z][%a]+ for [%d]+!$") or
			msg:find("^HAND OF SACRIFICE on [A-Z][%a]+!$") or
			msg:find("^LAY ON HANDS on [A-Z][%a]+!$") or
			msg:find("^TAUNT MISSED [.]*! %(Hand of Reckoning%)$") or
			msg:find("^Hand of Protection on [>]+[%s]*[A-Z][%a]+[%s]*[<]+$") or
			msg:find("^Clutch Lay on Hand$") or
			msg:find("^Hand of Protection on [>]+[%s]*[A-Z][%a]+[%s]*[<]+$") or
			msg:find("^Hand of Sacrifice on [A-Z][%a]+[!]*$") or
			msg:find("^SVL up[!]+$") or
			msg:find("^[%s]*SLV up[%s]*!$") or
			msg:find("^Salv on [A-Z][%a]+$") or
			msg:find("^Salvation [A-Z][%a]+[!]* ROAR AGGRO[%S]*[:]*[%D]*$") or
			msg:find("^SALVATION [A-Z]+$") or
			msg:find("^Casting HOSAC!$") or
			msg:find("^i used HoF next you$") or
			--aura mastery
			msg:find("^AM on[!]*$") or
			msg:lower():find("^aura mastery is up[%s]*[!]*$") or
			msg:lower():find("^aura mastery used[%s]*[!]*$") or
			msg:find("^AM used %- Aura 100[\\%] stronger for [%d]+ sec%.$") or
			msg:find("^AM used %- Aura 100%% stronger for [%d]+ sec%.$") or
			msg:find("^Casting Aura Mastery!$") or
			msg:find("^Aura Mastery is up!!! Thanks [A-Z][%a]+$") or
			msg:find("^Aura Mastery Activated[%s]*[!]*$") or
			msg:find("^Aura Mastery Faded!$") or
			msg:find("^Aura Mastery is up!!! Thanks Girl$") or
			msg:find("^Casting |cff71d5ff|Hspell:[%d]+|h[\\[]Aura Mastery]|h|r$") or
			msg:find("^Aura Mastery is up!!! Thanks [A-Z][%a]+$") or
			msg:find("^%-[>]+[%-]*|cff71d5ff|Hspell:[%d]+|h[\\[]Aura Mastery]|h|r is Up[%-]*[<]+[%-]+$") or
			msg:find("^CASTING AURA MASTERY$") or
			msg:find("^Aura mastery UP[!]+$") or
			msg:find("^uSED Aura mastery$") or
			msg:find("^FOR THE HORDE[!]+$") or
			msg:find("^Aura mastery UP !$") or
			msg:find("^[%s]*Arua mastery UP[%s]*!$") or
			msg:find("^AM used %- Aura 100%% stringer for 6 sec%.$") or
			msg:find("^Frso Resistance Aura Used$") or
			msg:find("^Frost Aura Mastery[!]*$") or
			msg:find("^Shadow Aura Mastery[!]*$") or
			msg:find("^Fire Aura Mastery[!]*$") or
			msg:find("^[A-Z][%a]+'s |cff71d5ff|Hspell:[%d]+|h[\\[]Frost Resistance Aura]|h|r AM faded$") or
			msg:find("^[A-Z][%a]+'s |cff71d5ff|Hspell:[%d]+|h[\\[]Fire Resistance Aura]|h|r AM faded$") or
			msg:find("^[A-Z][%a]+'s |cff71d5ff|Hspell:[%d]+|h[\\[]Shadow Resistance Aura]|h|r AM faded$") or
			msg:find("^[\\-]+AURA MASTERY[\\-]+$") or

			--other
			msg:find("^Hammer of Justice$") or
			msg:find("^%>%>%> Bubblewall is ACTIVE! %<%<%<$") or
			msg:find("^>>> Divine Protection is down. <<<$") or
			msg:find("^Ardent Defender just proc. Heal up!") or
			msg:find("^RAIDWALL is UP!$") or
			msg:find("^BUBBLE WALL is UP!$") or
			msg:find("^ARDENT DEFENDER HEALED ME! KEEP ME UP FOR 2 MINUTES!$") or
			msg:find("^RAIDWALL is DOWN!$") or
			msg:find("^BUBBLE WALL is DOWN!$") or
			msg:find("^Hand of Protection is down[%s!]*$") or
			msg:find("^Hand of Sacrifice is down[%s!]*$") or
			msg:find("^%>%>%> |cff71d5ff|Hspell:[%d]+|h[\\[]Divine Sacrifice]|h|r is down %<%<%<$") or
			msg:find("^HOLY FUCKING WRATH FUCKING USED[!]*$") or
			msg:find("^Free {rt5}[%s]*%> ME %<[%s]*{rt5}[%s]*TAKE IT IN [%d]+s!$") or
			msg:find("^%>%>%> Bubblewall is down%. %<%<%<$"))) or

		(UnitClass(author) == "Warrior" and UnitName("boss1") ~= nil and (
			msg:find("^casting Shattering Throw on "..UnitName("boss1").."$"))) or


		(UnitClass(author) == "Druid" and (--bress
			msg:find("^Casting Bress on [A-Z][%a]+$") or
			msg:find("^Resurrecting [A-Z][%a]+.$") or
			msg:find("^ressing [\\[][\\[] [A-Z][%a]+ ]]$") or
			msg:find("^OKC [A-Z][%a]+ casts Battle Res$") or
			msg:find("^Resurrecting [A-Z][%a]+%.$") or
			msg:find("^Casting Bress on [A-Z][%a]+!$") or
			msg:find("^[A-Z][%a]+ get back to life Ma B!tch$") or
			msg:find("^Casting on [A-Z][%a]+$") or
			msg:find("^cast Rebirth on [A-Z][%a]+$") or
			msg:find("^Started to cast |cff71d5ff|Hspell:[%d]+|h[\\[]Rebirth]|h|r on [A-Z][%a]+$") or
			msg:find("^rebirth on [A-Z][%a]+[%s!]*$") or
			msg:find("^Started to cast on |cff71d5ff|Hspell:[%d]+|h[\\[]Rebirth]|h|r [A-Z][%a]+$") or
			msg:find("^Come to life, [A-Z][%a]+, you b00n!$") or
			msg:find("^Casting Rebirth on [A-Z][%a]+$") or
			msg:find("^[A-Z][%a]+ Combat ressed$") or
			--barksin
			msg:find("^BARKSKIN USED$") or
			msg:find("^BARKSIN USED$") or
			msg:find("^Skin Protect On[%s]*[!]*$") or
			--other
			msg:find("^ENRAGED DEFENSE is DOWN!$") or
			msg:find("^LAST STAND[%s]*%(FERLOL%) is DOWN!$") or
			msg:find("^ENRAGED DEFENSE is UP!$") or
			msg:find("^LAST STAND[%s]*%(FERLOL%) is UP!$") or
			msg:find("^DRUID WALL is UP!$") or
			msg:find("^DRUID WALL is DOWN!$"))) or

		(UnitClass(author) == "Death Knight" and (--other
			msg:find("^BLOOD ARMOR [iI][SS] DOWN[!]+$") or
			msg:find("^VAMPIRIC BLOOD [iI][SS] DOWN[!]+$") or
			msg:find("^BLOOD ARMOR [iI][SS] UP[!]+$") or
			msg:find("^VAMPIRIC BLOOD [iI][SS] UP[!]+$") or
			msg:find("^DK WALL [iI][SS] UP[!]+$") or
			msg:find("^DK WALL [iI][SS] DOWN[!]+$"))) or

		(UnitClass(author) == "Priest" and (--hymn
			msg:find("^Hymn of Hope is out.$") or
			msg:find("^Hymn of Hope is casted!$") or
			msg:find("^using Divine Hymn$") or
			msg:find("^using Hymn of Hope$") or
			msg:find("^Casting [Divine Hymn]$") or
			msg:find("^Casting |cff71d5ff|Hspell:[%d]+|h[\\[]Divine Hymn]|h|r$") or
			msg:find("^Casting |cff71d5ff|Hspell:[%d]+|h[\\[]Hymn of Hope]|h|r$") or
			msg:find("^Using Hymn of Hope$") or
			msg:find("^Using Divine Hymn$") or
			msg:find("^Casting Hymn of Hope$") or
			msg:find("^Divine Hymn USED[!]* Thanks [A-Z][%a]+$") or
			msg:find("^Hymn of Hope USED[!]* Thanks [A-Z][%a]+$") or
			msg:find("^Casting Hymn of Hope now[!]*$") or
			msg:find("^innervae !! Hymn !!!$") or
			msg:find("^Awesome! Hymn of Hope up$") or
			msg:find("^Divine Hymn up!$") or
			msg:find("^Hymn of Hope up!$") or
			msg:find("^[\\[] Divine Hymn ] up$") or
			msg:find("^%[ Hymn Of Hope %][%s]*up$") or
			msg:find("^Divine Hymn is up!$") or
			msg:find("^Divine Hymn is up!$") or
			--gs
			msg:find("^Guardian Spirit up, quit dying you fools$") or
			--ps
			msg:find("^Pain[%s]*Suppression on [A-Z][%a]+[%s]*%(Tank%-Pala%) Please[!]*$") or
			-- fear ward
			msg:find("^Fear Ward up$") or
			msg:find("^[\\[] Fear Ward ] up$") or
			msg:find("^Fear Ward on [A-Z][%a]+$") or
			msg:find("^Fear on [A-Z][%a%s]+ has ended!$"))) or

		(UnitName("boss1") == "The Lich King" and ( -- fly away
			msg:find("^[A-Z][%a]+ is like a bi%-ird, he'll only fly awa%-ay%.%.%.$") or
			msg:find("^[A-Z][%a]+ is like a bi%-ird, she'll only fly awa%-ay%.%.%.$") or
			msg:find("^[A-Z][%a]+ and [A-Z][%a]+ are like a bi%-ird. they'll only fly awa%-ay%.%.%.$") or
			msg:find("^[A-Z][%a]+, [A-Z][%a]+ and [A-Z][%a]+ are like a bi%-ird, they'll only fly awa%-ay%.%.%.$") or
			msg:find("^[A-Z][%a]+, [A-Z][%a]+, [A-Z][%a]+ and [A-Z][%a]+ are like a bi%-ird, they'll only fly awa%-ay%.%.%.$") or
			--shamb
			msg:find("^Shambling Horror used Enrage [\\-] Stun/Tranq/Cooldown now!$") or
			msg:find("^Shambling Horror [%d]+ Frenzy in [\\.%d]*s! Plague will kill it [%d]+s later[\\.]$") or
			msg:find("^Shambling Horror [%d]+ Frenzy in [.%d]*s! Plague will not kill it!$") or
			msg:find("^Normal Enrage! Tranq now!$") or
			msg:find("^Hard Enrage!$") or
			msg:find("^Hard Enrag!$") or
			-- dispel
			msg:lower():find("^oh shit! dispel me in a bit.$") or
			--Infest
			msg:find("^Infest #[%d]+ coming up!$") or
			--Raging
			msg:find("^Raging Spirit on me[%s]*[!]*$") or
			-- Quake
			msg:find("^Quake! Run inside!!$") or
			msg:find("^Quake! Get in the middle!$") or
			-- Reaper
			msg:find("^Reaper on me[%s]*!$") or
			msg:find("^|cff71d5ff|Hspell:[%d]+|h[\\[]Soul Reaper]|h|r on me!$") or
			--valk
			msg:find("^[A-Z][%a]+ picked up!$") or
			msg:find("^Rsham is Grabbed!$") or
			msg:find("^Rshaman is Grabbed!$") or
			msg:find("^Hpala is Grabbed!$") or
			msg:find("^Disc is Grabbed!$") or
			msg:find("^Rdruid is Grabbed!$"))) or

		(UnitName("boss1") == "Halion" and (
			msg:find("^Meteor Strike in [%d]+ sec. Run to the other side!$") or
			msg:find("^[>]*Meteor[!]* Watch out[!]*[<]*$") or
			msg:find("^[%s]*Meteor[%s]*$") or
			msg:find("^[%s]*[Fiery Combustion] on me![%s]*$") or
			msg:find("^|cff71d5ff|Hspell:[%d]+|h[\\[]Twilight Cutter]|h|r in [%d]+ seconds! Adjust your position!$") or
			msg:find("^Twilight Cutter in [%d]+ sec%. Watch orbs[!]*$") or
			msg:find("^Twilight Cutter in [%d]+ seconds! Adjust your position!$") or
			msg:find("^[%s]*Cutters![%s]*$") or
			msg:find("^[>]*Cutters[!]* Adjust your position[!]*[<]*$") or
			msg:find("^60%% %- MORE DPS[!]+$") or
			msg:find("^40%% %- STOP ON BOSS[!]+$") or
			msg:find("^40%% %- STOP ON BOSS[!]+$") or
			msg:find("^Flame beacon on me[%s]*!$") or
			msg:find("^[%s]*Flame beacon on me[%s]*![%s]*$") or
			msg:find("^Beacon tneket$") or
			msg:find("^[%s]*Fire bomb on ME![%s]*$") or
			msg:find("^Cookie Cutter in [%d]+ seconds[!]*$"))) or

		(UnitName("boss1") == "Lord Marrowgar" and (
			msg:find("^Spike here! HELP!!!!$") or
			msg:find("^I am spiked !! ez afk$") or
			msg:find("^spyke !!!$")
			)) or

		(UnitName("boss1") == "Lady Deathwhisper" and (
			msg:find("^I got controlled, CC me NOW[!]* Dont Kill Me Dog[!]*$") or
			msg:lower():find("^curse of tongues is up!$") or
			msg:lower():find("^curse of torpor, dispel me !!$") or
			msg:find("^Curse of Torpor . Dispel me !!$") or
			msg:find("^[iI] got controlled. CC me NOW[!]*$") or
			msg:find("on me. Dispel, please$") or
			msg:find("^OMG! Dispel me in a bit$") or
			msg:find("^Cyclone me ! DON'T AOE !$") or
			msg:find("^Spirit on me$") or
			msg:find("^PLEASE DONT KILL ME! CC ANYONE?$") or
			msg:find("^Spirit on me!$") or
			msg:lower():find("^summoning vengeful spirits %-%- spread[!]*$") or
			msg:find("^KILL ME BEACHES[!]+$") or
			msg:find("^Curse of Torpor[%s]*,[%s]*Dispel Me !!$"))) or

		(UnitName("boss1") == "Deathbringer Saurfang" and (
			msg:find("^TAUNT$") or
			msg:find("^|cff71d5ff|Hspell:[%d]+|h[\\[]Mark of the Fallen Champion]|h|r on me!$") or
			msg:lower():find("^mark on me!$"))) or

		(UnitName("boss1") == "Festergut" and (  
			msg:find("^Espora de gas on me!$") or
			msg:find("^Gas Spore on TABK!$") or
			msg:find("^Gas Spore on TANK!$") or
			msg:find("^9 STACKS[%s]*%. TAUNT[%s]*[!]+$") or
			msg:find("^Gas Spore on me!$") or
			msg:find("^Vile Gas on me!$") or
			msg:find("^Gas Spore on [A-Z][%a]+!$") or
			msg:find("^Gas inmundo on me!$") or
			msg:find("^VILED!!! FFS SPREAD!!!$") or
			msg:lower():find("^spor on me!$") or
			msg:lower():find("^stack on me !!$") or
			msg:lower():find("^[%s]*defensives!$") or
			msg:find("^Activate your defensives!$") or
			msg:find("^Spor on me$") or
			msg:lower():find("^cyka bleat[%s]*[!]*$") or
			msg:find("^|cff71d5ff|Hspell:[%d]+|h[\\[]Pungent Blight]|h|r! Be careful!$") or
			msg:find("^Deffenslves!$") or
			msg:find("^|cff71d5ff|Hspell:[%d]+|h[\\[]Gas Spore]|h|r on me!$") or
			msg:find("^|cff71d5ff|Hspell:[%d]+|h[\\[]Gas Spore]|h|r on me! Stack up if you don't have any yet!$") or
			msg:find("^|cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-]*]|h|r! Activate your defensives!$") or
			msg:find("^Spore on me!$"))) or

		(UnitName("boss1") == "Rotface" and (
			msg:find("^Infected! Little ooze on me in a bit$") or
			msg:find("^|cff71d5ff|Hspell:[%d]+|h[\\[]Unstable Ooze Explosion]|h|r! Be careful!$") or
			msg:find("^|cff71d5ff|Hspell:[%d]+|h[\\[]Mutated Infection]|h|r on me[!]*$") or
			msg:find("^|cff71d5ff|Hspell:[%d]+|h[\\[]Mutated Infection]|h|r on me[!]* WTB merge[!]*$") or
			msg:find("^Mutated Infection on me!$") or
			msg:find("^Explosion!$"))) or

		(UnitName("boss1") == "Professor Putricide" and (
			msg:find("^|cff71d5ff|Hspell:[%d]+|h[\\[]Choking Gas Bomb]|h|r! Be careful and don't step in it!$") or
			msg:lower():find("^malleable goo on me!$") or
			msg:find("^Red [dD]ebuff$") or
			msg:find("^Malleables$") or
			msg:find("^Stack on me[%s]*[!]*$") or
			msg:lower():find("^cyka bleat[%s]*[!]*$") or
			msg:find("^|cff71d5ff|Hspell:[%d]+|h[\\[]Gaseous Bloat]|h|r on me[!]*$") or
			msg:find("^|cff71d5ff|Hspell:[%d]+|h[\\[]Ooze Variable]|h|r on me[!]*$") or
			msg:find("^|cff71d5ff|Hspell:[%d]+|h[\\[]Malleable Goo]|h|r on me[!]* Here we go again[%s]*%.%.%.$") or
			msg:find("^|cff71d5ff|Hspell:[%d]+|h[\\[]Malleable Goo]|h|r! Watch out!$") or
			msg:find("^|cff71d5ff|Hspell:[%d]+|h[\\[]Malleable Goo]|h|r! Be careful!$") or
			msg:find("^|cff71d5ff|Hspell:[%d]+|h[\\[]Choking Gas Bomb]|h|r! Be careful!$") or
			msg:find("^|cff71d5ff|Hspell:[%d]+|h[\\[]Volatile Ooze Adhesive]|h|r on me! WTB merge!$") or
			msg:find("^Choking$") or
			msg:find("^[Ii|] need to run away from red ooze !!$") or
			msg:find("^Green [dD]ebuff$") or
			msg:find("^Goo ball incoming!$"))) or

		((UnitName("boss1") == "Prince Keleseth" or UnitName("boss1") == "Prince Valanar" or UnitName("boss1") == "Prince Taldaram") and (
			msg:lower():find("^vortex!$") or
			msg:lower():find("^shock vortex on me!$") or
			msg:find("^|cff71d5ff|Hspell:[%d]+|h[\\[]Empowered Shock Vortex]|h|r[!]* Spread out[!]*$") or
			msg:find("^|cff71d5ff|Hspell:[%d]+|h[\\[]Empowered Shock Vortex]|h|r! Be careful!$") or
			msg:lower():find("^conjure empowered flame on me!$") or
			msg:find("^Flames on [A-Z][%a]+! Help me and soak[%s!]*$"))) or

		(UnitName("boss1") == "Blood-Queen Lana'thel" and (
			msg:lower():find("^link up!$") or
			msg:find("on me! Stack up if you don't have any yet!$") or
			msg:lower():find("^shadows on me !$") or
			msg:lower():find("^link fast!$") or
			msg:find("^Yikes! Catch me if you can! xD$") or
			msg:find("^BITE!!$") or
			msg:find("^I'm hungry!$") or
			msg:find("^Link$") or
			msg:find("^Come to daddy fast ^^$") or
			msg:find("^Swarming Shadows on me!$") or
			msg:find("^Swarming Shadow[s]* on "..author.."!$") or
			msg:find("^Hug me sisters!$") or
			msg:find("^Links %-%-%> Stack$") or
			msg:find("^Stack on me$") or
			msg:find("^Pact on [A-Z][%a]+[!]+$") or
			msg:find("^GET OVER HERE !!!$") or
			msg:find("^|cff71d5ff|Hspell:[%d]+|h[\\[]Pact of the Darkfallen]|h|r on me[!]*$") or
			msg:find("^|cff71d5ff|Hspell:[%d]+|h[\\[]Pact of the Darkfallen]|h|r on me[!]* Come together[!]*$") or
			msg:find("^|cff71d5ff|Hspell:[%d]+|h[\\[]Swarming Shadows]|h|r on me[!]*$") or
			msg:find("^Shadows On Me!!!$"))) or

		(UnitName("boss1") == "Valithria Dreamwalker" and (
			msg:find("^I lost my portal stacks[%s]*[!]+$"))) or

		(UnitName("boss1") == "Sindragosa" and (
			msg:find("^6 Instability Stacks!$") or
			msg:find("^Instability [%d]+ stacks$") or
			msg:find("^Unchained Magic on me!$") or
			msg:find("^Unchained on me!$") or
			msg:find("^Unchained on me! IM AFK!$") or
			msg:find("^|cff71d5ff|Hspell:[%d]+|h[\\[]Unchained Magic]|h|r on me$") or
			msg:find("^[%d]+cChilled Stacks!$") or
			msg:find("^[%d]+ Chilled Stacks!$") or
			msg:find("^YellBeacon$") or
			msg:find("^Frost Beacon on "..author.."$") or
			msg:lower():find("^stacks cleared!$") or
			msg:lower():find("^fvck stacks!$") or
			msg:find("^Oof [Ii][a]*m frozen !$") or
			msg:find("^WTF!!! Why on me????$") or
			msg:find("^|cff71d5ff|Hspell:[%d]+|h[\\[]Frost Beacon]|h|r on me!$") or
			msg:find("^Tomb on me!$"))) or

		--everyclasss says 
		msg:find("^[A-Z][%a]+ used AM with |cff71d5ff|Hspell:[%d]+|h[\\[]Frost Resistance Aura]|h|r$") or
		msg:find("^[A-Z][%a]+ used AM with |cff71d5ff|Hspell:[%d]+|h[\\[]Shadow Resistance Aura]|h|r$") or
		msg:find("^[A-Z][%a]+ used AM with |cff71d5ff|Hspell:[%d]+|h[\\[]Fire Resistance Aura]|h|r$") or
		msg:find("^[A-Z][%a]+ used AM with |cff71d5ff|Hspell:[%d]+|h[\\[]Crusader Aura]|h|r$") or

		msg:find("^[A-Z][%a]+ used Aura Mastery with |cff71d5ff|Hspell:[%d]+|h[\\[]Frost Resistance Aura]|h|r$") or
		msg:find("^[A-Z][%a]+ used Aura Mastery with |cff71d5ff|Hspell:[%d]+|h[\\[]Shadow Resistance Aura]|h|r$") or
		msg:find("^[A-Z][%a]+ used Aura Mastery with |cff71d5ff|Hspell:[%d]+|h[\\[]Fire Resistance Aura]|h|r$") or
		msg:find("^[A-Z][%a]+ used Aura Mastery with |cff71d5ff|Hspell:[%d]+|h[\\[]Crusader Aura]|h|r$") or
		msg:find("^AM down!$") or

		msg:find("^{star}[%s]*Innervate shaman[%s]*{star}[%s]*{star}[%s]*Innervate shaman[%s]*{star}$") or

		msg:find("^MAGE SPAWNED!!$") or		
		msg:find("^Dsac [Uu][Pp][!]*$") or
		msg:lower():find("^aura mastery up[%s]*[!]*$") or
	
		msg:find("^Silenced !$") or
		-- achieve
		msg:find("^{[Ss][Kk][Uu][Ll][LL]}[%s]*|cffffff00|Hachievement.+[%s]*failed!") or
		msg:find("^{rt[1,2,3,4,5,6,7,8]}[%s]*|cffffff00|Hachievement.+[%s]*failed!") or
		-- parry
		(UnitName("boss1") ~= nil and msg:find("^[A-Z][%a]+ caused a parry on "..UnitName("boss1").."$")) or
		msg:find("^[<]+PARRY[>]+[%s]*[A-Z][%a]+ parried [A-Z][%a]+[!]+$") or
		--loot
		msg:find("^[A-Z][%a]+ receives loot: |cff[%d%a]+|Hitem:[%d]+:0:0:0:0:0:0:0:[%d]+|h[\\[].+]|h|r%.$") or
		-- no listed class
		msg:find("^using Evocation !$") or
		msg:find("^Focus Magic on [A-Z][%a]+%.$") or
		msg:find("^I'll give you a soul if you come to me, Felguard! Please hear my command!$") or
		msg:find("^Banished [A-Z][%a%s]+!$") or
		msg:find("^Banish on [A-Z][%a%s]+ has ended!$") or
		msg:find("^Soulstone on [A-Z][%a]+$") or
		msg:find("^Last Standing$") or
		--trash talk
	--[[	msg:find("^BL TO DA MAAAAX!!!$") or
		msg:find("^SIZE MATTERS !$") or
		msg:find("^DADDY GIVE ME WINGS$") or
		msg:find("^*MASONS GAVE WINGS TO PERIX*$") or
		msg:find("^PS. SINX IS GAY$") or
		msg:find("^UGABUGARRRRRR$") or
		msg:find("^Red Bull Gives Me Wings!$") or
		msg:find("^holy shit!$") or
		msg:find("^Mu[a]+[h]+!!!!$") or
		msg:find("^Good job mofos xD$") or
		msg:find("^Wubba Lubba Dub Dub!!$") or
		msg:find("^MOTHERFUCKING WINGS!!$") or
		msg:find("^FOR THE ALLIANCE!!!!!$") or
		msg:find("^MRGLMRGLMRLGMRLGMRLMRLGMLRMGRGG[R]+$") or
		msg:find("^RELEASE THE KRAKEN[%s!]*$") or
		msg:find("^UGABUGAGAGA$") or
		msg:find("^Tactical Nuke[!]* Bloodlust[!]*$") or
		msg:find("^FCK HORDE!! FOR THE ALLIANCE[!]*$") or
		msg:find("^GET OVER HERE$") or
		msg:find("^Oyy Blyaaat!!!!!$") or
		msg:find("^UGABUGAUGABUGA$") or
		msg:find("^M[%s]*A[%s]*N[%s]*A[%s]*T[%s]*I[%s]*D[%s]*P[%s]*L[%s]*S$") or
		msg:find("^Summoning Baby Jutsu$") or
		msg:find("^COO COO MOTHER FUCKER[!]*$") or
		msg:find("^My lucky day boiz[!]* GtG$") or
		msg:find("^FUCK YOU BEACHES IMMA KEEL YOU ALL[!]*$") or
		msg:find("^ReCount Has Been Fix$") or
		msg:find("^BLYAT BLYAT BLYAT BLYAT[1]+$") or
		msg:find("^My Power too Much[%s]*[!]*$") or
		msg:find("^light is saved you[%s]*[!]+$") or ]]
		-- not class or boss specific
		msg:lower():find("^thanks for pain suppresion!!$") or
		msg:lower():find("^thanks for the pain suppresion!$") or
		msg:find("^Awesome! Divine Hymn up$") or
		msg:find("^Hymn of Hope is UP!! Thanks [A-Z][%a]+$") or
		msg:find("^Divine Hymn is UP!! Thanks [A-Z][%a]+$") or
		msg:find("^%=%> I Interrupted That: .+%.$") or
		msg:find("^|cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-]*]|h|r interrupted!$") or
		msg:find("^Interrupted [A-Z][%a%s]*'s |cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-:)(]*]|h|r!$") or
		msg:find("^Interrupted [%a%s]+ with |cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-:)(]*]|h|r$") or
		msg:find("^Time to bring the pain[!]*$") or
		msg:find("^Tanks for the Pain Suppresion!$") or
		msg:find("^Thanks for the Pain Suppression!$") or
		msg:find("^Thanks for the Pain Suppresion[!]+$") or
		msg:find("^Fearing [A-Z][%a%s]+!$") or
		msg:find("^CC%/Stuns%/Hex%/Fear anyone[?]+$") or
		msg:lower():find("^thanks for dguardian !$") or
		msg:lower():find("^thanks for the dguardian !$") or
		msg:lower():find("^thanks for the bloodlust!$") or
		msg:lower():find("^thanks for the power infusion!$") or
		msg:lower():find("^thanks for the hand of salvation[%s]*!$") or
		msg:lower():find("^salvation[!]*$") or
		msg:lower():find("^thanks for the hand of sacrifice[%s]*!$") or
		msg:lower():find("^thanks for dsac!$")or
		msg:lower():find("^thanks mate !$") or
		msg:lower():find("^thanks for bloodlust$") or
		msg:lower():find("^thanks for the bloodlust$") or
		msg:lower():find("^thanks!$") or
		msg:find("^Perfect Divine Sacrifice!!! Thanks [A-Z][%a]+$") or
		msg:find("^Thanks for the Hand of Protection!$") or
		msg:find("^Thanks for the PI!$") or
		msg:find("^Thanks for the Sacrifice!$") or
		msg:find("^Thanks for the Salvation!$") or
		msg:find("^Thanks for the bite !$") or
		msg:find("^Thanks for the Sacrifice!$") or
		msg:find("^Perfect Divine Sacrifice[!]* Thanks, [A-Z][%a]+$") or
		msg:find("^Waow[!] Thanks for the Hysteria$") or
		msg:find("^Thanks for the HOP[!]*$") or
		msg:find("^Thanks !$") or
		msg:find("^Thanks for Innervate+$") or				
		msg:find("^[A-Z][%a]+ used Hand of Protection on [%>]+ [A-Z][%a]+ [%<]+$") or
		msg:find("^[A-Z][%a]+ used Hand of Sacrifice on [%>]+ [A-Z][%a]+ [%<]+$") or
		msg:find("^[A-Z][%a]+ used Hand of Salvation on [%>]+ [A-Z][%a]+ [%<]+$") or
		msg:find("^[A-Z][%a]+ is casting Divine Sacrifice!$") or
		msg:find("^[A-Z][%a]+ used Divine Salvation$") or
		msg:find("^[A-Z][%a]+ used Divine Sacrifice$") or
		msg:find("^[A-Z][%a]+ used Divine Protection$") or
		msg:find("^get ready for the [Ss]uper [Ss]ayan. [aA]+[Hh]+$") or
		msg:find("^|cff71d5ff|Hspell:[%d]+|h[\\[]Stealth]|h|r up on [A-Z]") or
		msg:find("^salvación por favor$") or
		msg:lower():find("^salvation "..author.."!$") or
		msg:find("^[%s]*{triangle}[%s]*THORNS %- REMOVED[%s]*{triangle}[%s]*$") or
		msg:find("^[%s]*{triangle}[%s]*FOCUS MAGIC %- REMOVED[%s]*{triangle}[%s]*$") or
		msg:find("^[%s]*{triangle}[%s]*INTELLECT %- REMOVED[%s]*{triangle}[%s]*$") or
		msg:find("^[%s]*{triangle}[%s]*BEACON %- REMOVED[%s]*{triangle}[%s]*$") or
		msg:find("^5 stacks of |cff71d5ff|Hspell:[%d]+|h[\\[]Sunder Armor]|h|r applied on .+ in .+ sec[!]*$") or
		msg:find("^5 Sunders took .+seconds$") or
		msg:find("^|cff71d5ff|Hspell:[%d]+|h[\\[]Sunder Armor]|h|r dropped from .+[!]*$") or
		msg:find("^[A-Z][%a]+ just intervened to [A-Z][%a]+$") or
		--gts
		msg:find("^GTS is down[%s!]*$") or
		msg:find("^GTS Used[!]* Thanks, [A-Z][%a]+$") or
		msg:find("^GTS is up[%s!]*$") or
		msg:find("^[A-Z][%a]+'s GTS is up!!$") or
		msg:find("^GTS used$") or
		msg:find("^GTS UP$") or
		msg:find("^[A-Z][%a]+ GTS UP$") or
		msg:find("^GTS$") or
		msg:find("^Using GTS$") or
		msg:find("^I USE Glowing Twilight Scale$") or
		msg:find("^Glowing Twilight Scale USED$") or
		msg:find("^Glowing Twilight Scale Used$") or
		msg:find("^Used[%s]*|cffa335ee|Hitem:54589:0:0:0:0:0:0:0:80|h[\\[]Glowing Twilight Scale]|h|r$") or
		msg:find("^Used[%s]*|cffa335ee|Hitem:54589:0:0:0:0:0:0:0:0|h[\\[][Glowing Twilight Scale]|h|r$") or
		msg:find("^Used[%s]*|cffa335ee|Hitem:54573:0:0:0:0:0:0:0:80|h[\\[]Glowing Twilight Scale]|h|r$") or
		msg:find("^Used[%s]*|cffa335ee|Hitem:54573:0:0:0:0:0:0:0:0|h[\\[]Glowing Twilight Scale]|h|r$") or
		msg:find("^Used[%s]*|cffa335ee|Hitem:.+|h[\\[]Glowing Twilight Scale]|h|r$") or
		-- pulled
		msg:find("^[A-Z][%a]+ PULLED [A-Z][%a%s]*!!!$")or
		msg:find("^[A-Z][%a]+ PULLED Der [%a%s]+!!!$") or
		--taunts

		msg:find("^9 STACKS SOMEBODY TUANT!!!$") or
		msg:find("^9 STACKS SOMEBODY TAUNT!!!$") or
		msg:find("^3 STACKS , TAUNT !!$") or
		msg:find("^3 STACKS . TUANT !!$") or
		msg:find("^9 STACKS TAUNT[%s]*[!]+$") or
		msg:find("^Taunt now!$") or
		msg:find("^TAUNT IMMUNE: [.]+!$")

	--[[	msg:find("^Shield Up$") or
		msg:lower():find("^for the horde !$") or
		msg:lower():find("^am i sexy$") or
		msg:lower():find("^am i sexy!$") or
		--stacks
		msg:find("^[%d]+ STACKS [!]+$") or 

		msg:find("^Panic button$") or

		msg:find("^WTF[!]+ Why on me[?]+$") or
		msg:find("^I lOve [Uu]+$") or
		msg:find("^Are we Gucci?$") or
		msg:find("^Sug ma balls$") or
		msg:find("^By the Light be purged!$") or
		msg:find("^May the God fall mercy on you%.$") or
		msg:find("^Obey now, [A-Z][%a]+!$") or
		msg:find("^123$") or
		msg:find("^Hide red error messages macro:$") or
		msg:find("^hoe!$") or
		msg:find("^AAIZAVDYANO$") or
		msg:find("^Omae wa mou shindeiru[!]+$") or

		msg:find("^Casting |cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-]*]|h|r on [A-Z][%a]+$") or

		msg:find("^|cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-:)(]*]|h|r! Be careful!$") or
		msg:find("^|cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-:)(]*]|h|r! Watch out!$") or
		msg:find("^|cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-:)(]*]|h|r on me! Come together!$") or
		msg:find("^|cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-:)(]*]|h|r on me! Here we go again ...$") or
		msg:find("^|cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-:)(]*]|h|r on me! WTB merge!$") or
		msg:find("^|cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-:)(]*]|h|r! Spread out!$") or
		msg:find("^|cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-:)(]*]|h|r on me! Out of the way!$") or
		msg:find("^[%s]*|cff71d5ff|Hspell:[%d]+|h[\\[][%a%s-:)(']*]|h|r[%s]*on me!$") or
		]]
		 )) or

(FatCooldowns:GetModule("Display").db.profile.chatfilter[99933] and author ~= UnitName("player") and UnitClass("player") ~= "Druid" and -- inervate 
		(msg:lower():find("^innervate please[%s]*[!]*$") or
		msg:lower():find("^thanks for the innervate[%s!]*$") or
		msg:lower():find("^Innervate on [%a]+[%s!]*$")or
		msg:find("^cast Innervate on [A-Z][%a]+[%s!]*$") or
		msg:lower():find("^innervate me please[%s!]*$") or
		msg:find("^[A-Z][%a]+, Casted Innervate on you[%s!]*$") or
		msg:find("^Innvervate me now[%s!]*$") or
		msg:lower():find("^innervate me[%s!]*$") or
		msg:find("INNERVATE [A-Z][%a]+ PLEASE[%s!]*$") or
		msg:lower():find("^innervate "..author.."[%s!]*$") or
		msg:lower():find("^innervate "..author.."'s' booty[%s!]*$") or
		msg:find("^Casting |cff71d5ff|Hspell:[%d]+|h[\\[]Innervate]|h|r on [A-Z][%a]+[%s!]*$") or
		msg:find("^INNERVATE on [A-Z][%a]+ %([A-Z]+%) plz$") or
		msg:find("^[\"]INNERVATE ME PLEASE[\"]$") or
		msg:find("^INNER on [A-Z][%a]+ %(HPALA%) plz[%s!]*$") or
		msg:find("^INNERVATE USED$") or
		msg:find("^[A-Z][%a]+ Nayura et Manar!$") or
		msg:find("^[A-Z][%a]+ Innervated[!]*$") or
		msg:find("^[A-Z][%a]+, Casted Innervate on you[!]*$") or
		msg:find("^[A-Z][%a]+%. Casted Innervate on you[!]*$") or
		msg:find("^innervate on [A-Z][%a]+ please$") or
		msg:find("^INNERVATE HPALA [A-Z][%a]+[%s!]*$"))) or

--out of combat list can go here
(FatCooldowns:GetModule("Display").db.profile.chatfilter[99934] and author ~= UnitName("player") and
(msg:find("^Casting Resurrection on [A-Z][%a]+$") or
msg:find("^Casting Ancestral Spirit on [A-Z][%a]+$") or
msg:find("^Resurrecting [A-Z][%a]+%.$") or
msg:find("^If you cherish the idea of a mass suicide, [A-Z][%a]+ can now self-resurrect, so all should be fine. Go ahead.$") or
msg:find("^I need you to get this into your head, you have done this before, this is not progress, okey. It$") or
msg:lower():find("^in soviet icecrown, life chooses [%a]+!$") or
msg:find("^[A-Z][%a]+ get back to life Ma B!tch$") or
msg:find("^Come to life, [A-Z][%a]+, you b00n!$") or
msg:find("^Started to cast [Resurrection] on [A-Z][%a]+$") or
msg:find("^Creating a |cff71d5ff|Hspell:[%d]+|h[\\[]Ritual of Summoning]|h|r%. Please, assist%.$") or
msg:find("^Started to cast |cff71d5ff|Hspell:[%d]+|h[\\[]Soulstone Resurrection]|h|r on [A-Z][%a]+$") or
msg:find("^Started to cast |cff71d5ff|Hspell:[%d]+|h[\\[]Resurrection]|h|r on [A-Z][%a]+$") or
msg:find("^Obey now, Haaghun!$") or
msg:find("^I'll give you a soul if you come to me, Felguard! Please hear my command!$") or
msg:find("^ressing %[%[ [A-Z][%a]+ %]%]$") or
msg:find("^Wakey wakey, hands off snakey [A-Z][%a]+!$") or
msg:find("^Back on your feet%. [A-Z][%a]+[!]+ just don't come crying to me if you die again%.$") or
msg:find("^Clearly%. [A-Z][%a]+ hasn't learned how to get out of the fire yet%.$") or
msg:find("^And the [A-Z][%a]+ dies in the F[I]+[G]+HT[!]+$") or
msg:find("^Rezzing [A-Z][%a]+ should aggro every bears%.$") or
msg:find("^This Rebirth brought to [A-Z][%a]+ by Renaissance Magic%. Inc%. Bringing the dead to life faster, better, stronger%.$") or
msg:find("^Let nature come hence and heal thy wounds, and resurrect Somedeadguy, who is an utter noob!$") or
msg:find("^Hey name, think i should start using Amberseeds for this?$") or
msg:find("^[A-Z][%a]+ Combat ressedd$") or
msg:find("^Does anyone know what the respawn timer on [A-Z][%a]+ is?$") or
msg:find("^Obey now, Haaghun!$") or
msg:find("^Sending holy energies in all of [A-Z][%a]+'s secret places. Click Accept to consent$") or
msg:find("^Hey [A-Z][%a]+, I've calculated your chance of survival, but I don't think you'll like it.$") or
msg:find("^Get off the floor, [A-Z][%a]+, it does not love you that way$") or
msg:find("^Let's give [AZ][%a]+ a round of applause for that beautiful demonstration of what not to do.$") or
msg:find("^[A-Z][%a]+ get back to life u slacker !$") or
msg:find("^We have gathered here today%.%.%.%. to mourne the passing of%.%.%.%.%.%. what am i doing here again?$") or
msg:find("^Creating a |cff71d5ff|Hspell:[%d]+|h[\\[][[.]+]*]|h|r%. Please assist%.$"))) or 

((msg:lower():find("^unbound plague on me!$") or msg:lower():find("^entfesselte seuche on me!$") or msg:lower():find("^peste desatada on me!$") or msg:lower():find("^entfesselte seuche auf mir!$")) and FatCooldowns:GetModule("Display").db.profile.chatfilter[99938]) or

(msg:find("[\228-\237]") and author ~= UnitName("player") and FatCooldowns:GetModule("Display").db.profile.chatfilter[99916]) or
(msg:find("[\208]") and author ~= UnitName("player") and FatCooldowns:GetModule("Display").db.profile.chatfilter[99913]) or
((msg:find("¡") or msg:find("¿") or msg:find("Ü") or msg:find("á") or msg:find("í") or msg:find("ó") or msg:find("ú")  or msg:find("ñ") or  msg:find("Á") or msg:find("É") or
	msg:find("ü") or msg:find("Í") or msg:find("Ñ") or msg:find("Ó") or msg:find("Ú") or msg:find("é")) and author ~= UnitName("player") and FatCooldowns:GetModule("Display").db.profile.chatfilter[99937]) or

(language:find("Demonic") and author ~= UnitName("player")))

then if FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99917] > 0 and (FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[BubblesFilter] == nil or FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[BubblesFilter] ~= msg) then
	FatCooldowns:GetModule("Display").db.profile.ChatFilterReporterMessage[BubblesFilter] = msg _G["ChatFrame"..FatCooldowns:GetModule("Display").db.profile.ChatFilterReporter2[99917]]:AddMessage("FCDBubblesFilter:".."|Hplayer:"..author.."|h["..author.."]|h"..": "..msg, 1,0.49,0.04) end
	 SetCVar("chatBubbles", 0) SetCVar("chatBubblesParty", 0) if FatCooldowns:GetModule("Display").db.profile.chatfilter[99897] then return false else return true end else SetCVar("chatBubbles", 1) SetCVar("chatBubblesParty", 1) end end