local MINOR_VERSION = tonumber(("$Revision: 3 $"):match("%d+"))

FatCooldowns = LibStub("AceAddon-3.0"):NewAddon("FatCooldowns", "AceConsole-3.0", "AceComm-3.0", "AceEvent-3.0", "AceTimer-3.0","AceSerializer-3.0")
local LGT = LibStub("LibGroupTalents-1.0")
FatCooldowns.MINOR_VERSION = MINOR_VERSION
local UnitName = _G.UnitName
FatCooldowns.raidRoster = nil

FatCooldowns.FCDVer = 24

local BacklashStacks,BacklashTime = {},{}
local Oozetimestamp = nil
local Valk25MaxHP = 2992000
local Valkyrs = {}
local healers, lastcheckedpickedup = {}, 1
local RemoteSpam = {}
local markid, DispelTime, marktimestamp = nil, nil, {}
local LastDispelled = nil
local RaptureTimeStamp = {}
local PenTimeStamp = {}
local GasName1, GasName2, GasName3, GasDelay = nil, nil, nil, nil
local warriorhowls, warriorhowlschecked = {}, nil
local vilegastargets = {}
local summonvalktimestamp = nil
local Sundercount, Sundercountchecked, sundercountplayers, warrtank = {}, 0, false, false
local combatstarttimestamp, combatfinished = nil, nil
local ppsummonooze, ppsummonooze2, doublesummonooze, oozedead = nil, nil, false, false
local TimeH2, TimeH = 1, 1
local HolyPriest = nil
local backuptargetid = {}
local backuptargetspellname = {}
FatCooldowns.specchangertimestamp = nil
local NecroticTimer, lasthitbyplague, Necroticfailinfo, NecroTime = nil, nil, nil, {}
local weaponname1 = nil
local StealingBiteSpam = {}
local TotemAntiSpamp = {}
local TotemAntiSpamp2 = {}
local HuntMD = {}
local ToTRemover = nil
local manacheckcd = nil
local ValkGrabbed, GrabbedIcon = {}, 2
local WarlockBoomkinFail = 0
local SealSpamTimer = {}
local vehiclechecked = nil
local vehiclechecked2 = nil
local EmpShockTargetsTanks, EmpShockTargetsHealers, EmpShockDone = {}, {}, nil
local specchecked = nil
local FMCheck = true
local ScanIcons = true
local TempDeleteItems = true
local battlegrountargets = {}
local IsCombat = false
local ParryCounter, ParryCounterSetMembers, ParryCounterSetMembersSindra, ParryCounterH1, ParryCounterH2, ParryCounterH3, ParryCounterH4,ParryAntiSpam = {}, nil, nil, {}, {}, {}, {}, {}

local EventsFilters = {["UNIT_DIED"] = true, ["SPELL_CAST_SUCCESS"] = true, ["SPELL_AURA_APPLIED"] = true, ["SPELL_AURA_APPLIED_DOSE"] = true, ["SPELL_DISPEL"] = true, ["SPELL_PERIODIC_DAMAGE"] = true, ["SPELL_AURA_REMOVED"] = true,
["SPELL_CAST_START"] = true, ["SPELL_HEAL"] = true, ["SPELL_ENERGIZE"] = true, ["SPELL_AURA_REFRESH"] = true, ["SPELL_RESURRECT"] = true, ["SPELL_SUMMON"] = true, ["PARTY_KILL"] = true, ["SWING_DAMAGE"] = true, ["SWING_MISSED"] = true,
["RANGE_DAMAGE"] = true, ["SPELL_DAMAGE"] = true, ["SPELL_CREATE"] = true,

["SPELL_MISSED"] = false, ["SPELL_CAST_FAILED"] = false, ["ENCHANT_APPLIED"] = false, ["SPELL_PERIODIC_HEAL"] = false, ["ENVIRONMENTAL_DAMAGE"] = false, ["SPELL_PERIODIC_ENERGIZE"] = false, ["SPELL_STOLEN"] = false,
["ENCHANT_REMOVED"] = false, ["SPELL_PERIODIC_MISSED"] = false, ["SPELL_INTERRUPT"] = false, ["DAMAGE_SHIELD_MISSED"] = false, ["DAMAGE_SHIELD"] = false, ["SPELL_DISPEL_FAILED"] = false,
["RANGE_MISSED"] = false, ["SPELL_DRAIN"] = false, ["SPELL_AURA_REMOVED_DOSE"] = false, ["SPELL_PERIODIC_LEECH"] = false, ["DAMAGE_SPLIT"] = false, ["SPELL_EXTRA_ATTACKS"] = false, ["SPELL_INSTAKILL"] = false,}

local printed = {}
local buffsandprocs, buffsandprocscheck = {"Mote of Anger","Rage of the Fallen","Rage","Fury","Cultivated Power","Greatness","Surge of Power","Flame of the Heavens","Paragon","Frostforged Champion","Frostforged Sage","Swordguard Embroidery","Lightweave",
"Speed of the Vrykul","Aim of the Iron Dwarves","Precision of the Iron Dwarves","Strength of the Taunka","Power of the Taunka","Twilight Flames","Siphoned Power","Piercing Twilight",
"Icy Rage","Black Magic","Wild Magic","Speed","Blood Fury","Berserking","Bloodlust","Berserk","Chaons Bane","Soul Fragments","Demonic Pact","Hyperspeed Acceleration","Power Infusion",
"Berserk","Tricks of the Trade","Hysteria","Gift of the Wild","Mark of the Wild","Shadow Protection","Prayer of Shadow Protection","Freezing Fog","Killing Machine","Advantage","Desolation","Icy Talons","Omen of Doom",
"Starfall","Eclipse (Solar,","Eclipse (Lunar,","Tiger's Fury","Berserking","Berserk","Clearcasting","Furious","Agile","Agility of the Vrykul","Blessing of the Moon Goddess","Savage Roar","Owlkin Frenzy","Moonkin Aura",
"Leader of the Pack","Master Shapeshifter","Culling of the Herd","Furious Howl","Exploit Weakness","Quick Shots","Stinger","Arcane Potency","Combustion","Hot Streak","Missile Barrage","Molten Armor","Presence of Mind",
"The Art of War","Seal of Command","Seal of Corruption","Vengeance","Shadow Resistance Aura","Inner Focus","Shadow Weaving","Blade Flurry","Slice and Dice","Elemental Mastery","Flurry","Maelstrom Weapon",
"Maelstrom Power","Elemental Rage","Clearcasting","Totem of Wrath","Backdraft","Backlash","Eradication","Metamorphosis","Fel Armor","Molten Core","Decimation","Devious Minds","Shadow Trance","Flurry","Blood Drinker","Enrage"}, nil

function FatCooldowns:RaidScan(force)
	local newRaidRoster = {}
	local members = nil
	if self.raidRoster and force == nil then
		local newPlayers = {}

		if UnitInRaid("player") then
			members = GetNumRaidMembers()
		else
			members = GetNumPartyMembers() + 1
		end

		if members == 1 then
			self.raidRoster = nil
			self:GetModule("Display"):Reset()
			return
		end	

		for i = 1,members,1 do
			local ScanName = nil
			if UnitInRaid("player") then 
				ScanName = UnitName("raid" .. i)
			elseif not UnitInRaid("player") and i <= GetNumPartyMembers() then
				ScanName = UnitName("party" .. i)
			else
				ScanName = UnitName("player")
			end
			if ScanName == "Unknown" or ScanName == nil then
				self:ScheduleTimer(function() self:RaidScan(1) end, 10)
				return
			end
			newRaidRoster[ScanName] = true
			if self.raidRoster[ScanName] then
				self.raidRoster[ScanName] = nil
			else
				newPlayers[ScanName] = true
			end
		end
			
		if newPlayers ~= self.raidRoster then
			self:GetModule("Display"):RaidUpdate(newPlayers,self.raidRoster)
			self.raidRoster = newRaidRoster
		end
	else 
		if UnitInRaid("player") then
			members = GetNumRaidMembers()
		else 
			members = GetNumPartyMembers() + 1
		end

		if members == 1 then
			self.raidRoster = nil
			self:GetModule("Display"):Reset()
			return
		end	

		for i = 1,members,1 do
			local ScanName = nil
			if UnitInRaid("player") then
				ScanName = UnitName("raid"..i)
			elseif not UnitInRaid("player") and i <= GetNumPartyMembers() then
				ScanName = UnitName("party"..i)
			else 
				ScanName = UnitName("player")
			end
			if ScanName == "Unknown" or ScanName == nil then
				self:ScheduleTimer(function() self:RaidScan(1) end, 10)
				return
			end
			newRaidRoster[ScanName] = true
		end
			
		local verified = self:GetModule("Display"):RaidUpdate(newRaidRoster,{})
		if verified then
			self.raidRoster = newRaidRoster
		end
	end			
end

function FCDColorName2(CName,CColor)
	if CName == nil or CColor == nil then return nil end
	local _, ClassColorName = CustomUnitClass(CColor)
	if ClassColorName ~= nil then
        local CCName = RAID_CLASS_COLORS[ClassColorName]
        if CCName == nil then CCName = {r = 1, g = 1, b = 1} end
        CName = format("|cff%02x%02x%02x%s|r", CCName.r*255, CCName.g*255, CCName.b*255, CName)
        return CName
	else
		return CName
	end
end

function FCDColorName(CName)
	if CName == nil then return nil end
	local _, ClassColorName = CustomUnitClass(CName)
	if ClassColorName ~= nil then
        local CCName = RAID_CLASS_COLORS[ClassColorName]
        if CCName == nil then CCName = {r = 1, g = 1, b = 1} end
        CName = format("|cff%02x%02x%02x%s|r", CCName.r*255, CCName.g*255, CCName.b*255, CName)
        return CName
	else
		return CName
	end
end

function CustomUnitClass(classname)
	local classone, classtwo = nil, nil
	local weekday, month, day, year = CalendarGetDate()

	if classname == UnitName("player") then return UnitClass("player") end
	if UnitInRaid("player") and UnitInRaid(classname) then
		classone, classtwo = UnitClass(classname)
		if FatCooldowns:GetModule("Display").db.profile.StoreClaSSInfo then FatCooldowns:GetModule("Display").db.profile.StoreClaSSInfoExtra[classname] = {month = month, class = classone} end
		return UnitClass(classname)
	elseif UnitInParty("player") and UnitInParty(classname) then
		classone, classtwo = UnitClass(classname)
		if FatCooldowns:GetModule("Display").db.profile.StoreClaSSInfo then FatCooldowns:GetModule("Display").db.profile.StoreClaSSInfoExtra[classname] = {month = month, class = classone} end
		return UnitClass(classname)
	elseif UnitName("arena1") ~= nil then
		for a = 1, 5, 1 do
			if UnitName("arena"..a) ~= nil then
				if classname:find("[%a]+%-[%a]+") then
					local realscrnameone, realscrnametwo = select(3, classname:find("(%a+)%-(%a+)"))
					classone, classtwo = UnitClass("arena"..a)
					if realscrnameone == UnitName("arena"..a) then
						if FatCooldowns:GetModule("Display").db.profile.StoreClaSSInfo then FatCooldowns:GetModule("Display").db.profile.StoreClaSSInfoExtra[classname] = {month = month, class = classone} end
						return UnitClass("arena"..a)
					end
				elseif UnitName("arena"..a) == classname then
					classone, classtwo = UnitClass("arena1")
					if FatCooldowns:GetModule("Display").db.profile.StoreClaSSInfo then FatCooldowns:GetModule("Display").db.profile.StoreClaSSInfoExtra[classname] = {month = month, class = classone} end
					return UnitClass("arena"..a)
				end
			end
		end
	elseif UnitInBattleground("player") then
		if battlegrountargets[classname] == nil then 
			local classes = {["Death Knight"] = "DEATHKNIGHT", ["Druid"] = "DRUID", ["Hunter"] = "HUNTER", ["Mage"] = "MAGE", ["Paladin"] = "PALADIN", ["Priest"] = "PRIEST", ["Rogue"] = "ROGUE", ["Shaman"] = "SHAMAN", ["Warlock"] = "WARLOCK", ["Warrior"] = "WARRIOR"}
			for i = 1, GetNumBattlefieldScores() do
	    		local name, killingBlows, honorKills, deaths, honorGained, faction, rank, race, classbg, filename, damageDone, healingDone = GetBattlefieldScore(i)
	    		local realscrnameone, realscrnametwo = nil, nil
	    		if name ~= nil then
					if name:find("[%a]+%-[%a]+") then
						realscrnameone, realscrnametwo = select(3, name:find("(%a+)%-(%a+)"))
					end
		    		if (name == classname or realscrnameone == classname) and classbg and classname ~= nil then
						if FatCooldowns:GetModule("Display").db.profile.StoreClaSSInfo then FatCooldowns:GetModule("Display").db.profile.StoreClaSSInfoExtra[classname] = {month = month, class = classbg} end
						battlegrountargets[classname] = {class1 = classbg, class2 = classes[classbg]}
						return classbg, classes[classbg]
		    		end
		    	end
	    	end
	    else
	    	return battlegrountargets[classname].class1, battlegrountargets[classname].class2
	    end
	elseif UnitName("target") ~= nil and classname == UnitName("target") then
		classone, classtwo = UnitClass("target")
		if classone == "Warrior" or classone == "Paladin" or classone == "Hunter" or classone == "Rogue" or classone == "Priest" or classone == "Death Knight" or classone == "Shaman" or classone == "Mage" or classone == "Warlock" or classone == "Druid" then
		if FatCooldowns:GetModule("Display").db.profile.StoreClaSSInfo then FatCooldowns:GetModule("Display").db.profile.StoreClaSSInfoExtra[classname] = {month = month, class = classone} end
			return UnitClass("target")
		else return nil
		end
	elseif UnitName("focus") ~= nil and classname == UnitName("focus") then
		classone, classtwo = UnitClass("focus") 
		if classone == "Warrior" or classone == "Paladin" or classone == "Hunter" or classone == "Rogue" or classone == "Priest" or classone == "Death Knight" or classone == "Shaman" or classone == "Mage" or classone == "Warlock" or classone == "Druid" then
		if FatCooldowns:GetModule("Display").db.profile.StoreClaSSInfo then FatCooldowns:GetModule("Display").db.profile.StoreClaSSInfoExtra[classname] = {month = month, class = classone} end
			return UnitClass("focus")
		else return nil
		end
	elseif FatCooldowns:GetModule("Display").db.profile.StoreClaSSInfo and FatCooldowns:GetModule("Display").db.profile.StoreClaSSInfoExtra[classname] ~= nil then
			if FatCooldowns:GetModule("Display").db.profile.StoreClaSSInfoExtra[classname].class == "Warrior" then return "Warrior", "WARRIOR" end
			if FatCooldowns:GetModule("Display").db.profile.StoreClaSSInfoExtra[classname].class == "Paladin" then return "Paladin", "PALADIN" end
			if FatCooldowns:GetModule("Display").db.profile.StoreClaSSInfoExtra[classname].class == "Hunter" then return "Hunter", "HUNTER" end
			if FatCooldowns:GetModule("Display").db.profile.StoreClaSSInfoExtra[classname].class == "Rogue" then return "Rogue", "ROGUE" end
			if FatCooldowns:GetModule("Display").db.profile.StoreClaSSInfoExtra[classname].class == "Priest" then return "Priest", "PRIEST" end
			if FatCooldowns:GetModule("Display").db.profile.StoreClaSSInfoExtra[classname].class == "Death Knight" then return "Death Knight", "DEATHKNIGHT" end
			if FatCooldowns:GetModule("Display").db.profile.StoreClaSSInfoExtra[classname].class == "Shaman" then return "Shaman", "SHAMAN" end
			if FatCooldowns:GetModule("Display").db.profile.StoreClaSSInfoExtra[classname].class == "Mage" then return "Mage", "MAGE" end
			if FatCooldowns:GetModule("Display").db.profile.StoreClaSSInfoExtra[classname].class == "Warlock" then return "Warlock", "WARLOCK" end
			if FatCooldowns:GetModule("Display").db.profile.StoreClaSSInfoExtra[classname].class == "Druid" then return "Druid", "DRUID" end
	elseif FatCooldowns:GetModule("Display").db.profile.DeepClassScan then
		for x = 1, GetNumRaidMembers() do
			if UnitName("raid"..x.."target") ~= nil and classname == UnitName("raid"..x.."target") then
				classone, classtwo = UnitClass("raid"..x.."target") 
				if classone == "Warrior" or classone == "Paladin" or classone == "Hunter" or classone == "Rogue" or classone == "Priest" or classone == "Death Knight" or classone == "Shaman" or classone == "Mage" or classone == "Warlock" or classone == "Druid" then
					if FatCooldowns:GetModule("Display").db.profile.StoreClaSSInfo then FatCooldowns:GetModule("Display").db.profile.StoreClaSSInfoExtra[classname] = {month = month, class = classone} end
					return UnitClass("raid"..x.."target")
				end
			end
		end
	end
	return nil
end

function CustomUnitIsPlayer(playername)
	if UnitIsPlayer(playername) then return UnitIsPlayer(playername)
	elseif UnitName("arena1") ~= nil then
		for a = 1, 5, 1 do
			if UnitName("arena"..a) ~= nil then
				if playername:find("[%a]+%-[%a]+") then
					local realscrnameone, realscrnametwo = select(3, playername:find("(%a+)%-(%a+)"))
					if realscrnameone == UnitName("arena"..a) then
						return UnitIsPlayer("arena"..a)
					end
				elseif UnitName("arena"..a) == playername then
					return UnitIsPlayer("arena"..a)
				end
			end
		end
	elseif UnitInBattleground("player") then
		if battlegrountargets[playername] ~= nil then return true end
	elseif playername == UnitName("target") then return UnitIsPlayer("target")
	elseif UnitName("focus") ~= nil and playername == UnitName("focus") then return UnitIsPlayer("focus")
	elseif FatCooldowns:GetModule("Display").db.profile.StoreClaSSInfo and FatCooldowns:GetModule("Display").db.profile.StoreClaSSInfoExtra[playername] ~= nil then
			if FatCooldowns:GetModule("Display").db.profile.StoreClaSSInfoExtra[playername].class == "Warrior" then return true end
			if FatCooldowns:GetModule("Display").db.profile.StoreClaSSInfoExtra[playername].class == "Paladin" then return true end
			if FatCooldowns:GetModule("Display").db.profile.StoreClaSSInfoExtra[playername].class == "Hunter" then return true end
			if FatCooldowns:GetModule("Display").db.profile.StoreClaSSInfoExtra[playername].class == "Rogue" then return true end
			if FatCooldowns:GetModule("Display").db.profile.StoreClaSSInfoExtra[playername].class == "Priest" then return true end
			if FatCooldowns:GetModule("Display").db.profile.StoreClaSSInfoExtra[playername].class == "Death Knight" then return true end
			if FatCooldowns:GetModule("Display").db.profile.StoreClaSSInfoExtra[playername].class == "Shaman" then return true end
			if FatCooldowns:GetModule("Display").db.profile.StoreClaSSInfoExtra[playername].class == "Mage" then return true end
			if FatCooldowns:GetModule("Display").db.profile.StoreClaSSInfoExtra[playername].class == "Warlock" then return true end
			if FatCooldowns:GetModule("Display").db.profile.StoreClaSSInfoExtra[playername].class == "Druid" then return true end
	elseif FatCooldowns:GetModule("Display").db.profile.DeepClassScan then
		for x = 1, GetNumRaidMembers() do
			if UnitName("raid"..x.."target") ~= nil and playername == UnitName("raid"..x.."target") then return UnitIsPlayer("raid"..x.."target") end
		end
	end
end

local function AuraSource(self, func, unit, index, filter)
	local srcUnit = select(8, func(unit, index, filter))
	if srcUnit and FatCooldowns:GetModule("Display").db.profile.reporter[99892] then
		local _, class = UnitClass(srcUnit)
        local c = RAID_CLASS_COLORS[class]
		local srcSource = format("|cff%02x%02x%02x%s|r", c.r*255, c.g*255, c.b*255, GetUnitName(srcUnit, true))
		if srcUnit == "pet" or srcUnit == "vehicle" then
				_, class = UnitClass("player")
				c = RAID_CLASS_COLORS[class]
			srcSource = format("%s (|cff%02x%02x%02x%s|r)", GetUnitName(srcUnit), c.r*255, c.g*255, c.b*255, GetUnitName("player", true))
		else
			local partypet = srcUnit:match("^partypet(%d+)$")
			local raidpet = srcUnit:match("^raidpet(%d+)$")
			if partypet then
				_, class = UnitClass(GetUnitName("party"..partypet, true))
				c = RAID_CLASS_COLORS[class]
				srcSource = format("%s (|cff%02x%02x%02x%s|r)", GetUnitName(srcUnit), c.r*255, c.g*255, c.b*255, GetUnitName("party"..partypet, true))
			elseif raidpet then
				_, class = UnitClass(GetUnitName("raid"..raidpet, true))
				c = RAID_CLASS_COLORS[class]
				srcSource = format("%s (|cff%02x%02x%02x%s|r)", GetUnitName(srcUnit), c.r*255, c.g*255, c.b*255, GetUnitName("raid"..raidpet, true))
			end
		end		
		self:AddLine(srcSource)
		self:Show()
	end
end

local funcs = {SetUnitAura = UnitAura, SetUnitBuff = UnitBuff, SetUnitDebuff = UnitDebuff}

for k, v in pairs(funcs) do
	hooksecurefunc(GameTooltip, k, function(self, unit, index, filter)
		AuraSource(self, v, unit, index, filter)
	end)
end

function FatCooldowns:DistanceChecker(unit1,unit2)
	if UnitName("boss1") ~= "Sindragosa" or not UnitInRaid(unit1) or not UnitInRaid(unit2) then return 99 end
	SetMapToCurrentZone()
	local x1,y1 = GetPlayerMapPosition(unit1)
	local x2,y2 = GetPlayerMapPosition(unit2)
	local Lw,Lh = 720.60965618252, 481.1621506613
	local dx = (x2 - x1) * Lw
	local dy = (y2 - y1) * Lh
	return (dx*dx + dy*dy)^(0.5)
end

function FatCooldowns:MERCHANT_SHOW()
	FatCooldowns:GetModule("Display"):UpdateMF()
	FatCooldowns:GetModule("Display"):UpdateBF()
	if UnitLevel("player") == 80 and FatCooldowns:GetModule("Display").db.profile.reporter[99891] then
		local currentstock = nil
		if UnitClass("player") == "Druid" then
			currentstock = GetItemCount("Wild Spineleaf")
			if currentstock < 20 then
				local numtobuy = 20 - currentstock
				for i=1, GetMerchantNumItems() do
					if GetMerchantItemInfo(i) == "Wild Spineleaf" then BuyMerchantItem(i, numtobuy) end
				end
			end
		elseif UnitClass("player") == "Priest" then
			currentstock = GetItemCount("Devout Candle")
			if currentstock < 20 then
				local numtobuy = 20 - currentstock
				for i=1, GetMerchantNumItems() do
					if GetMerchantItemInfo(i) == "Devout Candle" then BuyMerchantItem(i, numtobuy) end
				end
			end
		elseif UnitClass("player") == "Paladin" then
			currentstock = GetItemCount("Symbol of Divinity")
			if currentstock < 5 then
				local numtobuy = 5 - currentstock
				for i=1, GetMerchantNumItems() do
					if GetMerchantItemInfo(i) == "Symbol of Divinity" then BuyMerchantItem(i, numtobuy) end
				end
			end
			currentstock = math.floor(GetItemCount("Symbol of Kings") / 20)
			if currentstock < 5 then
				local numtobuy = 5 - currentstock
				for i=1, GetMerchantNumItems() do
					if GetMerchantItemInfo(i) == "Symbol of Kings" then BuyMerchantItem(i, numtobuy) end
				end
			end
		elseif UnitClass("player") == "Mage" then
			currentstock = GetItemCount("Rune of Portals")
			if currentstock < 20 then
				local numtobuy = 20 - currentstock
				for i=1, GetMerchantNumItems() do
					if GetMerchantItemInfo(i) == "Rune of Portals" then BuyMerchantItem(i, numtobuy) end
				end
			end
			currentstock = GetItemCount("Arcane Powder")
			if currentstock < 100 then
				local numtobuy = 100 - currentstock
				for i=1, GetMerchantNumItems() do
					if GetMerchantItemInfo(i) == "Arcane Powder" then BuyMerchantItem(i, numtobuy) end
				end
			end
		elseif UnitClass("player") == "Rogue" then
			currentstock = GetItemCount("Deadly Poison IX")
			if currentstock < 20 then
				local numtobuy = 20 - currentstock
				for i=1, GetMerchantNumItems() do
					if GetMerchantItemInfo(i) == "Deadly Poison IX" then BuyMerchantItem(i, numtobuy) end
				end
			end
			currentstock = GetItemCount("Instant Poison IX")
			if currentstock < 20 then
				local numtobuy = 20 - currentstock
				for i=1, GetMerchantNumItems() do
					if GetMerchantItemInfo(i) == "Instant Poison IX" then BuyMerchantItem(i, numtobuy) end
				end
			end
		end
	end
	if FatCooldowns:GetModule("Display").db.profile.AutoSell then
		for x = 0, 4 do 
   			for y = 1, GetContainerNumSlots(x) do
				local icon, itemCount, locked, quality, readable, lootable, itemLink, isFiltered, noValue = GetContainerItemInfo(x,y)
				if itemLink ~= nil then
					local ItemName, itemLink, itemRarity, itemLevel, itemMinLevel, itemType, itemSubType, itemStackCount, itemEquipLoc, itemTexture, itemSellPrice = GetItemInfo(itemLink)
					if (itemRarity == 0 or FatCooldowns:GetModule("Display").db.profile.SellList[ItemName] == ItemName) then
						if itemSellPrice == 0 then
							if not FatCooldowns:GetModule("Display").db.profile.SellSilence then print("FCD: Destorying "..itemLink.." Cant Sell") end
	   						PickupContainerItem(x,y)
             				DeleteCursorItem()
						else
							if not FatCooldowns:GetModule("Display").db.profile.SellSilence then print("FCD: Selling "..itemLink) end
							UseContainerItem(x,y)
						end
					end
				end
   			end
   		end
	end
	if FatCooldowns:GetModule("Display").db.profile.reporter[99889] and CanMerchantRepair() then
		local repairAllCost, canRepair  = GetRepairAllCost()
		if repairAllCost ~= nil and repairAllCost ~= 0 and canRepair and repairAllCost <= GetMoney() then
			if CanGuildBankRepair() then
				RepairAllItems(1)
				local repairAllCost2, canRepair2  = GetRepairAllCost()
				if repairAllCost2 ~= nil and repairAllCost2 ~= 0 and canRepair2 and repairAllCost2 <= GetMoney() then
					local editedcost = repairAllCost - repairAllCost2
					RepairAllItems(0)
					if editedcost ~= nil and editedcost ~= 0 then DEFAULT_CHAT_FRAME:AddMessage("Guild: Items have been repaired for "..GetCoinText(editedcost,", ")..".",255,255,0) end
					DEFAULT_CHAT_FRAME:AddMessage("Guild: Items have been repaired for "..GetCoinText(repairAllCost2,", ")..".",255,255,0)
				else
				DEFAULT_CHAT_FRAME:AddMessage("Guild: Items have been repaired for "..GetCoinText(repairAllCost,", ")..".",255,255,0)
				end
			else
				RepairAllItems(0)
				DEFAULT_CHAT_FRAME:AddMessage("Self: Items have been repaired for "..GetCoinText(repairAllCost,", ")..".",255,255,0)
			end
		elseif repairAllCost ~= nil and repairAllCost ~= 0 and canRepair and repairAllCost >= GetMoney() then
			DEFAULT_CHAT_FRAME:AddMessage("Self: You need more gold for repairs",255,255,0)
		end
	end
end

function FatCooldowns:READY_CHECK()
	if FatCooldowns:GetModule("Display").db.profile.reporter[99890] and not (IsModifierKeyDown() or UnitIsAFK("player") or UnitIsDND("player")) then
		ConfirmReadyCheck(1)
		ReadyCheckFrame:Hide()
	end
end

function FatCooldowns:AvgIlvl()
	local AvgIlvlT, AvgIlvlC, AvgIlvlK = 0, 0, nil
	for i = 1, 18 do
		AvgIlvlK = GetInventoryItemLink("player",i)
		if i ~= 4 and AvgIlvlK then
			AvgIlvlT = AvgIlvlT + select(4,GetItemInfo(AvgIlvlK))
			AvgIlvlC = AvgIlvlC + 1
		end
	end
	return AvgIlvlT / AvgIlvlC
end

function FatCooldowns:START_LOOT_ROLL(Event, RollID, ...)
	local ItemLink, RollMethod = nil, nil
	local texture, name, count, quality, bindOnPickUp, canNeed, canGreed, canDisenchant, reasonNeed, reasonGreed, reasonDisenchant, deSkillRequired = GetLootRollItemInfo(RollID)

	if FatCooldowns:GetModule("Display").db.profile.ILvlAvg and self:AvgIlvl() < 232 then return end
	if FatCooldowns:GetModule("Display").db.profile.LootBlackList[name] == name then return end

	if quality == 2 then -- green 
		if FatCooldowns:GetModule("Display").db.profile.GLoot == 1 then return -- none
		elseif FatCooldowns:GetModule("Display").db.profile.GLoot == 2 then RollMethod = 0 -- apass
		elseif FatCooldowns:GetModule("Display").db.profile.GLoot == 3 then
			if canDisenchant then RollMethod = 3 else RollMethod = 2 end-- de > greed 
		elseif FatCooldowns:GetModule("Display").db.profile.GLoot == 4 then RollMethod = 2 -- greed
		elseif FatCooldowns:GetModule("Display").db.profile.GLoot == 5 then RollMethod = 1 -- need

		elseif FatCooldowns:GetModule("Display").db.profile.GLoot == 6 and UnitInRaid("player") then RollMethod = 0 -- pass
		elseif FatCooldowns:GetModule("Display").db.profile.GLoot == 7 and UnitInRaid("player") then
			if canDisenchant then RollMethod = 3 else RollMethod = 2 end-- de > greed 
		elseif FatCooldowns:GetModule("Display").db.profile.GLoot == 8 and UnitInRaid("player") then RollMethod = 2 -- greed
		elseif FatCooldowns:GetModule("Display").db.profile.GLoot == 9 and UnitInRaid("player") then RollMethod = 1 -- need

		elseif FatCooldowns:GetModule("Display").db.profile.GLoot == 10 and not UnitInRaid("player") then RollMethod = 0 -- pass
		elseif FatCooldowns:GetModule("Display").db.profile.GLoot == 11 and not UnitInRaid("player") then
			if canDisenchant then RollMethod = 3 else RollMethod = 2 end-- de > greed 
		elseif FatCooldowns:GetModule("Display").db.profile.GLoot == 12 and not UnitInRaid("player") then RollMethod = 2 -- greed
		elseif FatCooldowns:GetModule("Display").db.profile.GLoot == 13 and not UnitInRaid("player") then RollMethod = 1 -- need
		end
	elseif quality == 3 then -- blue
		if FatCooldowns:GetModule("Display").db.profile.BLoot == 1 then return -- none
		elseif FatCooldowns:GetModule("Display").db.profile.BLoot == 2 then RollMethod = 0 -- apass
		elseif FatCooldowns:GetModule("Display").db.profile.BLoot == 3 then
			if canDisenchant then RollMethod = 3 else RollMethod = 2 end-- de > greed 
		elseif FatCooldowns:GetModule("Display").db.profile.BLoot == 4 then RollMethod = 2 -- greed
		elseif FatCooldowns:GetModule("Display").db.profile.BLoot == 5 then RollMethod = 1 -- need

		elseif FatCooldowns:GetModule("Display").db.profile.BLoot == 6 and UnitInRaid("player") then RollMethod = 0 -- pass
		elseif FatCooldowns:GetModule("Display").db.profile.BLoot == 7 and UnitInRaid("player") then
			if canDisenchant then RollMethod = 3 else RollMethod = 2 end-- de > greed 
		elseif FatCooldowns:GetModule("Display").db.profile.BLoot == 8 and UnitInRaid("player") then RollMethod = 2 -- greed
		elseif FatCooldowns:GetModule("Display").db.profile.BLoot == 9 and UnitInRaid("player") then RollMethod = 1 -- need	

		elseif FatCooldowns:GetModule("Display").db.profile.BLoot == 10 and not UnitInRaid("player") then RollMethod = 0 -- pass
		elseif FatCooldowns:GetModule("Display").db.profile.BLoot == 11 and not UnitInRaid("player") then
			if canDisenchant then RollMethod = 3 else RollMethod = 2 end-- de > greed 
		elseif FatCooldowns:GetModule("Display").db.profile.BLoot == 12 and not UnitInRaid("player") then RollMethod = 2 -- greed
		elseif FatCooldowns:GetModule("Display").db.profile.BLoot == 13 and not UnitInRaid("player") then RollMethod = 1 -- need
		end
	elseif quality == 4 then -- purple
		if FatCooldowns:GetModule("Display").db.profile.PLoot == 1 then return -- none
		elseif FatCooldowns:GetModule("Display").db.profile.PLoot == 2 then RollMethod = 0 -- apass
		elseif FatCooldowns:GetModule("Display").db.profile.PLoot == 3 then
			if canDisenchant then RollMethod = 3 else RollMethod = 2 end-- de > greed 
		elseif FatCooldowns:GetModule("Display").db.profile.PLoot == 4 then RollMethod = 2 -- greed
		elseif FatCooldowns:GetModule("Display").db.profile.PLoot == 5 then RollMethod = 1 -- need
		elseif FatCooldowns:GetModule("Display").db.profile.PLoot == 6 and UnitInRaid("player") then RollMethod = 0 -- pass
		elseif FatCooldowns:GetModule("Display").db.profile.PLoot == 7 and UnitInRaid("player") then
			if canDisenchant then RollMethod = 3 else RollMethod = 2 end-- de > greed 
		elseif FatCooldowns:GetModule("Display").db.profile.PLoot == 8 and UnitInRaid("player") then RollMethod = 2 -- greed
		elseif FatCooldowns:GetModule("Display").db.profile.PLoot == 9 and UnitInRaid("player") then RollMethod = 1 -- need

		elseif FatCooldowns:GetModule("Display").db.profile.PLoot == 10 and not UnitInRaid("player") then RollMethod = 0 -- pass
		elseif FatCooldowns:GetModule("Display").db.profile.PLoot == 11 and not UnitInRaid("player") then
			if canDisenchant then RollMethod = 3 else RollMethod = 2 end-- de > greed 
		elseif FatCooldowns:GetModule("Display").db.profile.PLoot == 12 and not UnitInRaid("player") then RollMethod = 2 -- greed
		elseif FatCooldowns:GetModule("Display").db.profile.PLoot == 13 and not UnitInRaid("player") then RollMethod = 1 -- need
		end
	end
	if (quality == 2 or quality == 3 or quality == 4) and RollMethod ~= nil and RollID ~= nil then
		RollOnLoot(RollID, RollMethod)
		ConfirmLootRoll(RollID, RollMethod)
    	StaticPopup_Hide(Event, RollID)
    end
end

function FatCooldowns:OnInitialize()
	self:SetEnabledState(true)

	self.prefix = "FRCD3Shekles20"
	self.prefixB = "FRCD3BShekles20" -- broadcast
	self.prefixR = "FRCD3RShekles20" -- request
	self.prefixI = "FRCD3IShekles20" -- infodump
	self.prefixS = "FRCD3SShekles20" -- singleReport
	self.prefixL = "FRCD3LShekles" 
	self.prefixC = "FCDPARRYCOUNTER"
	self:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED")
	self:RegisterEvent("UNIT_SPELLCAST_SUCCEEDED")
	self:RegisterEvent("CHAT_MSG_ADDON")
	self:RegisterEvent("PARTY_MEMBERS_CHANGED")
	self:RegisterEvent("CHAT_MSG_RAID_BOSS_EMOTE")
	self:RegisterEvent("UNIT_SPELLCAST_SENT")
	self:RegisterEvent("UNIT_INVENTORY_CHANGED")
	self:RegisterEvent("MERCHANT_SHOW")
	self:RegisterEvent("READY_CHECK")
	self:RegisterEvent("UNIT_EXITED_VEHICLE")
	self:RegisterEvent("RAID_TARGET_UPDATE")
	self:RegisterEvent("START_LOOT_ROLL")
	self:RegisterEvent("LOOT_OPENED")
	self:RegisterEvent("UPDATE_INSTANCE_INFO")
end

function FatCooldowns:OnEnable()
	self:RegisterComm(self.prefix)
	self:RegisterComm(self.prefixB)
	self:RegisterComm(self.prefixR)
	self:RegisterComm(self.prefixI)
	self:RegisterComm(self.prefixS)
	self:RegisterComm(self.prefixL)
	self:RegisterComm(self.prefixC)
	
	local modulename, module
	for modulename, module in self:IterateModules() do
		if not module:IsEnabled() then
			self:EnableModule(modulename)
		end
	end
	
	self:RaidScan()
end

local EnterCombatToolTip = CreateFrame("Frame")
local LeaveCombatToolTip = CreateFrame("Frame")
EnterCombatToolTip:RegisterEvent("PLAYER_REGEN_DISABLED")
EnterCombatToolTip:SetScript("OnEvent",function() 
	GameTooltip:SetScript("OnShow",function(self) 
		local point, relativeTo, relativePoint = self:GetPoint()
		if FatCooldowns:GetModule("Display").db.profile.GameTooltipHide and point == "BOTTOMRIGHT" and relativeTo == UIParent and relativePoint == "BOTTOMRIGHT" then
			if FatCooldowns:GetModule("Display").db.profile.GameTooltipHideShift and IsShiftKeyDown() then
				self:Show()
			else
				self:Hide()
			end 
		end
	end) 
end)

LeaveCombatToolTip:RegisterEvent("PLAYER_REGEN_ENABLED")
LeaveCombatToolTip:SetScript("OnEvent",function() GameTooltip:SetScript("OnShow",function(self) end) end)

function FatCooldowns:UPDATE_INSTANCE_INFO(event, name)
	FatCooldowns:GetModule("Display"):UpdateRF()
end

function FatCooldowns:UNIT_EXITED_VEHICLE(event, name)
  	if UnitName("boss1") == "The Lich King" and name:find("raid") then
  		self:ValkScanner(event,name)
  		name = UnitName(name)
	end
end

function FatCooldowns:SetGroupLoot2()
  	if IsRaidLeader() and UnitName("boss1") == nil then
  		SetLootMethod("group")
  	end
end

function FatCooldowns:SetGroupLoot()
	local _, zone3 = IsInInstance()
  	if FatCooldowns:GetModule("Display").db.profile.GLOnBoss and (not FatCooldowns:GetModule("Display").db.profile.ICCnRSML or FatCooldowns:GetModule("Display").db.profile.ICCnRSML and (zone3 == "Icecrown Citadel" or zone3 == "Ruby Sanctum")) then
  		local lootmethod, masterlooterPartyID, masterlooterRaidID = GetLootMethod()
  		if UnitInRaid("player") and IsRaidLeader() and lootmethod ~= "group" then
  			self:ScheduleTimer(function() self:SetGroupLoot2() end, 40)
  		end
  	end
	if FatCooldowns:GetModule("Display").db.profile.reporter[99872] then
		for q=1, GetNumQuestLogEntries() do
			local title, level, _, _, _, _, isComplete = GetQuestLogTitle(q)
			if title == "Deprogramming" and level == 80 and isComplete == -1 then
				SelectQuestLogEntry(q)
				SetAbandonQuest()
				AbandonQuest()
			end
		end
	end
end

function FatCooldowns:SetMasterLoot2()
  	if IsRaidLeader() and UnitName("boss1") ~= nil then
		SetLootMethod("master", FatCooldowns:GetModule("Display").db.profile.MLOnBossName)
  	end
end

function FatCooldowns:SetMasterLoot()
	local _, zone3 = IsInInstance()
	if FatCooldowns:GetModule("Display").db.profile.MLOnBoss and (not FatCooldowns:GetModule("Display").db.profile.ICCnRSML or FatCooldowns:GetModule("Display").db.profile.ICCnRSML and (zone3 == "Icecrown Citadel" or zone3 == "Ruby Sanctum")) then
		if FatCooldowns:GetModule("Display").db.profile.MLOnBossName == nil or (FatCooldowns:GetModule("Display").db.profile.MLOnBossName ~= nil and not UnitInRaid(FatCooldowns:GetModule("Display").db.profile.MLOnBossName)) then
			FatCooldowns:GetModule("Display").db.profile.MLOnBossName = UnitName("player")
		end
	end
  	if FatCooldowns:GetModule("Display").db.profile.MLOnBoss then
  		local lootmethod, masterlooterPartyID, masterlooterRaidID = GetLootMethod()
  		if UnitInRaid("player") and IsRaidLeader() and lootmethod ~= "master" then
  			self:ScheduleTimer(function() self:SetMasterLoot2() end, 1)
  		end
  	end
end

function FatCooldowns:DeleteItems()
	if FatCooldowns:GetModule("Display").db.profile.EnablePopup then
		if FatCooldowns:GetModule("Display").db.profile.KeepSpaceFree > self:BagsFree() then
			self:ScheduleTimer(function() self:DeleteItems() end, 0.5)
			local ItemsToDelete = {}
			local ItemsToDeletePrice = {}
			local DelItem = false
			for x = 0, 4 do 
	   			for y = 1, GetContainerNumSlots(x) do
					local icon, itemCount, locked, quality, readable, lootable, itemLink, isFiltered, noValue = GetContainerItemInfo(x,y)
					if itemLink ~= nil then
						local ItemName, itemLink, itemRarity, itemLevel, itemMinLevel, itemType, itemSubType, itemStackCount, itemEquipLoc, itemTexture, itemSellPrice = GetItemInfo(itemLink)
						if (itemRarity == 0 or FatCooldowns:GetModule("Display").db.profile.SellList[ItemName] == ItemName) and itemSellPrice < FatCooldowns:GetModule("Display").db.profile.PriceRange then
							ItemsToDeletePrice[#ItemsToDeletePrice + 1] = itemSellPrice
							ItemsToDelete[itemSellPrice] = {bag = x, slot = y, itemLink = itemLink, ItemName = ItemName}
							DelItem = true
						end
					end
	   			end
	   		end
	   		if ItemsToDelete ~= nil and ItemsToDeletePrice ~= nil and DelItem then
	   			self:SortTableNum(ItemsToDeletePrice)
	   			if not FatCooldowns:GetModule("Display").db.profile.SellSilence and ItemsToDelete[ItemsToDeletePrice[1]] ~= nil then print("FCD: Destorying "..ItemsToDelete[ItemsToDeletePrice[1]].itemLink) end
	   			PickupContainerItem(ItemsToDelete[ItemsToDeletePrice[1]].bag, ItemsToDelete[ItemsToDeletePrice[1]].slot)
             	DeleteCursorItem()
	   		end
	   	else 
	   		TempDeleteItems = true
	   	end
	end
end

function FatCooldowns:LOOT_OPENED() 
	if UnitInRaid("player") and FatCooldowns:GetModule("Display").db.profile.MLAutoLoot then 
		for x = 1, GetNumRaidMembers() do
			if UnitName("player") == UnitName("raid"..x) then 
				local name, rank, subgroup, level, class, fileName, zone, online, isDead, role, isML = GetRaidRosterInfo(x)
				if isML and (not FatCooldowns:GetModule("Display").db.profile.MLAutoLootRSICC or (FatCooldowns:GetModule("Display").db.profile.MLAutoLootRSICC and (zone == "Icecrown Citadel" or zone == "Ruby Sanctum"))) then 
					for y = 1, GetNumRaidMembers() do
						if GetMasterLootCandidate(y) == UnitName("player") then 
							for l = 1, GetNumLootItems() do
								if GetLootSlotLink(l) ~= nil then
									local ItemName, itemLink, itemRarity, itemLevel, itemMinLevel, itemType, itemSubType, itemStackCount, itemEquipLoc, itemTexture, itemSellPrice = GetItemInfo(GetLootSlotLink(l))
									if ItemName ~= nil then
										if FatCooldowns:GetModule("Display").db.profile.MasterLootBlackList[ItemName] ~= nil and FatCooldowns:GetModule("Display").db.profile.MasterLootBlackList[ItemName] == ItemName then 
										else 
											if not IsShiftKeyDown() then
												GiveMasterLoot(l, y)
											end
										end
									end
								end
							end
						end
					end
				end
			end
		end
	end
end

--------------[[		Events		]]--------------
function FatCooldowns:UNIT_INVENTORY_CHANGED(event, arg1)
	if arg1 == "player" and CustomUnitClass("player") == "Warlock" and FatCooldowns:GetModule("Display").db.profile.SoulStoneCount ~= nil and FatCooldowns:GetModule("Display").db.profile.SoulStoneCount ~= 0 then
		local SSCount = GetItemCount("Soul Shard")
		for x = 0, 4 do 
   			for y = 1, GetContainerNumSlots(x) do
				if (SSCount > 0 and SSCount > FatCooldowns:GetModule("Display").db.profile.SoulStoneCount) then
    				local link = GetContainerItemLink(x,y)
    				if (link and (GetItemInfo(link) == "Soul Shard")) and UnitAffectingCombat("player") then
             			PickupContainerItem(x,y)
             			DeleteCursorItem()
             			self:ScheduleTimer(function() self:UNIT_INVENTORY_CHANGED(event, "player") end, 0.5)
             			return
             		end
             	end
         	end
     	end
	end
	if arg1 == "player" and TempDeleteItems then TempDeleteItems = false self:DeleteItems() end
end

function FatCooldowns:SetIconOnPlayer()
	if FatCooldowns:GetModule("Display").db.profile.KeepIcon2Toggle == true and FatCooldowns:GetModule("Display").db.profile.KeepIcon1Toggle == true then 
		if FatCooldowns:GetModule("Display").db.profile.KeepIcon2 ~= nil then
			if not UnitInRaid(FatCooldowns:GetModule("Display").db.profile.KeepIcon2) then FatCooldowns:GetModule("Display").db.profile.KeepIcon2 = nil end
		end
		if FatCooldowns:GetModule("Display").db.profile.KeepIcon1 ~= nil then 
			if not UnitInRaid(FatCooldowns:GetModule("Display").db.profile.KeepIcon1) then FatCooldowns:GetModule("Display").db.profile.KeepIcon1 = nil end
		end
		if FatCooldowns:GetModule("Display").db.profile.KeepIcon2 ~= nil and FatCooldowns:GetModule("Display").db.profile.KeepIcon1 ~= nil then 
			if FatCooldowns:GetModule("Display").db.profile.KeepIcon2Icon == FatCooldowns:GetModule("Display").db.profile.KeepIcon1Icon then
				print("FCD KeepIcons: Warning both icons are the same please change")
				return
			end
			if FatCooldowns:GetModule("Display").db.profile.KeepIcon2 == FatCooldowns:GetModule("Display").db.profile.KeepIcon1 then
				print("FCD KeepIcons: Warning both names are the same please change")
				return
			end
		end
	end
	if UnitInRaid("player") and (IsRaidLeader() or IsRaidOfficer()) then
		if FatCooldowns:GetModule("Display").db.profile.KeepIcon1Toggle == true and FatCooldowns:GetModule("Display").db.profile.KeepIcon1 ~= nil and 
			UnitInRaid(FatCooldowns:GetModule("Display").db.profile.KeepIcon1) and FatCooldowns:GetModule("Display").db.profile.KeepIcon1Icon ~= nil and FatCooldowns:GetModule("Display").db.profile.KeepIcon1Icon ~= 1 then
			if GetRaidTargetIndex(FatCooldowns:GetModule("Display").db.profile.KeepIcon1) ~= (FatCooldowns:GetModule("Display").db.profile.KeepIcon1Icon - 1) then
				SetRaidTarget(FatCooldowns:GetModule("Display").db.profile.KeepIcon1, FatCooldowns:GetModule("Display").db.profile.KeepIcon1Icon - 1)
			end
		end
		if FatCooldowns:GetModule("Display").db.profile.KeepIcon2Toggle == true and FatCooldowns:GetModule("Display").db.profile.KeepIcon2 ~= nil and
			UnitInRaid(FatCooldowns:GetModule("Display").db.profile.KeepIcon2) and FatCooldowns:GetModule("Display").db.profile.KeepIcon2Icon ~= nil and FatCooldowns:GetModule("Display").db.profile.KeepIcon2Icon ~= 1 then
			if GetRaidTargetIndex(FatCooldowns:GetModule("Display").db.profile.KeepIcon2) ~= (FatCooldowns:GetModule("Display").db.profile.KeepIcon2Icon - 1) then
				SetRaidTarget(FatCooldowns:GetModule("Display").db.profile.KeepIcon2, FatCooldowns:GetModule("Display").db.profile.KeepIcon2Icon - 1)
			end
		end
	end
	self:ScheduleTimer(function() self:SetIconOnPlayer() end, 2)
end

function FatCooldowns:RAID_TARGET_UPDATE()
	if FatCooldowns:GetModule("Display").db.profile.KeepIcon2Toggle == true or FatCooldowns:GetModule("Display").db.profile.KeepIcon1Toggle == true then 
		if ScanIcons then ScanIcons = false self:ScheduleTimer(function() self:SetIconOnPlayer() end, 2) end
	end
end

function FatCooldowns:CHAT_MSG_RAID_BOSS_EMOTE(event, text, playerName, _, _, playerName2)
	if playerName == "Prince Taldaram" and playerName2 ~= nil then
		if text:find("Empowered Flames speed toward") then
			local info = "Empowered Flames on "..playerName2.." run!"
			self:GetModule("Display"):chatreporter(playerName, 99967, 1,playerName2, nil, nil, nil, nil, info)
		end
	end
end

function FatCooldowns:CHAT_MSG_ADDON(event, prefix, msg, channel, sender, target, ...) 
	if event == "CHAT_MSG_ADDON" and msg == "FCDVerSend" then self:SendCommMessage("FRCD3LShekles", self:Serialize(FatCooldowns.FCDVer), "RAID", target) end
end

function FatCooldowns:Promo()
	if UnitInRaid("player") and not UnitAffectingCombat("player") and IsRaidLeader() then
		local Ranks = {}
		for i = 1, GuildControlGetNumRanks() do
			local rankName = GuildControlGetRankName(i)
			if Ranks[rankName] == nil then Ranks[rankName] = i end
		end
		if FatCooldowns:GetModule("Display").db.profile.AutoAssist ~= nil then
			if FatCooldowns:GetModule("Display").db.profile.AutoAssist[GetGuildInfo("player")] ~= nil then
				for x = 1, GetNumGuildMembers() do
					local name, rankName = GetGuildRosterInfo(x)
					if UnitInRaid(name) then
						for i = 1, GetNumRaidMembers() do
							local PlayerNamePromo, PlayerRankPromo = GetRaidRosterInfo(i)
							if name == PlayerNamePromo and PlayerRankPromo == 0 and Ranks[rankName] <= Ranks[FatCooldowns:GetModule("Display").db.profile.AutoAssist[GetGuildInfo("player")]] then
								PromoteToAssistant(name)
							end
						end
					end
				end
			end
		end
	end
end

function FatCooldowns:PARTY_MEMBERS_CHANGED(event)
	RaidPlayersNames()
	self:Promo()
	FatCooldowns:GetModule("Display"):TalentItemScan("True")
	FatCooldowns:GetModule("Display"):UpdateRF()
	if not UnitAffectingCombat("player") then
		if event == "PARTY_MEMBERS_CHANGED" and IsRaidLeader() then
			self:SendCommMessage("FRCD3LShekles", self:Serialize("FCDLEADER"), "RAID", target)
		elseif event == "PARTY_MEMBERS_CHANGED" and IsRaidOfficer() then
			self:SendCommMessage("FRCD3LShekles", self:Serialize("FCDOFFICER"), "RAID", target)
		elseif event == "PARTY_MEMBERS_CHANGED" and not IsRaidLeader() and not IsRaidOfficer() then
			self:SendCommMessage("FRCD3LShekles", self:Serialize("FCDPLAYER"), "RAID", target)
		end
	end
	self:ScheduleTimer(function() self:RaidScan() end, 2)
end

function FatCooldowns:UNIT_SPELLCAST_SENT(event, ...)
	local arg1, arg2, arg3, arg4 = ...
	local senderbackup = arg1
	local spellnamebackup = arg2
	local cooldownbackup = nil
	local spellIdbackup = nil

	if UnitInRaid("player") then
		if not senderbackup:find("raid") then return end
			senderbackup = UnitName(arg1)
	elseif not UnitInRaid("player") and GetNumPartyMembers() >= 1 then
		if senderbackup:find("party") then
			senderbackup = UnitName(arg1)
		elseif senderbackup:find("player") then
			senderbackup = UnitName("player")
		end
	elseif not UnitInRaid("player") and GetNumPartyMembers() == 0 then
		if senderbackup == "player" then senderbackup = UnitName(arg1) else return end
	end
	if senderbackup ~= nil and senderbackup:find("[%a]+%-[%a]+") and CustomUnitIsPlayer(senderbackup) then
		local realscrnameone, realscrnametwo = select(3, senderbackup:find("(%a+)%-(%a+)"))
		senderbackup = realscrnameone
	end
	if arg4 ~= nil and arg4:find("^[%a]+%-[%a]+$") and CustomUnitIsPlayer(arg4) then
		local realscrnameone, realscrnametwo = select(3, arg4:find("(%a+)%-(%a+)"))
		arg4 = realscrnameone
	end
	backuptargetid[senderbackup] = arg4
	backuptargetspellname[senderbackup] = spellnamebackup
end

function FatCooldowns:UNIT_SPELLCAST_SUCCEEDED(event, ...)
	local arg1, arg2, arg3 = ...

	if FatCooldowns:GetModule("Display").db.profile.reporter[99806] then
		if UnitName(arg1) == UnitName("player") and LGT:GetUnitTalentSpec("player") == nil then LGT:RefreshTalentsByUnit(UnitName("player")) end
		if UnitClass("player") == "Warrior" and arg2 == "Berserker Stance" and LGT:GetUnitTalentSpec("player") == "Fury" then
			UseEquipmentSet("FCDFury")
		end
	end

	if (arg2 == "Activate Secondary Spec" or arg2 == "Activate Primary Spec") and (arg1:find("player") or arg1:find("raid") or arg1:find("party")) then
		self.specchangertimestamp = GetTime()
		local SpecChanger = UnitName(arg1)
		local _, c = CustomUnitClass(SpecChanger)
		if SpecChanger ~= nil then self:ScheduleTimer(function() LGT:RefreshTalentsByUnit(SpecChanger) end, 3) end
		if self.cooldowns[c] then
		local spells = self.cooldowns[c]
			for spellName, spellTable in pairs(self.cooldowns[c]) do
				if spellTable.talent then
					self:GetModule("Display"):StopCooldown(SpecChanger,spellTable.id, "True")
				end
			end
		end
		if self.cooldowns["ITEMS"] then
			local spells = self.cooldowns["ITEMS"]
			for spellName, spellTable in pairs(self.cooldowns["ITEMS"]) do
				if spellTable.item then
					self:GetModule("Display"):StopCooldown(SpecChanger,spellTable.id, "True")
				end
			end
		end
		self:ScheduleTimer(function() self:GetModule("Display"):TalentItemScan("True") end, 5)
	end

	if arg2 == "War Stomp" then FatCooldowns:COMBAT_LOG_EVENT_UNFILTERED("COMBAT_LOG_EVENT_UNFILTERED", nil, "SPELL_CAST_SUCCESS", nil, arg1, nil, nil, nil, nil, 20549, "War Stomp" )
	elseif arg2 == "Stoneform" then FatCooldowns:COMBAT_LOG_EVENT_UNFILTERED("COMBAT_LOG_EVENT_UNFILTERED", nil, "SPELL_CAST_SUCCESS", nil, arg1, nil, nil, nil, nil, 20594, "Stoneform" ) end

	if not FatCooldowns:GetModule("Display").db.profile.Backupcdused and  arg2 ~= "Penance" and arg2 ~= "Rapture" and arg2 ~= "Combustion" and arg2 ~= "Divine Favor" and arg2 ~= "Nature's Swiftness" and arg2 ~= "Presence of Mind"  then
		if arg1 == "player" or arg1:find("party") or arg1:find("raid") then
			local senderbackup = arg1
			local spellnamebackup = arg2
			local cooldownbackup = nil
			local spellIdbackup = nil
			if UnitInRaid("player") then
				if not senderbackup:find("raid") then return end
					senderbackup = UnitName(arg1)
			elseif not UnitInRaid("player") and GetNumPartyMembers() >= 1 then
				if not senderbackup:find("player") then
					if not senderbackup:find("party") then return end
					senderbackup = UnitName(arg1)
				elseif senderbackup:find("player") then
					senderbackup = UnitName("player")
				end
			elseif not UnitInRaid("player") and GetNumPartyMembers() == 0 then
				if senderbackup == "player" then senderbackup = UnitName("player") else return end
			end
			if senderbackup ~= nil and CustomUnitIsPlayer(senderbackup) and senderbackup:find("[%a]+%-[%a]+") then
				local realscrnameone, realscrnametwo = select(3, senderbackup:find("(%a+)%-(%a+)"))
				senderbackup = realscrnameone
			end

			local _, c = CustomUnitClass(senderbackup) -- fix cd
			if FatCooldowns.cooldowns[c] then
				local spells = FatCooldowns.cooldowns[c]
				if spells[spellnamebackup] then
					if spells[spellnamebackup].cd ~= nil then cooldownbackup = spells[spellnamebackup].cd spellIdbackup = spells[spellnamebackup].id end
				end
			end
			if spellIdbackup ~= nil and cooldownbackup ~= nil and not UnitInVehicle(senderbackup) then
				if backuptargetspellname[senderbackup] == spellnamebackup then
					FatCooldowns:GetModule("Display"):backbarscheckercdtimer(senderbackup, arg2, cooldownbackup, spellIdbackup,backuptargetid[senderbackup])
				else
					FatCooldowns:GetModule("Display"):backbarscheckercdtimer(senderbackup, arg2, cooldownbackup, spellIdbackup)
				end
			end
			backuptargetid[senderbackup] = nil
			backuptargetspellname[senderbackup] = nil
		 end
	end
end

function isPet(pname) 
	if UnitInRaid("player") then
		for i=1, GetNumRaidMembers() do
       	    if UnitName("raidpet"..i) == pname then
           	   	return true, UnitName("raid"..i)
       		end 
     	end
   		return false
   	elseif UnitInParty("player") and UnitName("playerpet") ~= pname then
   		for i=1, GetNumPartyMembers() do
       		if UnitName("partypet"..i) == pname then
       	       	return true, UnitName("party"..i)
        	end 
        end
    	return false
    elseif UnitName("playerpet") == pname then
    	return true, UnitName("player")
	end
end

function raidIbyName(Pname)
   	for i=1, GetNumRaidMembers() do
       	if UnitName("raid"..i) == Pname then
           	return "raid"..i, i
       	end  
   	end
   	return false
end 

function FatCooldowns:NecroticScanBars(ncfail)
	local donerep = true
	for nb=1, GetNumRaidMembers() do
		if UnitDebuff("raid"..nb, "Necrotic Plague") then
			local NecroName = UnitName("raid"..nb)
			local name, rank, icon, count, debuffType, duration, expirationTime, unitCaster, isStealable, shouldConsolidate, spellId = UnitDebuff(NecroName, "Necrotic Plague")
			local Ntime = expirationTime and expirationTime - GetTime() or 5
			if Ntime > 10 then Ntime = Ntime - 10
			elseif Ntime > 5 then Ntime = Ntime - 5 end
			if ncfail == nil then self:GetModule("Display"):StartCooldown("Necrotic", 70337, Ntime,NecroName,nil)
			elseif ncfail ~= nil and NecroName ~= nil then
				donerep = false
				self:GetModule("Display"):chatreporter(UnitName("player"), 99961, 1,nil,nil,nil,nil,nil, ncfail..", Necrotic jumps to "..NecroName)
			end
			NecroTime[NecroName] = expirationTime and duration and expirationTime - duration or GetTime()
		end
	end
	if ncfail ~= nil and donerep then self:GetModule("Display"):chatreporter(UnitName("player"), 99961, 1,nil,nil,nil,nil,nil, ncfail) end
end

function FatCooldowns:HuntMDCheckerBuffchecker(srcName)
	for i=1,40 do
		local name, rank, icon, count, debuffType, duration, expirationTime, unitCaster, isStealable, shouldConsolidate, spellId  = UnitBuff(srcName,i)
		if (CustomUnitClass(srcName) == "Rogue" and spellId == 59628) or (CustomUnitClass(srcName) == "Hunter" and spellId == 35079) then
			return true
		end
	end 
	return false
end

function FatCooldowns:HuntMDChecker(srcName,timestamp)
	if timestamp == nil then
		if CustomUnitClass(srcName) == "Hunter" and not UnitIsDead(srcName) and HuntMD[srcName] == nil then
			if self:HuntMDCheckerBuffchecker(srcName) then return else self:GetModule("Display"):HunterMDRename(srcName, 34477, 30, "FAILED") end
		elseif CustomUnitClass(srcName) == "Rogue" and not UnitIsDead(srcName) and HuntMD[srcName] == nil then
			if self:HuntMDCheckerBuffchecker(srcName) then return else self:GetModule("Display"):HunterMDRename(srcName, 57934, 30, "FAILED") end
		end
	elseif timestamp ~= nil then
		if CustomUnitClass(srcName) == "Hunter" and not UnitIsDead(srcName) then
			if self:HuntMDCheckerBuffchecker(srcName) then return elseif HuntMD[srcName] ~= nil and timestamp - HuntMD[srcName] < 3.5 then self:GetModule("Display"):HunterMDRename(srcName, 34477, 30, "REMOVED") end
		elseif CustomUnitClass(srcName) == "Rogue" and not UnitIsDead(srcName) then
			if self:HuntMDCheckerBuffchecker(srcName) then return elseif HuntMD[srcName] ~= nil and timestamp - HuntMD[srcName] < 5.5 then self:GetModule("Display"):HunterMDRename(srcName, 57934, 30, "REMOVED") end
		end		
	end
end

--													0		1			2		3			4		5			6		7		8		9			10
function FatCooldowns:COMBAT_LOG_EVENT_UNFILTERED(event, timestamp, eventType, srcGUID, srcName, srcFlags, dstGUID, dstName, dstFlags, spellId, spellName, ...)
	if EventsFilters[eventType] == false then return end
	if EventsFilters[eventType] == nil then print(eventType) return end

	local instancename, instanceType, difficultyID, difficultyName, maxPlayers, dynamicDifficulty, isDynamic = GetInstanceInfo()
	local _, zone2 = IsInInstance()
	local arg = {...}

	if srcName ~= nil and srcName:find("^[%a]+%-[%a]+$") and CustomUnitIsPlayer(srcName) then
		local realscrnameone, realscrnametwo = select(3, srcName:find("(%a+)%-(%a+)"))
		srcName = realscrnameone
	end
	if dstName ~= nil and dstName:find("^[%a]+%-[%a]+$") and CustomUnitIsPlayer(dstName) then
		local realscrnameone, realscrnametwo = select(3, dstName:find("(%a+)%-(%a+)"))
		dstName = realscrnameone
	end

	if (spellId == 33697 and spellName == "Blood Fury") or (spellId == 20572 and spellName == "Blood Fury") then spellId = 33702 end
	if spellName == "Polymorph" and (spellId == 28271 or spellId == 28272 or spellId == 61025 or spellId == 61305 or spellId == 61721 or spellId == 61780 or spellId == 71319) then spellId = 12826 end
	self:FCDCHATREPORTER(event, timestamp, eventType, srcGUID, srcName, srcFlags, dstGUID, dstName, dstFlags, spellId, spellName, ...)

	if eventType == "UNIT_DIED" and (UnitInRaid(dstName) or UnitName("player") or UnitInParty(dstName)) and UnitBuff(dstName, "Feign Death") then self:GetModule("Display"):SyncCooldown(dstName, 5384, 25, nil,nil) end 
	if eventType == "UNIT_DIED" and UnitInRaid(dstName) then FatCooldowns:GetModule("Display"):UpdateDisplay() end
	if eventType == "UNIT_DIED" then return end

	if not UnitIsPlayer(srcName) and (eventType == "SPELL_CAST_SUCCESS" or (eventType == "SPELL_AURA_APPLIED" and spellName == "Demonic Pact")) and (UnitPlayerOrPetInParty(srcName) or UnitPlayerOrPetInRaid(srcName) or UnitName("playerpet") == srcName) then
		local checkPet, oname = isPet(srcName)
		if checkPet and not UnitInVehicle(oname) and CustomUnitClass(oname) == "Hunter" or CustomUnitClass(oname) == "Warlock" then
			local _, c = CustomUnitClass(oname)
			if self.cooldowns[c] then 
			local spells = self.cooldowns[c]
				if spells[spellName] or spells[spellId] then
					if dstName == srcName or dstName == oname then dstName = nil end
					srcName = oname
					local cd = spells[spellName] and spells[spellName].cd or spells[spellId] and spells[spellId].cd
					self:GetModule("Display"):SyncCooldown(srcName, spellId, cd,dstName,nil) 
				end
			end
		end
		return
	end
	
	if spellName == "War Stomp" or spellName == "Stoneform" then
		if eventType == "SPELL_CAST_SUCCESS" then
			if UnitInRaid("player") then
				if not srcName:find("raid") then return end
				srcName = UnitName(srcName)
			elseif not UnitInRaid("player") and GetNumPartyMembers() >= 1 then
				if not srcName:find("player") then
					if not srcName:find("party") then return end
					srcName = UnitName(srcName)
				else srcName = UnitName("player") end
			elseif not UnitInRaid("player") and GetNumPartyMembers() == 0 then
				if srcName == "player" then srcName = UnitName("player") else return end
			end
		else
			return
		end
	end

	if instancename == "Icecrown Citadel" and UnitName("boss1") == "Sindragosa" then
		if eventType == "SPELL_AURA_APPLIED" and spellId == 69766 then  
			self:GetModule("Display"):SyncCooldown(dstName, 69766, 5,"1",nil) 
 		elseif eventType == "SPELL_AURA_APPLIED_DOSE" and spellId == 69766 then 
			self:GetModule("Display"):SyncCooldown(dstName, 69766, 5,tostring(arg[3]),nil)
		end
    end

  	if UnitName("boss1") == "The Lich King" then
		if eventType == "SPELL_AURA_APPLIED" and (dstName == "Shambling Horror" or srcName == "Shambling Horror") and spellName == "Enrage" then  
			self:GetModule("Display"):StartCooldown("Shambling Horror", 72143, 5,nil,nil) 
		end
		if eventType == "SPELL_AURA_REMOVED" and (dstName == "Shambling Horror" or srcName == "Shambling Horror") and spellName == "Enrage" then  
			self:GetModule("Display"):StopCooldown("Shambling Horror", 72143)
		end
		if spellName == "Necrotic Plague" or arg[3] == "Necrotic Plague" then
			if eventType == "SPELL_DISPEL" then self:GetModule("Display"):StopCooldown("Necrotic"..dstName, 70337) end
			self:ScheduleTimer(function() self:NecroticScanBars() end, 0.2)
			if FatCooldowns:GetModule("Display").db.profile.reporter[99961] then
				if eventType == "SPELL_CAST_SUCCESS" and spellName == "Cloak of Shadows" and UnitDebuff(srcName,"Necrotic Plague") then
					self:GetModule("Display"):chatreporter(srcName, 99961, 1,nil,nil,nil,nil,nil, srcName.." used Cloak of Shadows with Necrotic")
				elseif eventType == "SPELL_PERIODIC_DAMAGE" and UnitInRaid(dstName) then
					self:GetModule("Display"):chatreporter(srcName, 99961, 1,nil,nil,nil,nil,nil, dstName.." was hit by Necrotic")
				elseif eventType == "SPELL_DISPEL" and arg[3] == "Necrotic Plague" then
					local dispeller = srcName
					if srcName == dstName and spellName == "Abolish Disease Effect" and UnitBuff(dstName, "Abolish Disease") then
						local realdispeler = select(8, UnitBuff(dstName, "Abolish Disease"))
						dispeller = UnitName(realdispeler)
					end
					if NecroTime[dstName] then
						local NPTime = string.format("%.1f", (GetTime() - NecroTime[dstName]))
						if GetTime() - NecroTime[dstName] > 6 then NPTime = "after Unknown sec" else NPTime = " after "..NPTime.."s" end
						local nctext = dispeller.." has dispelled Necrotic from "..dstName..NPTime
						self:ScheduleTimer(function() self:NecroticScanBars(nctext) end, 0.2)
						--self:GetModule("Display"):chatreporter(srcName, 99961, 1,nil,nil,nil,nil,nil, dispeller.." has dispelled Necrotic from "..dstName..NPTime)
					end
				end
			end
		end
    end

    if eventType == "SPELL_AURA_REMOVED" and FatCooldowns:GetModule("Display").db.profile.Removal then
		local _, c = CustomUnitClass(srcName)
		if c ~= nil and self.cooldowns[c] then
			local spells = self.cooldowns[c]
			local id = spells[spellName] and spells[spellName].id or spells[spellId] and spells[spellId].id
			local remove = spells[spellName] and spells[spellName].remove or spells[spellId] and spells[spellId].remove
			if (spells[spellName] or spells[spellId]) and id == spellId and remove then
				if UnitName("player") == dstName or UnitInParty(dstName) or UnitInRaid(dstName) and srcName ~= nil and id ~= nil then
					self:GetModule("Display"):StopCooldown(srcName, id)
				else
					self:GetModule("Display"):StopCooldown(srcName, id, true)
				end
			end
			remove = false
		end
    end

	if srcName ~= UnitName("player") and not UnitInParty(srcName) and not UnitInRaid(srcName) and not FatCooldowns:GetModule("Display").db.profile.ArenaMode then return end -- checks if player is in raid






















	if spellName == "Misdirection" then
		if spellId == 34477 and eventType == "SPELL_AURA_REMOVED" then 
			self:ScheduleTimer(function() self:HuntMDChecker(srcName) end, 1.2)
			HuntMD[srcName] = nil
		end
		if spellId == 35079 then
			if eventType == "SPELL_AURA_APPLIED" then 
				HuntMD[srcName] = timestamp
			end
 			if eventType == "SPELL_AURA_REMOVED" then
				self:ScheduleTimer(function() self:HuntMDChecker(srcName,timestamp) end, 1.2)
				self:ScheduleTimer(function() self:HuntMDChecker(srcName,timestamp) end, 1.7)
 			end
		end	
	end

	if spellName == "Tricks of the Trade" then
		if spellId == 57934 and eventType == "SPELL_AURA_REMOVED" then 
			self:ScheduleTimer(function() self:HuntMDChecker(srcName) end, 1.2)
			HuntMD[srcName] = nil
		end
		if spellId == 59628 then
			if eventType == "SPELL_AURA_APPLIED" then 
				HuntMD[srcName] = timestamp
			end
 			if eventType == "SPELL_AURA_REMOVED" then 
				self:ScheduleTimer(function() self:HuntMDChecker(srcName,timestamp) end, 1.2)
				self:ScheduleTimer(function() self:HuntMDChecker(srcName,timestamp) end, 1.7)
			end
		end	
	end

	if spellName == "Readiness" and eventType == "SPELL_CAST_SUCCESS" then
		HuntMD[srcName] = nil
		self:GetModule("Display"):StopCooldown(srcName, 19263)
		self:GetModule("Display"):StopCooldown(srcName, 781)
		self:GetModule("Display"):StopCooldown(srcName, 3045)
		self:GetModule("Display"):StopCooldown(srcName, 49067)
	end

	if eventType == "SPELL_CAST_SUCCESS" and (srcName == UnitName("player") or UnitInParty(srcName) or UnitInRaid(srcName)) and LGT:GetUnitRole(srcName) == "tank" then 
		if self.cooldowns["Tank Only Cooldowns"] then
			local spells = self.cooldowns["Tank Only Cooldowns"]
			if spells[spellName] or spells[spellId] then 
				local cd = spells[spellName] and spells[spellName].cd or spells[spellId] and spells[spellId].cd
				local id = spells[spellName] and spells[spellName].id or spells[spellId] and spells[spellId].id
				if spellName == "Hand of Salvation" and (dstName == srcName or dstName == nil) then self:GetModule("Display"):StartCooldown(srcName, id, spells[spellName].cd,nil,nil,nil,nil,nil,"TankCooldown")
				elseif spellName == "Shield Wall" then
					if LGT:UnitHasTalent(srcName, "Improved Disciplines") then 
						if LGT:UnitHasGlyph(srcName, "Glyph of Shield Wall") then 
							self:GetModule("Display"):StartCooldown(srcName, id, 120,nil,nil,nil,nil,nil,"TankCooldown")
						else 
							self:GetModule("Display"):StartCooldown(srcName, id, 240,nil,nil,nil,nil,nil,"TankCooldown")
						end
					else 
						self:GetModule("Display"):StartCooldown(srcName, id, spells[spellName].cd,nil,nil,nil,nil,nil,"TankCooldown")
					end
				elseif spellName == "Last Stand" then
					if LGT:UnitHasGlyph(srcName, "Glyph of Last Stand") then
						self:GetModule("Display"):StartCooldown(srcName, id, 120,nil,nil,nil,nil,nil,"TankCooldown") 
					else
						 self:GetModule("Display"):StartCooldown(srcName, id, cd,nil,nil,nil,nil,nil,"TankCooldown")
					end
				else self:GetModule("Display"):StartCooldown(srcName, id, cd,nil,nil,nil,nil,nil,"TankCooldown")
				end	
			end
		end
	end 

	if (eventType == "SPELL_CAST_SUCCESS" or eventType == "SPELL_CAST_START") and (spellId == 33786 or spellId == 12826 or spellId == 8129 or spellId == 6215 or spellId == 17928 or spellId == 605 or
		spellId == 10955 or spellId == 18647 or spellId == 14327) then 
		local _, c = CustomUnitClass(srcName)
		if c ~= nil and self.cooldowns[c] then
			local spells = self.cooldowns[c]
			local cd = spells[spellName] and spells[spellName].cd or spells[spellId] and spells[spellId].cd
			if spells[spellName] or spells[spellId] then self:GetModule("Display"):SyncCooldown(srcName, spellId, cd,dstName,nil) end
		end
		return
	end

	if eventType == "SPELL_CAST_SUCCESS" and spellId == 47788 then HolyPriest = srcName end
	if eventType == "SPELL_HEAL" and spellId == 48153 and HolyPriest ~= nil then self:GetModule("Display"):SyncCooldown(HolyPriest, 47788, -108,dstName,nil) return end

	if eventType == "SPELL_ENERGIZE" and spellId == 47755 then
		if RaptureTimeStamp[srcName] == nil or timestamp - RaptureTimeStamp[srcName] > 10 then
		local _, c = CustomUnitClass(srcName)
			if self.cooldowns[c] then
			local spells = self.cooldowns[c]
				if spells[spellName] or spells[spellId] then
					self:GetModule("Display"):SyncCooldown(srcName, 47755, 12,nil,nil)
					RaptureTimeStamp[srcName] = timestamp
				end 
			end
		end
		return
	end

	if eventType == "SPELL_CAST_SUCCESS" and spellId == 52985 then
		if PenTimeStamp[srcName] == nil or timestamp - PenTimeStamp[srcName] > 7 then
		local _, c = CustomUnitClass(srcName)
			if self.cooldowns[c] then
			local spells = self.cooldowns[c]
				if spells[spellName] or spells[spellId] then
					self:GetModule("Display"):SyncCooldown(srcName, 52985, 12,nil,nil)
					PenTimeStamp[srcName] = timestamp
				end 
			end
		end
		return
	end

	if eventType == "SPELL_CAST_START" and spellId == 1842 then self:GetModule("Display"):SyncCooldown(srcName, spellId, 5,nil, nil, nil) end

	if spellId == 28682 or spellId == 20216 or spellId == 16188 or spellId == 17116 or spellId == 12043 or spellName == "Combustion" or spellName == "Divine Favor" or spellName == "Nature's Swiftness" or spellName == "Presence of Mind" then
		if eventType == "SPELL_AURA_REMOVED" then
		local _, c = CustomUnitClass(srcName)
			if self.cooldowns[c] then
			local spells = self.cooldowns[c]
				if spells[spellName] or spells[spellId] then
					local cd = spells[spellName] and spells[spellName].cd or spells[spellId] and spells[spellId].cd
					self:GetModule("Display"):SyncCooldown(srcName, spellId, cd, dstName)
				end 
			end
		end
		return
	end 

	if (eventType == "SPELL_AURA_APPLIED" or eventType == "SPELL_AURA_REFRESH") and (spellId == 54153 or spellId == 16886) then
		local _, c = CustomUnitClass(srcName)
		if self.cooldowns[c] then
			local spells = self.cooldowns[c]
			if spells[spellName] or spells[spellId] then
				local cd = spells[spellName] and spells[spellName].cd or spells[spellId] and spells[spellId].cd
				self:GetModule("Display"):SyncCooldown(srcName, spellId, cd)
			end 
		end
		return
	end

	if eventType == "SPELL_CAST_SUCCESS" and (spellId == 48827 or spellId == 53595 or spellId == 53023) then -- target no target
		local _, c = CustomUnitClass(srcName)
		if self.cooldowns[c] then
			local spells = self.cooldowns[c]
			if spells[spellName] or spells[spellId] then
				local cd = spells[spellName] and spells[spellName].cd or spells[spellId] and spells[spellId].cd
				self:GetModule("Display"):SyncCooldown(srcName, spellId, cd)
			end 
		end
		return
	end

	local function isEquipped(itemID)
		local _, _, _, _, _, _, _, _, equipLoc = GetItemInfo(itemID)
		local slots = {
			AMMOSLOT = 0,
			INVTYPE_HEAD = 1,
			INVTYPE_NECK = 2,
			INVTYPE_SHOULDER = 3,
			INVTYPE_BODY = 4,
			INVTYPE_CHEST = 5,
			INVTYPE_WAIST = 6,
			INVTYPE_LEGS = 7,
			INVTYPE_FEET = 8,
			INVTYPE_WRIST = 9,
			INVTYPE_HAND = 10,
			INVTYPE_FINGER = {11, 12},
			INVTYPE_TRINKET = {13, 14},
			INVTYPE_CLOAK = 15,
			INVTYPE_WEAPONMAINHAND = 16,
			INVTYPE_2HWEAPON = 16,
			INVTYPE_WEAPON = {16, 17},
			INVTYPE_HOLDABLE = 17,
			INVTYPE_SHIELD = 17,
			INVTYPE_WEAPONOFFHAND = 17,
			INVTYPE_RANGED = 18
		}
		local slot = slots[equipLoc]
		
		if type(slot) == "table" then
			for _, v in ipairs(slot) do
				local link = GetInventoryItemLink("player", v)
				if link and link:match(("item:%s"):format(itemID)) then
					return true
				end
			end
		else
			local link = GetInventoryItemLink("player", slot)
			if link and link:match(("item:%s"):format(itemID)) then
				return true
			end
		end
		return false
	end

	local function checkSlotForEnchantID(slot, enchantID)
		local link = GetInventoryItemLink("player", slot)
		if not link then return false; end
		local itemID, enchant = link:match("item:(%d+):(%d+)")
		if tonumber(enchant or -1) == enchantID then
			return true, tonumber(itemID)
		else
			return false
		end
	end

	if srcName == UnitName("player") and not (eventType == "SPELL_AURA_REMOVED" or eventType == "SPELL_AURA_REFRESH" or eventType == "SPELL_AURA_APPLIED_DOSE") then 
		if self.AuraToItemID[spellId] then
			if type(self.AuraToItemID[spellId]) == "table" then
				for k, v in ipairs(self.AuraToItemID[spellId]) do
					local _, _, _, _, _, _, _, _, EQSlot = GetItemInfo(v)
					if EQSlot == "INVTYPE_WEAPONMAINHAND" or EQSlot == "INVTYPE_2HWEAPON" or EQSlot == "INVTYPE_WEAPONOFFHAND" then EQSlot = "INVTYPE_WEAPON" end
					if EQSlot and isEquipped(v) then
						if self.cooldowns["ITEM PROC"] then
							local spells = self.cooldowns["ITEM PROC"]
							if spells[EQSlot] then
								self:GetModule("Display"):StartCooldown(srcName, v, self.ItemIDCooldown[spellId] or 45, nil, nil, nil, nil, nil, nil, EQSlot)
							end
						end
					end
					link = nil
					EQSlot = nil
				end
			else 
				local _, _, _, _, _, _, _, _, EQSlot = GetItemInfo(self.AuraToItemID[spellId])
				if EQSlot == "INVTYPE_WEAPONMAINHAND" or EQSlot == "INVTYPE_2HWEAPON" or EQSlot == "INVTYPE_WEAPONOFFHAND" then EQSlot = "INVTYPE_WEAPON" end
				if EQSlot and isEquipped(self.AuraToItemID[spellId]) then 
					if self.cooldowns["ITEM PROC"] then 
						local spells = self.cooldowns["ITEM PROC"]
						if spells[EQSlot] then 
							self:GetModule("Display"):StartCooldown(srcName, self.AuraToItemID[spellId], self.ItemIDCooldown[spellId] or 45, nil, nil, nil, nil, nil, nil, EQSlot)
						end
					end
				end
				link = nil
			end
		elseif self.EnchantToItemID[spellId] then 
			if type(self.EnchantToItemID[spellId]) == "table" then 
				local EnchantID, EnchantSlot = unpack(self.EnchantToItemID[spellId])
				if EnchantID and EnchantSlot then
					local Equip, EquipItemID = checkSlotForEnchantID(EnchantSlot, EnchantID)
					if Equip then 
						local link = GetInventoryItemLink("player", EnchantSlot)
						local _, _, _, _, _, _, _, _, EQSlot = GetItemInfo(link)
						if EQSlot == "INVTYPE_WEAPONMAINHAND" or EQSlot == "INVTYPE_2HWEAPON" or EQSlot == "INVTYPE_WEAPONOFFHAND" then EQSlot = "INVTYPE_WEAPON" end
						if self.cooldowns["ITEM PROC"] then 
							local spells = self.cooldowns["ITEM PROC"]
							if spells[EQSlot] then 
								self:GetModule("Display"):StartCooldown(srcName, EquipItemID, self.ItemIDCooldown[spellId] or 45, nil, nil, nil, nil, EquipItemID, nil, EQSlot)
							end
						end
					end
				end
			end
		end
	end


		
	local removefail = true
	removefail = true
	if FatCooldowns:GetModule("Display").db.profile.Removal then
	    if (eventType == "SPELL_CAST_SUCCESS" or eventType == "SPELL_AURA_REFRESH" or eventType == "SPELL_AURA_APPLIED") then
			local _, c = CustomUnitClass(srcName)
			if c ~= nil and self.cooldowns[c] then
				local spells = self.cooldowns[c]
				local id = spells[spellName] and spells[spellName].id or spells[spellId] and spells[spellId].id
				local remove = spells[spellName] and spells[spellName].remove or spells[spellId] and spells[spellId].remove
				if (spells[spellName] or spells[spellId]) and id == spellId and remove then
				if eventType == "SPELL_AURA_REFRESH" then  eventType = "SPELL_AURA_APPLIED" end
				removefail = false end
			end
	    end
		if eventType == "SPELL_CAST_SUCCESS" and not removefail then return end -- for removal
	end

	if eventType ~= "SPELL_CAST_SUCCESS" and eventType ~= "SPELL_RESURRECT" and (eventType ~= "SPELL_SUMMON" or (spellId ~= 1122 and spellId ~= 48087)) and (eventType ~= "SPELL_AURA_APPLIED" or
		(spellId ~= 70654 and spellId ~= 70845 and spellId ~= 54861 and spellId ~= 28714 and spellId ~= 16190 and spellId ~= 64382 and spellId ~= 29858 and spellId ~= 47883 and spellId ~= 35079 and removefail
		 and spellId ~= 59628 and spellId ~= 66233 and spellId ~= 51514 and spellId ~= 48518 and spellId ~= 48517)) then return end

	local _, c = CustomUnitClass(srcName)
	if self.cooldowns["ITEMS"] and c ~= nil then
		local spells = self.cooldowns["ITEMS"]
		if spells[spellName] or spells[spellId] then
			local cd = spells[spellName] and spells[spellName].cd or spells[spellId].cd
			if dstName ~= nil then
				self:GetModule("Display"):SyncCooldown(srcName, spellId, cd,dstName,nil)
			else
				self:GetModule("Display"):SyncCooldown(srcName, spellId, cd,nil,nil)
			end
			return
		end
	end
	
	if self.cooldowns["RACIALS"] and c ~= nil then
		local spells = self.cooldowns["RACIALS"]
		if spells[spellName] or spells[spellId] then
			local cd = spells[spellName] and spells[spellName].cd or spells[spellId].cd
			if dstName ~= nil then
				self:GetModule("Display"):SyncCooldown(srcName, spellId, cd,dstName,nil)
			else
				self:GetModule("Display"):SyncCooldown(srcName, spellId, cd,nil,nil)
			end
			return
		end
	end

	if self.cooldowns["CONSUMABLES"] and c ~= nil then
		local spells = self.cooldowns["CONSUMABLES"]
		if spells[spellName] or spells[spellId] then
			local cd = spells[spellName] and spells[spellName].cd or spells[spellId].cd
			if dstName ~= nil then
				self:GetModule("Display"):SyncCooldown(srcName, spellId, cd,dstName,nil)
			else
				self:GetModule("Display"):SyncCooldown(srcName, spellId, cd,nil,nil)
			end
			return
		end
	end

	if self.cooldowns[c] then 	
		local spells = self.cooldowns[c]
		if spells[spellName] or spells[spellId] then
		--print(eventType,srcName,dstName,spellName)
			if spells[spellName] or spells[spellId] then 
				local cd = spells[spellName] and spells[spellName].cd or spells[spellId].cd 

				if spellId == 498 or spellId == 42650 or spellId == 871 or spellId == 12975 or spellId == 34433 or spellId == 53601 or spellId == 10308 or spellId == 48517 then if LGT:GetUnitTalentSpec(srcName) == nil and (UnitInRaid(srcName) or UnitInParty(srcName) or UnitName("player") == srcName) then LGT:RefreshTalentsByUnit(srcName) end end

				if spellId == 35079 or spellId == 34477 or spellId == 59628 or spellId == 57934 then -- md tot
					if spellId == 35079 then self:GetModule("Display"):SyncCooldown(srcName, 34477, spells[spellName].cd,dstName,nil) return
					elseif spellId == 59628 then self:GetModule("Display"):SyncCooldown(srcName, 57934, spells[spellName].cd,dstName,nil) return
					end
				elseif spellId == 498 and LGT:UnitHasTalent(srcName, "Sacred Duty") then self:GetModule("Display"):SyncCooldown(srcName, spellId, 120,nil,nil) return
				elseif spellId == 42650 and LGT:UnitHasTalent(srcName, "Night of the Dead") then self:GetModule("Display"):SyncCooldown(srcName, spellId, 360,nil,nil) return --dk army
				elseif spellId == 871 and LGT:UnitHasTalent(srcName, "Improved Disciplines") then 
						if LGT:UnitHasGlyph(srcName, "Glyph of Shield Wall") then 
							self:GetModule("Display"):StartCooldown(srcName, spellId, 120,nil) return
						else 
							self:GetModule("Display"):StartCooldown(srcName, spellId, 240,nil) return end
				elseif spellId == 12975 and LGT:UnitHasGlyph(srcName, "Glyph of Last Stand") then self:GetModule("Display"):SyncCooldown(srcName, spellId, 120,nil,nil) return --last stand
				elseif spellId == 34433 and LGT:UnitHasTalent(srcName, "Veiled Shadows") then self:GetModule("Display"):SyncCooldown(srcName, spellId, 180,dstName,nil) return --sp pet
				elseif spellId == 53601 and LGT:UnitHasTalent(srcName, "Divine Guardian") then self:GetModule("Display"):SyncCooldown(srcName, spellId, 60,dstName,nil) return -- Sacred shield
				elseif spellId == 10278 and LGT:UnitHasTalent(srcName, "Guardian's Favor") then self:GetModule("Display"):SyncCooldown(srcName, spellId, 180,dstName,nil) return -- hop
				elseif spellId == 2687 and LGT:UnitHasTalent(srcName, "Intensify Rage") then self:GetModule("Display"):SyncCooldown(srcName, spellId, 40,nil,nil) return -- hop
				elseif spellId == 48113 and LGT:UnitHasTalent(srcName, "Divine Providence") then self:GetModule("Display"):SyncCooldown(srcName, spellId, 7,dstName,nil) return -- hop
				elseif spellId == 10308 and LGT:UnitHasTalent(srcName, "Improved Hammer of Justice") then
					if LGT:UnitHasTalent(srcName, "Judgement of the Just") then self:GetModule("Display"):SyncCooldown(srcName, spellId, 30, dstName,nil)
					else self:GetModule("Display"):SyncCooldown(srcName, spellId, 40, dstName,nil) end return end -- Hammer of Justice 

				if dstName ~= nil then
					self:GetModule("Display"):SyncCooldown(srcName, spellId, cd,dstName,nil)
				elseif spellId == 48517 then
					self:GetModule("Display"):SyncCooldown(srcName, spellId, cd,nil,nil)
					self:GetModule("Display"):SyncCooldown(srcName, 96999, cd,nil,nil)
				else
					self:GetModule("Display"):SyncCooldown(srcName, spellId, cd,nil,nil) 
				end
			end
			return
		end
	end	
	return
end	

function FatCooldowns:AutoWeapon()
	UseEquipmentSet("FCDLDW")
end

function FatCooldowns:BagsFree()
	local freeslots = 0
	for x = 0, 4 do 
   		local tempfreeslots = GetContainerNumFreeSlots(x)
   		freeslots = freeslots + tempfreeslots
   	end
   	return freeslots
end

function FatCooldowns:isnotbosstarget(sname)
	if sname == nil then return end
	if UnitName("boss1") == nil then return false end
	if UnitName("boss1") ~= nil and UnitName("boss1target") == sname then return false end 
	if UnitName("boss2") ~= nil and UnitName("boss1target") == sname then return false end 
	if UnitName("boss3") ~= nil and UnitName("boss1target") == sname then return false end 
	return true
end

function FatCooldowns:SortTable(TableName)
	if TableName == nil then return end
	table.sort(TableName, function(a, b) return a:lower() < b:lower() end)
end
function FatCooldowns:SortTableNum(TableName)
	if TableName == nil then return end
	table.sort(TableName, function(a, b) return a < b end)
end

function FatCooldowns:ValkScannerReporter(healer)
	if healer == nil then return end
	if healers[healer] ~= nil then 
		if FatCooldowns:GetModule("Display").db.profile.reporter[99990] then
			if CustomUnitClass(healer) == "Priest" then 
				if LGT:GetUnitTalentSpec(healer) == "Holy" then
					PlaySoundFile("Interface\\AddOns\\FatCooldowns\\sounds\\Hpriest.mp3", "Master")
				else
					PlaySoundFile("Interface\\AddOns\\FatCooldowns\\sounds\\Disc.mp3", "Master")
				end
			elseif CustomUnitClass(healer) == "Paladin" then PlaySoundFile("Interface\\AddOns\\FatCooldowns\\sounds\\Hpala.mp3", "Master")
			elseif CustomUnitClass(healer) == "Shaman" then PlaySoundFile("Interface\\AddOns\\FatCooldowns\\sounds\\Shaman.mp3", "Master")
			elseif CustomUnitClass(healer) == "Druid" then PlaySoundFile("Interface\\AddOns\\FatCooldowns\\sounds\\Druid.mp3", "Master")
			end
		end
		if FatCooldowns:GetModule("Display").db.profile.reporter[99989] then
			local GrabbedHealer = nil
			if CustomUnitClass(healer) == "Priest" then
				if LGT:GetUnitTalentSpec(healer) == "Holy" then
					GrabbedHealer = "Hpriest is Grabbed!"
				else
					GrabbedHealer = "Disc is Grabbed!"
				end
			elseif CustomUnitClass(healer) == "Paladin" then GrabbedHealer = "Hpala is Grabbed!"
			elseif CustomUnitClass(healer) == "Shaman" then GrabbedHealer = "Rsham is Grabbed!"
			elseif CustomUnitClass(healer) == "Druid" then GrabbedHealer = "Rdruid is Grabbed!"
			end
			if GrabbedHealer ~= nil then SendChatMessage(GrabbedHealer, SAY) end
		end
	end
end

function FatCooldowns:ValkScanner(valkevent, grabbedname)
	if grabbedname ~= nil then grabbedname = UnitName(grabbedname) end
	if summonvalktimestamp == nil or (GetTime() - summonvalktimestamp < 10) then
		if valkevent == nil and grabbedname == nil then
			for x=1, GetNumRaidMembers() do
				local Valkplayer = UnitName("raid"..x)
				if UnitInVehicle(Valkplayer) and not ValkGrabbed[Valkplayer] then
					self:GetModule("Display"):StartCooldown(Valkplayer, 69037, 30," |TInterface\\TargetingFrame\\UI-RaidTargetingIcon_"..GrabbedIcon..":20:20|t")
					self:ValkScannerReporter(Valkplayer)
					ValkGrabbed[Valkplayer] = true 
					GrabbedIcon = GrabbedIcon + 1
				end
			end
			self:ScheduleTimer(function() self:ValkScanner() end, 0.5)
		elseif grabbedname ~= nil and not ValkGrabbed[grabbedname] then
			self:GetModule("Display"):StartCooldown(grabbedname, 69037, 30," |TInterface\\TargetingFrame\\UI-RaidTargetingIcon_"..GrabbedIcon..":20:20|t")
			self:ValkScannerReporter(grabbedname)
			ValkGrabbed[grabbedname] = true 
			GrabbedIcon = GrabbedIcon + 1
		end
	elseif summonvalktimestamp ~= nil and (GetTime() - summonvalktimestamp > 15) and (GetTime() - summonvalktimestamp < 30) and valkevent ~= nil and grabbedname ~= nil then
		self:GetModule("Display"):StopCooldown(grabbedname,69037, "True")
		table.wipe(ValkGrabbed)
		GrabbedIcon = 2
	else
		table.wipe(ValkGrabbed)
		GrabbedIcon = 2
	end
end

function FatCooldowns:RemoveToT()
	for i=1,40 do
		local name, rank, icon, count, debuffType, duration, expirationTime, unitCaster, isStealable, shouldConsolidate, spellId  = UnitBuff("player",i)
		if spellId == 59628 then
			CancelUnitBuff("player",i)
		end
	end 
end

function FatCooldowns:FCDCHATREPORTER(event, timestamp, eventType, srcGUID, srcName, srcFlags, dstGUID, dstName, dstFlags, spellId, spellName, ...)
	local instancename, instanceType, difficultyID, difficultyName, maxPlayers, dynamicDifficulty, isDynamic = GetInstanceInfo()
	local arg = {...}
	
	if not UnitAffectingCombat("player") and UnitName("boss1") == nil and not IsStealthed() and not UnitBuff("player", "Vanish") and not UnitBuff("player", "Feign Death") and not UnitBuff("player", "Invisibility") then
		combatstarttimestamp = nil Sundercount = nil sundercountplayers = false Sundercountchecked = 0 warrtank = false TimeH = 1 TimeH2 = 1 RolesChecked = true table.wipe(healers) ppsummonooze = nil ppsummonooze2 = nil
		weaponname1 = nil GasDelay = nil GasName1 = nil GasName2 = nil GasName3 = nil WarlockBoomkinFail = 0 table.wipe(EmpShockTargetsTanks) table.wipe(EmpShockTargetsHealers) specchecked = nil
		if UnitInRaid("player") and IsCombat then IsCombat = false self:SetGroupLoot() end
	end

	if UnitInRaid("player") and not IsCombat and UnitAffectingCombat("player") and UnitName("boss1") ~= nil then IsCombat = true self:SetMasterLoot() end

--if (dstName == UnitName("player") or srcName == UnitName("player")) then print(eventType, srcName, dstName, spellId, spellName) end

	if UnitAffectingCombat("player") and UnitName("boss1") ~= nil and combatstarttimestamp == nil then combatstarttimestamp = GetTime() end

	if FatCooldowns:GetModule("Display").db.profile.reporter[99888] then
		if ParryCounterSetMembersSindra == "true" and not UnitAffectingCombat("player") and UnitName("boss1") == nil and not IsStealthed() and not UnitBuff("player", "Vanish") and not UnitBuff("player", "Feign Death") and not UnitBuff("player", "Invisibility") then 
			local ParryCounterText = nil
			if ParryCounter ~= nil then self:SortTable(ParryCounter) end
			for player in pairs(ParryCounter) do
				if ParryCounterText == nil and ParryCounter[player][1] ~= 0 then
					ParryCounterText = player.." - "..ParryCounter[player][1]
				elseif ParryCounterText ~= nil and ParryCounter[player][1] ~= 0 then
					ParryCounterText = ParryCounterText..", "..player.." - "..ParryCounter[player][1]
				end
			end
			if ParryCounterText ~= nil then 
				self:GetModule("Display"):chatreporter(srcName, 99888, 1,nil,nil,nil,nil,nil, "ParryCounter: "..ParryCounterText)
			end	
			ParryCounterSetMembersSindra = nil
			ParryCounter = nil
			ParryCounterText = nil
		end	
		if UnitName("boss1") == "Sindragosa" then
			if ParryCounterSetMembersSindra == nil then 
				for x=1, GetNumRaidMembers() do
					local player = UnitName("raid"..x)
					ParryCounter = ParryCounter or {}
					ParryCounter[player] = ParryCounter[player] or {}
					ParryCounter[player][1] = ParryCounter[player][1] or 0
				end
				ParryCounterSetMembersSindra = "true"
			elseif (arg[2] == "PARRY" or spellId == "PARRY") and dstName == "Sindragosa" and UnitInRaid(srcName) and UnitIsPlayer(srcName) and UnitName("boss1target") ~= nil then 
				local player = srcName
				if not ParryCounter[player] then 
				else
					ParryCounter[player][1] = ParryCounter[player][1] + 1
				end
			end
		end
	end

	if dstName == "Halion" and (arg[2] == "PARRY" or spellId == "PARRY") then
		local TempSrcName = srcName
		local checkPet, oname = isPet(srcName)
		if checkPet then TempSrcName = oname end
		local Phase = nil
		if UnitName("boss1") == "Halion" and UnitHealth("boss1") / UnitHealthMax("boss1") > 0.75 then Phase = 1
		elseif UnitName("boss1") == "Halion" and UnitHealth("boss1") / UnitHealthMax("boss1") > 0.50 then Phase = 2
		elseif UnitName("boss1") == "Halion" and UnitHealth("boss1") / UnitHealthMax("boss1") < 0.50 and UnitBuff("boss1", "Dusk Shroud") then Phase = 3
		elseif UnitName("boss1") == "Halion" and UnitHealth("boss1") / UnitHealthMax("boss1") < 0.50 and not UnitBuff("boss1", "Dusk Shroud") then Phase = 4
		end
		if Phase ~= nil then self:SendCommMessage("FCDPARRYCOUNTER", self:Serialize("FCDPARRYCOUNTER "..TempSrcName.." "..time().." "..Phase), "RAID", target) Phase = nil end
	end

	if (FatCooldowns:GetModule("Display").db.profile.reporter[99880] or FatCooldowns:GetModule("Display").db.profile.reporter[99881] or FatCooldowns:GetModule("Display").db.profile.reporter[99882]) then
		if ParryCounterSetMembers == "true" and not UnitAffectingCombat("player") and UnitName("boss1") == nil and not IsStealthed() and not UnitBuff("player", "Vanish") and not UnitBuff("player", "Feign Death") and not UnitBuff("player", "Invisibility") then 
			if FatCooldowns:GetModule("Display").db.profile.reporter[99880] then 
				local ParryCounterText1 = nil
				if ParryCounterH1 ~= nil then self:SortTable(ParryCounterH1) end
				for player in pairs(ParryCounterH1) do
					if ParryCounterText1 == nil and ParryCounterH1[player][1] ~= 0 then 
						ParryCounterText1 = player.." - "..ParryCounterH1[player][1]
					elseif ParryCounterText1 ~= nil and ParryCounterH1[player][1] ~= 0 then 
						ParryCounterText1 = ParryCounterText1..", "..player.." - "..ParryCounterH1[player][1]
					end
				end
				if ParryCounterText1 ~= nil then 
					self:GetModule("Display"):chatreporter(srcName, 99880, 1,nil,nil,nil,nil,nil, "ParryCounterP1: "..ParryCounterText1)
				end	
				ParryCounterSetMembers = nil
				table.wipe(ParryCounterH1)
				ParryCounterText1 = nil
			end
			if FatCooldowns:GetModule("Display").db.profile.reporter[99881] then
				local ParryCounterText2 = nil
				if ParryCounterH2 ~= nil then self:SortTable(ParryCounterH2) end
				for player in pairs(ParryCounterH2) do
					if ParryCounterText2 == nil and ParryCounterH2[player][1] ~= 0 then
						ParryCounterText2 = player.." - "..ParryCounterH2[player][1]
					elseif ParryCounterText2 ~= nil and ParryCounterH2[player][1] ~= 0 then
						ParryCounterText2 = ParryCounterText2..", "..player.." - "..ParryCounterH2[player][1]
					end
				end
				if ParryCounterText2 ~= nil then 
					self:GetModule("Display"):chatreporter(srcName, 99881, 1,nil,nil,nil,nil,nil, "ParryCounterP2: "..ParryCounterText2)
				end	
				ParryCounterSetMembers = nil
				table.wipe(ParryCounterH2)
				ParryCounterText2 = nil
			end
			if FatCooldowns:GetModule("Display").db.profile.reporter[99882] then
				local ParryCounterText3 = nil
				if ParryCounterH3 ~= nil then self:SortTable(ParryCounterH3) end
				for player in pairs(ParryCounterH3) do
					if ParryCounterText3 == nil and ParryCounterH3[player][1] ~= 0 then
						ParryCounterText3 = player.." - "..ParryCounterH3[player][1]
					elseif ParryCounterText3 ~= nil and ParryCounterH3[player][1] ~= 0 then
						ParryCounterText3 = ParryCounterText3..", "..player.." - "..ParryCounterH3[player][1]
					end
				end
				if ParryCounterText3 ~= nil then 
					self:GetModule("Display"):chatreporter(srcName, 99882, 1,nil,nil,nil,nil,nil, "ParryCounterP3(In): "..ParryCounterText3)
				end	
				ParryCounterSetMembers = nil
				table.wipe(ParryCounterH3)
				ParryCounterText3 = nil
			end
			if FatCooldowns:GetModule("Display").db.profile.reporter[99882] then
				local ParryCounterText4 = nil
				if ParryCounterH4 ~= nil then self:SortTable(ParryCounterH4) end
				for player in pairs(ParryCounterH4) do
					if ParryCounterText4 == nil and ParryCounterH4[player][1] ~= 0 then
						ParryCounterText4 = player.." - "..ParryCounterH4[player][1]
					elseif ParryCounterText4 ~= nil and ParryCounterH4[player][1] ~= 0 then
						ParryCounterText4 = ParryCounterText4..", "..player.." - "..ParryCounterH4[player][1]
					end
				end
				if ParryCounterText4 ~= nil then 
					self:GetModule("Display"):chatreporter(srcName, 99882, 1,nil,nil,nil,nil,nil, "ParryCounterP3(Out): "..ParryCounterText4)
				end	
				ParryCounterSetMembers = nil
				table.wipe(ParryCounterH4)
				ParryCounterText4 = nil
			end
		end	
	end

	if FatCooldowns:GetModule("Display").db.profile.reporter[99997] and (eventType == "UNIT_DIED" or eventType == "PARTY_KILL") and (dstName == "Gas Cloud" or dstName == "Ooze Variable") then oozedead = false end

	if eventType == "UNIT_DIED" and UnitName("boss1") ~= "Sindragosa" and UnitName("boss1") ~= "Halion" then return end

	if FatCooldowns:GetModule("Display").db.profile.reporter[99805] and UnitName("boss1") == "Lady Deathwhisper" and self:BagsFree() > 3 and GetNumEquipmentSets() <= 9 then 
		if weaponname1 == nil then
			if LGT:GetUnitTalentSpec("player") == nil then LGT:RefreshTalentsByUnit(UnitName("player")) end
			if LGT:GetUnitRole("player") == "melee" then
				SaveEquipmentSet("FCDLDW",769)
			end
			weaponname1 = "done"
		elseif ((eventType == "SPELL_CAST_SUCCESS" or eventType == "SPELL_AURA_APPLIED") and spellName == "Dominate Mind" and dstName == UnitName("player")) or (not HasFullControl() and not UnitIsDead("player")) or UnitDebuff("player", "Dominate Mind") then 
			if LGT:GetUnitRole("player") == "melee" and CustomUnitClass("player") ~= "Hunter" then
				PickupInventoryItem(16)
	            PutItemInBackpack()
    	        PickupInventoryItem(17)
        	    PutItemInBackpack()
				weaponname2 = "done"
            elseif CustomUnitClass("player") == "Hunter" then
				PickupInventoryItem(18)
                PutItemInBackpack()
				weaponname2 = "done"
            end
        elseif weaponname2 == "done" and not UnitIsDead("player") then
        	weaponname2 = nil
        	self:ScheduleTimer(function() self:AutoWeapon() end, 10.2)
			self:ScheduleTimer(function() self:AutoWeapon() end, 11.7)
			self:ScheduleTimer(function() self:AutoWeapon() end, 13.3)
			self:ScheduleTimer(function() self:AutoWeapon() end, 14.7)
			self:ScheduleTimer(function() self:AutoWeapon() end, 16.3)
			self:ScheduleTimer(function() self:AutoWeapon() end, 17.7)
			self:ScheduleTimer(function() self:AutoWeapon() end, 19.2)
			self:ScheduleTimer(function() self:AutoWeapon() end, 20.7)
        elseif eventType == "SPELL_AURA_REMOVED" and spellName == "Dominate Mind" and dstName == UnitName("player") then 
	      	if LGT:GetUnitRole("player") == "melee" then
				self:ScheduleTimer(function() self:AutoWeapon() end, 0.2)
				self:ScheduleTimer(function() self:AutoWeapon() end, 1.7)
				self:ScheduleTimer(function() self:AutoWeapon() end, 3.3)
				self:ScheduleTimer(function() self:AutoWeapon() end, 4.7)
				self:ScheduleTimer(function() self:AutoWeapon() end, 6.3)
				self:ScheduleTimer(function() self:AutoWeapon() end, 7.7)
				self:ScheduleTimer(function() self:AutoWeapon() end, 9.2)
				self:ScheduleTimer(function() self:AutoWeapon() end, 10.7)
            end
        end
    end

    if FatCooldowns:GetModule("Display").db.profile.reporter[99894] and UnitName("boss1") == "Lady Deathwhisper" then
    	if (eventType == "SPELL_CAST_SUCCESS" or eventType == "SPELL_AURA_APPLIED") and spellName == "Dominate Mind" and dstName == UnitName("player") then
    		for k,v in pairs(buffsandprocs) do
    			if UnitBuff("player", v) then CancelUnitBuff("player", v) end
    		end
    		buffsandprocscheck = GetTime()
    	end
    end

    if FatCooldowns:GetModule("Display").db.profile.reporter[99893] and UnitName("boss1") ~= nil and LGT:GetUnitRole("player") == "melee" and UnitBuff("player", "Hand of Protection") then	CancelUnitBuff("player", "Hand of Protection") end
    if FatCooldowns:GetModule("Display").db.profile.reporter[99885] and UnitName("boss1") ~= nil and LGT:GetUnitRole("player") == "tank" and UnitBuff("player", "Hand of Protection") then	CancelUnitBuff("player", "Hand of Protection") end
    if FatCooldowns:GetModule("Display").db.profile.reporter[99864] and UnitName("boss1") ~= nil and LGT:GetUnitRole("player") == "tank" and UnitBuff("player", "Divine Shield") then	CancelUnitBuff("player", "Divine Shield") end

	if FatCooldowns:GetModule("Display").db.profile.reporter[99965] and UnitName("boss1") == "Festergut" and maxPlayers == 25 then 
		if eventType == "SPELL_CAST_SUCCESS" and spellName == "Vile Gas" then
			if GasName1 == nil and dstName ~= GasName3 and dstName ~= GasName2 then GasName1 = dstName end		
			if GasName2 == nil and dstName ~= GasName1 and dstName ~= GasName3 then GasName2 = dstName end		
			if GasName3 == nil and dstName ~= GasName1 and dstName ~= GasName2 then GasName3 = dstName end
			GasDelay = GetTime()
		elseif eventType == "SPELL_AURA_APPLIED" and spellName == "Vile Gas" and GasDelay ~= nil and GetTime() - GasDelay < 2.8 then
			if dstName ~= GasName1 and dstName ~= GasName3 and dstName ~= GasName2 then
				vilegastargets[#vilegastargets + 1] = dstName
			end
		elseif GasDelay ~= nil and GetTime() - GasDelay > 2.8 and GasName3 ~= nil and GasName2 ~= nil and GasName1 ~= nil then
			local GasText = nil
			for index, vilegasplayertargets in pairs(vilegastargets) do
				if GasText == nil then
					GasText = vilegasplayertargets
				else
					GasText = GasText..", "..vilegasplayertargets
				end
			end
			if GasText == nil then
				local text = "Vile Gas on: "..GasName1..", "..GasName2..", "..GasName3
				self:GetModule("Display"):chatreporter(srcName, 99965, 1,nil,nil,nil,nil,nil, text)
			else
				local text = "Vile Gas on: "..GasName1..", "..GasName2..", "..GasName3.." Extra: "..GasText
				self:GetModule("Display"):chatreporter(srcName, 99965, 1,nil,nil,nil,nil,nil, text)
			end
			GasText = nil
			GasName1 = nil
			GasName2 = nil
			GasName3 = nil
			GasDelay = nil
			table.wipe(vilegastargets)
		end 
	end

	if FatCooldowns:GetModule("Display").db.profile.reporter[99964] and UnitName("boss1") ~= nil and UnitName("boss1") ~= "Professor Putricide" and UnitName("boss1") ~= "Prince Keleseth" and UnitName("boss1") ~= "Prince Taldaram" and UnitName("boss1") ~= "Prince Valanar" and
		combatstarttimestamp ~= nil and maxPlayers == 25 then
		if sundercountplayers == false then 
			for x=1, GetNumRaidMembers() do
				local player = UnitName("raid"..x)
				local playerclass = CustomUnitClass(player)
				if playerclass == "Warrior" then
					if UnitHealthMax(player) >= 55000 then warrtank = true end
					Sundercount = Sundercount or {}
					Sundercount[player] = Sundercount[player] or {}
					Sundercount[player][1] = Sundercount[player][1] or 0 
				end
				playerclass = nil
				player = nil
			end
			sundercountplayers = true
		end
		if eventType == "SPELL_AURA_REMOVED" and spellName == "Sunder Armor" and srcName == UnitName("boss1") then Sundercountchecked = 0 end
		if UnitInRaid(srcName) and (spellName == "Sunder Armor" or spellId == 7386) and eventType == "SPELL_CAST_SUCCESS" and UnitLevel(raidIbyName(srcName).."target") == -1 then
			local player = srcName
			if not Sundercount[player] then
			else
				Sundercount[player][1] = Sundercount[player][1] + 1
				Sundercountchecked = Sundercountchecked + 1
			end
			if Sundercountchecked == 5 and not warrtank then
				local Sundertext = nil
				if Sundercount ~= nil then self:SortTable(Sundercount) end
				for player in pairs(Sundercount) do
					if Sundertext == nil then
						Sundertext = player.." - "..Sundercount[player][1]
					else
						Sundertext = Sundertext..", "..player.." - "..Sundercount[player][1]
					end
				end
				if Sundertext ~= nil then
					local time = string.format("%.0f", (GetTime() - combatstarttimestamp))
					self:GetModule("Display"):chatreporter(srcName, 99964, 1,nil,nil,nil,nil,nil, "5 Sunder's "..time.."sec: "..Sundertext)
					player = nil
					time = nil
					Sundertext = nil
				end
			end
		end
	end

	if FatCooldowns:GetModule("Display").db.profile.reporter[99966] and not UnitAffectingCombat("player") and UnitName("boss1") ~= "The Lich King" and not IsStealthed() and not UnitBuff("player", "Vanish") and not UnitBuff("player", "Invisibility") then
		if warriorhowlschecked == 1 then 
			local Holwstext = nil
			if warriorhowls ~= nil then self:SortTable(warriorhowls) end
			for player in pairs(warriorhowls) do
				if Holwstext == nil then
					Holwstext = player.." - "..warriorhowls[player][1]
				else
					Holwstext = Holwstext..", "..player.." - "..warriorhowls[player][1]
				end
			end
			if Holwstext ~= nil then 
				self:GetModule("Display"):chatreporter(srcName, 99966, 1,nil,nil,nil,nil,nil, "Piercing Howl's: "..Holwstext)
				Holwstext = nil
			end
		end
		if warriorhowlschecked == 1 or warriorhowlschecked == true then 
			warriorhowls = nil
			warriorhowlschecked = nil
		end
	end

	if FatCooldowns:GetModule("Display").db.profile.reporter[99966] and UnitName("boss1") == "The Lich King" and maxPlayers == 25 then 
		if warriorhowlschecked == nil and UnitHealth("boss1") / UnitHealthMax("boss1") > 0.90 then 
			for sx=1, GetNumRaidMembers() do
				local player = UnitName("raid"..sx)
				local playerclass = CustomUnitClass(player)
				if playerclass == "Warrior" then
					warriorhowls = warriorhowls or {}
					warriorhowls[player] = warriorhowls[player] or {}
					warriorhowls[player][1] = warriorhowls[player][1] or 0 
				end
				player = nil
				playerclass = nil
			end
			warriorhowlschecked = true
		elseif UnitHealth("boss1") / UnitHealthMax("boss1") > 0.38 and UnitHealth("boss1") / UnitHealthMax("boss1") < 0.68 then 
			if eventType == "SPELL_CAST_SUCCESS" and (spellName == "Piercing Howl" or spellId == 12323) and UnitInRaid(srcName) and summonvalktimestamp ~= nil and GetTime() - summonvalktimestamp <= 30  then 
				local player = srcName
				if not warriorhowls[player][1] then
				else
					warriorhowls[player][1] = warriorhowls[player][1] + 1
					warriorhowlschecked = 1
				end
				player = nil
			end
		end
	end

	if FatCooldowns:GetModule("Display").db.profile.reporter[99962] and UnitName("boss1") == "The Lich King" and maxPlayers == 25 and spellId == 69200 and eventType == "SPELL_CAST_SUCCESS" then
		if WarlockBoomkinFail == 0 or WarlockBoomkinFail == 4 then
			if not UnitDebuff("boss1", "Curse of the Elements") then self:GetModule("Display"):chatreporter(srcName, 99962, 1,nil,nil,nil,nil,nil, "Warning: Warlock Fail no \124cff71d5ff\124Hspell:47865\124h[Curse of the Elements]\124h\124r on LK") end
			if not UnitDebuff("boss1", "Faerie Fire") then self:GetModule("Display"):chatreporter(srcName, 99962, 1,nil,nil,nil,nil,nil, "Warning: Boomkin Fail no \124cff71d5ff\124Hspell:770\124h[Faerie Fire]\124h\124r on LK") end
		end
		WarlockBoomkinFail = WarlockBoomkinFail + 1
	end

	if UnitName("boss1") == "The Lich King" and spellId == 69037 and eventType == "SPELL_SUMMON" then
		if summonvalktimestamp == nil or (summonvalktimestamp ~= nil and GetTime() - summonvalktimestamp > 15) then
			summonvalktimestamp = GetTime()
		end
		Valkyrs[dstGUID] = Valk25MaxHP
		self:ValkScanner()
	end

	if FatCooldowns:GetModule("Display").db.profile.AutoIconValk and FatCooldowns:GetModule("Display").db.profile.AutoIconValkName ~= nil then
		if not UnitInRaid(FatCooldowns:GetModule("Display").db.profile.AutoIconValkName) then FatCooldowns:GetModule("Display").db.profile.AutoIconValkName = nil end
	end
	if FatCooldowns:GetModule("Display").db.profile.AutoIconValk and FatCooldowns:GetModule("Display").db.profile.AutoIconFrostmourne ~= nil then
		if not UnitInRaid(FatCooldowns:GetModule("Display").db.profile.AutoIconFrostmourneName) then FatCooldowns:GetModule("Display").db.profile.AutoIconFrostmourneName = nil end
	end

	if FatCooldowns:GetModule("Display").db.profile.AutoIconValk and UnitName("boss1") == "The Lich King" and (IsRaidLeader() or IsRaidOfficer()) and spellId == 72262 and dynamicDifficulty == 1 and
		FatCooldowns:GetModule("Display").db.profile.AutoIconValkName ~= nil and
		UnitInRaid(FatCooldowns:GetModule("Display").db.profile.AutoIconValkName) and FatCooldowns:GetModule("Display").db.profile.AutoIconValkIcon ~= nil and FatCooldowns:GetModule("Display").db.profile.AutoIconValkIcon ~= 1 then
		local iconinusevalk = false
		if iconinusevalk then iconinusevalk = false end
		for x=1, GetNumRaidMembers() do
			if GetRaidTargetIndex("raid"..x) == (FatCooldowns:GetModule("Display").db.profile.AutoIconValkIcon - 1) then iconinusevalk = true end
		end
		if not iconinusevalk then SetRaidTarget(FatCooldowns:GetModule("Display").db.profile.AutoIconValkName, (FatCooldowns:GetModule("Display").db.profile.AutoIconValkIcon - 1)) iconinusevalk = true end
	end
	if FatCooldowns:GetModule("Display").db.profile.AutoIconFrostmourne and UnitName("boss1") == "The Lich King" and (IsRaidLeader() or IsRaidOfficer()) and spellId == 74296 and dynamicDifficulty == 1 and
		FatCooldowns:GetModule("Display").db.profile.AutoIconFrostmourneName ~= nil and
		UnitInRaid(FatCooldowns:GetModule("Display").db.profile.AutoIconFrostmourneName) and FatCooldowns:GetModule("Display").db.profile.AutoIconFrostmourneIcon ~= nil and FatCooldowns:GetModule("Display").db.profile.AutoIconFrostmourneIcon ~= 1 then
		local iconinusefrost = false
		if iconinusefrost then iconinusefrost = false end
		for x=1, GetNumRaidMembers() do
			if GetRaidTargetIndex("raid"..x) == (FatCooldowns:GetModule("Display").db.profile.AutoIconFrostmourneIcon - 1) then iconinusefrost = true end
		end
		if not iconinusefrost then SetRaidTarget(FatCooldowns:GetModule("Display").db.profile.AutoIconFrostmourneName, (FatCooldowns:GetModule("Display").db.profile.AutoIconFrostmourneIcon - 1)) iconinusefrost = true end
	end

	if FatCooldowns:GetModule("Display").db.profile.reporter[99977] and srcName == UnitName("player") and eventType == "SPELL_DISPEL" and LastDispelled ~= arg[2] then
		LastDispelled = arg[2]
		text = FCDColorName(srcName).." Dispelled "..GetSpellLink(arg[2]).." From "..(FCDColorName(dstName) or "Unknown")
		if FatCooldowns:GetModule("Display").db.profile.reporter[99977] then print(text) text = nil end
	end 

	if instancename == "The Ruby Sanctum" and (FatCooldowns:GetModule("Display").db.profile.reporter[99979] or FatCooldowns:GetModule("Display").db.profile.reporter[99978]) then
		if spellId == 74833 and spellName == "Corporeality" and eventType == "SPELL_AURA_APPLIED" and UnitHealth("boss1") / UnitHealthMax("boss1") > 0.07  then
			if FatCooldowns:GetModule("Display").db.profile.reporter[99979] then PlaySoundFile("Interface\\AddOns\\FatCooldowns\\sounds\\StopDamage.mp3", "Master") end
			if FatCooldowns:GetModule("Display").db.profile.reporter[99978] then SendChatMessage("Stop Damege, 70%/30%", SAY) end
		end
	end

	if instancename == "The Ruby Sanctum" and FatCooldowns:GetModule("Display").db.profile.reporter[99960] and (eventType == "SWING_DAMAGE" or eventType == "SWING_MISSED") and srcName == "Halion" and dynamicDifficulty == 1 then
		TimeH = TimeH2
		TimeH2 = timestamp
		if (TimeH2 - TimeH) <= 1.5 then
			self:GetModule("Display"):chatreporter(srcName, 99960, 1,nil,nil,nil,nil,nil, "Boss has done a PARRY HASTED attack")
		end
	end

	if FatCooldowns:GetModule("Display").db.profile.reporter[99883] and (UnitName("boss1") == "Prince Valanar" or UnitName("boss1") ==  "Prince Keleseth" or UnitName("boss1") ==  "Prince Taldaram") then
		if eventType == "SPELL_CAST_SUCCESS" and dstName == "Kinetic Bomb" and (spellName == "Charge" or spellName == "Leap" or spellName == "Intercept") then
			local checkPet, oname = isPet(srcName)
			if checkPet then self:GetModule("Display"):chatreporter(srcName, 99883, 1,nil,nil,nil,nil,nil, "Warning: "..oname.."'s pet used "..spellName.." on Kinetic") end
			checkPet = nil
			oname = nil
		end
	end

	if instancename == "The Ruby Sanctum" and (FatCooldowns:GetModule("Display").db.profile.reporter[99991]) then
		local text = nil
		if eventType == "SPELL_AURA_REMOVED" and (spellName == "Fiery Combustion" or spellName == "Soul Consumption") and marktimestamp[dstName] ~= nil and timestamp - marktimestamp[dstName] > 28 then
			if spellName == "Fiery Combustion" then
				text = dstName.." Failed to move with "..GetSpellLink(74567).." after 30Sec"
				self:GetModule("Display"):chatreporter(srcName, 99991, 1,nil,nil,nil,nil,nil, text)
				table.remove(marktimestamp, marktimestamp[dstName])
			elseif spellName == "Soul Consumption" then
				text = dstName.." Failed to move with "..GetSpellLink(74795).." after 30Sec"
				self:GetModule("Display"):chatreporter(srcName, 99991, 1,nil,nil,nil,nil,nil, text)
				table.remove(marktimestamp, marktimestamp[dstName])
		end
		elseif  eventType == "UNIT_DIED" and (UnitDebuff(dstName, "Fiery Combustion") or UnitDebuff(dstName, "Soul Consumption") or UnitDebuff(dstName, "Mark of Combustion") or UnitDebuff(dstName, "Mark of Consumption")) then
			if marktimestamp[dstName] == nil then return else DispelTime = string.format("%.1f", (timestamp - marktimestamp[dstName])) end
			text = dstName.." died with Debuff after "..DispelTime.." Seconds"
			self:GetModule("Display"):chatreporter(dstName, 99991, 1,nil,nil,nil,nil,nil, text)
			text = nil
			if marktimestamp[dstName] ~= nil then table.remove(marktimestamp, marktimestamp[dstName]) end
		elseif (spellName == "Mark of Combustion" or spellName == "Mark of Consumption") and eventType == "SPELL_AURA_APPLIED" then
			marktimestamp[dstName] = timestamp
		elseif (eventType == "SPELL_DISPEL" and (arg[3] == "Fiery Combustion" or arg[3] == "Soul Consumption" or arg[3] == "Mark of Combustion" or arg[3] == "Mark of Consumption")) or (eventType == "SPELL_CAST_SUCCESS" and (spellName == "Divine Shield" or spellName == "Cloak of Shadows" or spellName == "Ice Block") and (UnitDebuff(srcName, "Mark of Consumption") or UnitDebuff(srcName, "Mark of Combustion")))  then
			if eventType == "SPELL_CAST_SUCCESS" and (spellName == "Divine Shield" or spellName == "Cloak of Shadows" or spellName == "Ice Block") then 
				if UnitDebuff(srcName, "Mark of Consumption") then markid = GetSpellLink(74795) 
				elseif UnitDebuff(srcName, "Mark of Combustion") then markid = GetSpellLink(74567) end
				if marktimestamp[srcName] ~= nil then DispelTime = string.format("%.1f", (timestamp - marktimestamp[srcName])) else DispelTime = "Unknown" end
				text = srcName.." has dispelled the mark with Bubble, Cloak or Ice Block after "..DispelTime.." Seconds"
				if CustomUnitClass(srcName) == "Paladin" then text = srcName.." has dispelled "..markid.." with "..GetSpellLink(642).." after "..DispelTime.." Seconds" 
				elseif CustomUnitClass(srcName) == "Mage" then text = srcName.." has dispelled "..markid.." with "..GetSpellLink(45438).." after "..DispelTime.." Seconds" 
				elseif CustomUnitClass(srcName) == "Rogue" then text = srcName.." has dispelled "..markid.." with "..GetSpellLink(31224).." after "..DispelTime.." Seconds" end
				self:GetModule("Display"):chatreporter(srcName, 99991, 1,nil,nil,nil,nil,nil, text)
				text = nil
				if marktimestamp[dstName] ~= nil then table.remove(marktimestamp, marktimestamp[dstName]) end
			elseif not UnitInRaid(srcName) then 
				local checkPet, oname = isPet(srcName)
				if CustomUnitClass(oname) == "Warlock" then
				if marktimestamp[dstName] ~= nil then DispelTime = string.format("%.1f", (timestamp - marktimestamp[dstName])) else DispelTime = "Unknown" end
				text = oname.."'s pet has dispelled "..GetSpellLink(arg[2]).." from "..dstName.." after "..DispelTime.." Seconds"
				self:GetModule("Display"):chatreporter(oname, 99991, 1,nil,nil,nil,nil,nil, text)
				text = nil
				checkPet = nil
				oname = nil
				if marktimestamp[dstName] ~= nil then table.remove(marktimestamp, marktimestamp[dstName]) end end
			else
				if marktimestamp[dstName] ~= nil then DispelTime = string.format("%.1f", (timestamp - marktimestamp[dstName])) else DispelTime = "Unknown" end
				text = srcName.." dispelled "..GetSpellLink(arg[2]).." from "..dstName.." after "..DispelTime.." Seconds"
				self:GetModule("Display"):chatreporter(srcName, 99991, 1,nil,nil,nil,nil,nil, text)
				text = nil
				if marktimestamp[dstName] ~= nil then table.remove(marktimestamp, marktimestamp[dstName]) end
			end
		end
	end

	if FatCooldowns:GetModule("Display").db.profile.reporter[99901] and UnitName("boss1") == "Lady Deathwhisper" and instancename == "Icecrown Citadel" and dynamicDifficulty == 1 and (maxPlayers == 25 or maxPlayers == 10) then		
		if (eventType == "SWING_DAMAGE" or eventType == "SWING_MISSED") and srcName == "Vengeful Shade" then
			self:GetModule("Display"):chatreporter(dstName, 99901, 1,srcName, nil, nil, eventType, nil, dstName.." has been hit by Vengeful Shade!")
		end
	end

	if FatCooldowns:GetModule("Display").db.profile.reporter[99902] and UnitName("boss1") == "Professor Putricide" then
		if (eventType == "SWING_DAMAGE" or eventType == "SWING_MISSED") and srcName == "Gas Cloud" then
			self:GetModule("Display"):chatreporter(dstName, 99902, 1,srcName, nil, nil, eventType,nil,"Red Ooze")
		end
	end
	if UnitName("boss1") == "Professor Putricide" then
		if spellName == "Unstable Experiment" then 
			oozedead = true
			ppsummonooze2 = ppsummonooze
			ppsummonooze = GetTime()
			if ppsummonooze2 ~= nil and ppsummonooze - ppsummonooze2 <= 18 then doublesummonooze = true else doublesummonooze = false end
		end
	end
	

	if instancename == "Icecrown Citadel" and UnitName("boss1") == "Blood-Queen Lana'thel" then
		if FatCooldowns:GetModule("Display").db.profile.reporter[99800] and UnitBuff("player", "Hand of Sacrifice") then CancelUnitBuff("player", "Hand of Sacrifice") end
		if FatCooldowns:GetModule("Display").db.profile.reporter[99993] and spellName == "Vampiric Bite" and eventType == "SPELL_CAST_SUCCESS" then
			local text = srcName.." has bitten "..dstName
			self:GetModule("Display"):chatreporter(srcName, 99993, 1, dstName, nil, nil, nil, nil, text)
			text = nil
		end
		if FatCooldowns:GetModule("Display").db.profile.reporter[99992] and spellName == "Uncontrollable Frenzy" and eventType == "SPELL_AURA_APPLIED" then
			local text = dstName.." has failed to bite"
			self:GetModule("Display"):chatreporter(srcName, 99992, 1, dstName, nil, nil, nil, nil, text)
			text = nil
		end
	end

	if FatCooldowns:GetModule("Display").db.profile.reporter[99998] and instancename == "Icecrown Citadel" and UnitName("boss1") == "Sindragosa" and dynamicDifficulty == 1 then
		if eventType == "UNIT_DIED" and srcName == nil then srcName = dstName end
		if (eventType == "SPELL_AURA_REMOVED" and spellId == 69766 and (BacklashStacks[srcName] ~= nil and BacklashStacks[srcName] ~= 0)) or
		(eventType == "SPELL_CAST_SUCCESS" and (spellId == 642 or spellId == 45438) and (UnitDebuff(srcName, "Backlash") or (BacklashStacks[srcName] ~= nil and BacklashStacks[srcName] ~= 0))) or
		(eventType == "UNIT_DIED" and (UnitDebuff(srcName, "Backlash") or (BacklashStacks[srcName] ~= nil and BacklashStacks[srcName] ~= 0))) then
			local text = nil
			local time = ""
			local BacklashCount = 0
			for bx=1, GetNumRaidMembers() do
				if not UnitIsDeadOrGhost("raid"..bx) and self:DistanceChecker(srcName,"raid"..bx) <= 20 then
					BacklashCount = BacklashCount + 1
					if BacklashCount <= 14 then
						if text == nil then text = UnitName("raid"..bx)
						else text = text..", "..UnitName("raid"..bx)
						end
					end
				end
			end
			if BacklashTime[srcName] ~= nil and (5 - (GetTime() - BacklashTime[srcName])) > 0.1 then
				time =  " "..string.format("%.1f",5 - (GetTime() - BacklashTime[srcName])).."Sec"
			end

			if eventType == "SPELL_CAST_SUCCESS" and spellId == 642 and text ~= nil then text = srcName.." Bubble".." "..BacklashStacks[srcName].." Hits: "..BacklashCount.." "..text
			elseif eventType == "SPELL_CAST_SUCCESS" and spellId == 45438 and text ~= nil then text = srcName.." Ice Block".." "..BacklashStacks[srcName].." Hits: "..BacklashCount.." "..text
			elseif text ~= nil then text = srcName..time.." "..BacklashStacks[srcName].." Hits: "..BacklashCount..": "..text end
			if text ~= nil and  (BacklashStacks[srcName] >= 5 and (UnitHealth("boss1") / UnitHealthMax("boss1") > 0.30)) or spellId == 642 or spellId == 45438 then
				self:GetModule("Display"):chatreporter(srcName, 99998, 1, dstName, nil, nil, nil, nil, text)
			elseif text ~= nil and BacklashStacks[srcName] >= 1 and (UnitHealth("boss1") / UnitHealthMax("boss1") < 0.30) then
				self:GetModule("Display"):chatreporter(srcName, 99998, 1, dstName, nil, nil, nil, nil, text)
			end
			text = nil
			time = ""
			BacklashStacks[srcName] = 0
			BacklashTime[srcName] = nil
			BacklashCount = 0
		end

		if eventType == "SPELL_AURA_APPLIED" and spellId == 69766 then  
   			BacklashStacks[dstName] = 1
   			BacklashTime[dstName] = GetTime()
 		elseif eventType == "SPELL_AURA_APPLIED_DOSE" and spellId == 69766 then 
    		BacklashStacks[dstName] = arg[3]
    		BacklashTime[dstName] = GetTime()
      	end
    end
	
	if instancename == "Icecrown Citadel" and eventType == "SPELL_AURA_APPLIED" and spellName == "Invocation of Blood" then	Oozetimestamp = timestamp end

	if ((FatCooldowns:GetModule("Display").db.profile.reporter[99985] and dstName == "Sindragosa") or (FatCooldowns:GetModule("Display").db.profile.reporter[99984] and dstName == "Halion")) and (instancename == "The Ruby Sanctum" or instancename == "Icecrown Citadel") then --and dynamicDifficulty == 1 then
		if (arg[2] == "PARRY" or spellId == "PARRY") and srcName ~= "Army of the Dead Ghoul" and srcName ~= "Treant" and srcName ~= "Venomous Snake" then
			local playersname = srcName
			local text = nil
			local checkPet, oname = isPet(srcName)
			local bosstarget = UnitName("boss1target")
			if FatCooldowns:GetModule("Display").db.profile.reporter[99874] then 
				playersname = FCDColorName(playersname)
				if bosstarget ~= nil then bosstarget = FCDColorName(bosstarget) end
			end
			if checkPet or oname ~= nil then
				if FatCooldowns:GetModule("Display").db.profile.reporter[99874] then 
					playersname = FCDColorName(oname).."'s pet ("..srcName..")"
					checkPet = nil
					oname = nil 
				else
					playersname = oname.."'s pet ("..srcName..")"
					checkPet = nil
					oname = nil
				end 
			end
			if dstName == "Sindragosa" then
				if UnitName("boss1target") ~= nil then
					text = "PARRY: "..playersname.." has caused a PARRY! Boss Target: "..bosstarget
				else
					text = "PARRY: "..playersname.." has caused a PARRY!"
				end
				if FatCooldowns:GetModule("Display").db.profile.reporter[99874] then
					print("FCD: Warning "..text)
				else
					self:GetModule("Display"):chatreporter(srcName, 99985, 1,nil,nil,nil,nil,nil,text)
				end
				text = nil
			elseif dstName == "Halion" then
				if UnitName("boss1target") ~= nil then
					text = "PARRY: "..playersname.." has caused a PARRY! Boss Target: "..bosstarget
				else
					text = "PARRY: "..playersname.." has caused a PARRY!"
				end
				if FatCooldowns:GetModule("Display").db.profile.reporter[99874] then
					print("FCD: Warning "..text)
				else
					self:GetModule("Display"):chatreporter(srcName, 99984, 1,nil,nil,nil,nil,nil,text)
				end
				text = nil
			end
		end	
	end

	if srcName ~= UnitName("player")  and not UnitInParty(srcName) and not UnitInRaid(srcName) then return end -- checks if player is in raid



































	if FatCooldowns:GetModule("Display").db.profile.reporter[99879] and UnitClass("player") == "Rogue" then
		if eventType == "SPELL_CAST_SUCCESS" and spellId == 57934 and UnitName("player") == srcName then
			ToTRemover = dstName
		end
		if eventType == "SPELL_AURA_APPLIED" and spellId == 59628 and UnitName("player") == srcName and ToTRemover ~= nil then
			if UnitClass(ToTRemover) ~= "Rogue" and (LGT:GetUnitRole(ToTRemover) == "melee" or LGT:GetUnitRole(ToTRemover) == "caster" or LGT:GetUnitRole(ToTRemover) == "healer") then
				self:ScheduleTimer(function() self:RemoveToT() end, 0.1)
			end
		end
	end

	if FatCooldowns:GetModule("Display").db.profile.reporter[99884] and UnitInRaid("player") and spellName == "Windfury Totem" and eventType == "SPELL_SUMMON" and (instancename == "Icecrown Citadel" or instancename == "The Ruby Sanctum") and
		(TotemAntiSpamp[srcName] == nil or GetTime() - TotemAntiSpamp[srcName] > 60) then
		local frostdk = nil
		local missingbuffcount = 0
		for fdk=1, GetNumRaidMembers() do
			if UnitBuff("raid"..fdk,"Improved Icy Talons") then frostdk = true end
			if not UnitBuff("raid"..fdk,"Wrath of Air Totem") and isUnitRelevant(UnitName("raid"..fdk)) then missingbuffcount = missingbuffcount + 1 end
		end
		if missingbuffcount > 0 then missingbuffcount = " "..missingbuffcount.." missing Spell Haste buff" elseif missingbuffcount == 0 then missingbuffcount = "" end
		if frostdk == true then	self:GetModule("Display"):chatreporter(srcName, 99884, 1,nil,nil,nil,nil,nil,"Warning: "..srcName.." used Windfury Totem with Icy Talons buff in raid"..missingbuffcount) end
		TotemAntiSpamp[srcName] = GetTime()
	end

	if FatCooldowns:GetModule("Display").db.profile.reporter[99863] and UnitInRaid("player") and spellName == "Strength of Earth Totem" and eventType == "SPELL_SUMMON" and (instancename == "Icecrown Citadel" or instancename == "The Ruby Sanctum") and
		(TotemAntiSpamp2[srcName] == nil or GetTime() - TotemAntiSpamp2[srcName] > 60) and LGT:GetUnitTalentSpec(srcName) ~= nil and LGT:GetUnitTalentSpec(srcName) ~= "Enhancement" then
		local StoneT = nil
		local missingbuffcount = 0
		local missingbuffcount2 = 0
		for ST=1, GetNumRaidMembers() do
			if UnitClass("raid"..ST) == "Death Knight" then StoneT = true end
			if not UnitBuff("raid"..ST,"Stoneskin Totem") and isUnitRelevant(UnitName("raid"..ST)) then missingbuffcount = missingbuffcount + 1 missingbuffcount2 = missingbuffcount2 + 1 end
		end
		if missingbuffcount > 0 then missingbuffcount = " "..missingbuffcount.." missing Stoneskin Totem buff" elseif missingbuffcount == 0 then missingbuffcount = "" end
		if StoneT == true and missingbuffcount2 > 0 then 
			self:GetModule("Display"):chatreporter(srcName, 99863, 1,nil,nil,nil,nil,nil,"Warning: "..srcName.." used Strength of the Earth Totem with DK buff in raid"..missingbuffcount) 
		end
		TotemAntiSpamp2[srcName] = GetTime()
	end


	if FatCooldowns:GetModule("Display").db.profile.reporter[99963] and	UnitInRaid("player") and UnitName("boss1") ~= nil and UnitName("boss1") ~= "Valithria Dreamwalker" and UnitClass("player") ~= "Druid" and (manacheckcd == nil or GetTime() - manacheckcd > 60) and
		((UnitHealth("boss1") / UnitHealthMax("boss1") > 0.15 and UnitName("boss1") ~= "The Lich King") or (UnitHealth("boss1") / UnitHealthMax("boss1") > 0.25 and UnitName("boss1") == "The Lich King")) then
		if LGT:GetUnitTalentSpec("player") == nil then LGT:RefreshTalentsByUnit(UnitName("player")) end
		if LGT:GetUnitRole("player") == "healer" and not UnitIsDead("player") and UnitMana("player") / UnitManaMax("player") < 0.2 then
			local druidinraid = false
			for drinraid = 1, GetNumRaidMembers() do
				if UnitClass("raid"..drinraid) == "Druid" then druidinraid = true end
			end
			if druidinraid then
				SendChatMessage("Innervate Me")
				manacheckcd = GetTime()
			end
		end
	end

	if FatCooldowns:GetModule("Display").db.profile.reporter[99976] and UnitName("boss1") ==  "Prince Keleseth" and UnitBuff("player", "Soul Fragment") then
		local stacks = select(4, UnitBuff("player", "Soul Fragment"))
		if stacks >= 5 then CancelUnitBuff("player", "Soul Fragment") end
	end

	if FatCooldowns:GetModule("Display").db.profile.reporter[99886] and UnitBuff("player", "Wisp Costume") then CancelUnitBuff("player", "Wisp Costume") end

	if (FatCooldowns:GetModule("Display").db.profile.reporter[99986] or FatCooldowns:GetModule("Display").db.profile.reporter[99983]) and UnitName("boss1") == "The Lich King" and UnitHealth("boss1") / UnitHealthMax("boss1") > 0.40 then
		if LGT:GetUnitTalentSpec("player") == nil then LGT:RefreshTalentsByUnit(UnitName("player")) end
		if (CustomUnitClass("player") == "Warrior" and LGT:GetUnitRole("player") == "melee" and FatCooldowns:GetModule("Display").db.profile.reporter[99986]) or (CustomUnitClass("player") == "Druid" and UnitBuff("player", "Moonkin Form") and FatCooldowns:GetModule("Display").db.profile.reporter[99983]) then
			if UnitBuff("player", "Power Word: Shield") then CancelUnitBuff("player", "Power Word: Shield") end
			if UnitBuff("player", "Sacred Shield") then CancelUnitBuff("player", "Sacred Shield") end
		end
	end

	if FatCooldowns:GetModule("Display").db.profile.reporter[99801] and UnitBuff("player", "Chaos Bane") and UnitClass("player") == "Paladin" then CancelUnitBuff("player", "Chaos Bane") end

	if (FatCooldowns:GetModule("Display").db.profile.reporter[99990] or FatCooldowns:GetModule("Display").db.profile.reporter[99989]) and UnitName("boss1") == "The Lich King" and UnitHealth("boss1") / UnitHealthMax("boss1") > 0.65 then
		if eventType == "SPELL_CAST_SUCCESS" and (spellName == "Earth Shield" or spellName == "Ripdtide") then healers[srcName] = srcName 
		elseif eventType == "SPELL_CAST_SUCCESS" and (spellName == "Beacon of Light" or spellName == "Holy Shock") then healers[srcName] = srcName
		elseif (eventType == "SPELL_ENERGIZE" and spellName == "Rupture") or ((spellName == "Power Infusion" or spellName == "Penance" or spellName == "Circle of Healing") and eventType == "SPELL_CAST_SUCCESS" ) then healers[srcName] = srcName 
		elseif eventType == "SPELL_CAST_SUCCESS" and spellName == "Wild Growth" then healers[srcName] = srcName
		elseif eventType == "SPELL_CAST_SUCCESS" and spellName == "Swiftmend" then healers[srcName] = srcName
		elseif eventType == "SPELL_AURA_APPLIED" and spellName == "Tidal Waves" then healers[srcName] = srcName
		elseif eventType == "SPELL_AURA_APPLIED" and spellName == "Borrowed Time" then healers[srcName] = srcName
		elseif eventType == "SPELL_AURA_APPLIED" and spellName == "Light's Grace" then healers[srcName] = srcName 
		elseif eventType == "SPELL_AURA_APPLIED" and spellName == "Judgements of the Pure" then healers[srcName] = srcName 
		elseif eventType == "SPELL_AURA_APPLIED" and spellName == "Surge of Light" then healers[srcName] = srcName 
		elseif eventType == "SPELL_AURA_APPLIED" and spellName == "Serendipity" then healers[srcName] = srcName 
		elseif eventType == "SPELL_AURA_APPLIED" and spellName == "Holy Concentration" then healers[srcName] = srcName 
		end
	end

	if FatCooldowns:GetModule("Display").db.profile.reporter[99896] and (UnitName("boss1") == "Prince Valanar" or UnitName("boss1") == "Prince Valanar" or UnitName("boss1") == "Prince Valanar") then
		if spellName == "Empowered Shock Vortex" and dstName == UnitName("player") then
			print("Warning: I was knocked by "..FCDColorName(srcName))
		end
	end

	if (FatCooldowns:GetModule("Display").db.profile.reporter[99988] or FatCooldowns:GetModule("Display").db.profile.reporter[99895]) and (UnitName("boss1") == "Prince Valanar" or UnitName("boss1") == "Prince Valanar" or UnitName("boss1") == "Prince Valanar") then
		if spellName ~= "Empowered Shock Vortex" then
			if eventType == "SPELL_CAST_SUCCESS" and (spellName == "Earth Shield" or spellName == "Ripdtide") then healers[srcName] = srcName 
			elseif eventType == "SPELL_CAST_SUCCESS" and (spellName == "Beacon of Light" or spellName == "Holy Shock") then healers[srcName] = srcName
			elseif (eventType == "SPELL_ENERGIZE" and spellName == "Rupture") or ((spellName == "Power Infusion" or spellName == "Penance" or spellName == "Circle of Healing") and eventType == "SPELL_CAST_SUCCESS" ) then healers[srcName] = srcName 
			elseif eventType == "SPELL_CAST_SUCCESS" and spellName == "Wild Growth" then healers[srcName] = srcName
			elseif eventType == "SPELL_CAST_SUCCESS" and spellName == "Swiftmend" then healers[srcName] = srcName
			elseif eventType == "SPELL_AURA_APPLIED" and spellName == "Tidal Waves" then healers[srcName] = srcName
			elseif eventType == "SPELL_AURA_APPLIED" and spellName == "Borrowed Time" then healers[srcName] = srcName
			elseif eventType == "SPELL_AURA_APPLIED" and spellName == "Light's Grace" then healers[srcName] = srcName
			elseif eventType == "SPELL_AURA_APPLIED" and spellName == "Judgements of the Pure" then healers[srcName] = srcName  
			elseif eventType == "SPELL_AURA_APPLIED" and spellName == "Surge of Light" then healers[srcName] = srcName 
			elseif eventType == "SPELL_AURA_APPLIED" and spellName == "Serendipity" then healers[srcName] = srcName 
			elseif eventType == "SPELL_AURA_APPLIED" and spellName == "Holy Concentration" then healers[srcName] = srcName 
			elseif eventType == "SPELL_AURA_APPLIED" and spellName == "Holy Concentration" then healers[srcName] = srcName 
			end
		end
		if UnitInRaid(dstName) and spellName == "Empowered Shock Vortex" then
			if FatCooldowns:GetModule("Display").db.profile.reporter[99895] and ((healers[dstName] ~= nil and healers[dstName] == dstName) or LGT:GetUnitRole(dstName) == "healer") then
				EmpShockTargetsHealers = EmpShockTargetsHealers or {}
				EmpShockTargetsHealers[dstName] = EmpShockTargetsHealers[dstName] or {}
				table.insert(EmpShockTargetsHealers[dstName], srcName)
				EmpShockDone = GetTime()
			elseif FatCooldowns:GetModule("Display").db.profile.reporter[99988] and (UnitName("boss1target") == dstName or UnitName("boss3target") == dstName or UnitName("boss2target") == dstName or LGT:GetUnitRole(dstName) == "tank") then
				EmpShockTargetsTanks = EmpShockTargetsTanks or {}
				EmpShockTargetsTanks[dstName] = EmpShockTargetsTanks[dstName] or {}
				table.insert(EmpShockTargetsTanks[dstName], srcName)
				EmpShockDone = GetTime()
			end
		end
		if EmpShockDone ~= nil and GetTime() - EmpShockDone > 2.5 then
			if FatCooldowns:GetModule("Display").db.profile.reporter[99988] then
				for key,val in pairs(EmpShockTargetsTanks) do 
					local KnockedTanks2 = nil
					for k,v in pairs(EmpShockTargetsTanks[key]) do
						if KnockedTanks2 == nil then
							KnockedTanks2 = "Warning: "..key.." Tank knocked by "..v
						else
							KnockedTanks2 = KnockedTanks2..", "..v
						end
					end
					if KnockedTanks2 ~= nil then 
						self:GetModule("Display"):chatreporter(srcName, 99988, 1,nil,nil,nil,nil,nil,KnockedTanks2)
					end
					KnockedTanks2 = nil
				end
				EmpShockDone = nil
			end
			if FatCooldowns:GetModule("Display").db.profile.reporter[99895] then
				for key,val in pairs(EmpShockTargetsHealers) do 
					local KnockedHeals2 = nil
					for k,v in pairs(EmpShockTargetsHealers[key]) do 
						if KnockedHeals2 == nil then
							KnockedHeals2 = "Warning: "..key.." Healer knocked by "..v
						else
							KnockedHeals2 = KnockedHeals2..", "..v
						end
					end
					if KnockedHeals2 ~= nil then 
						self:GetModule("Display"):chatreporter(srcName, 99895, 1,nil,nil,nil,nil,nil,KnockedHeals2)
					end
					KnockedHeals2 = nil
				end
				EmpShockDone = nil
			end
			KnockedTanks2 = nil
			EmpShockDone = nil
			KnockedHeals2 = nil
			table.wipe(EmpShockTargetsTanks)
			table.wipe(EmpShockTargetsHealers)
		end
	end

	if FatCooldowns:GetModule("Display").db.profile.reporter[99995] and (dstName == "Blood-Queen Lana'thel" or (UnitName("boss1") == "Blood-Queen Lana'thel" and spellName == "Defensive Stance")) and (UnitHealth("boss1") / UnitHealthMax("boss1") > 0.90) then
		if self:isnotbosstarget(srcName) and (spellName == "Defensive Stance" or (UnitBuff(srcName, "Righteous Fury") or UnitBuff(srcName, "Frost Presence"))) and (UnitInRaid(srcName) or UnitInParty(srcName) or UnitName("player") == srcName) and LGT:GetUnitTalentSpec(srcName) == nil then LGT:RefreshTalentsByUnit(srcName) end
		if spellName == "Searing Pain" and CustomUnitClass(srcName) == "Warlock" and UnitInRaid(srcName) and eventType == "SPELL_CAST_SUCCESS" then
			local StealingBite = nil
			StealingBite = "Stealing Bite: "..srcName.." used Searing Pain" self:GetModule("Display"):chatreporter(srcName, 99995, 1, dstName, nil, nil, nil, nil, StealingBite) StealingBite = nil
		elseif (CustomUnitClass(srcName) == "Warrior" and eventType == "SPELL_AURA_REMOVED" and spellName == "Defensive Stance" and LGT:GetUnitRole(srcName) == "melee" and not UnitBuff(srcName, "Essence of the Blood Queen")) then
			local StealingBite = nil StealingBite = "Stealing Bite: "..srcName.." had Defensive Stance on" self:GetModule("Display"):chatreporter(srcName, 99995, 1, dstName, nil, nil, nil, nil, StealingBite) StealingBite = nil
		elseif (UnitBuff(srcName, "Righteous Fury") or UnitBuff(srcName, "Frost Presence")) and LGT:GetUnitRole(srcName) == "melee" and (StealingBiteSpam[srcName] == nil or StealingBiteSpam[srcName] < 4) then
			if eventType == "SPELL_CAST_SUCCESS" and not UnitBuff(srcName, "Essence of the Blood Queen") then
				local StealingBite = nil
				if CustomUnitClass(srcName) == "Paladin" then
					StealingBite = "Stealing Bite: "..srcName.." has Righteous Fury" self:GetModule("Display"):chatreporter(srcName, 99995, 1, dstName, nil, nil, nil, nil, StealingBite) StealingBite = nil
					if StealingBiteSpam[srcName] == nil then StealingBiteSpam[srcName] = 1 else StealingBiteSpam[srcName] = StealingBiteSpam[srcName] + 1 end 
				elseif CustomUnitClass(srcName) == "Death Knight" then
					StealingBite = "Stealing Bite: "..srcName.." has Frost Presence" self:GetModule("Display"):chatreporter(srcName, 99995, 1, dstName, nil, nil, nil, nil, StealingBite) StealingBite = nil
					if StealingBiteSpam[srcName] == nil then StealingBiteSpam[srcName] = 1 else StealingBiteSpam[srcName] = StealingBiteSpam[srcName] + 1 end
				end
			end
		end
	end 

	if FatCooldowns:GetModule("Display").db.profile.reporter[99996] and (spellId == 60122 or spellName == "Baby Spice") and eventType == "SPELL_CAST_SUCCESS" then
		if dstName == UnitName("boss1") or dstName == "Lord Marrowgar" or dstName == "Lady Deathwhisper" or dstName == "Deathbringer Saurfang" or dstName == "Festergut" or dstName == "Rotface" or dstName == "Professor Putricide" or
			dstName == "Blood-Queen Lana'thel" or dstName == "Sindragosa" or dstName == "The Lich King" or dstName == "Halion" or dstName == "Prince Valanar" or dstName == "Prince Taldaram" or dstName == "Prince Keleseth" then
			local spice = srcName.." used "..GetSpellLink(60122).." on "..dstName
			self:GetModule("Display"):chatreporter(srcName, 99996, 1, dstName, nil, nil, nil, nil, spice) spice = nil
		end
		return
	end
	
	if FatCooldowns:GetModule("Display").db.profile.reporter[99997] and instancename == "Icecrown Citadel" and maxPlayers == 25 and UnitName("boss1") == "Professor Putricide" and dynamicDifficulty == 1 and not doublesummonooze and oozedead then
		if eventType == "SPELL_AURA_APPLIED" and spellName == "Gas Variable" or spellName == "Ooze Variable" then Oozetimestamp = timestamp end

		if (eventType == "SPELL_CAST_SUCCESS" or eventType == "SPELL_AURA_APPLIED") and
			(spellName == "Chimera Shot" or spellName == "Aimed Shot" or spellName == "Steady Shot" or
		 	 spellName == "Shadow Bolt" or spellName == "Immolate" or spellName == "Drain Life" or spellName == "Incinerate" or spellName == "Soul Fire" or spellName == "Drain Life" or
		 	 spellName == "Moonfire" or spellName == "Wrath" or spellName == "Starfire" or spellName == "Rake" or spellName == "Shred" or spellName == "Mangle (Cat)" or
		 	 spellName == "Crusader Strike" or spellName == "Divine Storm" or
		 	 spellName == "Blood Strike" or spellName == "Frost Strike" or spellName == "Scourge Strike" or spellName == "Icy Touch" or spellName == "Plague Strike" or
		 	 spellName == "Vampiric Touch" or spellName == "Mind Flay" or spellName == "Shadow Word: Pain" or spellName == "Devouring Plague" or
		 	 spellName == "Lava Lash" or spellName == "Stormstrike" or spellName == "Lightning Bolt" or spellName == "Flame Shock" or spellName == "Lava Brust" or
		 	 spellName == "Sinister Strike" or spellName == "Mutilate" or
		 	 spellName == "Bloodthirst" or spellName == "Execute" or spellName == "Heroic Strike" or
		 	 spellName == "Fireball" or spellName == "Living Bomb" or spellName == "Arcane Barrage" or spellName == "Arcane Blast" or spellName == "Arcane Missiles") then
			if (UnitDebuff(srcName, "Ooze Variable") and dstName == "Gas Cloud") or (UnitDebuff(srcName, "Gas Variable") and dstName == "Volatile Ooze") then
				if Oozetimestamp ~= nil then
					if (timestamp - Oozetimestamp) < 25 and (timestamp - Oozetimestamp) > 4 then
						local Oozetext = nil
						Oozetext = "Incorrect Ooze Damage: " .. srcName .. " used " .. GetSpellLink(spellId) .. " on " .. dstName .. " with incorrect debuff"
						self:GetModule("Display"):chatreporter(srcName, 99997, 1, dstName, nil, nil, nil, nil, Oozetext) Oozetext = nil
					end
				end
			end
		end
	end 

	if (FatCooldowns:GetModule("Display").db.profile.reporter[99994] or FatCooldowns:GetModule("Display").db.profile.reporter[99999]) and instancename == "Icecrown Citadel" then 
		if dstName == "Val'kyr Shadowguard" then
			if Valkyrs[dstGUID] then 
				if eventType == "SPELL_DAMAGE" or eventType == "SPELL_PERIODIC_DAMAGE" or eventType == "RANGE_DAMAGE" then Valkyrs[dstGUID] = Valkyrs[dstGUID] - arg[2] end
				if eventType == "SWING_DAMAGE" then Valkyrs[dstGUID] = Valkyrs[dstGUID] - spellId end
			else
				if eventType == "SPELL_DAMAGE" or eventType == "SPELL_PERIODIC_DAMAGE" or eventType == "RANGE_DAMAGE" then Valkyrs[dstGUID] = Valk25MaxHP - arg[2] end
				if eventType == "SWING_DAMAGE" then Valkyrs[dstGUID] = Valk25MaxHP - spellId end
			end
		end
	end

	if FatCooldowns:GetModule("Display").db.profile.reporter[99999] and instancename == "Icecrown Citadel" then
		if (spellName == "Cleave" or spellName == "Seal of Command") and self:isnotbosstarget(srcName) and (UnitInRaid(dstName) or UnitInParty(dstName) or UnitName("player") == dstName) and LGT:GetUnitTalentSpec(srcName) == nil then LGT:RefreshTalentsByUnit(srcName) end
		if (dstName == "Blood Beast" and eventType == "SPELL_AURA_APPLIED" and (spellName == "Living Bomb" or spellName == "Moonfire" or spellName == "Insect Swarm" or spellName == "Immolate" or spellName == "Shadow Word: Pain")) or
			(UnitName("boss1") == "Deathbringer Saurfang" and eventType == "SPELL_CAST_SUCCESS" and (spellName == "Mind Sear" or spellName == "Volley" or spellName == "Hurricane" or spellName == "Flamestrike" or spellName == "Rain of Fire" or
			spellName == "Seed of Corruption" or spellName == "Blizzard" or spellName == "Fan of Knives" or spellName == "Swipe (Cat)")) or 


			((dstName == "Little Ooze" or dstName == "Big Ooze") and eventType == "SPELL_AURA_APPLIED" and (spellName == "Living Bomb" or spellName == "Shadow Word: Pain" or spellName == "Vampiric Touch" or spellName == "Moonfire" or spellName == "Insect Swarm"  or spellName == "Immolate")) or
			(UnitName("boss1") == "Rotface" and eventType == "SPELL_CAST_SUCCESS" and (spellName == "Mind Sear" or spellName == "Volley" or spellName == "Hurricane" or spellName == "Flamestrike" or spellName == "Rain of Fire" or
			spellName == "Seed of Corruption" or spellName == "Blizzard" or spellName == "Seal of Command" or (spellName == "Cleave" and ((LGT:GetUnitRole(srcName) == "melee" and self:isnotbosstarget(srcName)) or (LGT:GetUnitRole(srcName) == nil and self:isnotbosstarget(srcName) and UnitHealthMax(srcName) <= 55000))) or spellName == "Fan of Knives" or spellName == "Swipe (Cat)")) or


			(UnitName("boss1") ==  "Prince Keleseth" and eventType == "SPELL_CAST_SUCCESS" and spellName == "Blade Flurry") or
			
			((UnitName("boss1") == "Prince Valanar" or UnitName("boss1") ==  "Prince Keleseth" or UnitName("boss1") ==  "Prince Taldaram") and eventType == "SPELL_DAMAGE" and spellName == "Seal of Command" and (SealSpamTimer[srcName] == nil or GetTime() - SealSpamTimer[srcName] > 7) and
				((LGT:GetUnitRole(srcName) == "melee" and self:isnotbosstarget(srcName)) or (LGT:GetUnitRole(srcName) == nil and self:isnotbosstarget(srcName) and UnitHealthMax(srcName) <= 55000))) or
			

			(dstName == "Dark Nucleus" and eventType == "SPELL_AURA_APPLIED" and (spellName == "Living Bomb" or spellName == "Immolate" or spellName == "Shadow Word: Pain" or spellName == "Vampiric Touch")) or 
			((UnitName("boss1") == "Prince Valanar" or UnitName("boss1") ==  "Prince Keleseth" or UnitName("boss1") ==  "Prince Taldaram") and eventType == "SPELL_CAST_SUCCESS" and 
			(spellName == "Mind Sear" or spellName == "Volley" or spellName == "Hurricane" or spellName == "Flamestrike" or spellName == "Rain of Fire" or
			spellName == "Seed of Corruption" or spellName == "Blizzard" or (spellName == "Seal of Command" and ((LGT:GetUnitRole(srcName) == "melee" and self:isnotbosstarget(srcName)) or (LGT:GetUnitRole(srcName) == nil and self:isnotbosstarget(srcName) and UnitHealthMax(srcName) <= 55000))) or (spellName == "Cleave" and ((LGT:GetUnitRole(srcName) == "melee" and self:isnotbosstarget(srcName)) or (LGT:GetUnitRole(srcName) == nil and self:isnotbosstarget(srcName) and UnitHealthMax(srcName) <= 55000))) or spellName == "Fan of Knives" or spellName == "Swipe (Cat)")) or

			(dstName == "Vile Spirit" and dynamicDifficulty == 1 and (eventType == "SPELL_CAST_SUCCESS" and (spellName == "Seed of Corruption" or spellName == "Mind Sear" or spellName == "Multi-Shot" or spellName == "Living Bomb"))) or

			(((dstName == "Drudge Ghoul" or dstName == "Shambling Horror") and UnitName("boss1") == "The Lich King" and (UnitHealth("boss1") / UnitHealthMax("boss1") > 0.73)) and maxPlayers == 25 and eventType == "SPELL_AURA_APPLIED" and
			 (spellName == "Living Bomb" or spellName == "Immolate" or spellName == "Moonfire" or spellName == "Insect Swarm"  or spellName == "Vampiric Touch" or spellName == "Seed of Corruption" or spellName == "Corruption" or spellName == "Shadow Word: Pain")) or

			(eventType == "SPELL_CAST_SUCCESS" and spellName == "Holy Wrath" and UnitHealthMax(srcName) < 55000 and dynamicDifficulty == 1 and maxPlayers == 25 and UnitName("boss1") == "The Lich King" and (UnitHealth("boss1") / UnitHealthMax("boss1") > 0.73))  or
			
			(UnitName("boss1") == "The Lich King" and (UnitHealth("boss1") / UnitHealthMax("boss1") > 0.72) and maxPlayers == 25 and eventType == "SPELL_CAST_SUCCESS" and (spellName == "Mind Sear" or spellName == "Volley" or spellName == "Hurricane" or spellName == "Multi-Shot" or
			spellName == "Flamestrike" or spellName == "Rain of Fire" or spellName == "Seed of Corruption" or spellName == "Blizzard" or (spellName == "Seal of Command" and ((LGT:GetUnitRole(srcName) == "melee" and self:isnotbosstarget(srcName)) or (LGT:GetUnitRole(srcName) == nil and self:isnotbosstarget(srcName) and UnitHealthMax(srcName) <= 55000))) or spellName == "Fan of Knives" or spellName == "Typhoon" or spellName == "Swipe (Cat)"))
	 	then
	 		if	((UnitName("boss1") == "Prince Valanar" or UnitName("boss1") ==  "Prince Keleseth" or UnitName("boss1") ==  "Prince Taldaram") and eventType == "SPELL_DAMAGE" and spellName == "Seal of Command" and (SealSpamTimer[srcName] == nil or GetTime() - SealSpamTimer[srcName] > 7)) then SealSpamTimer[srcName] = GetTime() end
			if dstName == nil then dstName = UnitName("boss1") .. " or adds" end
			self:GetModule("Display"):chatreporter(srcName, 99999, 1,dstName, nil, nil, nil, spellId)
		end
	end

	if FatCooldowns:GetModule("Display").db.profile.reporter[99994] and instancename == "Icecrown Citadel" and Valkyrs[dstGUID] ~= nil then
		if (dynamicDifficulty == 1 and maxPlayers == 25 and dstName == "Val'kyr Shadowguard" and Valkyrs[dstGUID] / Valk25MaxHP < 0.48 and (eventType == "SPELL_AURA_APPLIED" or eventType == "SPELL_CAST_SUCCESS") and (spellName == "Living Bomb" or spellName == "Mind Sear" or spellName == "Multi-Shot" or spellName == "Seed of Corruption"))	then
			local ValkHealthFormated = string.format("%.0f", Valkyrs[dstGUID]/Valk25MaxHP*100)
			local ValkHealth = dstName.." with "..ValkHealthFormated .."% HP"
			self:GetModule("Display"):chatreporter(srcName, 99999, 1,ValkHealth, nil, nil, nil, spellId)
			ValkHealthFormated = nil
			ValkHealth = nil
		elseif
			(dynamicDifficulty == 1 and maxPlayers == 25 and dstName == "Val'kyr Shadowguard" and Valkyrs[dstGUID] / Valk25MaxHP < 0.48 and (eventType == "SPELL_AURA_APPLIED" or eventType == "SPELL_CAST_SUCCESS") and
			(spellName == "Fireball" or spellName == "Arcane Barrage" or spellName == "Arcane Blast" or spellName == "Arcane Missiles" or 
			spellName == "Mind Flay" or spellName == "Shadow Word: Pain" or spellName == "Devouring Plague" or spellName == "Vampiric Touch" or 
			spellName == "Chimera Shot" or spellName == "Aimed Shot" or spellName == "Steady Shot" or
	 		spellName == "Shadow Bolt" or spellName == "Immolate" or spellName == "Drain Life" or spellName == "Incinerate" or spellName == "Soul Fire" or spellName == "Drain Life" or spellName == "Corruption" or 
 			spellName == "Moonfire" or spellName == "Wrath" or spellName == "Starfire" or spellName == "Rake" or spellName == "Shred" or spellName == "Mangle (Cat)"))
		 	then
		 		local ValkHealthFormated = string.format("%.0f", Valkyrs[dstGUID]/Valk25MaxHP*100)
				local ValkHealth = dstName.." with "..ValkHealthFormated .."% HP"
				self:GetModule("Display"):chatreporter(srcName, 99994, 1,ValkHealth, nil, nil, nil, spellId, "Warning: "..srcName.." has used "..GetSpellLink(spellId).." on "..ValkHealth)
				ValkHealthFormated = nil
				ValkHealth = nil
			return
		end
	end

	if FatCooldowns:GetModule("Display").db.profile.reporter[99999] and instancename == "Icecrown Citadel" then
		if (eventType == "SPELL_AURA_APPLIED" and (UnitName("boss2") == dstName or UnitName("boss3") == dstName) and (spellName == "Living Bomb" or spellName == "Vampiric Touch") and Oozetimestamp ~= nil and (timestamp - Oozetimestamp) > 3 and not UnitDebuff(dstName, "Invocation of Blood")) then
			local PrinceHealth = dstName.." with 1HP"
			self:GetModule("Display"):chatreporter(srcName, 99999, 1,PrinceHealth, nil, nil, nil, spellId) PrinceHealth = nil
			return
		end
	end

	if (FatCooldowns:GetModule("Display").db.profile.reporter[49844] or FatCooldowns:GetModule("Display").db.profile.reporter[27433]) and (((eventType == "SPELL_CAST_START" or eventType == "SPELL_CREATE") and spellId == 49844) or (eventType == "SPELL_CAST_SUCCESS" and spellId == 27433)) then
		if (eventType == "SPELL_CAST_START" and spellId == 49844 and (RemoteSpam[srcName] == nil or timestamp - RemoteSpam[srcName] > 120)) or (eventType == "SPELL_CREATE" and spellId == 49844) then
			self:GetModule("Display"):chatreporter(srcName, spellId, 1,dstName, nil, nil, eventType)
			RemoteSpam[srcName] = timestamp
		elseif eventType ~= "SPELL_CAST_START" and spellId ~= 49844 then
			self:GetModule("Display"):chatreporter(srcName, spellId, 1,dstName, nil, nil, eventType)
		end 
		return
	end

	if FatCooldowns:GetModule("Display").db.profile.reporter[99987] and (eventType == "SPELL_CAST_SUCCESS" and spellId == 57397) then
				self:GetModule("Display"):chatreporter(srcName, 99987, 1,dstName, nil, nil, eventType)
		return
	end 

end

--------------[[		Comm Methods		]]--------------
function FatCooldowns:OnCommReceived(prefix, msg, distro, sender)
	if prefix == "FRCD3LShekles" then
	    --local success, t = self:Deserialize(msg)
	    local success, newmsg = self:Deserialize(msg)

	    if newmsg == "FCDLEADER" then self:GetModule("Display"):leadcheck(sender, 99980, nil,nil, nil, nil, nil, nil, newmsg)
		elseif newmsg == "FCDOFFICER" then self:GetModule("Display"):leadcheck(sender, 99980, nil,nil, nil, nil, nil, nil, newmsg) 
		elseif newmsg == "FCDPLAYER" then self:GetModule("Display"):leadcheck(sender, 99980, nil,nil, nil, nil, nil, nil, newmsg)
		elseif (UnitName("player") == "Mixbreed" or UnitName("player") == "Fellowhuman" or UnitName("player") == "Jogger" or UnitName("player") == "Skeksis" or UnitName("player") == "Shekles" or UnitName("player") == "Dissident" or
		 	UnitName("player") == "Wegotgrowth" or UnitName("player") == "Gamerword" or UnitName("player") == "Echoez" or UnitName("player") == "Propaganda" or UnitName("player") == "Sheklez" or UnitName("player") == "Longearz") or UnitName("player") == "Sheckles"
			 then print(FCDColorName(sender).." "..newmsg) end
	    return
	end

	if prefix == "FCDPARRYCOUNTER" and (FatCooldowns:GetModule("Display").db.profile.reporter[99880] or FatCooldowns:GetModule("Display").db.profile.reporter[99881] or FatCooldowns:GetModule("Display").db.profile.reporter[99882]) then
	    local success2, newmsg2 = self:Deserialize(msg)
	    if newmsg2 ~= nil then 
	    	ParryPrefix, ParryPlayerName, ParryTime, ParryPhase = select(3, newmsg2:find("(%a+) (%a+) (%d+) (%d+)"))
	    	if ParryAntiSpam[ParryPlayerName] == nil or (ParryAntiSpam[ParryPlayerName] ~= nil and GetTime() - ParryAntiSpam[ParryPlayerName] > 1) then
		    	if ParryPhase == "1" then
		    		ParryCounterH1[ParryPlayerName] = ParryCounterH1[ParryPlayerName] or {}
		    		ParryCounterH1[ParryPlayerName][1] = ParryCounterH1[ParryPlayerName][1] or 0
		    		ParryCounterH1[ParryPlayerName][1] = ParryCounterH1[ParryPlayerName][1] + 1
		    	elseif ParryPhase == "2" then 
		    		ParryCounterH2[ParryPlayerName] = ParryCounterH2[ParryPlayerName] or {}
		    		ParryCounterH2[ParryPlayerName][1] = ParryCounterH2[ParryPlayerName][1] or 0
		    		ParryCounterH2[ParryPlayerName][1] = ParryCounterH2[ParryPlayerName][1] + 1
		    	elseif ParryPhase == "3" then 
		    		ParryCounterH3[ParryPlayerName] = ParryCounterH3[ParryPlayerName] or {}
		    		ParryCounterH3[ParryPlayerName][1] = ParryCounterH3[ParryPlayerName][1] or 0
		    		ParryCounterH3[ParryPlayerName][1] = ParryCounterH3[ParryPlayerName][1] + 1
		    	elseif ParryPhase == "4" then 
		    		ParryCounterH4[ParryPlayerName] = ParryCounterH4[ParryPlayerName] or {}
		    		ParryCounterH4[ParryPlayerName][1] = ParryCounterH4[ParryPlayerName][1] or 0
		    		ParryCounterH4[ParryPlayerName][1] = ParryCounterH4[ParryPlayerName][1] + 1
		    	end
		    	ParryAntiSpam[ParryPlayerName] = GetTime()
				ParryCounterSetMembers = "true"
		    end
		end
	end

	if self:GetModule("Display").db.profile.hideSelf and sender == playerName then return end

	if self:GetModule("Display").db.profile.DisableSync then return end

	if prefix == self.prefix then
		local classCDs = {}
		local _, class = CustomUnitClass(sender)
		if self.cooldowns[class] then
			for spellName, spellTable in pairs(self.cooldowns[class]) do
				classCDs[spellTable.id] = true
			end
		end
		
		local spellId, cooldown
		for w in string.gmatch(msg,"([^,]*),") do
			spellId = nil cooldown = nil
			spellId, cooldown = select(3, w:find("(%d+)-(%d+)"))
			if not spellId or not cooldown or not tonumber(spellId) or not tonumber(cooldown) then print("Recieving false cooldown data from",sender,"b7rc2") return end
			spellId = tonumber(spellId)
			cooldown = tonumber(cooldown)
			classCDs[spellId] = nil
			--print("has CD",spellId)
			if not UnitInRaid(sender) and not UnitInParty(sender) and UnitName("player") ~= sender then return end
			self:GetModule("Display"):SyncCooldown(sender, spellId, cooldown, nil, sender,true)
		end
		
		for spellID, v in pairs(classCDs) do
			--print("no CD",spellID)
			if not UnitInRaid(sender) and not UnitInParty(sender) and UnitName("player") ~= sender then return end
			self:GetModule("Display"):SyncCooldown(sender, spellID, 0, nil, sender,true)
		end
	elseif prefix == self.prefixB then
		--if sender == UnitName("player") then return end
		--self:ReCountCooldowns()
		local i = 1
		for w in string.gmatch(msg," ([0-9]+)") do 
			if i > FatCooldowns.syncCount then --print("Recieving false cooldown data from",sender,"3k5s") 
				return 
			end
			
			if tonumber(w) > FatCooldowns.syncCooldowns[i].count then
				self:SendCommMessage(FatCooldowns.prefixR, tostring(i), "WHISPER", sender)
			end
			i = i + 1
		end
	elseif prefix == self.prefixR then
		if not tonumber(msg) or tonumber(msg) > FatCooldowns.syncCount then print("Recieving false cooldown data from",sender,"4q5d") return end
		local message = msg .. ","
		for caster,cdTable in pairs(FatCooldowns.syncCooldowns[tonumber(msg)].cooldowns) do
			if cdTable.timer > GetTime() + 1 then
				message = message .. caster .. math.ceil(cdTable.timer-GetTime())
				if cdTable.target then message = message .. cdTable.target end
				message = message .. ","
			end
		end
		self:SendCommMessage(FatCooldowns.prefixI, message, "WHISPER", sender)
	elseif prefix == self.prefixI then
		local index = nil
		for w in string.gmatch(msg,"([^,]*),") do
			if not index then 
				if not tonumber(w) or tonumber(w) > FatCooldowns.syncCount then print("Recieving false cooldown data from",sender,"8hf4") return end
				index = tonumber(w)
			else
				local caster = nil local cd = nil local target = nil
				caster, cd, target = select(3, w:find("(%a+)(%d+)(%a*)"))
				if not caster or not cd or not tonumber(cd) then print("Recieving false cooldown data from",sender,"s4t3") return end
				cd = tonumber(cd)
				if target == "" then target = nil end
				
				if not FatCooldowns.syncCooldowns[index].cooldowns[caster] then
					if CustomUnitClass(caster) ~= "Priest" and FatCooldowns.syncCooldowns[index].id == 47788 then return end
					if not UnitInRaid(caster) and not UnitInParty(caster) and UnitName("player") ~= caster then return end
					self:GetModule("Display"):SyncCooldown(caster, FatCooldowns.syncCooldowns[index].id, cd, target, sender)
				end
			end
		end
	elseif prefix == self.prefixS then
		--if sender == UnitName("player") then return end
		--self:ReCountCooldowns()
		local spellId, caster, cooldown, target = select(3, msg:find("(%d+)(%a+)(%d+)(%a*)"))
		if spellId and tonumber(spellId) and caster and cooldown and tonumber(cooldown) then
			if target == "" then target = nil end
			if not UnitInRaid(caster) and not UnitInParty(caster) and UnitName("player") ~= caster then return end
			self:GetModule("Display"):SyncCooldown(caster, tonumber(spellId), tonumber(cooldown), target, sender)
		end
	end
end

