-- Got Class?
if not ( select(2,UnitClass("player")) == "SHAMAN" ) then return end
-- Yay!

Koko_TotemTimers = LibStub("AceAddon-3.0"):NewAddon("Koko_TotemTimers", "AceConsole-3.0", "AceEvent-3.0");

local versioninfo = GetAddOnMetadata("Koko_TotemTimers", "Version");

-- constants
local FIRE_TOTEM_SLOT = 1;
local EARTH_TOTEM_SLOT = 2;
local WATER_TOTEM_SLOT = 3;
local AIR_TOTEM_SLOT = 4;
local MAGMA_TICK = 5;
local TREMOR_TICK = 6;
local CLEANSE_TICK = 7;

local LOCATION = {
	"Totem bar", 
	"Tick bar", 
	"Disabled"
};

local TEXTURE_AMOUNT = 10;

local TEXTURES = {
	"",
	"Interface\\AddOns\\Koko_TotemTimers\\Textures\\default",
	"Interface\\AddOns\\Koko_TotemTimers\\Textures\\bantobar",
	"Interface\\AddOns\\Koko_TotemTimers\\Textures\\charcoal",
	"Interface\\AddOns\\Koko_TotemTimers\\Textures\\glaze",
	"Interface\\AddOns\\Koko_TotemTimers\\Textures\\otravi",
	"Interface\\AddOns\\Koko_TotemTimers\\Textures\\perl",
	"Interface\\AddOns\\Koko_TotemTimers\\Textures\\smooth",
	"Interface\\AddOns\\Koko_TotemTimers\\Textures\\smudge",
	"Interface\\AddOns\\Koko_TotemTimers\\Textures\\striped",
}
local TEXTURES_NAME = {
	"None",
	"Default",
	"Bantobar",
	"Charcoal",
	"Glaze",
	"Otravi",
	"Pearl",
	"Smooth",
	"Smudge",
	"Striped",
}

local TOTEMICRECALL = GetSpellInfo(36936)
local CLEANSE = GetSpellInfo(8170)
local TREMOR = GetSpellInfo(8143)
local MAGMA = GetSpellInfo(8190)

local totemname = {};

------------------------------
---- configuration values ----
------------------------------
local defaults = {
    profile = {
        TOTEM_TIMER_SCALE = 1,
		TOTEM_TIMER_TEXTURE = 2,
		TOTEM_TIMER_X = 200,
		TOTEM_TIMER_Y = 550,
		TOTEM_TIMER_WIDTH = 200,
		TOTEM_TICK_ENABLE = true,
		TOTEM_TICK_LOCATION = 2,
		TOTEM_TICK_SCALE = 1,
		TOTEM_TICK_TEXTURE = 2,
		TOTEM_TICK_X = 200,
		TOTEM_TICK_Y = 650,
		TOTEM_TICK_WIDTH = 150,
		TOTEM_DEATH_ANNOUNCE = false,
		KTT_ENABLED = true,
		KTT_ANCHOR = true,
		TREMOR_TICK = true,
		CLEANSE_TICK = true,
		MAGMA_TICK = false,
	},
}

local GTBLib, GTBTotem, GTBTick, GTBTickLoc;
local MAX_TOTEMS = 4;
local MAX_BARS = MAX_TOTEMS + 2;

local options = {
    name = "Koko Totem Timers",
    handler = Koko_TotemTimers,
    type = "group",
    args = {
		mydesc = {
			order = 1,
			type = "description",
			name = "A simple shaman totem timer mod inspired by GotWood.\n\nAlso includes a special 'Tick Bar' for Tremor/Cleansing/Magma totem ticks.\n",
		},
		globalopts = {
			order = 1,
			type = "group",
			name = "Global Options",
			args = {
				enable = {
					order = 1,
					type = "toggle",
					name = "Enable",
					desc = "Enable/disables KTT",
					set = function(info,val) Koko_TotemTimers:Enable(val) end,
					get = function(info) return Koko_TotemTimers.db.profile.KTT_ENABLED end
				},
				show_anchor = {
					order = 2,
					type = "toggle",
					name = "Anchor",
					desc = "Enable/disables anchors",
					set = function(info,val) Koko_TotemTimers:SetAnchor(val) end,
					get = "GetAnchor",
				},
				announce = {
					order = 3,
					type = "toggle",
					name = "Announce",
					desc = "Enable/disables totem death announcements",
					set = function(info,val) Koko_TotemTimers:Announce(val) end,
					get = function(info) return Koko_TotemTimers.db.profile.TOTEM_DEATH_ANNOUNCE end
				},
			},
		},
		config = {
            type = "group",
            name = "Bar options",
            desc = "Bar configuration options",
            args = {
				totemtimer = {
					type = "group",
					name = "Totem Bar",
					desc = "Totem timer configure options",
					args = {
						totscale = {
							type = "range",
							name = "Scale",
							desc = "Totem timer scale",
							min = 0.5,
							max = 2,
							step = 0.1,
							get = "GetTotScale",
							set = function(info, val) Koko_TotemTimers:SetTotScale(val) end,
						},
						totwidth = {
							type = "range",
							name = "Width",
							desc = "Totem timer width",
							min = 50,
							max = 1000,
							step = 10,
							get = "GetTotWidth",
							set = function(info, val) Koko_TotemTimers:SetTotWidth(val) end,
						},
						totbartexture = {
							type = "select",
							name = "Bar texture",
							desc = "Totem timer texture",
							values = TEXTURES_NAME,
							set = function(info, val) Koko_TotemTimers:SetTotTexture(val) end,
							get = "GetTotTexture",
						},
					},
				},
				ticktimer = {
					type = "group",
					name = "Totem Tick Bar",
					desc = "Totem timer configure options",
					args = {
						tickscale = {
							type = "range",
							name = "Scale",
							desc = "Totem tick scale",
							min = 0.5,
							max = 2,
							step = 0.1,
							get = "GetTickScale",
							set = function(info, val) Koko_TotemTimers:SetTickScale(val) end,
						},
						tickwidth = {
							type = "range",
							name = "Width",
							desc = "Totem tick width",
							min = 50,
							max = 1000,
							step = 10,
							get = "GetTickWidth",
							set = function(info, val) Koko_TotemTimers:SetTickWidth(val) end,
						},
						tickbartexture = {
							type = "select",
							name = "Bar texture",
							desc = "Totem tick texture",
							values = TEXTURES_NAME,
							set = function(info, val) Koko_TotemTimers:SetTickTexture(val) end,
							get = "GetTickTexture",
						},
						enable = {
							order = 1,
							type = "toggle",
							name = "Enable",
							desc = "Enable/disables tick bar",
							set = function(info,val) Koko_TotemTimers:EnableTick(val) end,
							get = function(info) return Koko_TotemTimers.db.profile.TOTEM_TICK_ENABLE end
						},
						magmaon = {
							order = 7,
							type = "toggle",
							name = "Magma",
							desc = "Enable magma tick",
							set = function(info,val) Koko_TotemTimers:TotTick(val, 1) end,
							get = function(info) return Koko_TotemTimers:TotTickReturn(1) end
						},
						cleanseon = {
							order = 8,
							type = "toggle",
							name = "Cleansing Totem",
							desc = "Enable/disables cleanse tick",
							set = function(info,val) Koko_TotemTimers:TotTick(val, 3) end,
							get = function(info) return Koko_TotemTimers:TotTickReturn(3) end
						},
						tremoron = {
							order = 9,
							type = "toggle",
							name = "Tremor Totem",
							desc = "Enable/disables tremor tick",
							set = function(info,val) Koko_TotemTimers:TotTick(val, 2) end,
							get = function(info) return Koko_TotemTimers:TotTickReturn(2) end
						},
					},
				},
			},
        },
		reset = {
            type = "execute",
			order = 3,
            name = "Reset",
            desc = "Resets settings back to the default values",
            func = "resetProf",
        },
		about = {
            type = "execute",
			order = 2,
            name = "About",
            desc = "Version info",
            func = "aboutM",
        },
    },
};

----------------------------------------------------
----		Configuration functions 			----
----------------------------------------------------
function Koko_TotemTimers:TotTick(val, totem)
	local enable = Koko_TotemTimers.db.profile.TOTEM_TICK_ENABLE
	
	--1 = magma, 2 = cleanse, 3 = tremor
	if totem == 1 then
		Koko_TotemTimers.db.profile.MAGMA_TICK = val;
	elseif totem == 2 then
		Koko_TotemTimers.db.profile.TREMOR_TICK = val;
	elseif totem == 3 then
		Koko_TotemTimers.db.profile.CLEANSE_TICK = val;
	end
	-- create tick bar if needed
	if enable then Koko_TotemTimers:DoTotemTick(val, totem) end
end

function Koko_TotemTimers:TotTickReturn(totem)
	--1 = magma, 2 = cleanse, 3 = tremor
	if totem == 1 then
		return Koko_TotemTimers.db.profile.MAGMA_TICK;
	elseif totem == 2 then
		return Koko_TotemTimers.db.profile.TREMOR_TICK;
	elseif totem == 3 then
		return Koko_TotemTimers.db.profile.CLEANSE_TICK;
	end
end


function Koko_TotemTimers:GetTotScale()
	return self.db.profile.TOTEM_TIMER_SCALE
end

function Koko_TotemTimers:SetTotScale(val)
	self.db.profile.TOTEM_TIMER_SCALE = val
	GTBTotem:SetScale(self.db.profile.TOTEM_TIMER_SCALE);
end

function Koko_TotemTimers:GetTotWidth()
	return self.db.profile.TOTEM_TIMER_WIDTH
end
function Koko_TotemTimers:SetTotWidth(val)
	self.db.profile.TOTEM_TIMER_WIDTH = val
	GTBTotem:SetWidth(self.db.profile.TOTEM_TIMER_WIDTH);
end

function Koko_TotemTimers:GetTotTexture()
	return self.db.profile.TOTEM_TIMER_TEXTURE;
end

function Koko_TotemTimers:SetTotTexture(val)
	GTBTotem:SetTexture(TEXTURES[val]);
	self.db.profile.TOTEM_TIMER_TEXTURE = val;
end

function Koko_TotemTimers:GetTickScale()
	return self.db.profile.TOTEM_TICK_SCALE
end

function Koko_TotemTimers:SetTickScale(val)
	self.db.profile.TOTEM_TICK_SCALE = val
	GTBTick:SetScale(self.db.profile.TOTEM_TICK_SCALE);
end

function Koko_TotemTimers:GetTickWidth()
	return self.db.profile.TOTEM_TICK_WIDTH
end
function Koko_TotemTimers:SetTickWidth(val)
	self.db.profile.TOTEM_TICK_WIDTH = val
	GTBTick:SetWidth(self.db.profile.TOTEM_TICK_WIDTH);
end

function Koko_TotemTimers:GetTickTexture()
	return self.db.profile.TOTEM_TICK_TEXTURE;
end

function Koko_TotemTimers:SetTickTexture(val)
	GTBTickLoc:SetTexture(TEXTURES[val]);
	self.db.profile.TOTEM_TICK_TEXTURE = val;
end

function Koko_TotemTimers:SetAnchor(val)
	GTBTotem:SetAnchorVisible(val);
	GTBTick:SetAnchorVisible(val);
	GTBTickLoc:SetAnchorVisible(val);
	self.db.profile.KTT_ANCHOR = val;
end

function Koko_TotemTimers:GetAnchor()
	return self.db.profile.KTT_ANCHOR
end

function Koko_TotemTimers:resetProf()
	self.db:ResetDB();
	self:TotemInit();
	self:SetAnchor(self:GetAnchor());
end

function Koko_TotemTimers:Announce(val)
	self.db.profile.TOTEM_DEATH_ANNOUNCE = val;
end

function Koko_TotemTimers:NYI()
	self:Print("Not yet implemented");
end

----------------------------------------------------
----------------------------------------------------

function Koko_TotemTimers:aboutM()
	Koko_TotemTimers:Print("Version " .. versioninfo .." created by Kokomala, Silver Hand. Moo");
end

function Koko_TotemTimers:OnInitialize()
    	-- Called when the addon is loaded
	self.db = LibStub("AceDB-3.0"):New("Koko_TotemTimersDB", defaults, "Default")
	LibStub("AceConfig-3.0"):RegisterOptionsTable("Koko_TotemTimers", options);
	self.optionsFrame = LibStub("AceConfigDialog-3.0"):AddToBlizOptions("Koko_TotemTimers", "Koko Totem Timers")
	self:RegisterChatCommand("ktt", "ChatCommand")

	-- LDB launcher
	LibStub:GetLibrary("LibDataBroker-1.1"):NewDataObject("Koko_TotemTimers", {
		type = "launcher",
		icon = "Interface\\Icons\\Spell_Nature_TremorTotem.blp",
		text = "Koko Totem Timers",
		OnClick = function(clickedframe, button)
				if InterfaceOptionsFrame:IsVisible() then
					InterfaceOptionsFrame:Hide()
				else
					InterfaceOptionsFrame_OpenToCategory("Koko Totem Timers")
				end
			end,
		OnLeave = function() return GameTooltip:Hide() end,
		OnEnter = function(self) 
			local frame = self
			local showBelow = select( 2, self:GetCenter() ) > UIParent:GetHeight() / 2
			GameTooltip:SetOwner( self, "ANCHOR_NONE" )
			GameTooltip:SetPoint( showBelow and "TOP" or "BOTTOM", self, showBelow and "BOTTOM" or "TOP" )
			GameTooltip:AddLine( "Click to show/hide options." )
			return GameTooltip:Show()
		end,
	})
end

function Koko_TotemTimers:ChatCommand(input)
	if not input or input:trim() == "" then
        InterfaceOptionsFrame_OpenToCategory(self.optionsFrame)
    else
        LibStub("AceConfigCmd-3.0").HandleCommand(Koko_TotemTimers, "ktt", input)
    end

end

function Koko_TotemTimers:OnEnable()
	-- Called when the addon is enabled
	local val = self.db.profile.KTT_ENABLED;
	
	self:Enable(val);
end

function Koko_TotemTimers:OnDisable()
    -- Called when the addon is disabled
	self:Enable(false);
end

function Koko_TotemTimers:Enable(val)
	self.db.profile.KTT_ENABLED = val;

	if val then
		self:RegisterEvent("PLAYER_TOTEM_UPDATE");
		self:RegisterEvent("UNIT_SPELLCAST_SUCCEEDED");
		self:RegisterEvent("PLAYER_ENTERING_WORLD");
		
		self:TotemInit();
		
		for i = 1, MAX_TOTEMS do
			totemname[i] = "";
		end
		
		self:LoadTotems();
		self:Print("Koko Totem Timers enabled. Type /ktt for options.");
	elseif not val then
			-- Unregister events
		self:UnregisterEvent("PLAYER_TOTEM_UPDATE");
		self:UnregisterEvent("UNIT_SPELLCAST_SUCCEEDED");
		self:UnregisterEvent("PLAYER_ENTERING_WORLD");
	
		-- Unregister bars and groups
		if GTBTotem then
			GTBTotem:SetAnchorVisible(false);
			GTBTotem:UnregisterAllBars(i);
		end
		
		if GTBTick then
			GTBTick:SetAnchorVisible(false);
			GTBTick:UnregisterAllBars();
		end
		
		if GTBTickLoc then
			GTBTickLoc:SetAnchorVisible(false);
			GTBTickLoc:UnregisterAllBars();
		end
				
		self:Print("Koko Totem Timers disabled.");
	end
end

function Koko_TotemTimers:EnableTick(val)
	local tremen, cleanen, magen = self:TotTickReturn(3), self:TotTickReturn(2), self:TotTickReturn(1)
	self.db.profile.TOTEM_TICK_ENABLE = val;
	
	if not val then
		-- destroy tick bars
		GTBTickLoc:UnregisterAllBars();
		GTBTickLoc:SetAnchorVisible(false);
	elseif val then
		if ((totemname[EARTH_TOTEM_SLOT] == TREMOR) and tremen ) then
			self:DoTotemTick(val, EARTH_TOTEM_SLOT);
		end
		if ((totemname[WATER_TOTEM_SLOT] == CLEANSE) and cleanen ) then
			self:DoTotemTick(val, WATER_TOTEM_SLOT);
		end
		if (strfind(totemname[FIRE_TOTEM_SLOT], MAGMA) and magen ) then
			self:DoTotemTick(val, FIRE_TOTEM_SLOT);
		end
	end
end

function Koko_TotemTimers:DoTotemTick(val, index)
	if val then
		local haveTotem, name, startTime, duration, icon = GetTotemInfo(index);
		local est_dur = startTime + duration - GetTime();
		self:FancyTickBarCode(name, est_dur, icon);
	else
		-- disable bar
		GTBTickLoc:UnregisterBar(MAX_TOTEMS + index);
	end
end
	
function Koko_TotemTimers:PLAYER_TOTEM_UPDATE()
	local slot = arg1;
	local haveTotem, name, startTime, duration, icon = GetTotemInfo(slot);
	--ticks enabled
	local tickenable = self.db.profile.TOTEM_TICK_ENABLE
	local toten, cleanen, magen = self:TotTickReturn(3), self:TotTickReturn(2), self:TotTickReturn(1)

	if (duration > 0 ) then
		if tickenable then
			if ((name == TREMOR) and ( toten == true)) then
				GTBTickLoc:RegisterBar(TREMOR_TICK, "Tremor Tick", 3, 3, icon);
				GTBTickLoc:SetRepeatingTimer(TREMOR_TICK, true)
			elseif (slot == 2) then
					GTBTickLoc:UnregisterBar(TREMOR_TICK);
			end
			
			if ((name == CLEANSE) and (cleanen == true)) then
				GTBTickLoc:RegisterBar(CLEANSE_TICK, "Cleanse Tick", 3, 3, icon);
				GTBTickLoc:SetRepeatingTimer(CLEANSE_TICK, true)
			elseif (slot == 3) then
				GTBTickLoc:UnregisterBar(CLEANSE_TICK);
			end
			
			if (strfind(name, MAGMA) and (magen == true))  then
				GTBTickLoc:RegisterBar(MAGMA_TICK, "Magma Tick", 2, 2, icon);
				GTBTickLoc:SetRepeatingTimer(MAGMA_TICK, true)
			elseif (slot == 1) then
				GTBTickLoc:UnregisterBar(MAGMA_TICK);
			end
		end
		
		-- Assume totem was dropped
		GTBTotem:RegisterBar(slot, name, duration, duration, icon);
			
		totemname[slot] = name;
	else
		-- Assume totem expired or destroyed
		GTBTotem:UnregisterBar(slot);
		
		if self.db.profile.TOTEM_TICK_ENABLE then
			if (slot == EARTH_TOTEM_SLOT) then
				GTBTickLoc:UnregisterBar(TREMOR_TICK);
			elseif (slot == WATER_TOTEM_SLOT) then
				GTBTickLoc:UnregisterBar(CLEANSE_TICK);
			elseif (slot == FIRE_TOTEM_SLOT) then
				GTBTickLoc:UnregisterBar(MAGMA_TICK);
			end
			
			if self.db.profile.TOTEM_DEATH_ANNOUNCE and not ( totemname[slot] == "" )then
					
				local n = GetNumPartyMembers();
			
				if n == 0 then
					print(totemname[slot] .. " Destroyed");
				elseif n > 0 then
					SendChatMessage(totemname[slot] .. " Destroyed." ,"PARTY");
				end
			end
		end
		
		totemname[slot] = "";
	end;
end

function Koko_TotemTimers:PLAYER_ENTERING_WORLD()
		if self.db.profile.KTT_ENABLED then
			self:LoadTotems()
		end
end

function Koko_TotemTimers:UNIT_SPELLCAST_SUCCEEDED()
	if (arg2 == TOTEMICRECALL) then
		if arg1 == "player" then
			for i =1, MAX_TOTEMS do
				totemname[i] = "";
			end
		end
	end
end

function Koko_TotemTimers:LoadTotems()
	-- funky code to display totem durations from a reloadui/relog/enable. Woo!!
	for i = 1, MAX_TOTEMS do
		local haveTotem, name, startTime, duration, icon = GetTotemInfo(i);
		
		totemname[i] = name;
		
		if duration > 0 then
			local est_dur = startTime + duration - GetTime();
				
			GTBTotem:RegisterBar(i, name, est_dur, duration, icon);
	
			-- fancy tick bar code to get them up and running and accurate.
			self:FancyTickBarCode(name, est_dur, icon);
		else
			-- Assume totem expired or destroyed
			GTBTotem:UnregisterBar(i);
			
			if (i == EARTH_TOTEM_SLOT) then
				GTBTickLoc:UnregisterBar(TREMOR_TICK);
			elseif (i == WATER_TOTEM_SLOT) then
				GTBTickLoc:UnregisterBar(CLEANSE_TICK);
			elseif (i == FIRE_TOTEM_SLOT) then
				GTBTickLoc:UnregisterBar(MAGMA_TICK);
			end
		end
	end
end

function Koko_TotemTimers:FancyTickBarCode(name, est_dur, icon)
	-- funky code to get the tick bars working and accurate. Woo!!
	-- assume ticks are enabled.
	if (name == "Tremor Totem") then
		time_left = est_dur/3 - floor(est_dur/3);
		GTBTickLoc:RegisterBar(TREMOR_TICK, "Tremor Tick", time_left, 3, icon);
		GTBTickLoc:SetRepeatingTimer(TREMOR_TICK, true);
	elseif (name == "Cleansing Totem") then
		time_left = est_dur/3 - floor(est_dur/3);
		GTBTickLoc:RegisterBar(CLEANSE_TICK, "Cleanse Tick", time_left, 3, icon);
		GTBTickLoc:SetRepeatingTimer(CLEANSE_TICK, true);
	elseif strfind(name, "Magma Totem") then
		time_left = est_dur/2 - floor(est_dur/2);
		GTBTickLoc:RegisterBar(MAGMA_TICK, "Magma Tick", time_left, 2, icon);
		GTBTickLoc:SetRepeatingTimer(MAGMA_TICK, true);
	end
end

function Koko_TotemTimers:TotemInit()
		-- initialize totem timer group and load GTB
	if not GTBLib then
		GTBLib = LibStub:GetLibrary("GTB-1.0");
	end
		
	if not GTBTotem then
		GTBTotem = GTBLib:RegisterGroup("Totems", "");

		GTBTotem:RegisterOnMove(self, "OnTotemBarMove");
		GTBTotem:RegisterOnFade(self, "OnTotemBarFade");
	end
	
	if not GTBTick then
		GTBTick = GTBLib:RegisterGroup("Tick", "");
		
		GTBTick:RegisterOnMove(self, "OnTickBarMove");
		GTBTick:RegisterOnFade(self, "OnTickBarFade");
	end
	
	achor = self:GetAnchor();
	
		-- load totem bar
	GTBTotem:SetDisplayGroup("Totems");
	GTBTotem:SetPoint("TOPLEFT", "UIParent", "BOTTOMLEFT", self.db.profile.TOTEM_TIMER_X, self.db.profile.TOTEM_TIMER_Y);
	GTBTotem:SetAnchorVisible(anchor);
	GTBTotem:SetBarGrowth("DOWN");
	GTBTotem:SetMaxBars(MAX_BARS);
	GTBTotem:SetIconPosition("LEFT");
	
	self:SetTotScale(self:GetTotScale());
	self:SetTotWidth(self:GetTotWidth());
	self:SetTotTexture(self:GetTotTexture());
	
		-- load tick bar
	GTBTick:SetDisplayGroup(self.db.profile.TOTEM_TICK_LOC);
	GTBTick:SetPoint("TOPLEFT", "UIParent", "BOTTOMLEFT", self.db.profile.TOTEM_TICK_X, self.db.profile.TOTEM_TICK_Y);
	GTBTick:SetAnchorVisible(anchor);
	GTBTick:SetBarGrowth("DOWN");
	GTBTick:SetMaxBars(MAX_BARS);
	GTBTick:SetIconPosition("LEFT");
	
		-- set tick location
	if self.db.profile.TOTEM_TICK_LOCATION == 1 then
		GTBTickLoc = GTBTotem;
	elseif self.db.profile.TOTEM_TICK_LOCATION == 2 then
		GTBTickLoc = GTBTick;
	else
		GTBTickLoc = GTBTick;
		GTBTickLoc:SetAnchorVisible(anchor);
	end
		
		-- finish tick bar loading
	self:SetTickScale(self:GetTickScale());
	self:SetTickWidth(self:GetTickWidth());
	self:SetTickTexture(self:GetTickTexture());
	
end

function Koko_TotemTimers:OnTotemBarMove(parent, x, y)
	--self.Print(x .. ", " .. y);
	self.db.profile.TOTEM_TIMER_X = x;
	self.db.profile.TOTEM_TIMER_Y = y;

end

function Koko_TotemTimers:OnTotemBarFade(parent, x, y)

end

function Koko_TotemTimers:OnTickBarMove(parent, x, y)
	--self.Print(x .. ", " .. y);
	self.db.profile.TOTEM_TICK_X = x;
	self.db.profile.TOTEM_TICK_Y = y;

end

function Koko_TotemTimers:OnTickBarFade(parent, x, y)

end
