﻿
local L, locale = OVERACHIEVER_STRINGS, GetLocale()

L.SEARCH_TAB = "Search";
L.SEARCH_HELP = "Use this tab to search for achievements. You can also search for achievements by name or ID using slash commands. See Overachiever's readme.txt file for details.";
L.SEARCH_NAME = "Name:";
L.SEARCH_DESC = "Description:";
L.SEARCH_CRITERIA = "Criteria:";
L.SEARCH_REWARD = "Reward:";
L.SEARCH_ANY = "Any of the above:";
L.SEARCH_FULLLIST = "Search all achievements";
L.SEARCH_FULLLIST_TIP = "Include in the search achievements that aren't normally listed in the default UI, such as those exclusive to the opposing faction, unacquired Feats of Strength, etc.";
L.SEARCH_SUBMIT = "Search";
L.SEARCH_RESET = "Reset";
L.SEARCH_RESULTS = "Found %s |4achievement:achievements;.";

L.SUGGESTIONS_TAB = "Suggestions";
L.SUGGESTIONS_HELP = "Suggested achievements are listed here based on your current location. Also listed are any achievements you were reminded about through a tooltip within the last 2 minutes or that have a timer which started recently.";
L.SUGGESTIONS_REFRESH = "Refresh";
L.SUGGESTIONS_EMPTY = "Overachiever has no suggestions for you at this time.";
L.SUGGESTIONS_RESULTS = "%d |4suggestion:suggestions; found.";
L.SUGGESTIONS_RESULTS_TRADESKILL = "%s: %d |4suggestion:suggestions; found.";
L.SUGGESTIONS_EMPTY_TRADESKILL = "%s: Overachiever has no suggestions for you at this time.";
L.SUGGESTIONS_LOCATION = "Location:"
L.SUGGESTIONS_LOCATION_TIP = "Override Zone/Instance Location"
L.SUGGESTIONS_LOCATION_TIP2 = "Leave blank to get suggestions for your current location or start typing to get a matching valid zone or instance name to use instead. Press |cffffffffTab|r to cycle between locations that match the text to the left of the cursor. |cffffffffShift+Tab|r cycles in reverse order. If the cursor is at the leftmost position, it cycles between all valid locations."
L.SUGGESTIONS_LOCATION_SUBZONE = "Subzone:"
L.SUGGESTIONS_LOCATION_NOSUBZONE = "(unspecified)"

L.WATCH_TAB = "Watch";
L.WATCH_HELP = "Create your watch list by |cffffffffalt+clicking|r on achievements in the other tabs or achievement chat links. |cffffffffAlt+click|r on one displayed here to stop watching it.";
L.WATCH_EMPTY = "Your watch list is empty. Alt+click on an achievement in another tab or an achievement's chat link to watch it.";
L.WATCH_EMPTY_SHORT = "Empty List";
L.WATCH_DISPLAYEDLIST = "Displayed List:";
L.WATCH_DEFAULTLIST = "Default List:";
L.WATCH_DEFAULTLIST_TIP = "The specified list will be the Displayed List at the beginning of each session.";
L.WATCH_COPY = "Copy to List:";
L.WATCH_COPY_TIP = "When enabled, if you |cffffffffshift+alt+click|r on an achievement on this tab, it will be added to the specified watch list.";
L.WATCH_LIST_GLOBAL = "Global";
L.WATCH_LIST_PERCHAR = "Character-specific";
L.WATCH_NEW = "New";
L.WATCH_DELETE = "Delete";
L.WATCH_CLEAR = "Clear";
L.WATCH_COPY = "Copy To:";
L.WATCH_POPUP_NEWLIST = "Enter the name of your new achievement watch list:";
L.WATCH_POPUP_DELETELIST = "Are you sure you want to permanently delete the current achievement watch list?";
L.WATCH_POPUP_CLEARLIST = "Are you sure you want to clear the contents of the current achievement watch list?";

L.TAB_SORT = "Sort by:";
L.TAB_SORT_NAME = "Name";
L.TAB_SORT_ID = "ID";
L.TAB_SORT_POINTS = "Point value";
L.TAB_SORT_COMPLETE = "Date completed";
L.TAB_HELP = "|cffffffffCtrl-click|r on an achievement to jump to its place in the standard UI.|n|nA |cffffffffblue background|r means it is part of a series for which you haven't completed an earlier step.|n|nA |cffffffffred background|r means it cannot be found in the standard UI for this character because it is exclusive to the opposing faction or is an unacquired Feat of Strength.|n|nA |cffffffffgreen background|r means a reminder about this achievement was displayed in a tooltip recently or it has a timer which started recently.";

if (locale == "deDE") then  -- German
L["SEARCH_ANY"] = "In allen suchen"
L["SEARCH_CRITERIA"] = "Kriterium:"
L["SEARCH_DESC"] = "Beschreibung:"
L["SEARCH_FULLLIST"] = "Alle Erfolge durchsuchen"
L["SEARCH_FULLLIST_TIP"] = "Auch in Achievements suchen, die normal nicht aufgelistet werden. Wie zB welche der gegnerischen Fraktion, unerreichte Heldentaten, usw."
L["SEARCH_HELP"] = "Nutze diese Seite um nach Achievements zu suchen. Per Slash-Command kannst du auch nach Achievement-Name oder ID suchen. Lies die readme.txt für weitere Details."
L["SEARCH_NAME"] = "Name:"
L["SEARCH_RESET"] = "Zurücksetzen"
L["SEARCH_RESULTS"] = "%s |4Achievement:Achievements; gefunden."
L["SEARCH_REWARD"] = "Belohnung:"
L["SEARCH_SUBMIT"] = "Suchen"
L["SEARCH_TAB"] = "Suche"
L["SUGGESTIONS_EMPTY"] = "Overachiever hat zur Zeit keine Vorschläge für dich."
L["SUGGESTIONS_EMPTY_TRADESKILL"] = "%s: Overachiever hat zur Zeit keine Vorschläge für dich."
L["SUGGESTIONS_HELP"] = "Hier werden Achievements aufgelistet, die du in deiner aktuellen Zone abschließen kannst. Es werden auch alle Achievemts aufgelistet an die du in den letzen 2 Minuten per Tooltip erinnert wurdest."
L["SUGGESTIONS_LOCATION"] = "Standort:"
L["SUGGESTIONS_LOCATION_NOSUBZONE"] = "(nicht spezifiziert)"
L["SUGGESTIONS_LOCATION_SUBZONE"] = "Subzone:"
L["SUGGESTIONS_LOCATION_TIP"] = "Gebiete-/Instanzen-Standorte übergehen"
L["SUGGESTIONS_LOCATION_TIP2"] = [=[Leer lassen, um Vorschläge für deinen aktuellen Standort zu erhalten. Oder beginne zu Tippen, um ein passendes, gültiges Gebiet oder Instanz zu erhalten, die stattdessen verwendet werden kann. Drücke |cffffffffTab|r , um zwischen Standorten zu wechseln, die zum Text links vom Cursor passen. Drücke |cffffffffSHIFT+Tab|r , um in entgegengesetzter Reihenfolge zu wechseln. Wenn der Cursor sich ganz links befindet, wird zwischen allen gültigen Standorten gewechselt.

Tabs]=]
L["SUGGESTIONS_REFRESH"] = "Aktualisieren"
L["SUGGESTIONS_RESULTS"] = "%d |4Vorschlag:Vorschläge; gefunden."
L["SUGGESTIONS_RESULTS_TRADESKILL"] = "%s: %d |4Vorschlag:Vorschläge; gefunden."
L["SUGGESTIONS_TAB"] = "Vorschläge"
L["TAB_HELP"] = "|cffffffffCtrl-klick|r auf ein Achievement um es in der Standard UI anzuzeigen.|n|nEin |cffffffffblauer Hintergrund|r bedeutet das Achievement ist Teil einer Serie, bei welcher dir noch ein vorheriger Schritt fehlt.|n|nEin |cffffffffroter Hintergrund|r bedeutet das Achievement kann nicht im Standard UI gefunden werden, weil es nur von der Gegnerischen Fraktion erlangt werden kann oder eine unerreichtes Heldtentat ist.|n|nEin |cffffffffgüner Hintergrund|r zeigt an, daß du kürzlich im Tooltip an dieses Achievement erinnert wurdest."
L["TAB_SORT"] = "Sortieren nach:"
L["TAB_SORT_COMPLETE"] = "Abgeschlossen am"
L["TAB_SORT_ID"] = "ID"
L["TAB_SORT_NAME"] = "Name"
L["TAB_SORT_POINTS"] = "Punktwert"
-- L["WATCH_CLEAR"] = ""
-- L["WATCH_COPY"] = ""
-- L["WATCH_COPY_TIP"] = ""
-- L["WATCH_DEFAULTLIST"] = ""
-- L["WATCH_DEFAULTLIST_TIP"] = ""
-- L["WATCH_DELETE"] = ""
-- L["WATCH_DISPLAYEDLIST"] = ""
L["WATCH_EMPTY"] = "Deine Beobachtungsliste ist leer. Alt+Klick auf ein Achievement in einem anderen Tab oder einem Chat-Link um es zu beobachten."
-- L["WATCH_EMPTY_SHORT"] = ""
L["WATCH_HELP"] = "Erstelle deine Beobachtungsliste mittels |cffffffffAlt+Klick|r auf Achievements in den anderen Tabs. |cffffffffAlt+Klick|r auf ein hier angezeigtes um es von der Liste zu nehmen."
-- L["WATCH_LIST_GLOBAL"] = ""
-- L["WATCH_LIST_PERCHAR"] = ""
-- L["WATCH_NEW"] = ""
-- L["WATCH_POPUP_CLEARLIST"] = ""
-- L["WATCH_POPUP_DELETELIST"] = ""
-- L["WATCH_POPUP_NEWLIST"] = ""
L["WATCH_TAB"] = "Beobachten"
L.SUBZONES = {
	-- ["Argent Pavilion"] = "",
	-- ["Argent Tournament Grounds"] = "",
	["Formation Grounds"] = "Gestaltungsgelände",
	-- ["Razorscale's Aerie"] = "",
	-- ["Silver Covenant Pavilion"] = "",
	-- ["Sunreaver Pavilion"] = "",
	-- ["The Alliance Valiants' Ring"] = "",
	-- ["The Argent Valiants' Ring"] = "",
	-- ["The Aspirants' Ring"] = "",
	["The Assembly of Iron"] = "Die Versammlung des Eisens",
	["The Celestial Planetarium"] = "Das himmlische Planetarium",
	["The Clash of Thunder"] = "Der Donnerschlag",
	["The Colossal Forge"] = "Kolossale Schmiede",
	["The Conservatory of Life"] = "Das Konservatorium des Lebens",
	["The Descent into Madness"] = "Der Abstieg in den Wahnsinn",
	["The Halls of Winter"] = "Hallen des Winters",
	-- ["The Horde Valiants' Ring"] = "",
	-- ["The Observation Ring"] = "",
	["The Prison of Yogg-Saron"] = "Das Gefängnis von Yogg-Saron",
	-- ["The Ring of Champions"] = "",
	["The Scrapyard"] = "Der Schrottplatz",
	["The Shattered Walkway"] = "Der zerschmetterte Gang",
	["The Spark of Imagination"] = "Der Funke der Imagination",
}


elseif (locale == "frFR") then  -- French
L["SEARCH_ANY"] = "Tout ce qui précède :"
L["SEARCH_CRITERIA"] = "Critère :"
L["SEARCH_DESC"] = "Description :"
L["SEARCH_FULLLIST"] = "Chercher dans tous les Hauts faits"
L["SEARCH_FULLLIST_TIP"] = "Inclut dans la recherche les hauts faits qui ne sont pas normalement affichés dans l'IU par défaut, comme ceux de la faction adverse, les Tours de force non accomplis, etc."
L["SEARCH_HELP"] = "Utilisez cet onglet pour chercher des hauts faits. Vous pouvez également rechercher des hauts faits par nom ou par ID en utilisant les commandes \"slash\". Référez-vous au fichier readme.txt d'Overachiever pour les détails."
L["SEARCH_NAME"] = "Nom :"
L["SEARCH_RESET"] = "Réinitialiser"
L["SEARCH_RESULTS"] = "%s |4haut fait trouvé:hauts faits trouvés;."
L["SEARCH_REWARD"] = "Récompense :"
L["SEARCH_SUBMIT"] = "Chercher"
L["SEARCH_TAB"] = "Recherches"
L["SUGGESTIONS_EMPTY"] = "Overachiever n'a aucune suggestion pour le moment"
L["SUGGESTIONS_EMPTY_TRADESKILL"] = " %s: Overachiever n'a aucune suggestion à faire pour le moment."
L["SUGGESTIONS_HELP"] = "Les hauts faits suggérés sont affichés ici en fonction de votre localisation. Sont également listés tous les hauts faits qui vous ont été rappelés par une infobulle dans les 2 dernières minutes ou qui ont une alarme qui s'est déclenchée récemment."
L["SUGGESTIONS_LOCATION"] = "Emplacement :"
L["SUGGESTIONS_LOCATION_NOSUBZONE"] = "(indéterminé)"
L["SUGGESTIONS_LOCATION_SUBZONE"] = "Sous-zone :"
L["SUGGESTIONS_LOCATION_TIP"] = "Ne pas tenir compte de l'emplacement de la zone/instance"
L["SUGGESTIONS_LOCATION_TIP2"] = "Laissez vierge pour obtenir les suggestions relatives à votre position actuelle ou entrez les premiers caractères pour obtenir un nom de zone ou d'instance valide. Appuez sur |cffffffffTab|r pour faire défiler les noms de lieux correspondants au texte entré à gauche du curseur. |cffffffffShift+Tab|r fait défiler les noms dans l'ordre inverse. Si le curseur est à l'extrême gauche, tous les lieux possibles défilent."
L["SUGGESTIONS_REFRESH"] = "Rafraîchir"
L["SUGGESTIONS_RESULTS"] = "%d |4suggestion trouvée:suggestions trouvées;."
L["SUGGESTIONS_RESULTS_TRADESKILL"] = " %s: %d |4suggestion trouvée:suggestions trouvées;."
L["SUGGESTIONS_TAB"] = "Suggestions"
L["TAB_HELP"] = "|cffffffffCtrl-click|r sur un haut fait pour l'afficher dans l'IU standard.|n|nUn |cfffffffffond bleu|r signifie qu'il fait partie d'une série dont vous n'avez pas encore effectué une étape précédente.|n|nUn |cfffffffffond rouge|r signifie qu'il ne peut pas être trouvé dans l'IU standard de ce personnage car il est propre à la faction adverse ou bien il s'agit d'un Tour de force non accompli.|n|nA |cfffffffffond vert|r signifie qu'un rappel pour ce haut fait a été affiché récemment dans une infobulle ou qu'il possède une alarme qui s'est déclenchée il y a peu."
L["TAB_SORT"] = "Trier par :"
L["TAB_SORT_COMPLETE"] = "Date d'accomplissement"
L["TAB_SORT_ID"] = "ID"
L["TAB_SORT_NAME"] = "Nom"
L["TAB_SORT_POINTS"] = "Valeur en point"
-- L["WATCH_CLEAR"] = ""
-- L["WATCH_COPY"] = ""
-- L["WATCH_COPY_TIP"] = ""
-- L["WATCH_DEFAULTLIST"] = ""
-- L["WATCH_DEFAULTLIST_TIP"] = ""
-- L["WATCH_DELETE"] = ""
-- L["WATCH_DISPLAYEDLIST"] = ""
L["WATCH_EMPTY"] = "Votre liste de suivi est vide. Vous pouvez faire Alt+click sur un haut fait dans un autre onglet ou sur un lien de haut fait dans la fenêtre de discussion pour l'afficher."
-- L["WATCH_EMPTY_SHORT"] = ""
L["WATCH_HELP"] = "Vous pouvez créer votre liste de suivi avec un |cffffffffalt+click|r sur un haut fait dans un autre onglet ou sur un lien de haut fait dans la fenêtre de discussion. Avec un |cffffffffAlt+click|r sur un haut fait affiché ici, vous arrêtez le suivi."
-- L["WATCH_LIST_GLOBAL"] = ""
-- L["WATCH_LIST_PERCHAR"] = ""
-- L["WATCH_NEW"] = ""
-- L["WATCH_POPUP_CLEARLIST"] = ""
-- L["WATCH_POPUP_DELETELIST"] = ""
-- L["WATCH_POPUP_NEWLIST"] = ""
L["WATCH_TAB"] = "Suivi"
L.SUBZONES = {
	["Argent Pavilion"] = "Pavillon d'Argent",
	["Argent Tournament Grounds"] = "Enceinte du tournoi d'Argent",
	["Formation Grounds"] = "Champs d'entraînement",
	["Razorscale's Aerie"] = "Aire de Tranchécaille",
	["Silver Covenant Pavilion"] = "Pavillon du Concordat argenté",
	["Sunreaver Pavilion"] = "Pavillon de Saccage-soleil",
	["The Alliance Valiants' Ring"] = "Lice des vaillants de l'Alliance",
	["The Argent Valiants' Ring"] = "Lice des vaillants d'Argent",
	["The Aspirants' Ring"] = "Lice des aspirants",
	["The Assembly of Iron"] = "L'assemblée du Fer",
	["The Celestial Planetarium"] = "Le planétarium céleste",
	["The Clash of Thunder"] = "Le fracas du tonnerre",
	["The Colossal Forge"] = "La forge colossale",
	["The Conservatory of Life"] = "Le jardin de  la vie",
	["The Descent into Madness"] = "La descente dans la folie",
	["The Halls of Winter"] = "Les salles de l'hiver",
	["The Horde Valiants' Ring"] = "Lice des vaillants de la Horde",
	["The Observation Ring"] = "Le cercle d'observation",
	["The Prison of Yogg-Saron"] = "Prison de Yogg-Saron",
	["The Ring of Champions"] = "Lice des champions",
	["The Scrapyard"] = "La ferraillerie",
	["The Shattered Walkway"] = "Le passage brisé",
	["The Spark of Imagination"] = "L'étincelle d'imagination",
}


elseif (locale == "zhTW") then  -- Traditional Chinese
L["SEARCH_ANY"] = "以上皆可:"
L["SEARCH_CRITERIA"] = "條件:"
L["SEARCH_DESC"] = "描述:"
L["SEARCH_FULLLIST"] = "搜索所有成就"
L["SEARCH_FULLLIST_TIP"] = "包括所有成就,已完成的,未完成的,無法完成的,等等."
L["SEARCH_HELP"] = "使用此標籤來搜索成就。您也可以使用命令搜索成就的名稱或編號。見 Overachiever 的 Readme.txt 文件的相關內容。"
L["SEARCH_NAME"] = "名稱:"
L["SEARCH_RESET"] = "重置"
L["SEARCH_RESULTS"] = "搜索到 %s |4achievement:個成就;."
L["SEARCH_REWARD"] = "獎勵:"
L["SEARCH_SUBMIT"] = "搜索"
L["SEARCH_TAB"] = "搜索"
L["SUGGESTIONS_EMPTY"] = "Overachiever現在沒有任何建議。"
L["SUGGESTIONS_EMPTY_TRADESKILL"] = "%s: Overachiever 此時無法提供建議."
L["SUGGESTIONS_HELP"] = "根據你目前的位置建議追蹤成就。"
L["SUGGESTIONS_LOCATION"] = "區域 :"
L["SUGGESTIONS_LOCATION_NOSUBZONE"] = "(未指定)"
L["SUGGESTIONS_LOCATION_SUBZONE"] = "次區域："
L["SUGGESTIONS_LOCATION_TIP"] = "無視區域/副本位置"
L["SUGGESTIONS_LOCATION_TIP2"] = "在欄位中輸入一個完整的有效區域或副本名稱，以取得提示。若欄位保持空白，則會根據你目前的所在位置。當游標在欄位中時，按下|cffffffffTab|r鍵可根據已輸入的內容依序產生有效的完整位置名稱。按下|cffffffffShift+Tab|r則產生前一個名稱。如果游標在欄位的最左側，它將依序產生所有有效位置名稱。"
L["SUGGESTIONS_REFRESH"] = "刷新"
L["SUGGESTIONS_RESULTS"] = "找到 %d 個建議."
L["SUGGESTIONS_RESULTS_TRADESKILL"] = "%s: 找到 %d 個建議."
L["SUGGESTIONS_TAB"] = "建議"
L["TAB_HELP"] = "|cffffffffCtrl + 點選|r 所選成就會跳轉到該成就的頁面.|n|n |cffffffff藍色背景|r表示此成就是你還沒有完成前續內容的系列成就部分.|n|n |cffffffff紅色背景|r表示此成就無法在你當前人物的標準成就界面中找到,因為這是陣營專屬成就,或者是你尚未取得的『光輝事跡』成就."
L["TAB_SORT"] = "類型:"
L["TAB_SORT_COMPLETE"] = "完成時間"
L["TAB_SORT_ID"] = "成就ID"
L["TAB_SORT_NAME"] = "名稱"
L["TAB_SORT_POINTS"] = "成就點數"
-- L["WATCH_CLEAR"] = ""
-- L["WATCH_COPY"] = ""
-- L["WATCH_COPY_TIP"] = ""
-- L["WATCH_DEFAULTLIST"] = ""
-- L["WATCH_DEFAULTLIST_TIP"] = ""
-- L["WATCH_DELETE"] = ""
-- L["WATCH_DISPLAYEDLIST"] = ""
L["WATCH_EMPTY"] = "你的觀察列表示空的. Alt+click在其它成就標籤上或是成就連結來觀察."
-- L["WATCH_EMPTY_SHORT"] = ""
L["WATCH_HELP"] = "在其他成就標籤上或是成就連結使用 |cffffffffalt+clicking|r來新建你的觀察列表. |cffffffffAlt+click|r 將停止觀察. "
-- L["WATCH_LIST_GLOBAL"] = ""
-- L["WATCH_LIST_PERCHAR"] = ""
-- L["WATCH_NEW"] = ""
-- L["WATCH_POPUP_CLEARLIST"] = ""
-- L["WATCH_POPUP_DELETELIST"] = ""
-- L["WATCH_POPUP_NEWLIST"] = ""
L["WATCH_TAB"] = "觀察"
L.SUBZONES = {
	["Argent Pavilion"] = "銀白亭閣",
	["Argent Tournament Grounds"] = "銀白聯賽場地",
	["Formation Grounds"] = "構築之地",
	["Razorscale's Aerie"] = "銳鱗之巢",
	["Silver Covenant Pavilion"] = "白銀誓盟亭閣",
	["Sunreaver Pavilion"] = "奪日者亭閣",
	["The Alliance Valiants' Ring"] = "聯盟驍士競技場",
	["The Argent Valiants' Ring"] = "銀白驍士競技場",
	["The Aspirants' Ring"] = "志士競技場",
	["The Assembly of Iron"] = "鐵之集會所",
	["The Celestial Planetarium"] = "星穹渾天儀",
	["The Clash of Thunder"] = "雷鳴之廳",
	["The Colossal Forge"] = "巨熔爐",
	["The Conservatory of Life"] = "生命溫室",
	["The Descent into Madness"] = "驟狂斜廊",
	["The Halls of Winter"] = "凜冬之廳",
	["The Horde Valiants' Ring"] = "部落驍士競技場",
	["The Observation Ring"] = "觀察之環",
	["The Prison of Yogg-Saron"] = "尤格薩倫之獄",
	["The Ring of Champions"] = "勇士競技場",
	["The Scrapyard"] = "廢料場",
	["The Shattered Walkway"] = "破碎走道",
	["The Spark of Imagination"] = "創思之廳",
}


elseif (locale == "zhCN") then  -- Simplified Chinese
L["SEARCH_ANY"] = "以上所有：" -- Needs review
L["SEARCH_CRITERIA"] = "条件：" -- Needs review
L["SEARCH_DESC"] = "描述：" -- Needs review
L["SEARCH_FULLLIST"] = "搜索所有成就" -- Needs review
L["SEARCH_FULLLIST_TIP"] = "包括没有在默认列表中显示的成就，例如阵营专属成就、‘光辉事迹’成就等。" -- Needs review
L["SEARCH_HELP"] = "使用这个标签来搜索成就。你也可以通过斜杠命令用名字或ID来搜索成就。详细请参见Overachiever的readme.txt文件。" -- Needs review
L["SEARCH_NAME"] = "名字：" -- Needs review
L["SEARCH_RESET"] = "重置" -- Needs review
L["SEARCH_RESULTS"] = "找到 %s |4achievement:个成就;." -- Needs review
L["SEARCH_REWARD"] = "奖励：" -- Needs review
L["SEARCH_SUBMIT"] = "搜索" -- Needs review
L["SEARCH_TAB"] = "搜索" -- Needs review
L["SUGGESTIONS_EMPTY"] = "Overachiever现在没有任何建议。" -- Needs review
-- L["SUGGESTIONS_EMPTY_TRADESKILL"] = ""
L["SUGGESTIONS_HELP"] = "根据你的当前位置建议追踪成就。" -- Needs review
-- L["SUGGESTIONS_LOCATION"] = ""
-- L["SUGGESTIONS_LOCATION_NOSUBZONE"] = ""
-- L["SUGGESTIONS_LOCATION_SUBZONE"] = ""
-- L["SUGGESTIONS_LOCATION_TIP"] = ""
-- L["SUGGESTIONS_LOCATION_TIP2"] = ""
L["SUGGESTIONS_REFRESH"] = "刷新" -- Needs review
L["SUGGESTIONS_RESULTS"] = "找到 %d |4成就:成就;." -- Needs review
-- L["SUGGESTIONS_RESULTS_TRADESKILL"] = ""
L["SUGGESTIONS_TAB"] = "建议" -- Needs review
L["TAB_HELP"] = "|cffffffffCtrl-点击|r一个成就跳转到它在标准成就界面的位置。|n|n |cffffffff蓝色背景|r表示此成就是你还没有完成前续内容的系列成就。|n|n |cffffffff红色背景|r表示此成就无法在当前人物的标准成就界面中找到，因为这是阵营专属成就，或是无法取得的‘光辉事迹’成就。|n|n  |cffffffff绿色背景|r 是提醒此成就最近在鼠标提示中显示过。" -- Needs review
L["TAB_SORT"] = "按……排序：" -- Needs review
L["TAB_SORT_COMPLETE"] = "完成时间" -- Needs review
L["TAB_SORT_ID"] = "成就ID" -- Needs review
L["TAB_SORT_NAME"] = "名字" -- Needs review
L["TAB_SORT_POINTS"] = "成就点数" -- Needs review
-- L["WATCH_CLEAR"] = ""
-- L["WATCH_COPY"] = ""
-- L["WATCH_COPY_TIP"] = ""
-- L["WATCH_DEFAULTLIST"] = ""
-- L["WATCH_DEFAULTLIST_TIP"] = ""
-- L["WATCH_DELETE"] = ""
-- L["WATCH_DISPLAYEDLIST"] = ""
-- L["WATCH_EMPTY"] = ""
-- L["WATCH_EMPTY_SHORT"] = ""
-- L["WATCH_HELP"] = ""
-- L["WATCH_LIST_GLOBAL"] = ""
-- L["WATCH_LIST_PERCHAR"] = ""
-- L["WATCH_NEW"] = ""
-- L["WATCH_POPUP_CLEARLIST"] = ""
-- L["WATCH_POPUP_DELETELIST"] = ""
-- L["WATCH_POPUP_NEWLIST"] = ""
-- L["WATCH_TAB"] = ""
L.SUBZONES = {
	-- ["Argent Pavilion"] = "",
	-- ["Argent Tournament Grounds"] = "",
	-- ["Formation Grounds"] = "",
	-- ["Razorscale's Aerie"] = "",
	-- ["Silver Covenant Pavilion"] = "",
	-- ["Sunreaver Pavilion"] = "",
	["The Alliance Valiants' Ring"] = "联盟勇士赛场",
	["The Argent Valiants' Ring"] = "银色勇士赛场",
	-- ["The Aspirants' Ring"] = "",
	-- ["The Assembly of Iron"] = "",
	-- ["The Celestial Planetarium"] = "",
	-- ["The Clash of Thunder"] = "",
	-- ["The Colossal Forge"] = "",
	-- ["The Conservatory of Life"] = "",
	-- ["The Descent into Madness"] = "",
	-- ["The Halls of Winter"] = "",
	["The Horde Valiants' Ring"] = "部落勇士赛场",
	-- ["The Observation Ring"] = "",
	-- ["The Prison of Yogg-Saron"] = "",
	-- ["The Ring of Champions"] = "",
	-- ["The Scrapyard"] = "",
	-- ["The Shattered Walkway"] = "",
	-- ["The Spark of Imagination"] = "",
}


elseif (locale == "ruRU") then  -- Russian
L["SEARCH_ANY"] = "Всё перечисленное:"
L["SEARCH_CRITERIA"] = "Критерий:"
L["SEARCH_DESC"] = "Описание:"
L["SEARCH_FULLLIST"] = "Искать по всем достижениям"
L["SEARCH_FULLLIST_TIP"] = "В поиск будут включаться все достижения, включая не представленные в стандартном интерфейсе (например, достижения для противоположной фракции или невыполнимые)."
L["SEARCH_HELP"] = "Воспользуйтесь этой вкладкой для поиска достижений. Вы также можете искать достижения по имени или номеру, используя команды часа. Более подробную информацию вы найдёте в файле readme.txt в папке аддона."
L["SEARCH_NAME"] = "Название:"
L["SEARCH_RESET"] = "Сбросить"
L["SEARCH_RESULTS"] = "Найдено достижений: %s."
L["SEARCH_REWARD"] = "Награда:"
L["SEARCH_SUBMIT"] = "Поиск"
L["SEARCH_TAB"] = "Поиск"
L["SUGGESTIONS_EMPTY"] = "В данный момент подходящих достижений не обнаружено."
L["SUGGESTIONS_EMPTY_TRADESKILL"] = "%s: Overachiever для вас в данный момент не имеет предложений."
L["SUGGESTIONS_HELP"] = "Предпологаемые достижения, указанные здесь, основаны на вашем текущем местоположении. Также здесь могут находиться достижения, объекты к которым вы повстречали за последние 2 минуты."
L["SUGGESTIONS_LOCATION"] = "Локация:"
L["SUGGESTIONS_LOCATION_NOSUBZONE"] = "(неопределёно)"
L["SUGGESTIONS_LOCATION_SUBZONE"] = "Подзона:"
-- L["SUGGESTIONS_LOCATION_TIP"] = ""
-- L["SUGGESTIONS_LOCATION_TIP2"] = ""
L["SUGGESTIONS_REFRESH"] = "Обновить"
L["SUGGESTIONS_RESULTS"] = "Найдено предполагаемых\\nдостижений: %d."
L["SUGGESTIONS_RESULTS_TRADESKILL"] = "%s: %d |4предложение:предложений; найденно."
L["SUGGESTIONS_TAB"] = "Предположения"
L["TAB_HELP"] = "|cffffffffCtrl+левый клик|r на достижении перенаправит вас к его местоположению в стандартном интерфейсе.|n|n|cffffffffСиний фон|r означает, что это часть серии достижений, для которой вы ещё не выполнили предыдущий шаг.|n|n|cffffffffКрасный фон|r означает, что это достижение не может быть найдено в стандартном интерфейсе, так оно эксклюзивно для противоположной фракции или невыполнимо по какой-либо причине.|n|n|cffffffffЗелёный фон|r означает, что совсем недавно вы встречали объект, необходимый для этого достижения."
L["TAB_SORT"] = "Сортировать по:"
L["TAB_SORT_COMPLETE"] = "дате завершения"
L["TAB_SORT_ID"] = "номеру"
L["TAB_SORT_NAME"] = "названию"
L["TAB_SORT_POINTS"] = "очкам"
-- L["WATCH_CLEAR"] = ""
-- L["WATCH_COPY"] = ""
-- L["WATCH_COPY_TIP"] = ""
-- L["WATCH_DEFAULTLIST"] = ""
-- L["WATCH_DEFAULTLIST_TIP"] = ""
-- L["WATCH_DELETE"] = ""
-- L["WATCH_DISPLAYEDLIST"] = ""
L["WATCH_EMPTY"] = "Ваш список наблюдений пуст. Нажмите на достижение Alt+Клик для наблюдения за ним."
-- L["WATCH_EMPTY_SHORT"] = ""
L["WATCH_HELP"] = "Создайте ваш список наблюдений нажав  |cffffffffalt+клик|r по достижению в других закладках или по ссылке в чате. Нажав |cffffffffAlt+клик|r по одному из присутствующих достижений вы удалите его из списка."
-- L["WATCH_LIST_GLOBAL"] = ""
-- L["WATCH_LIST_PERCHAR"] = ""
-- L["WATCH_NEW"] = ""
-- L["WATCH_POPUP_CLEARLIST"] = ""
-- L["WATCH_POPUP_DELETELIST"] = ""
-- L["WATCH_POPUP_NEWLIST"] = ""
L["WATCH_TAB"] = "Наблюдение"
L.SUBZONES = {
	["Argent Pavilion"] = "Серебряный павильон",
	["Argent Tournament Grounds"] = "Ристалище Серебряного турнира",
	["Formation Grounds"] = "Плац",
	["Razorscale's Aerie"] = "Гнездо Острокрылой",
	["Silver Covenant Pavilion"] = "Павильон Серебряного Союза",
	["Sunreaver Pavilion"] = "Павильон Похитителей Солнца",
	["The Alliance Valiants' Ring"] = "Арена искателей славы из Альянса",
	["The Argent Valiants' Ring"] = "Арена искателей славы Серебряного Авангарда",
	["The Aspirants' Ring"] = "Арена претендентов",
	["The Assembly of Iron"] = "Железное Собрание",
	["The Celestial Planetarium"] = "Священный Планетарий",
	["The Clash of Thunder"] = "Раскаты Грома",
	["The Colossal Forge"] = "Гигантская кузня",
	["The Conservatory of Life"] = "Оранжерея Жизни",
	["The Descent into Madness"] = "Провал Безумия",
	["The Halls of Winter"] = "Залы Зимы",
	["The Horde Valiants' Ring"] = "Арена искателей славы из Орды",
	["The Observation Ring"] = "Круг Наблюдения",
	["The Prison of Yogg-Saron"] = "Темница Йогг-Сарона",
	["The Ring of Champions"] = "Арена чемпионов",
	["The Scrapyard"] = "Мусорная свалка",
	["The Shattered Walkway"] = "Обвалившаяся галерея",
	["The Spark of Imagination"] = "Искра Воображения",
}


elseif (locale == "koKR") then  -- Korean
L["SEARCH_ANY"] = "다음 중 적어도 하나 포함:"
L["SEARCH_CRITERIA"] = "기준:"
L["SEARCH_DESC"] = "내용:"
L["SEARCH_FULLLIST"] = "모든 업적 검색"
L["SEARCH_FULLLIST_TIP"] = "달성하지 않은 위업이나 반대 평판때문에 기본 UI에서는 표시되지 않는 업적들도 모두 표시합니다."
L["SEARCH_HELP"] = "업적을 검색하려면 이 탭을 이용하십시오. 또한 /명령어를 이용해서 이름이나 ID로 검색할 수도 있습니다. (자세한 내용은 readme.txt 참고하세요.)"
L["SEARCH_NAME"] = "이름:"
L["SEARCH_RESET"] = "초기화"
L["SEARCH_RESULTS"] = "%s개의 업적을 찾음."
L["SEARCH_REWARD"] = "보상:"
L["SEARCH_SUBMIT"] = "검색"
L["SEARCH_TAB"] = "검색"
L["SUGGESTIONS_EMPTY"] = "지금은 Overachiever가 추천하는 업적이 없습니다."
L["SUGGESTIONS_EMPTY_TRADESKILL"] = "%s: 지금은 Overachiever가 추천하는 업적이 없습니다."
L["SUGGESTIONS_HELP"] = "추천된 업적은 플레이어의 현재 위치를 기준하여 표시됩니다. 또한 2분전까지 툴팁으로 알려주었던 업적도 포함됩니다."
-- L["SUGGESTIONS_LOCATION"] = ""
-- L["SUGGESTIONS_LOCATION_NOSUBZONE"] = ""
-- L["SUGGESTIONS_LOCATION_SUBZONE"] = ""
-- L["SUGGESTIONS_LOCATION_TIP"] = ""
-- L["SUGGESTIONS_LOCATION_TIP2"] = ""
L["SUGGESTIONS_REFRESH"] = "새로 고침"
L["SUGGESTIONS_RESULTS"] = "추천하는 업적 %d개."
L["SUGGESTIONS_RESULTS_TRADESKILL"] = "%s: 추천하는 업적 %d개."
L["SUGGESTIONS_TAB"] = "추천"
L["TAB_HELP"] = "|cffffffff컨트롤+좌클릭|r으로 기본 UI의 해당 업적으로 이동할 수 있습니다.|n|n|cffffffff푸른 바탕|r은 완료되지 않은 업적 세트의 일부를 의미합니다.|n|n|cffffffff붉은 바탕|r은 반대 평판 등의 이유로 이 캐릭터의 기본 UI에는 존재하지 않는 업적을 의미합니다.|n|n|cffffffff녹색 바탕|r은 이 업적과 관련된 알림 정보가 최근 툴팁에 표시되었음을 의미합니다."
L["TAB_SORT"] = "정렬 기준:"
L["TAB_SORT_COMPLETE"] = "완료된 날짜 순"
L["TAB_SORT_ID"] = "ID 순"
L["TAB_SORT_NAME"] = "이름 순"
L["TAB_SORT_POINTS"] = "업적 점수 순"
-- L["WATCH_CLEAR"] = ""
-- L["WATCH_COPY"] = ""
-- L["WATCH_COPY_TIP"] = ""
-- L["WATCH_DEFAULTLIST"] = ""
-- L["WATCH_DEFAULTLIST_TIP"] = ""
-- L["WATCH_DELETE"] = ""
-- L["WATCH_DISPLAYEDLIST"] = ""
L["WATCH_EMPTY"] = "추적"
-- L["WATCH_EMPTY_SHORT"] = ""
L["WATCH_HELP"] = "다른 탭이나 업적 링크에서 |cffffffffAlt+좌클릭|r하여 추적 항목을 추가할 수 있습니다. 현재 창에서 |cffffffffAlt+좌클릭|r하면 추적 목록에서 제거합니다."
-- L["WATCH_LIST_GLOBAL"] = ""
-- L["WATCH_LIST_PERCHAR"] = ""
-- L["WATCH_NEW"] = ""
-- L["WATCH_POPUP_CLEARLIST"] = ""
-- L["WATCH_POPUP_DELETELIST"] = ""
-- L["WATCH_POPUP_NEWLIST"] = ""
L["WATCH_TAB"] = "추적"
L.SUBZONES = {
	-- ["Argent Pavilion"] = "",
	-- ["Argent Tournament Grounds"] = "",
	["Formation Grounds"] = "전투대형 훈련장",
	["Razorscale's Aerie"] = "칼날비늘의 둥지",
	-- ["Silver Covenant Pavilion"] = "",
	-- ["Sunreaver Pavilion"] = "",
	-- ["The Alliance Valiants' Ring"] = "",
	-- ["The Argent Valiants' Ring"] = "",
	-- ["The Aspirants' Ring"] = "",
	["The Assembly of Iron"] = "무쇠 회합실",
	["The Celestial Planetarium"] = "별자리 투영관",
	["The Clash of Thunder"] = "천둥의 울림",
	["The Colossal Forge"] = "거대 제련실",
	["The Conservatory of Life"] = "생명의 정원",
	["The Descent into Madness"] = "광기의 내리막길",
	["The Halls of Winter"] = "겨울의 전당",
	-- ["The Horde Valiants' Ring"] = "",
	-- ["The Observation Ring"] = "",
	["The Prison of Yogg-Saron"] = "요그사론의 감옥",
	-- ["The Ring of Champions"] = "",
	["The Scrapyard"] = "고철 야적장",
	["The Shattered Walkway"] = "부서진 산책로",
	["The Spark of Imagination"] = "상상의 작업실",
}


elseif (locale == "esES" or locale == "esMX") then  -- Spanish
L["SEARCH_ANY"] = "Cualquiera de los anteriores:"
L["SEARCH_CRITERIA"] = "Requisitos:"
L["SEARCH_DESC"] = "Descripción:"
L["SEARCH_FULLLIST"] = "Buscar en todos los logros"
L["SEARCH_FULLLIST_TIP"] = "Incluye en la búsqueda de logros aquellos que normalmente no aparecen en el interface por defecto, como aquellos exclusivos de la facción contraria, Logros de fuerza sin conseguir, etc."
L["SEARCH_HELP"] = "Usa esta pestaña para buscar logros. También puedes usar los comandos de chat para buscar logros por nombre o ID. Lee el archivo readme.txt de Overachiever para más detalles."
L["SEARCH_NAME"] = "Nombre:"
L["SEARCH_RESET"] = "Limpiar"
L["SEARCH_RESULTS"] = "|4Encontrado:Encontrados; %s |4logro:logros;."
L["SEARCH_REWARD"] = "Recompensa:"
L["SEARCH_SUBMIT"] = "Buscar"
L["SEARCH_TAB"] = "Búsqueda"
L["SUGGESTIONS_EMPTY"] = "Overachiever no tiene sugerencias para ti en este momento."
L["SUGGESTIONS_EMPTY_TRADESKILL"] = "%s: Overachiever no tiene sugerencias para tí en este momento."
L["SUGGESTIONS_HELP"] = "Las sugerencias de logros aquí listados se basan en tu ubicación actual. También se lista cualquier logro del cual se te ha mostrado un tooltip recordatorio en los últimos dos minutos."
L["SUGGESTIONS_LOCATION"] = "Ubicación:"
L["SUGGESTIONS_LOCATION_NOSUBZONE"] = "(sin especificar)"
L["SUGGESTIONS_LOCATION_SUBZONE"] = "Subzona:"
L["SUGGESTIONS_LOCATION_TIP"] = "Ignorar la ubicación actual"
L["SUGGESTIONS_LOCATION_TIP2"] = "Déjalo en blanco para obtener sugerencias sobre tu ubicación actual o empieza a teclear para obtener una zona o instancia coincidente válida para usar en vez de la actual. Pulsa |cffffffffTabulador|r para alternar entre las ubicaciones que coinciden con el texto a la izquierda del cursor. |cffffffffSfit+Tabulador|r alterna invirtiendo el orden. Si el cursor está en la izquierda del todo, alternará entre todas las ubicaciones válidas."
L["SUGGESTIONS_REFRESH"] = "Actualizar"
L["SUGGESTIONS_RESULTS"] = "%d |4sugerencia:sugerencias; |4encontrada:encontradas;"
L["SUGGESTIONS_RESULTS_TRADESKILL"] = "%s: %d |4sugerencia:sugerencias; |4encontrada:encontradas;"
L["SUGGESTIONS_TAB"] = "Sugerencias"
L["TAB_HELP"] = "|cffffffffCtrl-click|r sobre un logro para saltar a su posición en el interface estándar.|n|nUn |cfffffffffondo azul|r indica que es parte de una serie para la que aún no has completado un paso anterior.|n|nUn |cfffffffffondo rojo|r indica que no se encuentra en el interface estándar para este personaje porque es exclusivo de la facción contraria o es una Proeza de fuerza que aún no has logrado.|n|nUn |cfffffffffondo verde|r indica que se ha mostrado un tooltip recordatorio sobre este logro recientemente."
L["TAB_SORT"] = "Ordenado por:"
L["TAB_SORT_COMPLETE"] = "Fecha de finalización"
L["TAB_SORT_ID"] = "ID"
L["TAB_SORT_NAME"] = "Nombre"
L["TAB_SORT_POINTS"] = "Puntuación"
-- L["WATCH_CLEAR"] = ""
-- L["WATCH_COPY"] = ""
-- L["WATCH_COPY_TIP"] = ""
-- L["WATCH_DEFAULTLIST"] = ""
-- L["WATCH_DEFAULTLIST_TIP"] = ""
-- L["WATCH_DELETE"] = ""
-- L["WATCH_DISPLAYEDLIST"] = ""
L["WATCH_EMPTY"] = "Tu lista de vigilancia está vacía. Alt+click sobre un logro en otra pestaña o sobre el enlace de un logro en el chat para vigilarlo."
-- L["WATCH_EMPTY_SHORT"] = ""
L["WATCH_HELP"] = "Crea tu lista de vigilancia haciendo |cffffffffalt+click|r sobre logros en las otras pestañas o sobre enlaces de logros el el chat. |cffffffffAlt+click|r sobre uno mostrado aquí para dejar de vigilarlo."
-- L["WATCH_LIST_GLOBAL"] = ""
-- L["WATCH_LIST_PERCHAR"] = ""
-- L["WATCH_NEW"] = ""
-- L["WATCH_POPUP_CLEARLIST"] = ""
-- L["WATCH_POPUP_DELETELIST"] = ""
-- L["WATCH_POPUP_NEWLIST"] = ""
L["WATCH_TAB"] = "Seguimiento"
L.SUBZONES = {
	["Argent Pavilion"] = "Pabellón Argenta",
	["Argent Tournament Grounds"] = "Campos del Torneo Argenta",
	["Formation Grounds"] = "Campo de Formación",
	["Razorscale's Aerie"] = "Nidal de Tajoescama",
	["Silver Covenant Pavilion"] = "Pabellón de El Pacto de Plata",
	["Sunreaver Pavilion"] = "Pabellón Atracasol",
	["The Alliance Valiants' Ring"] = "La Liza de los Valerosos de la Alianza",
	["The Argent Valiants' Ring"] = "La Liza de los Valerosos Argenta",
	["The Aspirants' Ring"] = "La Liza de los Aspirantes",
	["The Assembly of Iron"] = "La Asamblea de Hierro",
	["The Celestial Planetarium"] = "El Planetario Celestial",
	["The Clash of Thunder"] = "El Fragor del Trueno",
	["The Colossal Forge"] = "La Forja Colosal",
	["The Conservatory of Life"] = "El Invernadero de Vida",
	["The Descent into Madness"] = "El Descenso a la Locura",
	["The Halls of Winter"] = "Las Cámaras del Invierno",
	["The Horde Valiants' Ring"] = "La Liza de los Valerosos de la Horda",
	["The Observation Ring"] = "El Circulo de Observación",
	["The Prison of Yogg-Saron"] = "La Prisión de Yogg-Saron",
	["The Ring of Champions"] = "La Liza de los Campeones",
	["The Scrapyard"] = "La Chatarrería",
	["The Shattered Walkway"] = "La Pasarela Devastada",
	["The Spark of Imagination"] = "Chispa de Imaginación",
}


	if (locale == "esMX") then  -- Spanish (Mexican)
-- L["SEARCH_ANY"] = ""
-- L["SEARCH_CRITERIA"] = ""
-- L["SEARCH_DESC"] = ""
-- L["SEARCH_FULLLIST"] = ""
-- L["SEARCH_FULLLIST_TIP"] = ""
-- L["SEARCH_HELP"] = ""
-- L["SEARCH_NAME"] = ""
-- L["SEARCH_RESET"] = ""
-- L["SEARCH_RESULTS"] = ""
-- L["SEARCH_REWARD"] = ""
-- L["SEARCH_SUBMIT"] = ""
-- L["SEARCH_TAB"] = ""
-- L["SUGGESTIONS_EMPTY"] = ""
-- L["SUGGESTIONS_EMPTY_TRADESKILL"] = ""
-- L["SUGGESTIONS_HELP"] = ""
-- L["SUGGESTIONS_LOCATION"] = ""
-- L["SUGGESTIONS_LOCATION_NOSUBZONE"] = ""
-- L["SUGGESTIONS_LOCATION_SUBZONE"] = ""
-- L["SUGGESTIONS_LOCATION_TIP"] = ""
-- L["SUGGESTIONS_LOCATION_TIP2"] = ""
-- L["SUGGESTIONS_REFRESH"] = ""
-- L["SUGGESTIONS_RESULTS"] = ""
-- L["SUGGESTIONS_RESULTS_TRADESKILL"] = ""
-- L["SUGGESTIONS_TAB"] = ""
-- L["TAB_HELP"] = ""
-- L["TAB_SORT"] = ""
-- L["TAB_SORT_COMPLETE"] = ""
-- L["TAB_SORT_ID"] = ""
-- L["TAB_SORT_NAME"] = ""
-- L["TAB_SORT_POINTS"] = ""
-- L["WATCH_CLEAR"] = ""
-- L["WATCH_COPY"] = ""
-- L["WATCH_COPY_TIP"] = ""
-- L["WATCH_DEFAULTLIST"] = ""
-- L["WATCH_DEFAULTLIST_TIP"] = ""
-- L["WATCH_DELETE"] = ""
-- L["WATCH_DISPLAYEDLIST"] = ""
-- L["WATCH_EMPTY"] = ""
-- L["WATCH_EMPTY_SHORT"] = ""
-- L["WATCH_HELP"] = ""
-- L["WATCH_LIST_GLOBAL"] = ""
-- L["WATCH_LIST_PERCHAR"] = ""
-- L["WATCH_NEW"] = ""
-- L["WATCH_POPUP_CLEARLIST"] = ""
-- L["WATCH_POPUP_DELETELIST"] = ""
-- L["WATCH_POPUP_NEWLIST"] = ""
-- L["WATCH_TAB"] = ""
-- L["SUBZONES/Argent Pavilion"] = ""
-- L["SUBZONES/Argent Tournament Grounds"] = ""
-- L["SUBZONES/Formation Grounds"] = ""
-- L["SUBZONES/Razorscale's Aerie"] = ""
-- L["SUBZONES/Silver Covenant Pavilion"] = ""
-- L["SUBZONES/Sunreaver Pavilion"] = ""
-- L["SUBZONES/The Alliance Valiants' Ring"] = ""
-- L["SUBZONES/The Argent Valiants' Ring"] = ""
-- L["SUBZONES/The Aspirants' Ring"] = ""
-- L["SUBZONES/The Assembly of Iron"] = ""
-- L["SUBZONES/The Celestial Planetarium"] = ""
-- L["SUBZONES/The Clash of Thunder"] = ""
-- L["SUBZONES/The Colossal Forge"] = ""
-- L["SUBZONES/The Conservatory of Life"] = ""
-- L["SUBZONES/The Descent into Madness"] = ""
-- L["SUBZONES/The Halls of Winter"] = ""
-- L["SUBZONES/The Horde Valiants' Ring"] = ""
-- L["SUBZONES/The Observation Ring"] = ""
-- L["SUBZONES/The Prison of Yogg-Saron"] = ""
-- L["SUBZONES/The Ring of Champions"] = ""
-- L["SUBZONES/The Scrapyard"] = ""
-- L["SUBZONES/The Shattered Walkway"] = ""
-- L["SUBZONES/The Spark of Imagination"] = ""


	-- We had to use "concat" instead of "subtable" for Curse's handle-subnamespaces substitution scheme so
	-- esMX's L.SUBZONES doesn't entirely overwrite esES's. This puts them in the format "SUBZONES/<key>";
	-- we'll iterate over the table to find those and put the values in the proper place:
		local tab = L.SUBZONES
		for k,v in pairs(L) do
			if (strsub(k, 1, 9) == "SUBZONES/") then
				tab[strsub(k, 10)] = v
				L[k] = nil
			end
		end
	end

end
if (not L.SUBZONES) then
	L.SUBZONES = {
	-- Ulduar:
		["Formation Grounds"] = "Formation Grounds",
		["Razorscale's Aerie"] = "Razorscale's Aerie",
		["The Assembly of Iron"] = "The Assembly of Iron",
		["The Celestial Planetarium"] = "The Celestial Planetarium",
		["The Clash of Thunder"] = "The Clash of Thunder",
		["The Colossal Forge"] = "The Colossal Forge",
		["The Conservatory of Life"] = "The Conservatory of Life",
		["The Descent into Madness"] = "The Descent into Madness",
		["The Halls of Winter"] = "The Halls of Winter",
		["The Observation Ring"] = "The Observation Ring",
		["The Prison of Yogg-Saron"] = "The Prison of Yogg-Saron",
		["The Scrapyard"] = "The Scrapyard",
		["The Shattered Walkway"] = "The Shattered Walkway",
		["The Spark of Imagination"] = "The Spark of Imagination",
	-- Icecrown:
		["Argent Tournament Grounds"] = "Argent Tournament Grounds",
		["The Ring of Champions"] = "The Ring of Champions",
		["Argent Pavilion"] = "Argent Pavilion",
		["The Argent Valiants' Ring"] = "The Argent Valiants' Ring",
		["The Aspirants' Ring"] = "The Aspirants' Ring",
		["The Alliance Valiants' Ring"] = "The Alliance Valiants' Ring",
		["Silver Covenant Pavilion"] = "Silver Covenant Pavilion",
		["Sunreaver Pavilion"] = "Sunreaver Pavilion",
		["The Horde Valiants' Ring"] = "The Horde Valiants' Ring",
	}
end