Plagued = LibStub("AceAddon-3.0"):NewAddon("Plagued", "AceEvent-3.0", "AceTimer-3.0")
Plagued.MINOR_VERSION = tonumber(("$Revision: 24 $"):match("%d+"))
local mod = Plagued
local L

L = LibStub("AceLocale-3.0"):NewLocale("Plagued", "enUS", true)
L["Help me in %d seconds!"] = true
L["Help me NOW!"] = true

L = LibStub("AceLocale-3.0"):NewLocale("Plagued", "deDE")
if L then
L["Help me in %d seconds!"] = "Helft mir in %d Sekunden!"
L["Help me NOW!"] = "Helft mir JETZT!"

end
L = LibStub("AceLocale-3.0"):NewLocale("Plagued", "esES")
if L then
-- L["Help me in %d seconds!"] = ""
-- L["Help me NOW!"] = ""

end
L = LibStub("AceLocale-3.0"):NewLocale("Plagued", "esMX")
if L then
-- L["Help me in %d seconds!"] = ""
-- L["Help me NOW!"] = ""

end
L = LibStub("AceLocale-3.0"):NewLocale("Plagued", "frFR")
if L then
L["Help me in %d seconds!"] = "Aidez-moi dans %d secondes !"
L["Help me NOW!"] = "Aidez-moi MAINTENANT !"

end
L = LibStub("AceLocale-3.0"):NewLocale("Plagued", "koKR")
if L then
L["Help me in %d seconds!"] = "교대 %d 초전!"
L["Help me NOW!"] = "지금 교대해 주세요!"

end
L = LibStub("AceLocale-3.0"):NewLocale("Plagued", "ruRU")
if L then
-- L["Help me in %d seconds!"] = ""
-- L["Help me NOW!"] = ""

end
L = LibStub("AceLocale-3.0"):NewLocale("Plagued", "zhCN")
if L then
-- L["Help me in %d seconds!"] = ""
-- L["Help me NOW!"] = ""

end
L = LibStub("AceLocale-3.0"):NewLocale("Plagued", "zhTW")
if L then
-- L["Help me in %d seconds!"] = ""
-- L["Help me NOW!"] = ""

end
L = LibStub("AceLocale-3.0"):GetLocale("Plagued")

local unboundPlague = GetSpellInfo(72856)
local pullNPCs = { 36678, 37562, 37697 }
local seconds = 10

function mod:OnEnable()
	self:RegisterEvent("PLAYER_REGEN_DISABLED", "CheckForPull")
end

function mod:StartFight()
	self:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED", "OnCombatEvent")
	self:RegisterEvent("PLAYER_REGEN_ENABLED", "EndFight")
end

function mod:EndFight()
	self:UnregisterEvent("COMBAT_LOG_EVENT_UNFILTERED")
	self:UnregisterEvent("PLAYER_REGEN_ENABLED")
end

local function onTimer()
	if seconds > 0 then
		SendChatMessage(format(L["Help me in %d seconds!"], seconds), "YELL")
		seconds = seconds - 1
	elseif seconds == 0 then
		SendChatMessage(L["Help me NOW!"], "YELL")
		mod:CancelAllTimers()
	end
end

function mod:OnCombatEvent(event, timestamp, eventType, srcGuid, srcName, srcFlags, dstGuid, dstName, dstFlags, spellId, spellName)
	if eventType == "SPELL_AURA_APPLIED" and dstName == UnitName("player") and spellName == unboundPlague then
		self:CancelAllTimers()
		seconds = 10
		onTimer()
		self:ScheduleRepeatingTimer(function() onTimer() end, 1.0)
	elseif eventType == "SPELL_AURA_REMOVED" and dstName == UnitName("player") and spellName == unboundPlague then
		self:CancelAllTimers()
		SendChatMessage("----", "YELL")		
	end
end

do -- Pull detection
	local t = { "target", "targettarget", "focus", "focustarget", "mouseover", "mouseovertarget" }
	for i = 1, 4 do t[#t+1] = format("party%dtarget", i) end
	for i = 1, 40 do t[#t+1] = format("raid%dtarget", i) end
	
	local function doCheckForPull(id, num)
		for _, unit in pairs(t) do
			if UnitExists(unit) and not UnitIsPlayer(unit) and tonumber(UnitGUID(unit):sub(-12, -7), 16) == id then
				if UnitAffectingCombat(unit) then
					mod:StartFight()
					return true
				elseif num < 30 then
					mod:ScheduleTimer(function() doCheckForPull(id, num + 1) end, 1)
				end
				return
			end
		end
	end

	function mod:CheckForPull()
		if UnitInRaid("player") then for _, id in pairs(pullNPCs) do if doCheckForPull(id, 0) then return end end end
	end
end
